/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.tools;

import com.tridium.ui.BOptionDialog;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Size;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.BFolder;
import javax.baja.workbench.BWbShell;

public class NewModuleWizard
extends WizardModel {
    static BImage openIcon = BImage.make((String)"module://icons/x16/open.png");
    static BDirectoryChooser chooser;
    static BImage moduleIcon;
    public static UiLexicon lex;
    public static BImage banner;
    public static final String lexUseLexicon;
    public static final String lexUsePalette;
    public static final String lexModuleDir;
    public static final String lexModuleName;
    public static final String lexPrefSymbol;
    public static final String lexDescription;
    public static final String lexVendor;
    BWbShell shell;
    int currentStep = 0;
    BWidget step0;
    BWidget step1;
    BWidget step2;
    BTextField moduleDir;
    BTextField moduleName;
    BTextField prefSymbol;
    BTextField description;
    BTextField vendor;
    BCheckBox useLexicon;
    BCheckBox usePalette;
    BTable table;
    BCheckBox useVendorVersion;
    BTable packages;
    static /* synthetic */ Class class$com$tridium$workbench$tools$NewModuleWizard;

    public static void kickIt(BWbShell bWbShell) {
        NewModuleWizard newModuleWizard = new NewModuleWizard(bWbShell);
        BWizard.open((BWidget)bWbShell, (WizardModel)newModuleWizard);
    }

    public NewModuleWizard(BWbShell bWbShell) {
        this.shell = bWbShell;
        this.buildStep0();
        this.buildStep1();
        this.buildStep2();
    }

    private void buildStep0() {
        this.moduleDir = new BTextField("", 60);
        this.moduleName = new BTextField("", 20);
        this.prefSymbol = new BTextField("", 20);
        this.description = new BTextField("", 50);
        this.vendor = new BTextField("", 50);
        this.useLexicon = new BCheckBox(lexUseLexicon);
        this.usePalette = new BCheckBox(lexUsePalette);
        this.useLexicon.setSelected(true);
        this.moduleName.setModel((TextModel)new ModuleNameModel());
        BButton bButton = new BButton((Command)new Browse((BWidget)this.shell, this.moduleDir));
        bButton.setButtonStyle(BButtonStyle.toolBar);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)this.moduleDir);
        bGridPane.add(null, (BValue)bButton);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.add(null, (BValue)new BLabel(lexModuleDir));
        bGridPane2.add(null, (BValue)bGridPane);
        BGridPane bGridPane3 = new BGridPane(2);
        bGridPane3.add(null, (BValue)new BLabel(lexModuleName));
        bGridPane3.add(null, (BValue)this.moduleName);
        bGridPane3.add(null, (BValue)new BLabel(lexPrefSymbol));
        bGridPane3.add(null, (BValue)this.prefSymbol);
        bGridPane3.add(null, (BValue)new BLabel(lexDescription));
        bGridPane3.add(null, (BValue)this.description);
        bGridPane3.add(null, (BValue)new BLabel(lexVendor));
        bGridPane3.add(null, (BValue)this.vendor);
        BGridPane bGridPane4 = new BGridPane(1);
        bGridPane4.add(null, (BValue)this.useLexicon);
        bGridPane4.add(null, (BValue)this.usePalette);
        BGridPane bGridPane5 = new BGridPane(1);
        bGridPane5.setRowGap(10.0);
        bGridPane5.add(null, (BValue)bGridPane2);
        bGridPane5.add(null, (BValue)bGridPane3);
        bGridPane5.add(null, (BValue)bGridPane4);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), UiLexicon.bajaui.getText("wizard.step1") + " of 3"));
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)bGridPane5, 10.0, 10.0, 10.0, 10.0));
        this.step0 = bEdgePane;
    }

    private void buildStep1() {
        BLabel bLabel = new BLabel(lex.getText("newModule.selectDependencies"), BHalign.left);
        Model model = new Model();
        BModule bModule = Sys.getBajaModule();
        model.addRow(new String[]{bModule.getModuleName(), bModule.getVendor(), bModule.getVendorVersion().toString(2)});
        this.table = new BTable((TableModel)model);
        this.table.setController((TableController)new Controller());
        this.useVendorVersion = new BCheckBox((ToggleCommand)new UseVendorVersion((BWidget)this.shell));
        this.useVendorVersion.setSelected(true);
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.add(null, (BValue)bLabel);
        bGridPane.add(null, (BValue)new BBorderPane((BWidget)this.useVendorVersion, 0.0, 0.0, 0.0, 5.0));
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setColumnAlign(BHalign.fill);
        bGridPane2.setValign(BValign.top);
        bGridPane2.add(null, (BValue)new BButton((Command)new Add((BWidget)this.shell)));
        bGridPane2.add(null, (BValue)new BButton((Command)new Remove((BWidget)this.shell)));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 5.0, 0.0));
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bEdgePane.setRight((BWidget)new BBorderPane((BWidget)bGridPane2, 0.0, 0.0, 0.0, 5.0));
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), UiLexicon.bajaui.getText("wizard.step2") + " of 3"));
        bEdgePane2.setCenter((BWidget)new BBorderPane((BWidget)bEdgePane, 10.0, 10.0, 10.0, 10.0));
        this.step1 = bEdgePane2;
    }

    private BOptionDialog getDialog(BWidget bWidget) {
        bWidget = bWidget.getParentWidget();
        while (!(bWidget instanceof BDialog)) {
            bWidget = bWidget.getParentWidget();
        }
        return (BOptionDialog)bWidget;
    }

    private void buildStep2() {
        BLabel bLabel = new BLabel(lex.getText("newModule.addPackages"), BHalign.left);
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{lex.getText("newModule.package")});
        this.packages = new BTable((TableModel)defaultTableModel);
        this.packages.setController((TableController)new PackageController());
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setValign(BValign.top);
        bGridPane.add(null, (BValue)new BButton((Command)new AddPackage((BWidget)this.shell)));
        bGridPane.add(null, (BValue)new BButton((Command)new RemovePackage((BWidget)this.shell)));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BBorderPane((BWidget)bLabel, 0.0, 0.0, 5.0, 0.0));
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.packages, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bEdgePane.setRight((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 0.0, 5.0));
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), UiLexicon.bajaui.getText("wizard.step3") + " of 3"));
        bEdgePane2.setCenter((BWidget)new BBorderPane((BWidget)bEdgePane, 10.0, 10.0, 10.0, 10.0));
        this.step2 = bEdgePane2;
    }

    public String getTitle() {
        return lex.getText("newModule.title");
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(490.0, 320.0);
    }

    public void init() {
        this.updateTo0();
    }

    public void back() {
        switch (this.currentStep) {
            case 1: {
                this.updateTo0();
                break;
            }
            case 2: {
                this.updateTo1();
            }
        }
    }

    public void next() {
        switch (this.currentStep) {
            case 0: {
                if (this.moduleDir.getText().length() == 0) {
                    throw new BajaRuntimeException("Module directory is not valid.");
                }
                new FilePath(this.moduleDir.getText());
                if (this.moduleName.getText().length() == 0) {
                    throw new BajaRuntimeException("Module name is not valid.");
                }
                if (this.prefSymbol.getText().length() == 0) {
                    throw new BajaRuntimeException("Prefered symbol is not valid.");
                }
                if (this.prefSymbol.getText().length() > 8) {
                    throw new BajaRuntimeException("Prefered symbol is too long.");
                }
                if (this.vendor.getText().length() == 0) {
                    throw new BajaRuntimeException("Vendor is not valid.");
                }
                this.updateTo1();
                break;
            }
            case 1: {
                this.updateTo2();
            }
        }
    }

    public boolean finish() {
        this.shell.enterBusy();
        try {
            this.doit();
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            BDialog.error((BWidget)this.shell, (String)"Error", (Object)"Cannot create new module", (Throwable)throwable);
            boolean bl = false;
            return bl;
        }
        finally {
            this.shell.exitBusy();
        }
    }

    private void updateTo0() {
        String string = this.moduleName.getText();
        int n = SlotPath.isValidName((String)string) && string.length() <= 45 ? 2 : 0;
        this.update(this.step0, n);
        this.getWizard().setNextAsDefault();
        this.moduleDir.requestFocus();
        this.currentStep = 0;
    }

    private void updateTo1() {
        this.update(this.step1, 3);
        this.currentStep = 1;
    }

    private void updateTo2() {
        this.update(this.step2, 5);
        this.currentStep = 2;
    }

    private void doit() throws Exception {
        BIFile bIFile;
        FilePath filePath = new FilePath(this.moduleDir.getText()).merge(this.moduleName.getText());
        BFileSystem bFileSystem = BFileSystem.INSTANCE;
        bFileSystem.makeDir(filePath, null);
        BIFile bIFile2 = bFileSystem.makeFile(filePath.merge("build.xml"), null);
        this.doBuild(bIFile2.getOutputStream());
        BIFile bIFile3 = bFileSystem.makeFile(filePath.merge("module-include.xml"), null);
        this.doModuleInclude(bIFile3.getOutputStream());
        if (this.useLexicon.isSelected()) {
            bIFile = bFileSystem.makeFile(filePath.merge("module.lexicon"), null);
            this.doLexicon(bIFile.getOutputStream());
        }
        if (this.usePalette.isSelected()) {
            bIFile = bFileSystem.makeFile(filePath.merge("module.palette"), null);
            this.doPalette(bIFile.getOutputStream());
        }
        bIFile = (DefaultTableModel)this.packages.getModel();
        for (int i = 0; i < bIFile.getRowCount(); ++i) {
            FilePath filePath2 = filePath.merge("src");
            String[] stringArray = TextUtil.split((String)((String)bIFile.getValueAt(i, 0)), (char)'.');
            for (int j = 0; j < stringArray.length; ++j) {
                filePath2 = filePath2.merge(stringArray[j]);
            }
            bFileSystem.makeDir(filePath2, null);
        }
        this.shell.hyperlink(BOrd.make((BOrd)bFileSystem.getNavOrd(), (OrdQuery)filePath));
    }

    private void doBuild(OutputStream outputStream) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<!-- Module Build File -->\n");
        stringBuffer.append("\n");
        stringBuffer.append("<module\n");
        stringBuffer.append("  name = \"").append(this.moduleName.getText()).append("\"\n");
        stringBuffer.append("  bajaVersion = \"0\"\n");
        stringBuffer.append("  preferredSymbol = \"").append(this.prefSymbol.getText()).append("\"\n");
        stringBuffer.append("  description = \"").append(this.description.getText()).append("\"\n");
        stringBuffer.append("  vendor = \"").append(this.vendor.getText()).append("\"\n");
        stringBuffer.append(">\n");
        stringBuffer.append("\n");
        Model model = (Model)this.table.getModel();
        if (model.getRowCount() > 0) {
            stringBuffer.append("  <!-- Dependencies -->\n");
        }
        for (int i = 0; i < model.getRowCount(); ++i) {
            stringBuffer.append("  <dependency name=\"").append((String)model.getValueAt(i, 0)).append("\" ");
            if (model.vendor) {
                stringBuffer.append("vendor=\"").append((String)model.getValueAt(i, 1)).append("\" ");
                stringBuffer.append("vendorVersion=\"").append((String)model.getValueAt(i, 2)).append("\" ");
            }
            stringBuffer.append("/>\n");
        }
        stringBuffer.append("\n");
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.packages.getModel();
        if (defaultTableModel.getRowCount() > 0) {
            stringBuffer.append("  <!-- Packages -->\n");
        }
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            stringBuffer.append("  <package name=\"").append((String)defaultTableModel.getValueAt(i, 0)).append("\" />\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("</module>\n");
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.write(stringBuffer.toString());
        printWriter.flush();
        outputStream.flush();
    }

    private void doModuleInclude(OutputStream outputStream) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<!-- Module Include File -->\n");
        stringBuffer.append("\n");
        stringBuffer.append("<!-- Types -->\n");
        stringBuffer.append("<types>\n");
        stringBuffer.append("  <!-- Type Example:\n");
        stringBuffer.append("  <type name=\"MyClass\" class=\"com.acme.BMyClass\"/>\n");
        stringBuffer.append("  -->\n");
        stringBuffer.append("</types>\n");
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.write(stringBuffer.toString());
        printWriter.flush();
        outputStream.flush();
    }

    private void doLexicon(OutputStream outputStream) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#\n");
        stringBuffer.append("# Lexicon for the ").append(this.moduleName.getText()).append(" module.\n");
        stringBuffer.append("#\n");
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.write(stringBuffer.toString());
        printWriter.flush();
        outputStream.flush();
    }

    private void doPalette(OutputStream outputStream) throws Exception {
        ValueDocEncoder valueDocEncoder = new ValueDocEncoder(outputStream);
        valueDocEncoder.encodeDocument((BValue)new BFolder());
        valueDocEncoder.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        moduleIcon = BImage.make((String)"module://icons/x16/module.png");
        lex = new UiLexicon(class$com$tridium$workbench$tools$NewModuleWizard == null ? (class$com$tridium$workbench$tools$NewModuleWizard = NewModuleWizard.class$("com.tridium.workbench.tools.NewModuleWizard")) : class$com$tridium$workbench$tools$NewModuleWizard);
        banner = BImage.make((String)"module://icons/x32/newModule.png");
        lexUseLexicon = lex.getText("newModule.useLexicon");
        lexUsePalette = lex.getText("newModule.usePalette");
        lexModuleDir = lex.getText("newModule.moduleDir");
        lexModuleName = lex.getText("newModule.moduleName");
        lexPrefSymbol = lex.getText("newModule.prefSymbol");
        lexDescription = lex.getText("newModule.description");
        lexVendor = lex.getText("newModule.vendor");
    }

    class PackageController
    extends TableController {
        PackageController() {
        }

        public void keyReleased(BKeyEvent bKeyEvent) {
            super.keyReleased(bKeyEvent);
            if (bKeyEvent.getKeyCode() == 127) {
                new RemovePackage((BWidget)NewModuleWizard.this.shell).invoke();
            }
        }
    }

    class RemovePackage
    extends Command {
        RemovePackage(BWidget bWidget) {
            super(bWidget, lex.getText("newModule.remove"));
        }

        public CommandArtifact doInvoke() {
            DefaultTableModel defaultTableModel = (DefaultTableModel)NewModuleWizard.this.packages.getModel();
            int[] nArray = NewModuleWizard.this.packages.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                defaultTableModel.removeRow(nArray[i] - i);
            }
            NewModuleWizard.this.packages.relayout();
            return null;
        }
    }

    class AddPackage
    extends Command {
        AddPackage(BWidget bWidget) {
            super(bWidget, lex.getText("newModule.add"));
        }

        public CommandArtifact doInvoke() {
            String string = BDialog.prompt((BWidget)this.getOwner(), (String)lex.getText("newModule.add"), (String)"", (int)50);
            if (string != null) {
                DefaultTableModel defaultTableModel = (DefaultTableModel)NewModuleWizard.this.packages.getModel();
                defaultTableModel.addRow((Object[])new String[]{string});
                NewModuleWizard.this.packages.relayout();
            }
            return null;
        }
    }

    class ChildController
    extends TableController {
        ChildController() {
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            NewModuleWizard.this.getDialog((BWidget)this.getTable()).getOkButton().invokeAction();
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyReleased(BKeyEvent bKeyEvent) {
            super.keyReleased(bKeyEvent);
            if (bKeyEvent.getKeyCode() == 127) {
                new Remove((BWidget)NewModuleWizard.this.shell).invoke();
            }
        }
    }

    class Model
    extends TableModel {
        private ArrayList kids = new ArrayList();
        private String[] cols = new String[]{lex.getText("newModule.moduleName"), lex.getText("newModule.vendor"), lex.getText("newModule.vendorVersion")};
        public boolean vendor = true;

        Model() {
        }

        public void addRow(String[] stringArray) {
            this.kids.add(stringArray);
        }

        public void removeRow(int n) {
            this.kids.remove(n);
        }

        public int getRowCount() {
            return this.kids.size();
        }

        public int getColumnCount() {
            return this.cols.length;
        }

        public String getColumnName(int n) {
            return this.cols[n];
        }

        public BImage getRowIcon(int n) {
            return moduleIcon;
        }

        public Object getSubject(int n) {
            return this.kids.get(n);
        }

        public Object getValueAt(int n, int n2) {
            String[] stringArray = (String[])this.kids.get(n);
            switch (n2) {
                case 0: {
                    return stringArray[0];
                }
                case 1: {
                    return this.vendor ? stringArray[1] : "-";
                }
                case 2: {
                    return this.vendor ? stringArray[2] : "-";
                }
            }
            return "";
        }
    }

    class UseVendorVersion
    extends ToggleCommand {
        UseVendorVersion(BWidget bWidget) {
            super(bWidget, lex.getText("newModule.vendorVersion"));
        }

        public CommandArtifact doInvoke() {
            Model model = (Model)NewModuleWizard.this.table.getModel();
            model.vendor = this.isSelected();
            NewModuleWizard.this.table.relayout();
            return null;
        }
    }

    class Remove
    extends Command {
        Remove(BWidget bWidget) {
            super(bWidget, lex.getText("newModule.remove"));
        }

        public CommandArtifact doInvoke() {
            Model model = (Model)NewModuleWizard.this.table.getModel();
            int[] nArray = NewModuleWizard.this.table.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                model.removeRow(nArray[i] - i);
            }
            NewModuleWizard.this.table.relayout();
            return null;
        }
    }

    class Add
    extends Command {
        Add(BWidget bWidget) {
            super(bWidget, lex.getText("newModule.add"));
        }

        public CommandArtifact doInvoke() {
            DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{lex.getText("newModule.moduleName"), lex.getText("newModule.vendor"), lex.getText("newModule.vendorVersion")});
            ModuleInfo[] moduleInfoArray = Sys.getRegistry().getModules();
            for (int i = 0; i < moduleInfoArray.length; ++i) {
                defaultTableModel.addRow((Object[])new String[]{moduleInfoArray[i].getModuleName(), moduleInfoArray[i].getVendor(), moduleInfoArray[i].getVendorVersion().toString(2)});
            }
            BTable bTable = new BTable((TableModel)defaultTableModel);
            bTable.setController((TableController)new ChildController());
            BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)bTable, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
            bConstrainedPane.setMinWidth(400.0);
            bConstrainedPane.setMaxHeight(300.0);
            BBorderPane bBorderPane = new BBorderPane((BWidget)bConstrainedPane, 10.0, 10.0, 10.0, 10.0);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("newModule.selectDependencies"), (Object)bBorderPane, (int)3)) {
                int[] nArray = bTable.getSelection().getRows();
                if (nArray.length == 0) {
                    return null;
                }
                Model model = (Model)NewModuleWizard.this.table.getModel();
                for (int i = 0; i < nArray.length; ++i) {
                    model.addRow(new String[]{(String)defaultTableModel.getValueAt(nArray[i], 0), (String)defaultTableModel.getValueAt(nArray[i], 1), (String)defaultTableModel.getValueAt(nArray[i], 2)});
                }
                NewModuleWizard.this.table.relayout();
            }
            return null;
        }
    }

    public static class Browse
    extends Command {
        BTextField moduleDir;

        public Browse(BWidget bWidget, BTextField bTextField) {
            super(bWidget, "");
            this.moduleDir = bTextField;
        }

        public String getText() {
            return null;
        }

        public BImage getIcon() {
            return openIcon;
        }

        public CommandArtifact doInvoke() {
            BOrd bOrd;
            if (chooser == null) {
                chooser = BDirectoryChooser.make((BWidget)this.getOwner());
            }
            if ((bOrd = chooser.show()) != null) {
                OrdQuery[] ordQueryArray = bOrd.parse();
                this.moduleDir.setText(ordQueryArray[ordQueryArray.length - 1].getBody());
                this.moduleDir.repaint();
            }
            return null;
        }
    }

    class ModuleNameModel
    extends TextModel {
        ModuleNameModel() {
        }

        protected void textModified() {
            String string = NewModuleWizard.this.moduleName.getText();
            if (NewModuleWizard.this.getWizard() != null) {
                NewModuleWizard.this.getWizard().setNextEnabled(SlotPath.isValidName((String)string) && string.length() <= 45);
            }
        }
    }
}

