/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.tools;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

public class BTodoList
extends BWbView {
    public static final Action filter = BTodoList.newAction((int)0, null);
    public static final Action refreshTable = BTodoList.newAction((int)0, null);
    public static final Action setEnabledStates = BTodoList.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$tools$BTodoList == null ? (class$com$tridium$workbench$tools$BTodoList = BTodoList.class$("com.tridium.workbench.tools.BTodoList")) : class$com$tridium$workbench$tools$BTodoList));
    static final int MODE_FULL = 1;
    static final int MODE_COMPACT = 2;
    static BImage addIcon = BImage.make((String)"module://icons/x16/add.png");
    static BImage editIcon = BImage.make((String)"module://icons/x16/edit.png");
    static BImage completeIcon = BImage.make((String)"module://icons/x16/ok.png");
    static BImage moveToTopIcon = BImage.make((String)"module://icons/x16/moveToTop.png");
    static BImage moveUpIcon = BImage.make((String)"module://icons/x16/moveUp.png");
    static BImage moveDownIcon = BImage.make((String)"module://icons/x16/moveDown.png");
    static BImage moveToBottomIcon = BImage.make((String)"module://icons/x16/moveToBottom.png");
    static BImage removeIcon = BImage.make((String)"module://icons/x16/delete.png");
    static BImage taskIcon = BImage.make((String)"module://icons/x16/task.png");
    static Lexicon lex = Lexicon.make((String)"wbutil");
    Model model;
    BOptions tasks;
    BTextDropDown filterSummary;
    BTextDropDown filterGroup;
    String lastGroup = "General";
    int mode;
    Command cmdAdd;
    Command cmdEdit;
    Command cmdComplete;
    Command cmdMoveToTop;
    Command cmdMoveUp;
    Command cmdMoveDown;
    Command cmdMoveToBottom;
    Command cmdRemove;
    static /* synthetic */ Class class$com$tridium$workbench$tools$BTodoList;

    public void filter() {
        this.invoke(filter, null, null);
    }

    public void refreshTable() {
        this.invoke(refreshTable, null, null);
    }

    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTodoList() {
        this(1);
    }

    public BTodoList(int n) {
        this.mode = n;
        this.tasks = BOptions.load((String)"wbutil-TodoList", (Type)BOptions.TYPE);
        this.cmdAdd = new Add((BWidget)this);
        this.cmdEdit = new Edit((BWidget)this);
        this.cmdComplete = new Completed((BWidget)this);
        this.cmdMoveToTop = new MoveToTop((BWidget)this);
        this.cmdMoveUp = new MoveUp((BWidget)this);
        this.cmdMoveDown = new MoveDown((BWidget)this);
        this.cmdMoveToBottom = new MoveToBottom((BWidget)this);
        this.cmdRemove = new Remove((BWidget)this);
        this.filterSummary = new BTextDropDown("", 15, true);
        this.filterGroup = new BTextDropDown("", 15, true);
        this.linkTo((BComponent)this.filterSummary.getEditor(), (Slot)BTextField.textModified, (Slot)filter);
        this.linkTo((BComponent)this.filterGroup.getEditor(), (Slot)BTextField.textModified, (Slot)filter);
        this.model = new Model();
        BTable bTable = new BTable((TableModel)this.model);
        bTable.setController((TableController)new TodoController());
        bTable.setCellRenderer((TableCellRenderer)new TodoRenderer());
        bTable.setSelection(new TableSelection());
        if (this.isCompact()) {
            bTable.setHeaderVisible(false);
        }
        this.linkTo((BComponent)bTable, (Slot)BTable.selectionModified, (Slot)setEnabledStates);
        this.linkTo((BComponent)this.tasks, (Slot)BOptions.optionsSaved, (Slot)refreshTable);
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, this.cmdAdd);
        if (!this.isCompact()) {
            bToolBar.add(null, this.cmdComplete);
            bToolBar.add(null, this.cmdEdit);
            bToolBar.add(null, (BValue)new BSeparator());
            bToolBar.add(null, this.cmdMoveToTop);
            bToolBar.add(null, this.cmdMoveUp);
            bToolBar.add(null, this.cmdMoveDown);
            bToolBar.add(null, this.cmdMoveToBottom);
            bToolBar.add(null, (BValue)new BSeparator());
            bToolBar.add(null, this.cmdRemove);
        }
        BGridPane bGridPane = null;
        if (!this.isCompact()) {
            bGridPane = new BGridPane(4);
            bGridPane.setRowAlign(BValign.fill);
            bGridPane.add(null, (BValue)new BBorderPane((BWidget)new BLabel(BTodoList.text("summary"), Theme.widget().getBoldText()), 0.0, 0.0, 0.0, 5.0));
            bGridPane.add(null, (BValue)this.filterSummary);
            bGridPane.add(null, (BValue)new BBorderPane((BWidget)new BLabel(BTodoList.text("group"), Theme.widget().getBoldText()), 0.0, 0.0, 0.0, 5.0));
            bGridPane.add(null, (BValue)this.filterGroup);
        }
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)bToolBar);
        if (this.isCompact()) {
            bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.filterGroup, 0.0, 0.0, 0.0, 5.0));
        } else {
            bEdgePane.setRight((BWidget)bGridPane);
        }
        BEdgePane bEdgePane2 = new BEdgePane();
        if (this.isCompact()) {
            bEdgePane2.setTop((BWidget)new BBorderPane((BWidget)bEdgePane, 5.0, 5.0, 5.0, 5.0));
            bEdgePane2.setCenter((BWidget)bTable);
        } else {
            bEdgePane2.setTop((BWidget)new BBorderPane((BWidget)bEdgePane, 0.0, 0.0, 5.0, 0.0));
            bEdgePane2.setCenter((BWidget)new BBorderPane((BWidget)bTable, BBorder.inset, BInsets.DEFAULT));
        }
        StyleUtils.addStyleClass((IStylable)bEdgePane2.getTop(), (String)"sidebar-header");
        this.setContent((BWidget)bEdgePane2);
        this.updateView();
        this.model.sortByColumn(2, true);
        this.model.updateTable(true);
        this.model.getSelection().updateTable();
    }

    BButton makeButton(Command command) {
        BButton bButton = new BButton(command);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        return bButton;
    }

    boolean isCompact() {
        return this.mode == 2;
    }

    int getIndexOf(BComponent bComponent) {
        SlotCursor slotCursor = this.tasks.getSlots();
        int n = 0;
        while (slotCursor.next()) {
            if (slotCursor.slot().getName().equals(bComponent.getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void doReorder(int n) {
        if (this.model.kids.size() == 0) {
            return;
        }
        int[] nArray = this.model.getSelection().getRows();
        BComponent bComponent = (BComponent)this.model.kids.get(nArray[0]);
        Property property = bComponent.getPropertyInParent();
        switch (n) {
            case -3: {
                this.tasks.reorderToTop(property);
                this.model.getSelection().deselectAll();
                this.model.getSelection().select(0);
                break;
            }
            case -2: {
                this.tasks.reorderToBottom(property);
                this.model.getSelection().deselectAll();
                this.model.getSelection().select(this.model.kids.size() - 1);
                break;
            }
            case -1: {
                Property[] propertyArray = this.tasks.getPropertiesArray();
                for (int i = 0; i < propertyArray.length; ++i) {
                    if (propertyArray[i] != property || i <= 0) continue;
                    Property property2 = propertyArray[i - 1];
                    propertyArray[i - 1] = propertyArray[i];
                    propertyArray[i] = property2;
                    this.tasks.reorder(propertyArray);
                    this.model.getSelection().deselectAll();
                    this.model.getSelection().select(nArray[0] - 1);
                }
                break;
            }
            case 1: {
                Property[] propertyArray = this.tasks.getPropertiesArray();
                for (int i = propertyArray.length - 1; i >= 0; --i) {
                    if (propertyArray[i] != property || i >= propertyArray.length - 1) continue;
                    Property property3 = propertyArray[i + 1];
                    propertyArray[i + 1] = propertyArray[i];
                    propertyArray[i] = property3;
                    this.tasks.reorder(propertyArray);
                    this.model.getSelection().deselectAll();
                    this.model.getSelection().select(nArray[0] + 1);
                }
                break;
            }
        }
        this.updateView();
    }

    void updateView() {
        this.tasks.save();
        this.model.refresh();
        this.loadGroups(this.filterGroup.getList());
    }

    void loadGroups(BList bList) {
        bList.removeAllItems();
        Property[] propertyArray = this.tasks.getPropertiesArray();
        for (int i = 0; i < propertyArray.length; ++i) {
            BComponent bComponent = this.tasks.get(propertyArray[i]).asComponent();
            String string = ((BString)bComponent.get("group")).getString();
            if (bList.indexOfItem((Object)string) != -1) continue;
            bList.addItem((Object)string);
        }
    }

    public void doFilter() {
        this.model.refresh();
    }

    public void doSetEnabledStates() {
        boolean bl = this.model.getSelection().getRows().length > 0;
        this.cmdComplete.setEnabled(bl);
        this.cmdEdit.setEnabled(bl);
        this.cmdRemove.setEnabled(bl);
        boolean bl2 = this.model.getRowCount() > 1;
        this.cmdMoveToTop.setEnabled(bl && bl2);
        this.cmdMoveUp.setEnabled(bl && bl2);
        this.cmdMoveDown.setEnabled(bl && bl2);
        this.cmdMoveToBottom.setEnabled(bl && bl2);
    }

    public void doRefreshTable() {
        this.model.refresh();
        this.loadGroups(this.filterGroup.getList());
        if (this.model.getRowCount() == 0) {
            this.model.getSelection().deselectAll();
        }
    }

    static String text(String string) {
        return lex.getText("todoList." + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TodoRenderer
    extends TableCellRenderer {
        BBrush completedColor = BBrush.make((String)"#999");

        TodoRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            BComponent bComponent = (BComponent)BTodoList.this.model.kids.get(cell.row);
            if (bComponent.get("completed") == BBoolean.TRUE) {
                return this.completedColor;
            }
            return super.getForeground(cell);
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            super.paintCell(graphics, cell);
            BComponent bComponent = (BComponent)BTodoList.this.model.kids.get(cell.row);
            if (bComponent.get("completed") == BBoolean.TRUE) {
                String string = this.getCellText(cell);
                BFont bFont = this.getFont(cell);
                double d = cell.column == 0 ? 21.0 : 1.0;
                double d2 = cell.height / 2.0;
                double d3 = bFont.width(string);
                graphics.setBrush(cell.selected ? BColor.white.toBrush() : this.completedColor);
                graphics.strokeLine(d, d2, d + d3 + 1.0, d2);
            }
        }
    }

    class TodoController
    extends TableController {
        TodoController() {
        }

        public void keyPressed(BKeyEvent bKeyEvent) {
            super.keyPressed(bKeyEvent);
            switch (bKeyEvent.getKeyCode()) {
                case 65: {
                    BTodoList.this.cmdAdd.invoke();
                    break;
                }
                case 127: {
                    BTodoList.this.cmdRemove.invoke();
                }
            }
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BTodoList.this.cmdEdit.invoke();
        }

        protected BMenu makePopup(TableSubject tableSubject) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, BTodoList.this.cmdAdd);
            bMenu.add(null, BTodoList.this.cmdComplete);
            bMenu.add(null, BTodoList.this.cmdEdit);
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, BTodoList.this.cmdMoveToTop);
            bMenu.add(null, BTodoList.this.cmdMoveUp);
            bMenu.add(null, BTodoList.this.cmdMoveDown);
            bMenu.add(null, BTodoList.this.cmdMoveToBottom);
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, BTodoList.this.cmdRemove);
            return bMenu;
        }
    }

    class Remove
    extends Command {
        public Remove(BWidget bWidget) {
            super(bWidget, BTodoList.text("remove"));
        }

        public BImage getIcon() {
            return removeIcon;
        }

        public CommandArtifact doInvoke() {
            if (BTodoList.this.model.kids.size() == 0) {
                return null;
            }
            int[] nArray = BTodoList.this.model.getSelection().getRows();
            if (nArray.length == 0) {
                return null;
            }
            if (4 == BDialog.confirm((BWidget)this.getOwner(), (String)BTodoList.text("remove"), (Object)BTodoList.text("removeQuery"))) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    BComponent bComponent = (BComponent)BTodoList.this.model.kids.get(nArray[i]);
                    BTodoList.this.tasks.remove(bComponent.getPropertyInParent());
                }
                BTodoList.this.updateView();
                BTodoList.this.model.getSelection().deselectAll();
            }
            return null;
        }
    }

    class MoveToBottom
    extends Command {
        public MoveToBottom(BWidget bWidget) {
            super(bWidget, BTodoList.text("moveToBottom"));
        }

        public BImage getIcon() {
            return moveToBottomIcon;
        }

        public CommandArtifact doInvoke() {
            BTodoList.this.doReorder(-2);
            return null;
        }
    }

    class MoveDown
    extends Command {
        public MoveDown(BWidget bWidget) {
            super(bWidget, BTodoList.text("moveDown"));
        }

        public BImage getIcon() {
            return moveDownIcon;
        }

        public CommandArtifact doInvoke() {
            BTodoList.this.doReorder(1);
            return null;
        }
    }

    class MoveUp
    extends Command {
        public MoveUp(BWidget bWidget) {
            super(bWidget, BTodoList.text("moveUp"));
        }

        public BImage getIcon() {
            return moveUpIcon;
        }

        public CommandArtifact doInvoke() {
            BTodoList.this.doReorder(-1);
            return null;
        }
    }

    class MoveToTop
    extends Command {
        public MoveToTop(BWidget bWidget) {
            super(bWidget, BTodoList.text("moveToTop"));
        }

        public BImage getIcon() {
            return moveToTopIcon;
        }

        public CommandArtifact doInvoke() {
            BTodoList.this.doReorder(-3);
            return null;
        }
    }

    class Completed
    extends Command {
        public Completed(BWidget bWidget) {
            super(bWidget, BTodoList.text("completed"));
        }

        public BImage getIcon() {
            return completeIcon;
        }

        public CommandArtifact doInvoke() {
            if (BTodoList.this.model.kids.size() == 0) {
                return null;
            }
            int[] nArray = BTodoList.this.model.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                BComponent bComponent = (BComponent)BTodoList.this.model.kids.get(nArray[i]);
                BBoolean bBoolean = (BBoolean)bComponent.get("completed");
                if (bBoolean == null) {
                    bComponent.add("completed", (BValue)BBoolean.TRUE);
                    bComponent.add("dateCompleted", (BValue)BAbsTime.now());
                    continue;
                }
                if (bBoolean == BBoolean.FALSE) {
                    bComponent.set("completed", (BValue)BBoolean.TRUE);
                    bComponent.add("dateCompleted", (BValue)BAbsTime.now());
                    continue;
                }
                if (bBoolean != BBoolean.TRUE) continue;
                bComponent.set("completed", (BValue)BBoolean.FALSE);
                bComponent.remove("dateCompleted");
            }
            BTodoList.this.updateView();
            return null;
        }
    }

    class Edit
    extends Command {
        public Edit(BWidget bWidget) {
            super(bWidget, BTodoList.text("edit"));
        }

        public BImage getIcon() {
            return editIcon;
        }

        public CommandArtifact doInvoke() {
            if (BTodoList.this.model.kids.size() == 0) {
                return null;
            }
            int n = BTodoList.this.model.getSelection().getRow();
            BComponent bComponent = (BComponent)BTodoList.this.model.kids.get(n);
            BTextField bTextField = new BTextField(bComponent.get("summary").toString(), 50);
            BTextDropDown bTextDropDown = new BTextDropDown(bComponent.get("group").toString(), 30, true);
            BTodoList.this.loadGroups(bTextDropDown.getList());
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.add(null, (BValue)new BLabel(BTodoList.text("summary")));
            bGridPane.add(null, (BValue)bTextField);
            bGridPane.add(null, (BValue)new BLabel(BTodoList.text("group")));
            bGridPane.add(null, (BValue)bTextDropDown);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)BTodoList.text("edit"), (Object)new BBorderPane((BWidget)bGridPane), (int)3)) {
                bComponent.set("summary", (BValue)BString.make((String)bTextField.getText()));
                bComponent.set("group", (BValue)BString.make((String)bTextDropDown.getText()));
                BTodoList.this.updateView();
                BTodoList.this.model.getSelection().deselectAll();
            }
            return null;
        }
    }

    class Add
    extends Command {
        public Add(BWidget bWidget) {
            super(bWidget, BTodoList.text("add"));
        }

        public BImage getIcon() {
            return addIcon;
        }

        public CommandArtifact doInvoke() {
            BTextField bTextField = new BTextField("", 50);
            BTextDropDown bTextDropDown = new BTextDropDown(BTodoList.this.lastGroup, 30, true);
            BTodoList.this.loadGroups(bTextDropDown.getList());
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.add(null, (BValue)new BLabel(BTodoList.text("summary")));
            bGridPane.add(null, (BValue)bTextField);
            bGridPane.add(null, (BValue)new BLabel(BTodoList.text("group")));
            bGridPane.add(null, (BValue)bTextDropDown);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)BTodoList.text("add"), (Object)new BBorderPane((BWidget)bGridPane), (int)3)) {
                BComponent bComponent = new BComponent();
                bComponent.add("summary", (BValue)BString.make((String)bTextField.getText()));
                bComponent.add("group", (BValue)BString.make((String)bTextDropDown.getText()));
                bComponent.add("date", (BValue)BAbsTime.now());
                BTodoList.this.tasks.add(null, (BValue)bComponent);
                BTodoList.this.updateView();
                BTodoList.this.lastGroup = bTextDropDown.getText();
                BTodoList.this.model.getSelection().deselectAll();
            }
            return null;
        }
    }

    class ClearFilters
    extends Command {
        public ClearFilters(BWidget bWidget) {
            super(bWidget, "");
        }

        public String getLabel() {
            return null;
        }

        public BImage getIcon() {
            return removeIcon;
        }

        public CommandArtifact doInvoke() {
            BTodoList.this.filterSummary.getEditor().setText("");
            BTodoList.this.filterGroup.getEditor().setText("");
            BTodoList.this.doFilter();
            return null;
        }
    }

    class Sorter
    implements Comparator {
        int col = 0;
        boolean ascend = true;

        public Sorter(int n, boolean bl) {
            this.col = n;
            this.ascend = bl;
        }

        public int compare(Object object, Object object2) {
            BComponent bComponent = (BComponent)object;
            BComponent bComponent2 = (BComponent)object2;
            switch (this.col) {
                case 0: {
                    String string = bComponent.get("summary").toString();
                    String string2 = bComponent2.get("summary").toString();
                    return this.ascend ? string.compareToIgnoreCase(string2) : string2.compareToIgnoreCase(string);
                }
                case 1: {
                    String string = bComponent.get("group").toString();
                    String string3 = bComponent2.get("group").toString();
                    return this.ascend ? string.compareToIgnoreCase(string3) : string3.compareToIgnoreCase(string);
                }
                case 2: {
                    int n = BTodoList.this.getIndexOf(bComponent);
                    int n2 = BTodoList.this.getIndexOf(bComponent2);
                    if (n < n2) {
                        return this.ascend ? -1 : 1;
                    }
                    if (n > n2) {
                        return this.ascend ? 1 : -1;
                    }
                    return 0;
                }
                case 3: {
                    BAbsTime bAbsTime = (BAbsTime)bComponent.get("date");
                    BAbsTime bAbsTime2 = (BAbsTime)bComponent2.get("date");
                    return this.ascend ? bAbsTime.compareTo((Object)bAbsTime2) : bAbsTime2.compareTo((Object)bAbsTime);
                }
                case 4: {
                    BAbsTime bAbsTime = (BAbsTime)bComponent.get("dateCompleted");
                    BAbsTime bAbsTime3 = (BAbsTime)bComponent2.get("dateCompleted");
                    if (bAbsTime != null && bAbsTime3 != null) {
                        return this.ascend ? bAbsTime.compareTo((Object)bAbsTime3) : bAbsTime3.compareTo((Object)bAbsTime);
                    }
                    if (bAbsTime == null && bAbsTime3 == null) {
                        return 0;
                    }
                    if (bAbsTime != null && bAbsTime3 == null) {
                        return this.ascend ? 1 : -1;
                    }
                    if (bAbsTime != null || bAbsTime3 == null) break;
                    return this.ascend ? -1 : 1;
                }
            }
            return 0;
        }
    }

    class Model
    extends TableModel {
        ArrayList kids = new ArrayList();

        Model() {
        }

        public int getRowCount() {
            return this.kids.size();
        }

        public int getColumnCount() {
            return BTodoList.this.isCompact() ? 1 : 5;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return BTodoList.text("summary");
                }
                case 1: {
                    return BTodoList.text("group");
                }
                case 2: {
                    return BTodoList.text("priority");
                }
                case 3: {
                    return BTodoList.text("date");
                }
                case 4: {
                    return BTodoList.text("dateCompleted");
                }
            }
            return "";
        }

        public Object getValueAt(int n, int n2) {
            BComponent bComponent = (BComponent)this.kids.get(n);
            switch (n2) {
                case 0: {
                    return bComponent.get("summary");
                }
                case 1: {
                    return bComponent.get("group");
                }
                case 2: {
                    return Integer.toString(BTodoList.this.getIndexOf(bComponent));
                }
                case 3: {
                    return bComponent.get("date");
                }
                case 4: {
                    return bComponent.get("dateCompleted") == null ? new String("Task Still Open") : bComponent.get("dateCompleted");
                }
            }
            return "";
        }

        public Object getSubject(int n) {
            return this.kids.get(n);
        }

        public BImage getRowIcon(int n) {
            return taskIcon;
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            BComponent[] bComponentArray = this.kids.toArray(new BComponent[this.kids.size()]);
            Arrays.sort(bComponentArray, new Sorter(n, bl));
            this.kids.clear();
            for (int i = 0; i < bComponentArray.length; ++i) {
                this.kids.add(bComponentArray[i]);
            }
        }

        public void refresh() {
            this.kids.clear();
            Property[] propertyArray = BTodoList.this.tasks.getPropertiesArray();
            for (int i = 0; i < propertyArray.length; ++i) {
                BComponent bComponent = BTodoList.this.tasks.get(propertyArray[i]).asComponent();
                String string = BTodoList.this.filterGroup.getText().toLowerCase();
                String string2 = ((BString)bComponent.get("group")).getString().toLowerCase();
                if (string.length() != 0 && string2.indexOf(string) == -1) continue;
                string = BTodoList.this.filterSummary.getText().toLowerCase();
                string2 = ((BString)bComponent.get("summary")).getString().toLowerCase();
                if (string.length() != 0 && string2.indexOf(string) == -1) continue;
                this.kids.add(bComponent);
            }
            this.updateTable(true);
        }
    }
}

