/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.tools;

import com.tridium.timezone.HistoricalDstRule;
import com.tridium.timezone.HistoricalTimeZone;
import com.tridium.timezone.HistoricalTimeZoneDate;
import com.tridium.timezone.HistoricalTimeZoneEra;
import com.tridium.timezone.TimeZoneDatabaseManifest;
import com.tridium.timezone.TzJarUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.util.ObjectUtil;
import com.tridium.workbench.fieldeditors.BAbsTimeFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

public class BTimeZoneViewer
extends BWbView {
    public static final Action databaseTimeZoneModified = BTimeZoneViewer.newAction((int)4, null);
    public static final Action dstCalculatorValuesModified = BTimeZoneViewer.newAction((int)4, null);
    public static final Action calculatorSourceTimeZoneModified = BTimeZoneViewer.newAction((int)4, null);
    public static final Action calculatorTargetTimeZoneModified = BTimeZoneViewer.newAction((int)4, null);
    public static final Action calculatorSourceTimeModified = BTimeZoneViewer.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$tools$BTimeZoneViewer == null ? (class$com$tridium$workbench$tools$BTimeZoneViewer = BTimeZoneViewer.class$("com.tridium.workbench.tools.BTimeZoneViewer")) : class$com$tridium$workbench$tools$BTimeZoneViewer));
    public static final Comparator TZ_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            long l = System.currentTimeMillis();
            BTimeZone bTimeZone = (BTimeZone)object;
            BTimeZone bTimeZone2 = (BTimeZone)object2;
            if (bTimeZone.getUtcOffset(l) == bTimeZone2.getUtcOffset(l)) {
                return bTimeZone.getId().compareTo(bTimeZone2.getId());
            }
            if (bTimeZone.getUtcOffset(l) < bTimeZone2.getUtcOffset(l)) {
                return -1;
            }
            return 1;
        }
    };
    public static BFont BOLD_TEXT_FONT = Theme.widget().getBoldText();
    private static final Lexicon lex = Lexicon.make((String)"wbutil");
    private BTabbedPane tabbedPane = null;
    private BBorderPane borderedMetaPane = null;
    private BEdgePane metaEdgePane = null;
    private BGridPane metaTopPane = null;
    private BLabel metaVersionLabel = null;
    private BLabel metaSourceLabel = null;
    private BLabel metaMinYearLabel = null;
    private BLabel metaMaxYearLabel = null;
    private BTextEditor americasZonesProvided = null;
    private BTextEditor indianZonesProvided = null;
    private BTextEditor canadaZonesProvided = null;
    private BTextEditor asiaZonesProvided = null;
    private BTextEditor africaZonesProvided = null;
    private BTextEditor atlanticZonesProvided = null;
    private BTextEditor europeZonesProvided = null;
    private BTextEditor antarcticaZonesProvided = null;
    private BTextEditor australiaZonesProvided = null;
    private BTextEditor otherZonesProvided = null;
    private BTextEditor pacificZonesProvided = null;
    private BTextEditor usZonesProvided = null;
    private BTextEditor etcZonesProvided = null;
    private BBorderPane borderedDstPane = null;
    private BGridPane dstPane = null;
    private BListDropDown dstTimeZoneDropDown = null;
    private BIntegerFE targetYear = null;
    private BLabel dstStartTime = null;
    private BLabel dstEndTime = null;
    private BLabel inDaylightNow = null;
    private BBorderPane borderedCalculatorPane = null;
    private BGridPane calculatorPane = null;
    private BAbsTimeFE sourceTimeFE = null;
    private BAbsTimeFE targetTimeFE = null;
    private BListDropDown sourceTimeZoneDropDown = null;
    private BListDropDown targetTimeZoneDropDown = null;
    private BBorderPane borderedDatabasePane = null;
    private BEdgePane databaseEdgePane = null;
    private BBorderPane databaseTimeZoneEraPaneBorder = null;
    private BGridPane databaseTopPane = null;
    private BListDropDown databaseTimeZoneDropDown = null;
    private BAbsTimeFE currentTimeInTimeZoneFE = null;
    private BLabel historicalTimeZoneLabel = null;
    private static final BTimeZone[] zonesAsZones = TimeZoneDatabase.get().getTimeZones();
    private static final BFacets yearFacets = BFacets.make((String[])new String[]{"min", "max", "fieldWidth"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1900), BInteger.make((int)9999), BInteger.make((int)5)});
    static /* synthetic */ Class class$com$tridium$workbench$tools$BTimeZoneViewer;
    static /* synthetic */ Class class$javax$baja$timezone$BTimeZone;

    public void databaseTimeZoneModified() {
        this.invoke(databaseTimeZoneModified, null, null);
    }

    public void dstCalculatorValuesModified() {
        this.invoke(dstCalculatorValuesModified, null, null);
    }

    public void calculatorSourceTimeZoneModified() {
        this.invoke(calculatorSourceTimeZoneModified, null, null);
    }

    public void calculatorTargetTimeZoneModified() {
        this.invoke(calculatorTargetTimeZoneModified, null, null);
    }

    public void calculatorSourceTimeModified() {
        this.invoke(calculatorSourceTimeModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void deactivated() {
        super.deactivated();
        this.tabbedPane = null;
        this.borderedMetaPane = null;
        this.metaEdgePane = null;
        this.metaTopPane = null;
        this.metaVersionLabel = null;
        this.metaSourceLabel = null;
        this.metaMinYearLabel = null;
        this.metaMaxYearLabel = null;
        this.americasZonesProvided = null;
        this.indianZonesProvided = null;
        this.canadaZonesProvided = null;
        this.asiaZonesProvided = null;
        this.africaZonesProvided = null;
        this.atlanticZonesProvided = null;
        this.europeZonesProvided = null;
        this.antarcticaZonesProvided = null;
        this.australiaZonesProvided = null;
        this.otherZonesProvided = null;
        this.pacificZonesProvided = null;
        this.usZonesProvided = null;
        this.etcZonesProvided = null;
        this.borderedCalculatorPane = null;
        this.calculatorPane = null;
        this.sourceTimeFE = null;
        this.targetTimeFE = null;
        this.sourceTimeZoneDropDown = null;
        this.targetTimeZoneDropDown = null;
        this.borderedDatabasePane = null;
        this.databaseEdgePane = null;
        this.databaseTimeZoneEraPaneBorder = null;
        this.databaseTopPane = null;
        this.databaseTimeZoneDropDown = null;
        this.currentTimeInTimeZoneFE = null;
        this.historicalTimeZoneLabel = null;
        this.borderedDstPane = null;
        this.dstPane = null;
        this.dstTimeZoneDropDown = null;
        this.targetYear = null;
        this.dstStartTime = null;
        this.dstEndTime = null;
        this.inDaylightNow = null;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BTimeZone bTimeZone;
        if (zonesAsZones.length <= 0) {
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.setHalign(BHalign.left);
            bGridPane.setValign(BValign.top);
            bGridPane.setColumnGap(10.0);
            bGridPane.setRowGap(6.0);
            bGridPane.setColorRows(false);
            bGridPane.add("error", (BValue)new BLabel("Time Zone Database Unavailable."));
            this.setContent((BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)bGridPane, BBorder.solid), BBorder.inset, BInsets.DEFAULT));
            return;
        }
        this.tabbedPane = new BTabbedPane();
        this.metaTopPane = new BGridPane(2);
        this.metaTopPane.setHalign(BHalign.left);
        this.metaTopPane.setValign(BValign.top);
        this.metaTopPane.setColumnAlign(BHalign.left);
        this.metaTopPane.setColumnGap(10.0);
        this.metaTopPane.setRowGap(6.0);
        this.metaTopPane.setColorRows(false);
        TimeZoneDatabaseManifest timeZoneDatabaseManifest = TimeZoneDatabase.getManifest();
        this.metaVersionLabel = new BLabel();
        BTimeZoneViewer.addLabelWidgetPair(this.metaTopPane, BTimeZoneViewer.text("meta.version"), (BWidget)this.metaVersionLabel, true);
        this.metaSourceLabel = new BLabel();
        BTimeZoneViewer.addLabelWidgetPair(this.metaTopPane, BTimeZoneViewer.text("meta.source"), (BWidget)this.metaSourceLabel, true);
        this.metaMinYearLabel = new BLabel();
        BTimeZoneViewer.addLabelWidgetPair(this.metaTopPane, BTimeZoneViewer.text("meta.minYear"), (BWidget)this.metaMinYearLabel, true);
        this.metaMaxYearLabel = new BLabel();
        BTimeZoneViewer.addLabelWidgetPair(this.metaTopPane, BTimeZoneViewer.text("meta.maxYear"), (BWidget)this.metaMaxYearLabel, true);
        this.metaVersionLabel.setText(timeZoneDatabaseManifest.getVersion().toString());
        this.metaSourceLabel.setText(timeZoneDatabaseManifest.getSource());
        this.metaMinYearLabel.setText(String.valueOf(timeZoneDatabaseManifest.getMinYear()));
        this.metaMaxYearLabel.setText(String.valueOf(timeZoneDatabaseManifest.getMaxYear()));
        this.metaEdgePane = new BEdgePane();
        this.metaEdgePane.setTop((BWidget)this.metaTopPane);
        Object[] objectArray = timeZoneDatabaseManifest.getZoneIds();
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        StringBuffer stringBuffer5 = new StringBuffer();
        StringBuffer stringBuffer6 = new StringBuffer();
        StringBuffer stringBuffer7 = new StringBuffer();
        StringBuffer stringBuffer8 = new StringBuffer();
        StringBuffer stringBuffer9 = new StringBuffer();
        StringBuffer stringBuffer10 = new StringBuffer();
        StringBuffer stringBuffer11 = new StringBuffer();
        StringBuffer stringBuffer12 = new StringBuffer();
        StringBuffer stringBuffer13 = new StringBuffer();
        String string = System.getProperty("line.separator", "\n");
        for (int i = 0; i < objectArray.length; ++i) {
            if (((String)objectArray[i]).startsWith("Africa/")) {
                stringBuffer.append((String)objectArray[i] + string);
                continue;
            }
            if (((String)objectArray[i]).startsWith("Atlantic/")) {
                stringBuffer5.append((String)objectArray[i] + string);
                continue;
            }
            if (((String)objectArray[i]).startsWith("America/")) {
                stringBuffer2.append((String)objectArray[i] + string);
                continue;
            }
            if (((String)objectArray[i]).startsWith("Antarctica/")) {
                stringBuffer3.append((String)objectArray[i] + string);
                continue;
            }
            if (((String)objectArray[i]).startsWith("Asia/")) {
                stringBuffer4.append((String)objectArray[i] + string);
                continue;
            }
            if (((String)objectArray[i]).startsWith("Australia/")) {
                stringBuffer6.append((String)objectArray[i] + string);
                continue;
            }
            if (((String)objectArray[i]).startsWith("Canada/")) {
                stringBuffer12.append((String)objectArray[i] + string);
                continue;
            }
            if (((String)objectArray[i]).startsWith("Etc/")) {
                stringBuffer13.append((String)objectArray[i] + string);
                continue;
            }
            if (((String)objectArray[i]).startsWith("Europe/")) {
                stringBuffer7.append((String)objectArray[i] + string);
                continue;
            }
            if (((String)objectArray[i]).startsWith("Indian/")) {
                stringBuffer11.append((String)objectArray[i] + string);
                continue;
            }
            if (((String)objectArray[i]).startsWith("Pacific/")) {
                stringBuffer9.append((String)objectArray[i] + string);
                continue;
            }
            if (((String)objectArray[i]).startsWith("US/")) {
                stringBuffer10.append((String)objectArray[i] + string);
                continue;
            }
            stringBuffer8.append((String)objectArray[i] + string);
        }
        this.africaZonesProvided = new BTextEditor(stringBuffer.toString(), false);
        this.americasZonesProvided = new BTextEditor(stringBuffer2.toString(), false);
        this.antarcticaZonesProvided = new BTextEditor(stringBuffer3.toString(), false);
        this.asiaZonesProvided = new BTextEditor(stringBuffer4.toString(), false);
        this.atlanticZonesProvided = new BTextEditor(stringBuffer5.toString(), false);
        this.australiaZonesProvided = new BTextEditor(stringBuffer6.toString(), false);
        this.europeZonesProvided = new BTextEditor(stringBuffer7.toString(), false);
        this.otherZonesProvided = new BTextEditor(stringBuffer8.toString(), false);
        this.pacificZonesProvided = new BTextEditor(stringBuffer9.toString(), false);
        this.usZonesProvided = new BTextEditor(stringBuffer10.toString(), false);
        this.indianZonesProvided = new BTextEditor(stringBuffer11.toString(), false);
        this.canadaZonesProvided = new BTextEditor(stringBuffer12.toString(), false);
        this.etcZonesProvided = new BTextEditor(stringBuffer13.toString(), false);
        BTabbedPane bTabbedPane = new BTabbedPane();
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.africaZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("Africa", false), (BWidget)bScrollPane);
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.americasZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("Americas", false), (BWidget)bScrollPane);
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.antarcticaZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("Antarctica", false), (BWidget)bScrollPane);
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.asiaZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("Asia", false), (BWidget)bScrollPane);
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.atlanticZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("Atlantic", false), (BWidget)bScrollPane);
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.australiaZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("Australia", false), (BWidget)bScrollPane);
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.canadaZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("Canada", false), (BWidget)bScrollPane);
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.europeZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("Europe", false), (BWidget)bScrollPane);
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.etcZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("Etc", false), (BWidget)bScrollPane);
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.indianZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("Indian", false), (BWidget)bScrollPane);
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.otherZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("Other", false), (BWidget)bScrollPane);
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.pacificZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("Pacific", false), (BWidget)bScrollPane);
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.usZonesProvided, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bTabbedPane.addPane(BTimeZoneViewer.makeLabel("US", false), (BWidget)bScrollPane);
        BBorderPane bBorderPane = new BBorderPane((BWidget)BTimeZoneViewer.makeLabel(BTimeZoneViewer.text("meta.zonesProvided"), true), BInsets.make((double)9.0, (double)0.0, (double)0.0, (double)0.0));
        this.metaEdgePane.setCenter((BWidget)new BEdgePane((BWidget)bBorderPane, null, null, null, (BWidget)new BBorderPane((BWidget)bTabbedPane, 5.0, 5.0, 5.0, 5.0)));
        this.borderedMetaPane = new BBorderPane((BWidget)new BBorderPane((BWidget)this.metaEdgePane, BBorder.solid), BBorder.inset, BInsets.DEFAULT);
        this.dstPane = new BGridPane(2);
        this.dstPane.setHalign(BHalign.left);
        this.dstPane.setValign(BValign.top);
        this.dstPane.setColumnAlign(BHalign.left);
        this.dstPane.setColumnGap(10.0);
        this.dstPane.setRowGap(6.0);
        this.dstPane.setColorRows(false);
        this.dstTimeZoneDropDown = new BListDropDown();
        BTimeZoneViewer.addLabelWidgetPair(this.dstPane, BTimeZoneViewer.text("dst.timezone"), (BWidget)this.dstTimeZoneDropDown, true);
        this.targetYear = new BIntegerFE();
        BTimeZoneViewer.addLabelWidgetPair(this.dstPane, BTimeZoneViewer.text("dst.year"), (BWidget)this.targetYear, true);
        this.dstStartTime = new BLabel();
        BTimeZoneViewer.addLabelWidgetPair(this.dstPane, BTimeZoneViewer.text("dst.startDate"), (BWidget)this.dstStartTime, true);
        this.dstEndTime = new BLabel();
        BTimeZoneViewer.addLabelWidgetPair(this.dstPane, BTimeZoneViewer.text("dst.endDate"), (BWidget)this.dstEndTime, true);
        this.inDaylightNow = new BLabel();
        BTimeZoneViewer.addLabelWidgetPair(this.dstPane, BTimeZoneViewer.text("dst.inDaylightNow"), (BWidget)this.inDaylightNow, true);
        this.dstTimeZoneDropDown.getList().setModel((ListModel)new ZoneListModel(zonesAsZones));
        this.dstTimeZoneDropDown.setSelectedItem((Object)BTimeZone.getLocal());
        this.dstTimeZoneDropDown.getList().setMultipleSelection(false);
        this.targetYear.loadValue((BObject)BInteger.make((int)BAbsTime.now().getYear()), (Context)yearFacets);
        this.doDstCalculatorValuesModified();
        this.linkTo(null, (BComponent)this.dstTimeZoneDropDown, (Slot)BListDropDown.valueModified, (Slot)dstCalculatorValuesModified);
        this.linkTo(null, (BComponent)this.targetYear, (Slot)BIntegerFE.actionPerformed, (Slot)dstCalculatorValuesModified);
        this.borderedDstPane = new BBorderPane((BWidget)new BBorderPane((BWidget)this.dstPane, BBorder.solid), BBorder.inset, BInsets.DEFAULT);
        this.calculatorPane = new BGridPane(2);
        this.calculatorPane.setHalign(BHalign.left);
        this.calculatorPane.setValign(BValign.top);
        this.calculatorPane.setColumnAlign(BHalign.left);
        this.calculatorPane.setColumnGap(10.0);
        this.calculatorPane.setRowGap(6.0);
        this.calculatorPane.setColorRows(false);
        this.sourceTimeFE = new BAbsTimeFE();
        BTimeZoneViewer.addLabelWidgetPair(this.calculatorPane, BTimeZoneViewer.text("calculator.sourceTime"), (BWidget)this.sourceTimeFE, true);
        this.sourceTimeZoneDropDown = new BListDropDown();
        BTimeZoneViewer.addLabelWidgetPair(this.calculatorPane, BTimeZoneViewer.text("calculator.sourceTimeZone"), (BWidget)this.sourceTimeZoneDropDown, true);
        this.targetTimeZoneDropDown = new BListDropDown();
        BTimeZoneViewer.addLabelWidgetPair(this.calculatorPane, BTimeZoneViewer.text("calculator.targetTimeZone"), (BWidget)this.targetTimeZoneDropDown, true);
        this.targetTimeFE = new BAbsTimeFE();
        BTimeZoneViewer.addLabelWidgetPair(this.calculatorPane, BTimeZoneViewer.text("calculator.targetTime"), (BWidget)this.targetTimeFE, true);
        this.sourceTimeZoneDropDown.getList().setModel((ListModel)new ZoneListModel(zonesAsZones));
        this.sourceTimeZoneDropDown.setSelectedItem((Object)BTimeZone.getLocal());
        this.sourceTimeZoneDropDown.getList().setMultipleSelection(false);
        BTimeZone bTimeZone2 = (BTimeZone)this.sourceTimeZoneDropDown.getSelectedItem();
        bTimeZone2 = bTimeZone2 == null ? BTimeZone.UTC : BTimeZone.getTimeZone((String)bTimeZone2.getId());
        this.sourceTimeFE.loadValue((BObject)BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)bTimeZone2), (Context)BFacets.make((String)"showTimeZone", (boolean)false));
        this.targetTimeZoneDropDown.getList().setModel((ListModel)new ZoneListModel(zonesAsZones));
        this.targetTimeZoneDropDown.setSelectedItem((Object)BTimeZone.getLocal());
        this.targetTimeZoneDropDown.getList().setMultipleSelection(false);
        this.targetTimeFE.setReadonly(true);
        try {
            bTimeZone = (BTimeZone)this.targetTimeZoneDropDown.getSelectedItem();
            bTimeZone = bTimeZone == null ? BTimeZone.UTC : BTimeZone.getTimeZone((String)bTimeZone.getId());
            this.targetTimeFE.loadValue((BObject)BAbsTime.make((long)((BAbsTime)this.sourceTimeFE.saveValue()).getMillis(), (BTimeZone)bTimeZone));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.linkTo(null, (BComponent)this.sourceTimeZoneDropDown, (Slot)BListDropDown.valueModified, (Slot)calculatorSourceTimeZoneModified);
        this.linkTo(null, (BComponent)this.sourceTimeFE, (Slot)BAbsTimeFE.pluginModified, (Slot)calculatorSourceTimeModified);
        this.linkTo(null, (BComponent)this.targetTimeZoneDropDown, (Slot)BListDropDown.valueModified, (Slot)calculatorTargetTimeZoneModified);
        this.borderedCalculatorPane = new BBorderPane((BWidget)new BBorderPane((BWidget)this.calculatorPane, BBorder.solid), BBorder.inset, BInsets.DEFAULT);
        this.databaseTopPane = new BGridPane(2);
        this.databaseTopPane.setHalign(BHalign.left);
        this.databaseTopPane.setValign(BValign.top);
        this.databaseTopPane.setColumnAlign(BHalign.left);
        this.databaseTopPane.setColumnGap(10.0);
        this.databaseTopPane.setRowGap(6.0);
        this.databaseTopPane.setColorRows(false);
        this.databaseTimeZoneDropDown = new BListDropDown();
        BTimeZoneViewer.addLabelWidgetPair(this.databaseTopPane, BTimeZoneViewer.text("database.sourceTimeZone"), (BWidget)this.databaseTimeZoneDropDown, true);
        this.currentTimeInTimeZoneFE = new BAbsTimeFE();
        BTimeZoneViewer.addLabelWidgetPair(this.databaseTopPane, BTimeZoneViewer.text("database.currentTime"), (BWidget)this.currentTimeInTimeZoneFE, true);
        this.historicalTimeZoneLabel = new BLabel("");
        BTimeZoneViewer.addLabelWidgetPair(this.databaseTopPane, BTimeZoneViewer.text("database.historicalTimeZone"), (BWidget)this.historicalTimeZoneLabel, true);
        this.databaseTimeZoneDropDown.getList().setModel((ListModel)new ZoneListModel(zonesAsZones));
        this.databaseTimeZoneDropDown.setSelectedItem((Object)BTimeZone.getLocal());
        this.databaseTimeZoneDropDown.getList().setMultipleSelection(false);
        bTimeZone = (BTimeZone)this.databaseTimeZoneDropDown.getSelectedItem();
        if (bTimeZone == null) {
            bTimeZone = BTimeZone.UTC;
        }
        this.currentTimeInTimeZoneFE.loadValue((BObject)BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)bTimeZone));
        this.currentTimeInTimeZoneFE.setReadonly(true);
        this.linkTo(null, (BComponent)this.databaseTimeZoneDropDown, (Slot)BListDropDown.valueModified, (Slot)databaseTimeZoneModified);
        this.databaseEdgePane = new BEdgePane();
        this.databaseEdgePane.setTop((BWidget)this.databaseTopPane);
        this.databaseTimeZoneEraPaneBorder = new BBorderPane((BWidget)new BNullWidget(), BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0));
        bScrollPane = new BScrollPane((BWidget)this.databaseTimeZoneEraPaneBorder);
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        bBorderPane = new BBorderPane((BWidget)BTimeZoneViewer.makeLabel(BTimeZoneViewer.text("database.eraTitle"), true), BInsets.make((double)9.0, (double)0.0, (double)0.0, (double)0.0));
        this.databaseEdgePane.setCenter((BWidget)new BEdgePane((BWidget)bBorderPane, null, null, null, (BWidget)bScrollPane));
        this.borderedDatabasePane = new BBorderPane((BWidget)new BBorderPane((BWidget)this.databaseEdgePane, BBorder.solid), BBorder.inset, BInsets.DEFAULT);
        this.doDatabaseTimeZoneModified();
        this.tabbedPane.addPane(BTimeZoneViewer.makeLabel(BTimeZoneViewer.text("meta.title"), BImage.make((BIcon)BIcon.std((String)"specification.png")), false), (BWidget)this.borderedMetaPane);
        this.tabbedPane.addPane(BTimeZoneViewer.makeLabel(BTimeZoneViewer.text("database.title"), BImage.make((BIcon)BIcon.make((BIcon)BIcon.std((String)"database.png"), (BIcon)BIcon.std((String)"badges/clock.png"))), false), (BWidget)this.borderedDatabasePane);
        this.tabbedPane.addPane(BTimeZoneViewer.makeLabel(BTimeZoneViewer.text("dst.title"), BImage.make((BIcon)BIcon.std((String)"calendar.png")), false), (BWidget)this.borderedDstPane);
        this.tabbedPane.addPane(BTimeZoneViewer.makeLabel(BTimeZoneViewer.text("calculator.title"), BImage.make((BIcon)BIcon.make((BIcon)BIcon.std((String)"planet.png"), (BIcon)BIcon.std((String)"badges/clock.png"))), false), (BWidget)this.borderedCalculatorPane);
        this.setContent((BWidget)this.tabbedPane);
    }

    public void doCalculatorSourceTimeZoneModified() {
        try {
            if (this.sourceTimeFE != null && this.sourceTimeZoneDropDown != null && this.sourceTimeZoneDropDown.getSelectedItem() != null) {
                BAbsTime bAbsTime = (BAbsTime)this.sourceTimeFE.saveValue();
                BTimeZone bTimeZone = (BTimeZone)this.sourceTimeZoneDropDown.getSelectedItem();
                bTimeZone = bTimeZone == null ? BTimeZone.UTC : BTimeZone.getTimeZone((String)bTimeZone.getId());
                this.sourceTimeFE.loadValue((BObject)BAbsTime.make((long)bAbsTime.getMillis(), (BTimeZone)bTimeZone));
                this.relayout();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doCalculatorSourceTimeModified() {
        try {
            BAbsTime bAbsTime = (BAbsTime)this.sourceTimeFE.saveValue();
            BTimeZone bTimeZone = (BTimeZone)this.targetTimeZoneDropDown.getSelectedItem();
            bTimeZone = bTimeZone == null ? BTimeZone.UTC : BTimeZone.getTimeZone((String)bTimeZone.getId());
            this.targetTimeFE.loadValue((BObject)BAbsTime.make((long)bAbsTime.getMillis(), (BTimeZone)bTimeZone));
            this.relayout();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doCalculatorTargetTimeZoneModified() {
        try {
            BAbsTime bAbsTime = (BAbsTime)this.sourceTimeFE.saveValue();
            BTimeZone bTimeZone = (BTimeZone)this.targetTimeZoneDropDown.getSelectedItem();
            bTimeZone = bTimeZone == null ? BTimeZone.UTC : BTimeZone.getTimeZone((String)bTimeZone.getId());
            this.targetTimeFE.loadValue((BObject)BAbsTime.make((long)bAbsTime.getMillis(), (BTimeZone)bTimeZone));
            this.relayout();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doDstCalculatorValuesModified() {
        int n = BAbsTime.now().getYear();
        try {
            n = ((BInteger)this.targetYear.saveValue()).getInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BTimeZone bTimeZone = (BTimeZone)this.dstTimeZoneDropDown.getSelectedItem();
        bTimeZone = bTimeZone == null ? BTimeZone.UTC : BTimeZone.getTimeZone((String)bTimeZone.getId());
        DstRule dstRule = bTimeZone.getDaylightStartRule(BAbsTime.getMiddleOfYear((int)n));
        DstRule dstRule2 = bTimeZone.getDaylightEndRule(BAbsTime.getMiddleOfYear((int)n));
        if (dstRule != null && dstRule2 != null) {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            Calendar calendar = BTimeZoneViewer.calculateDateTime(n, dstRule);
            Calendar calendar2 = BTimeZoneViewer.calculateDateTime(n, dstRule2);
            string = BWeekday.make((int)(calendar.get(7) - 1)) + " " + BMonth.make((int)calendar.get(2)) + " " + calendar.get(5);
            string2 = BWeekday.make((int)(calendar2.get(7) - 1)) + " " + BMonth.make((int)calendar2.get(2)) + " " + calendar2.get(5);
            string3 = dstRule.getTime().toString() + " " + BTimeZoneViewer.timeModeToString(dstRule.getTimeMode());
            string4 = dstRule2.getTime().toString() + " " + BTimeZoneViewer.timeModeToString(dstRule2.getTimeMode());
            this.dstStartTime.setText(string + " at " + string3);
            this.dstEndTime.setText(string2 + " at " + string4);
            this.inDaylightNow.setText(BAbsTime.make((BAbsTime)BAbsTime.now(), (BTimeZone)bTimeZone).inDaylightTime() ? BTimeZoneViewer.text("dst.inDaylightNow.true") : BTimeZoneViewer.text("dst.inDaylightNow.false"));
        } else {
            this.dstStartTime.setText("N/A");
            this.dstEndTime.setText("N/A");
            this.inDaylightNow.setText("N/A");
        }
    }

    private static Calendar calculateDateTime(int n, DstRule dstRule) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
        gregorianCalendar.clear();
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(2, dstRule.getMonth().getOrdinal());
        if (dstRule.getDayMode() == -1) {
            if (dstRule.getWeek() == 5 || dstRule.getWeek() == 4) {
                gregorianCalendar.set(5, BAbsTime.getDaysInMonth((int)n, (BMonth)dstRule.getMonth()));
                gregorianCalendar.setLenient(false);
                while (gregorianCalendar.get(7) != dstRule.getWeekday().getOrdinal() + 1) {
                    ((Calendar)gregorianCalendar).add(5, -1);
                }
            } else {
                int n2;
                if (dstRule.getWeek() == 0) {
                    n2 = 1;
                } else if (dstRule.getWeek() == 1) {
                    n2 = 8;
                } else if (dstRule.getWeek() == 2) {
                    n2 = 15;
                } else if (dstRule.getWeek() == 3) {
                    n2 = 22;
                } else {
                    throw new IllegalArgumentException("Invalid week: " + dstRule.getWeek());
                }
                gregorianCalendar.set(5, n2);
                gregorianCalendar.setLenient(false);
                while (gregorianCalendar.get(7) != dstRule.getWeekday().getOrdinal() + 1) {
                    ((Calendar)gregorianCalendar).add(5, 1);
                }
            }
        } else if (dstRule.getDayMode() == 0) {
            gregorianCalendar.set(5, dstRule.getDay());
        } else if (dstRule.getDayMode() == 1 || dstRule.getDayMode() == 2) {
            gregorianCalendar.set(5, dstRule.getDay());
            gregorianCalendar.setLenient(false);
            while (gregorianCalendar.get(7) != dstRule.getWeekday().getOrdinal() + 1) {
                if (dstRule.getDayMode() == 1) {
                    ((Calendar)gregorianCalendar).add(5, 1);
                    continue;
                }
                ((Calendar)gregorianCalendar).add(5, -1);
            }
        } else {
            throw new IllegalStateException("Cannot compute dst rule time.");
        }
        gregorianCalendar.set(11, dstRule.getTime().getHour());
        gregorianCalendar.set(12, dstRule.getTime().getMinute());
        gregorianCalendar.set(13, dstRule.getTime().getSecond());
        gregorianCalendar.set(14, dstRule.getTime().getSecond());
        return gregorianCalendar;
    }

    public void doDatabaseTimeZoneModified() {
        try {
            BTimeZone bTimeZone = (BTimeZone)this.databaseTimeZoneDropDown.getSelectedItem();
            if (bTimeZone == null) {
                bTimeZone = BTimeZone.UTC;
            }
            this.currentTimeInTimeZoneFE.loadValue((BObject)BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)bTimeZone));
            HistoricalTimeZone historicalTimeZone = TzJarUtil.getCompleteTimeZone((String)bTimeZone.getId());
            if (historicalTimeZone == null) {
                historicalTimeZone = HistoricalTimeZone.make((String)"UTC");
            }
            boolean bl = historicalTimeZone.getNumberEras() > 1;
            String string = bl ? BTimeZoneViewer.text("database.yes") : BTimeZoneViewer.text("database.no");
            this.historicalTimeZoneLabel.setText(string);
            BTabbedPane bTabbedPane = new BTabbedPane();
            HistoricalTimeZoneEra historicalTimeZoneEra = null;
            BGridPane bGridPane = null;
            boolean bl2 = false;
            for (int i = historicalTimeZone.getNumberEras() - 1; i >= 0; --i) {
                historicalTimeZoneEra = historicalTimeZone.getEraAtIndex((short)i);
                bGridPane = new BGridPane(2);
                bGridPane.setHalign(BHalign.left);
                bGridPane.setValign(BValign.top);
                bGridPane.setColumnAlign(BHalign.left);
                bGridPane.setColumnGap(10.0);
                bGridPane.setRowGap(6.0);
                bGridPane.setColorRows(false);
                HistoricalTimeZoneDate historicalTimeZoneDate = historicalTimeZoneEra.getValidFromDate();
                HistoricalTimeZoneDate historicalTimeZoneDate2 = historicalTimeZoneEra.getValidUntilDate();
                BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.eraStartDate"), (BWidget)new BLabel(historicalTimeZoneDate.toString()), true);
                BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.eraEndDate"), (BWidget)new BLabel(historicalTimeZoneDate2.toString()), true);
                long l = historicalTimeZoneEra.getActiveUtcOffsetMillis();
                long l2 = l / 3600000L;
                long l3 = Math.abs(l % 3600000L / 60000L);
                StringBuffer stringBuffer = new StringBuffer();
                if (l >= 0L) {
                    stringBuffer.append("+");
                }
                stringBuffer.append(String.valueOf(l2));
                if (l3 != 0L) {
                    stringBuffer.append(":");
                    if (l3 < 10L) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(String.valueOf(l3));
                    stringBuffer.append(" Hours");
                }
                BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.standardUTCOffset"), (BWidget)new BLabel(stringBuffer.toString()), true);
                bl2 = historicalTimeZoneEra.getStartRule() != null;
                String string2 = bl2 ? BTimeZoneViewer.text("database.yes") : BTimeZoneViewer.text("database.no");
                BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.observesDaylight"), (BWidget)new BLabel(string2), true);
                if (bl2) {
                    HistoricalDstRule historicalDstRule = historicalTimeZoneEra.getStartRule();
                    HistoricalDstRule historicalDstRule2 = historicalTimeZoneEra.getEndRule();
                    BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.daylightStartDate"), (BWidget)new BLabel(historicalDstRule.getOccursOnAnnualDate().toString()), true);
                    BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.daylightEndDate"), (BWidget)new BLabel(historicalDstRule2.getOccursOnAnnualDate().toString()), true);
                    long l4 = historicalDstRule.getDaylightAdjMillis();
                    long l5 = l4 / 3600000L;
                    long l6 = Math.abs(l4 % 3600000L / 60000L);
                    StringBuffer stringBuffer2 = new StringBuffer();
                    if (l4 >= 0L) {
                        stringBuffer2.append("+");
                    }
                    stringBuffer2.append(String.valueOf(l5));
                    if (l6 != 0L) {
                        stringBuffer2.append(":");
                        if (l6 < 10L) {
                            stringBuffer2.append("0");
                        }
                        stringBuffer2.append(String.valueOf(l6));
                        stringBuffer2.append(" Hours");
                    }
                    BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.daylightAdjusment"), (BWidget)new BLabel(stringBuffer2.toString()), true);
                    BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.shortNameFormat"), (BWidget)new BLabel(historicalTimeZoneEra.getActiveZoneFormat()), true);
                    BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.startLetter"), (BWidget)new BLabel(historicalDstRule.getRuleLetters()), true);
                    BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.endLetter"), (BWidget)new BLabel(historicalDstRule2.getRuleLetters()), true);
                    BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.daylightActiveShortName"), (BWidget)new BLabel(historicalTimeZoneEra.getShortName(true)), true);
                    BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.daylightInactiveShortName"), (BWidget)new BLabel(historicalTimeZoneEra.getShortName(false)), true);
                } else {
                    BTimeZoneViewer.addLabelWidgetPair(bGridPane, BTimeZoneViewer.text("database.noDaylightShortName"), (BWidget)new BLabel(historicalTimeZoneEra.getShortName(false)), true);
                }
                bTabbedPane.addPane(historicalTimeZoneDate.getTheMonth() + ", " + historicalTimeZoneDate.getTheYear() + "-" + historicalTimeZoneDate2.getTheMonth() + ", " + historicalTimeZoneDate2.getTheYear(), (BWidget)new BBorderPane((BWidget)bGridPane));
            }
            bTabbedPane.computePreferredSize();
            this.databaseTimeZoneEraPaneBorder.setContent((BWidget)bTabbedPane);
            this.databaseTimeZoneEraPaneBorder.computePreferredSize();
            this.relayout();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String timeModeToString(int n) {
        if (n == 2) {
            return "Universal Coordinated Time";
        }
        if (n == 1) {
            return "Standard Time";
        }
        if (n == 0) {
            return "Wall Time";
        }
        return "Unknown Time Mode";
    }

    private static void addLabelWidgetPair(BGridPane bGridPane, String string, BWidget bWidget, boolean bl) {
        String string2 = string.trim();
        if (string2.length() > 10) {
            string2 = string2.substring(0, 10);
        }
        string2 = ObjectUtil.generateUniqueSlotName((String)SlotPath.escape((String)string2), (ObjectUtil.NameContainer)new NameContainer((BComplex)bGridPane));
        bGridPane.add(string2, (BValue)BTimeZoneViewer.makeLabel(string, bl));
        bGridPane.add(null, (BValue)bWidget);
    }

    public static BLabel makeLabel(String string, boolean bl) {
        return BTimeZoneViewer.makeLabel(string, null, bl, BHalign.left);
    }

    public static BLabel makeLabel(String string, BImage bImage, boolean bl) {
        return BTimeZoneViewer.makeLabel(string, bImage, bl, BHalign.left);
    }

    public static BLabel makeLabel(String string, BImage bImage, boolean bl, BHalign bHalign) {
        BLabel bLabel = new BLabel(string == null ? "" : string, bHalign);
        if (bImage != null) {
            bLabel.setImage(bImage);
        }
        if (bl) {
            bLabel.setFont(BOLD_TEXT_FONT);
        }
        return bLabel;
    }

    static String text(String string) {
        return lex.getText("timeZoneViewer." + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class NameContainer
    implements ObjectUtil.NameContainer {
        BComplex complex;

        public NameContainer(BComplex bComplex) {
            this.complex = bComplex;
        }

        public boolean contains(String string) {
            return this.complex.getSlot(string) != null;
        }
    }

    private static class ZoneListModel
    extends ListModel {
        BTimeZone[] items;

        public ZoneListModel(BTimeZone[] bTimeZoneArray) {
            Array array = new Array(class$javax$baja$timezone$BTimeZone == null ? (class$javax$baja$timezone$BTimeZone = BTimeZoneViewer.class$("javax.baja.timezone.BTimeZone")) : class$javax$baja$timezone$BTimeZone);
            array.addAll((Object[])bTimeZoneArray);
            array = array.sort(TZ_COMPARATOR);
            this.items = (BTimeZone[])array.trim();
        }

        public int getItemCount() {
            return this.items.length;
        }

        public BTimeZone getTimeZone(int n) {
            return this.items[n];
        }

        public Object getItem(int n) {
            return this.getTimeZone(n);
        }
    }
}

