/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.BBrushSwatch;
import com.tridium.workbench.colorchooser.BColorChooser;
import com.tridium.workbench.colorchooser.BGradientEditor;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

public class BStopEditor
extends BWidget {
    public static final Action setModified = BStopEditor.newAction((int)0, null);
    public static final Action offsetChanged = BStopEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$colorchooser$BStopEditor == null ? (class$com$tridium$workbench$colorchooser$BStopEditor = BStopEditor.class$("com.tridium.workbench.colorchooser.BStopEditor")) : class$com$tridium$workbench$colorchooser$BStopEditor));
    private static BImage removeIcon = BImage.make((String)"module://icons/x16/delete.png");
    private Sorter sorter = new Sorter();
    private static BBrush selectionBrush = BColor.make((int)65280).toBrush();
    private static Lexicon lexicon = Lexicon.make((String)"wbutil");
    private BBrush.Stop[] stops;
    private PolygonGeom[] markers = null;
    private PolygonGeom selection = new PolygonGeom();
    private boolean drag = false;
    private int focus = 0;
    private boolean out = false;
    private BBrushSwatch bar;
    private BWidget controls;
    private BTextField offsetField;
    private BBrushSwatch colorSwatch;
    private RemoveCommand removeCommand;
    static /* synthetic */ Class class$com$tridium$workbench$colorchooser$BStopEditor;

    public void setModified() {
        this.invoke(setModified, null, null);
    }

    public void offsetChanged() {
        this.invoke(offsetChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BStopEditor() {
        throw new IllegalStateException();
    }

    public BStopEditor(BBrush.Stop[] stopArray) {
        this.colorSwatch = new BBrushSwatch();
        this.colorSwatch.setController(new Controller());
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.add(null, (BValue)new BLabel(BStopEditor.getText("offset")));
        this.offsetField = new BTextField("", 6);
        bGridPane.add(null, (BValue)this.offsetField);
        bGridPane.add(null, (BValue)new BLabel("%"));
        bGridPane.add(null, (BValue)new BLabel(BStopEditor.getText("color")));
        bGridPane.add(null, (BValue)new BBorderPane((BWidget)this.colorSwatch, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bGridPane.add(null, (BValue)new BNullWidget());
        this.removeCommand = new RemoveCommand(this);
        BButton bButton = new BButton((Command)this.removeCommand);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.add(null, (BValue)bGridPane);
        bGridPane2.add(null, (BValue)bButton);
        this.bar = new BBrushSwatch();
        this.add(null, (BValue)this.bar);
        this.controls = bGridPane2;
        this.add(null, (BValue)this.controls);
        this.setStops(stopArray);
        this.linkTo((BComponent)this.offsetField, (Slot)BTextField.textModified, (Slot)offsetChanged);
    }

    public void computePreferredSize() {
        this.offsetField.computePreferredSize();
        this.colorSwatch.setPreferredSize(this.offsetField.getPreferredWidth() - 2.0, this.offsetField.getPreferredHeight() - 2.0);
        this.controls.computePreferredSize();
        double d = 320.0 + this.controls.getPreferredWidth();
        double d2 = Math.max(40.0, this.controls.getPreferredHeight());
        this.setPreferredSize(d, d2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        this.offsetField.computePreferredSize();
        this.colorSwatch.setPreferredSize(this.offsetField.getPreferredWidth() - 2.0, this.offsetField.getPreferredHeight() - 2.0);
        BWidget bWidget = this.controls;
        bWidget.computePreferredSize();
        bWidget.setBounds(d - bWidget.getPreferredWidth(), 0.0, bWidget.getPreferredWidth(), bWidget.getPreferredHeight());
        this.bar.setBounds(5.0, 0.0, (d -= bWidget.getPreferredWidth() + 20.0) - 11.0, d2 - 21.0);
    }

    public void paint(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        this.bar.setBrush(BBrush.makeLinearGradient((BBrush.Stop[])this.stops));
        this.paintChild(graphics, this.bar);
        if (this.markers == null) {
            this.makeMarkers();
        }
        for (int i = 0; i < this.markers.length; ++i) {
            if (i == this.focus && this.out) continue;
            graphics.setBrush(this.stops[i].getColor());
            graphics.fill((IGeom)this.markers[i]);
            graphics.setBrush(Theme.widget().getControlForeground());
            graphics.stroke((IGeom)this.markers[i]);
            double[] dArray = this.markers[i].x();
            double[] dArray2 = this.markers[i].y();
            graphics.setBrush(Theme.widget().getControlHighlight());
            graphics.strokeLine(dArray[0], dArray2[0] + 1.0, dArray[4] + 1.0, dArray2[4]);
            graphics.strokeLine(dArray[4] + 1.0, dArray2[4], dArray[3] + 1.0, dArray2[3] - 1.0);
            graphics.setBrush(Theme.widget().getControlShadow());
            graphics.strokeLine(dArray[3] + 1.0, dArray2[3] - 1.0, dArray[2] - 1.0, dArray2[2] - 1.0);
            graphics.strokeLine(dArray[2] - 1.0, dArray2[2] - 1.0, dArray[1] - 1.0, dArray2[1]);
            graphics.strokeLine(dArray[1] - 1.0, dArray2[1], dArray[0], dArray2[0] + 1.0);
            if (i != this.focus) continue;
            dArray2[0] = dArray2[0] - 1.0;
            dArray[1] = dArray[1] + 1.0;
            dArray[2] = dArray[2] + 1.0;
            dArray2[2] = dArray2[2] + 1.0;
            dArray[3] = dArray[3] - 1.0;
            dArray2[3] = dArray2[3] + 1.0;
            dArray[4] = dArray[4] - 1.0;
            this.selection.set(dArray, dArray2, 5);
            graphics.setBrush(selectionBrush);
            graphics.stroke((IGeom)this.selection);
        }
        this.paintChild(graphics, this.controls);
    }

    private void makeMarkers() {
        this.markers = new PolygonGeom[this.stops.length];
        for (int i = 0; i < this.stops.length; ++i) {
            BBrush.Stop stop = this.stops[i];
            double d = this.toScreen(stop.getOffset());
            double d2 = this.bar.getHeight() + 2.0;
            double[] dArray = new double[]{d, d + 5.0, d + 5.0, d - 5.0, d - 5.0};
            double[] dArray2 = new double[]{d2, d2 + 5.0, d2 + 15.0, d2 + 15.0, d2 + 5.0};
            this.markers[i] = new PolygonGeom(dArray, dArray2, 5);
        }
    }

    public BBrush.Stop[] getStops() {
        return this.stops;
    }

    public void setStops(BBrush.Stop[] stopArray) {
        this.stops = stopArray;
        this.updateControls();
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.focus = this.indexOf(bMouseEvent.getX(), bMouseEvent.getY());
        if (this.focus == -1) {
            this.focus = this.addStop(this.toPercent(bMouseEvent.getX()));
        }
        this.updateControls();
        this.repaint();
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.out = false;
        if (this.drag && !this.contains(0.0, bMouseEvent.getY())) {
            this.drag = false;
            this.removeCommand.invoke();
        } else {
            this.setModified();
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        if (this.focus == -1) {
            return;
        }
        this.out = this.stops.length > 2 && !this.contains(0.0, bMouseEvent.getY());
        this.drag = true;
        this.stops[this.focus] = BBrush.stop((double)this.toPercent(bMouseEvent.getX()), (BColor)this.stops[this.focus].getColor());
        BBrush.Stop stop = this.stops[this.focus];
        Arrays.sort(this.stops, this.sorter);
        for (int i = 0; i < this.stops.length; ++i) {
            if (this.stops[i] != stop) continue;
            this.focus = i;
        }
        this.markers = null;
        this.updateControls();
        this.repaint();
    }

    private void updateControls() {
        if (this.focus == -1 || this.focus >= this.stops.length) {
            return;
        }
        this.offsetField.setText(Double.toString(this.stops[this.focus].getOffset()));
        this.colorSwatch.setBrush(this.stops[this.focus].getColor().toBrush());
    }

    private int addStop(double d) {
        int n;
        BBrush.Stop stop = BBrush.stop((double)d, (BColor)BColor.red);
        BBrush.Stop[] stopArray = new BBrush.Stop[this.stops.length + 1];
        for (n = 0; n < this.stops.length; ++n) {
            stopArray[n] = this.stops[n];
        }
        stopArray[stopArray.length - 1] = stop;
        Arrays.sort(stopArray, this.sorter);
        this.setStops(stopArray);
        this.markers = null;
        for (n = 0; n < stopArray.length; ++n) {
            if (this.stops[n] != stop) continue;
            BBrush.Stop stop2 = n > 0 ? this.stops[n - 1] : this.stops[n + 1];
            this.stops[n] = BBrush.stop((double)this.stops[n].getOffset(), (BColor)stop2.getColor());
            return n;
        }
        return -1;
    }

    private void removeStop(int n) {
        BBrush.Stop[] stopArray = new BBrush.Stop[this.stops.length - 1];
        for (int i = 0; i < this.stops.length; ++i) {
            if (i < n) {
                stopArray[i] = this.stops[i];
                continue;
            }
            if (i <= n) continue;
            stopArray[i - 1] = this.stops[i];
        }
        this.setStops(stopArray);
        this.markers = null;
    }

    private int indexOf(double d, double d2) {
        for (int i = 0; i < this.markers.length; ++i) {
            if (!this.markers[i].contains(d, d2)) continue;
            return i;
        }
        return -1;
    }

    private double toPercent(double d) {
        if (d < this.bar.getX()) {
            return 0.0;
        }
        if (d > this.bar.getX() + this.bar.getWidth()) {
            return 100.0;
        }
        d = (d - this.bar.getX()) / this.bar.getWidth() * 100.0;
        return BGradientEditor.round(d);
    }

    private double toScreen(double d) {
        return this.bar.getX() + d / 100.0 * this.bar.getWidth();
    }

    public void doSetModified() {
        this.repaint();
    }

    public void doOffsetChanged() {
        try {
            double d = Double.parseDouble(this.offsetField.getText());
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 100.0) {
                d = 100.0;
            }
            this.stops[this.focus] = BBrush.stop((double)d, (BColor)this.stops[this.focus].getColor());
            BBrush.Stop stop = this.stops[this.focus];
            Arrays.sort(this.stops, this.sorter);
            for (int i = 0; i < this.stops.length; ++i) {
                if (this.stops[i] != stop) continue;
                this.focus = i;
            }
            this.markers = null;
            this.setModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getText(String string) {
        return lexicon.getText("gradientEditor." + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Controller
    extends BBrushSwatch.Controller {
        Controller() {
        }

        public void mousePressed(BMouseEvent bMouseEvent) {
            if (BStopEditor.this.focus == -1) {
                return;
            }
            BColor bColor = BColorChooser.openInDialog(BStopEditor.this, BStopEditor.this.stops[BStopEditor.this.focus].getColor());
            if (bColor != null) {
                ((BStopEditor)BStopEditor.this).stops[((BStopEditor)BStopEditor.this).focus] = BBrush.stop((double)BStopEditor.this.stops[BStopEditor.this.focus].getOffset(), (BColor)bColor);
                BStopEditor.this.colorSwatch.setBrush(bColor.toBrush());
                BStopEditor.this.setModified();
            }
        }

        public void mouseEntered(BMouseEvent bMouseEvent) {
            this.swatch.setMouseCursor(MouseCursor.dropper);
        }

        public void mouseExited(BMouseEvent bMouseEvent) {
            this.swatch.setMouseCursor(MouseCursor.normal);
        }
    }

    class Sorter
    implements Comparator {
        Sorter() {
        }

        public boolean equals(Object object) {
            return false;
        }

        public int compare(Object object, Object object2) {
            double d;
            double d2 = ((BBrush.Stop)object).getOffset();
            if (d2 < (d = ((BBrush.Stop)object2).getOffset())) {
                return -1;
            }
            if (d2 == d) {
                return 0;
            }
            return 1;
        }
    }

    class RemoveCommand
    extends Command {
        RemoveCommand(BWidget bWidget) {
            super(bWidget, BStopEditor.getText("remove"));
        }

        public BImage getIcon() {
            return removeIcon;
        }

        public CommandArtifact doInvoke() {
            if (BStopEditor.this.focus != -1 && BStopEditor.this.stops.length > 2) {
                BStopEditor.this.removeStop(BStopEditor.this.focus);
                BStopEditor.this.focus--;
                if (BStopEditor.this.focus < 0) {
                    BStopEditor.this.focus = 0;
                }
                BStopEditor.this.updateControls();
                BStopEditor.this.setModified();
            }
            return null;
        }
    }
}

