/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.ColorModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

public class BSatBrightBox
extends BWidget
implements ColorModel.Agent {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$colorchooser$BSatBrightBox == null ? (class$com$tridium$workbench$colorchooser$BSatBrightBox = BSatBrightBox.class$("com.tridium.workbench.colorchooser.BSatBrightBox")) : class$com$tridium$workbench$colorchooser$BSatBrightBox));
    private float lastHue = -1.0f;
    private ColorModel model;
    private BImage image;
    private BBrush brush = BColor.red.toBrush();
    private int[] sample = new int[4];
    static /* synthetic */ Class class$com$tridium$workbench$colorchooser$BSatBrightBox;

    public Type getType() {
        return TYPE;
    }

    public BSatBrightBox() {
        throw new IllegalStateException();
    }

    public BSatBrightBox(ColorModel colorModel) {
        this.model = colorModel;
        colorModel.addAgent(this);
    }

    public void computePreferredSize() {
        this.setPreferredSize(300.0, 300.0);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth() - 5.0;
        double d2 = this.getHeight() - 5.0;
        if (this.image == null || this.image.getWidth() != d || this.image.getHeight() != d2) {
            if (this.image != null) {
                this.image.dispose();
            }
            this.image = BImage.make((double)d, (double)d2);
            this.createImage();
        }
    }

    public void paint(javax.baja.gx.Graphics graphics) {
        if (this.image != null) {
            double d = this.getWidth() - 1.0;
            double d2 = this.getHeight() - 1.0;
            graphics.setBrush(this.brush);
            graphics.fillRect(2.0, 2.0, d - 3.0, d2 - 3.0);
            graphics.drawImage(this.image, 2.0, 2.0);
            double d3 = 2.0 + (double)this.model.getSat() * (d - 3.0);
            double d4 = 2.0 + (double)(1.0f - this.model.getBri()) * (d2 - 3.0);
            graphics.setBrush(BColor.white);
            graphics.strokeRect(d3 - 5.0, d4 - 5.0, 9.0, 9.0);
            graphics.setBrush(BColor.black);
            graphics.strokeRect(d3 - 6.0, d4 - 6.0, 11.0, 11.0);
            graphics.setBrush(BColor.black);
            graphics.strokeRect(1.0, 1.0, d - 2.0, d2 - 2.0);
            graphics.setBrush(Theme.widget().getControlHighlight());
            graphics.strokeLine(d, 0.0, d, d2);
            graphics.strokeLine(0.0, d2, d, d2);
            graphics.setBrush(Theme.widget().getControlShadow());
            graphics.strokeLine(0.0, 0.0, d, 0.0);
            graphics.strokeLine(0.0, 0.0, 0.0, d2);
        }
    }

    private void createImage() {
        if (this.image == null) {
            return;
        }
        if (UiEnv.get().isMicroEdition()) {
            return;
        }
        double d = this.image.getWidth();
        double d2 = this.image.getHeight();
        BufferedImage bufferedImage = (BufferedImage)AwtEnv.peer((BImage)this.image).image();
        Graphics graphics = bufferedImage.getGraphics();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = 0;
        while ((double)n < d2) {
            int n2 = 255 - (int)((double)(255 * n) / d2);
            int n3 = 0;
            while ((double)n3 < d) {
                this.sample[0] = n2;
                this.sample[1] = n2;
                this.sample[2] = n2;
                this.sample[3] = 255 - (int)((double)(255 * n3) / d);
                writableRaster.setPixel(n3, n, this.sample);
                ++n3;
            }
            ++n;
        }
        graphics.dispose();
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.doEvent(bMouseEvent);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.doEvent(bMouseEvent);
    }

    public void doEvent(BMouseEvent bMouseEvent) {
        float f = (float)(bMouseEvent.getX() / (this.getWidth() - 1.0));
        float f2 = 1.0f - (float)(bMouseEvent.getY() / (this.getHeight() - 1.0));
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.model.set(this.model.getHue(), f, f2);
        this.repaint();
    }

    public void colorChanged() {
        float f = this.model.getHue();
        if (this.lastHue != f) {
            Color color = Color.getHSBColor(f, 1.0f, 1.0f);
            BColor bColor = BColor.make((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
            this.brush = BBrush.makeLinearGradient((BBrush.Stop[])new BBrush.Stop[]{BBrush.stop((double)0.0, (BColor)bColor), BBrush.stop((double)100.0, (BColor)BColor.black)}, (int)1, (double)-90.0);
            this.repaint();
        }
        this.lastHue = f;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

