/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.ColorModel;
import java.awt.Color;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.Insets;
import javax.baja.gx.PolygonGeom;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

public class BHueBar
extends BWidget
implements ColorModel.Agent {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$colorchooser$BHueBar == null ? (class$com$tridium$workbench$colorchooser$BHueBar = BHueBar.class$("com.tridium.workbench.colorchooser.BHueBar")) : class$com$tridium$workbench$colorchooser$BHueBar));
    private static Insets insets = new Insets(2.0, 2.0, 2.0, 2.0);
    private ColorModel model;
    private BImage image;
    private int arrowWidth = 5;
    static /* synthetic */ Class class$com$tridium$workbench$colorchooser$BHueBar;

    public Type getType() {
        return TYPE;
    }

    public BHueBar() {
        throw new IllegalStateException();
    }

    public BHueBar(ColorModel colorModel) {
        this.model = colorModel;
        colorModel.addAgent(this);
    }

    public void computePreferredSize() {
        this.setPreferredSize(40.0, 300.0);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth() - 1.0 - BHueBar.insets.left - BHueBar.insets.right - (double)this.arrowWidth;
        double d2 = this.getHeight() - 5.0 - BHueBar.insets.top - BHueBar.insets.bottom;
        if (this.image == null || this.image.getWidth() != d || this.image.getHeight() != d2) {
            if (this.image != null) {
                this.image.dispose();
            }
            this.image = BImage.make((double)d, (double)d2);
            this.createImage();
        }
    }

    public void paint(Graphics graphics) {
        if (this.image == null) {
            return;
        }
        double d = BHueBar.insets.left;
        double d2 = BHueBar.insets.top;
        double d3 = this.image.getWidth();
        double d4 = this.image.getHeight();
        if (this.image != null) {
            graphics.drawImage(this.image, d, d2 + 2.0);
        }
        graphics.setBrush(BColor.black);
        graphics.strokeRect(1.0, 3.0, d3 + 1.0, d4 + 1.0);
        graphics.setBrush(Theme.widget().getControlShadow());
        graphics.strokeLine(0.0, 2.0, d3 + 3.0, 2.0);
        graphics.strokeLine(0.0, 2.0, 0.0, d4 + 5.0);
        graphics.setBrush(Theme.widget().getControlHighlight());
        graphics.strokeLine(d3 + 3.0, 3.0, d3 + 3.0, d4 + 5.0);
        graphics.strokeLine(1.0, d4 + 5.0, d3 + 3.0, d4 + 5.0);
        double d5 = d3 + 1.0 + BHueBar.insets.left + BHueBar.insets.right;
        double d6 = 4.0 + d4 - (double)this.model.getHue() * d4;
        if (this.isEnabled()) {
            double[] dArray = new double[]{d5, d5 + (double)this.arrowWidth, d5 + (double)this.arrowWidth};
            double[] dArray2 = new double[]{d6, d6 - 5.0, d6 + 5.0};
            PolygonGeom polygonGeom = new PolygonGeom(dArray, dArray2, 3);
            graphics.setBrush(BColor.black);
            graphics.fill((IGeom)polygonGeom);
        }
    }

    private void createImage() {
        if (this.image == null) {
            return;
        }
        double d = this.image.getWidth();
        double d2 = this.image.getHeight();
        Graphics graphics = this.image.getGraphics();
        float f = this.model.getHue();
        float f2 = 1.0f;
        float f3 = 1.0f;
        int n = 0;
        while ((double)n <= d2) {
            f = 1.0f - (float)((double)n / d2);
            graphics.setBrush(BColor.make((int)Color.getHSBColor(f, f2, f3).getRGB()));
            graphics.strokeLine(0.0, (double)n, d, (double)n);
            ++n;
        }
        graphics.dispose();
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.doEvent(bMouseEvent);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.doEvent(bMouseEvent);
    }

    public void doEvent(BMouseEvent bMouseEvent) {
        float f = (float)(bMouseEvent.getY() / this.getHeight());
        if (bMouseEvent.getY() <= 0.0) {
            f = 0.0f;
        }
        if (bMouseEvent.getY() >= this.getHeight()) {
            f = 1.0f;
        }
        f = 1.0f - f;
        this.model.set(f, this.model.getSat(), this.model.getBri());
        this.repaint();
    }

    public void colorChanged() {
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

