/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import com.tridium.workbench.colorchooser.BBrushSwatch;
import com.tridium.workbench.colorchooser.BStopEditor;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

public class BGradientEditor
extends BEdgePane {
    public static final Action updateSwatch = BGradientEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$colorchooser$BGradientEditor == null ? (class$com$tridium$workbench$colorchooser$BGradientEditor = BGradientEditor.class$("com.tridium.workbench.colorchooser.BGradientEditor")) : class$com$tridium$workbench$colorchooser$BGradientEditor));
    private static BImage newIcon = BImage.make((String)"module://icons/x16/new.png");
    private static BImage dupIcon = BImage.make((String)"module://icons/x16/duplicate.png");
    private static BImage saveIcon = BImage.make((String)"module://icons/x16/save.png");
    private static BImage saveAsIcon = BImage.make((String)"module://icons/x16/saveAs.png");
    private static BImage removeIcon = BImage.make((String)"module://icons/x16/delete.png");
    private static BImage linIcon = BImage.make((String)"module://wbutil/com/tridium/workbench/colorchooser/icons/linear.png");
    private static BImage radIcon = BImage.make((String)"module://wbutil/com/tridium/workbench/colorchooser/icons/radial.png");
    private static Lexicon lexicon = Lexicon.make((String)"wbutil");
    private static BBrush defaultBrush = BBrush.make((String)"linearGradient(stop(0% #ff0000) stop(100% #000080))");
    private BBrush brush;
    private BStopEditor stopEditor;
    private BBrushSwatch swatch;
    private LinearCommand linCommand;
    private RadialCommand radCommand;
    private BTextField centerX;
    private BTextField centerY;
    private BTextField focalX;
    private BTextField focalY;
    private BTextField radius;
    private BTextField angle;
    static /* synthetic */ Class class$com$tridium$workbench$colorchooser$BGradientEditor;

    public void updateSwatch() {
        this.invoke(updateSwatch, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BBrush openInDialog(BWidget bWidget, BBrush bBrush) {
        BGradientEditor bGradientEditor = new BGradientEditor(bBrush);
        if (1 == BDialog.open((BWidget)bWidget, (String)BGradientEditor.getText("gradientEditor"), (Object)new BBorderPane((BWidget)bGradientEditor), (int)3)) {
            return bGradientEditor.swatch.getBrush();
        }
        return null;
    }

    public BGradientEditor() {
        this(BBrush.NULL);
    }

    public BGradientEditor(BBrush bBrush) {
        this.brush = bBrush.isNull() ? defaultBrush : bBrush;
        BBrush.Gradient gradient = (BBrush.Gradient)this.brush.getPaint();
        this.linCommand = new LinearCommand((BWidget)this);
        BToggleButton bToggleButton = new BToggleButton((Command)this.linCommand);
        this.radCommand = new RadialCommand((BWidget)this);
        BToggleButton bToggleButton2 = new BToggleButton((Command)this.radCommand);
        bToggleButton.setPadding(BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0));
        bToggleButton2.setPadding(BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0));
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnGap(-1.0);
        bGridPane.add(null, (BValue)bToggleButton);
        bGridPane.add(null, (BValue)bToggleButton2);
        BGridPane bGridPane2 = new BGridPane(3);
        bGridPane2.add(null, (BValue)new BLabel(BGradientEditor.getText("centerX")));
        this.centerX = new BTextField("50", 6);
        bGridPane2.add(null, (BValue)this.centerX);
        bGridPane2.add(null, (BValue)new BLabel("%"));
        bGridPane2.add(null, (BValue)new BLabel(BGradientEditor.getText("centerY")));
        this.centerY = new BTextField("50", 6);
        bGridPane2.add(null, (BValue)this.centerY);
        bGridPane2.add(null, (BValue)new BLabel("%"));
        bGridPane2.add(null, (BValue)new BLabel(BGradientEditor.getText("radius")));
        this.radius = new BTextField("50", 6);
        bGridPane2.add(null, (BValue)this.radius);
        bGridPane2.add(null, (BValue)new BLabel("%"));
        BGridPane bGridPane3 = new BGridPane(3);
        bGridPane3.add(null, (BValue)new BLabel(BGradientEditor.getText("focalX")));
        this.focalX = new BTextField("50", 6);
        bGridPane3.add(null, (BValue)this.focalX);
        bGridPane3.add(null, (BValue)new BLabel("%"));
        bGridPane3.add(null, (BValue)new BLabel(BGradientEditor.getText("focalY")));
        this.focalY = new BTextField("50", 6);
        bGridPane3.add(null, (BValue)this.focalY);
        bGridPane3.add(null, (BValue)new BLabel("%"));
        bGridPane3.add(null, (BValue)new BLabel(BGradientEditor.getText("angle")));
        this.angle = new BTextField("0", 6);
        bGridPane3.add(null, (BValue)this.angle);
        BGridPane bGridPane4 = new BGridPane(2);
        bGridPane4.setColumnGap(20.0);
        bGridPane4.add(null, (BValue)bGridPane2);
        bGridPane4.add(null, (BValue)bGridPane3);
        this.swatch = new BBrushSwatch(this.brush);
        this.swatch.setPreferredSize(80.0, 80.0);
        BGridPane bGridPane5 = new BGridPane(3);
        bGridPane5.setRowAlign(BValign.top);
        bGridPane5.setColumnGap(20.0);
        bGridPane5.add(null, (BValue)this.swatch);
        bGridPane5.add(null, (BValue)bGridPane4);
        bGridPane5.add(null, (BValue)bGridPane);
        BGridPane bGridPane6 = new BGridPane(1);
        bGridPane6.setColumnAlign(BHalign.fill);
        bGridPane6.setStretchColumn(0);
        bGridPane6.setRowGap(20.0);
        bGridPane6.add(null, (BValue)bGridPane5);
        this.stopEditor = new BStopEditor(gradient.getStops());
        bGridPane6.add(null, (BValue)this.stopEditor);
        this.setCenter((BWidget)bGridPane6);
        this.linkTo((BComponent)this.centerX, (Slot)BTextField.textModified, (Slot)updateSwatch);
        this.linkTo((BComponent)this.centerY, (Slot)BTextField.textModified, (Slot)updateSwatch);
        this.linkTo((BComponent)this.focalX, (Slot)BTextField.textModified, (Slot)updateSwatch);
        this.linkTo((BComponent)this.focalY, (Slot)BTextField.textModified, (Slot)updateSwatch);
        this.linkTo((BComponent)this.radius, (Slot)BTextField.textModified, (Slot)updateSwatch);
        this.linkTo((BComponent)this.angle, (Slot)BTextField.textModified, (Slot)updateSwatch);
        this.linkTo((BComponent)this.stopEditor, (Slot)BStopEditor.setModified, (Slot)updateSwatch);
        if (gradient instanceof BBrush.LinearGradient) {
            this.angle.setText(Double.toString(((BBrush.LinearGradient)gradient).getAngle()));
            this.linCommand.invoke();
        } else {
            BBrush.RadialGradient radialGradient = (BBrush.RadialGradient)gradient;
            this.centerX.setText(Double.toString(radialGradient.getCenter().x));
            this.centerY.setText(Double.toString(radialGradient.getCenter().y));
            this.focalX.setText(Double.toString(radialGradient.getFocal().y));
            this.focalY.setText(Double.toString(radialGradient.getFocal().y));
            this.radius.setText(Double.toString(radialGradient.getRadius()));
            this.radCommand.invoke();
        }
    }

    public static double round(double d) {
        long l = Math.round(d *= 100.0);
        return (double)l / 100.0;
    }

    public static double stringToDouble(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public void doUpdateSwatch() {
        if (this.linCommand.isSelected()) {
            double d = BGradientEditor.stringToDouble(this.angle.getText());
            this.brush = BBrush.makeLinearGradient((BBrush.Stop[])this.stopEditor.getStops(), (int)1, (double)d);
        } else {
            double d = BGradientEditor.stringToDouble(this.centerX.getText());
            double d2 = BGradientEditor.stringToDouble(this.centerY.getText());
            double d3 = BGradientEditor.stringToDouble(this.focalX.getText());
            double d4 = BGradientEditor.stringToDouble(this.focalY.getText());
            double d5 = BGradientEditor.stringToDouble(this.radius.getText());
            this.brush = BBrush.makeRadialGradient((BBrush.Stop[])this.stopEditor.getStops(), (int)1, (IPoint)new Point(d, d2), (double)d5, (IPoint)new Point(d3, d4));
        }
        this.swatch.setBrush(this.brush);
        this.swatch.repaint();
    }

    private static String getText(String string) {
        return lexicon.getText("gradientEditor." + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RemoveCommand
    extends Command {
        RemoveCommand(BWidget bWidget) {
            super(bWidget, BGradientEditor.getText("remove"));
        }

        public BImage getIcon() {
            return removeIcon;
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    class SaveAsCommand
    extends Command {
        SaveAsCommand(BWidget bWidget) {
            super(bWidget, BGradientEditor.getText("saveAs"));
        }

        public BImage getIcon() {
            return saveAsIcon;
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    class SaveCommand
    extends Command {
        SaveCommand(BWidget bWidget) {
            super(bWidget, BGradientEditor.getText("save"));
        }

        public BImage getIcon() {
            return saveIcon;
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    class DuplicateCommand
    extends Command {
        DuplicateCommand(BWidget bWidget) {
            super(bWidget, BGradientEditor.getText("duplicate"));
        }

        public BImage getIcon() {
            return dupIcon;
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    class NewCommand
    extends Command {
        NewCommand(BWidget bWidget) {
            super(bWidget, BGradientEditor.getText("new"));
        }

        public BImage getIcon() {
            return newIcon;
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    class RadialCommand
    extends ToggleCommand {
        RadialCommand(BWidget bWidget) {
            super(bWidget, null);
        }

        public BImage getIcon() {
            return radIcon;
        }

        public CommandArtifact doInvoke() {
            if (!this.isSelected() && !BGradientEditor.this.linCommand.isSelected()) {
                this.setSelected(true);
            } else if (this.isSelected()) {
                BGradientEditor.this.centerX.setEnabled(true);
                BGradientEditor.this.centerY.setEnabled(true);
                BGradientEditor.this.focalX.setEnabled(true);
                BGradientEditor.this.focalY.setEnabled(true);
                BGradientEditor.this.radius.setEnabled(true);
                BGradientEditor.this.angle.setEnabled(false);
                BGradientEditor.this.centerX.requestFocus();
                BGradientEditor.this.linCommand.setSelected(false);
                BGradientEditor.this.updateSwatch();
            }
            return null;
        }
    }

    class LinearCommand
    extends ToggleCommand {
        LinearCommand(BWidget bWidget) {
            super(bWidget, null);
        }

        public BImage getIcon() {
            return linIcon;
        }

        public CommandArtifact doInvoke() {
            if (!this.isSelected() && !BGradientEditor.this.radCommand.isSelected()) {
                this.setSelected(true);
            } else if (this.isSelected()) {
                BGradientEditor.this.centerX.setEnabled(false);
                BGradientEditor.this.centerY.setEnabled(false);
                BGradientEditor.this.focalX.setEnabled(false);
                BGradientEditor.this.focalY.setEnabled(false);
                BGradientEditor.this.radius.setEnabled(false);
                BGradientEditor.this.angle.setEnabled(true);
                BGradientEditor.this.angle.requestFocus();
                BGradientEditor.this.radCommand.setSelected(false);
                BGradientEditor.this.updateSwatch();
            }
            return null;
        }
    }
}

