/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.category;

import com.tridium.workbench.category.Category;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbShell;

public class BCategoryCheckList
extends BWbPlugin {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$category$BCategoryCheckList == null ? (class$com$tridium$workbench$category$BCategoryCheckList = BCategoryCheckList.class$("com.tridium.workbench.category.BCategoryCheckList")) : class$com$tridium$workbench$category$BCategoryCheckList));
    static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$workbench$category$BCategoryCheckList == null ? (class$com$tridium$workbench$category$BCategoryCheckList = BCategoryCheckList.class$("com.tridium.workbench.category.BCategoryCheckList")) : class$com$tridium$workbench$category$BCategoryCheckList));
    static final String lexCategories = lex.getText("Categories");
    static final BImage check = BImage.make((String)"module://icons/x16/check.png");
    static final int inset = 20;
    static final BBrush trumpForeground = BColor.gray.toBrush();
    BTable table;
    boolean trump;
    BCategoryMask mask;
    BCategoryMask trumpMask;
    Row[] rows = new Row[1];
    BCategoryService service;
    static /* synthetic */ Class class$com$tridium$workbench$category$BCategoryCheckList;

    public Type getType() {
        return TYPE;
    }

    public BCategoryCheckList() {
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setOptionsButtonVisible(false);
        this.setContent((BWidget)this.table);
    }

    public boolean isTrump() {
        return this.trump;
    }

    public void setTrump(boolean bl) {
        this.trump = bl;
        this.repaint();
    }

    public void selectAll() {
        for (int i = 1; i < this.rows.length; ++i) {
            this.rows[i].selected = true;
        }
        this.repaint();
    }

    public void deselectAll() {
        for (int i = 1; i < this.rows.length; ++i) {
            this.rows[i].selected = false;
        }
        this.repaint();
    }

    public void load(BWbShell bWbShell, BCategoryMask bCategoryMask, BCategoryMask bCategoryMask2) {
        this.mask = bCategoryMask;
        this.trumpMask = bCategoryMask2;
        Category.Result result = Category.load(bWbShell, bCategoryMask.size() + 1);
        Row[] rowArray = new Row[result.categories.length];
        for (int i = 1; i < rowArray.length; ++i) {
            rowArray[i] = new Row(this, result.categories[i]);
        }
        this.rows = rowArray;
        this.service = result.service;
        this.table.relayout();
    }

    public BCategoryMask save() {
        int n;
        if (this.trump) {
            throw new IllegalStateException("Cannot call save() in trump model");
        }
        int n2 = 0;
        for (n = 1; n < this.rows.length; ++n) {
            if (!this.rows[n].selected) continue;
            ++n2;
        }
        n = 0;
        int[] nArray = new int[n2];
        for (int i = 1; i < this.rows.length; ++i) {
            if (!this.rows[i].selected) continue;
            nArray[n++] = i;
        }
        this.clearModified();
        return BCategoryMask.make((int[])nArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Row {
        int index;
        String display;
        boolean selected;
        boolean trump;

        Row(BCategoryCheckList bCategoryCheckList, Category category) {
            this.index = category.index;
            this.display = category.display;
            if (this.index > 0) {
                this.selected = bCategoryCheckList.mask.get(this.index);
                this.trump = bCategoryCheckList.trumpMask.get(this.index);
            }
        }
    }

    class Renderer
    extends TableCellRenderer {
        Renderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            if (BCategoryCheckList.this.trump) {
                return trumpForeground;
            }
            return super.getForeground(cell);
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return this.getBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return 20.0 + super.getPreferredCellWidth(cell);
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            boolean bl;
            this.paintCellBackground(graphics, cell);
            graphics.translate(20.0, 0.0);
            super.paintCell(graphics, cell);
            graphics.translate(-20.0, 0.0);
            Row row = BCategoryCheckList.this.rows[cell.row + 1];
            boolean bl2 = bl = BCategoryCheckList.this.trump ? row.trump : row.selected;
            if (bl) {
                graphics.drawImage(check, 2.0, 0.0);
            }
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellReleased(BMouseEvent bMouseEvent, int n, int n2) {
            if (BCategoryCheckList.this.trump) {
                return;
            }
            if (!bMouseEvent.isPopupTrigger()) {
                Row row = BCategoryCheckList.this.rows[n + 1];
                row.selected = !row.selected;
                BCategoryCheckList.this.setModified();
                BCategoryCheckList.this.repaint();
            }
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BCategoryCheckList.this.rows.length - 1;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return lexCategories;
        }

        public Object getSubject(int n) {
            return BCategoryCheckList.this.rows[n + 1];
        }

        public Object getValueAt(int n, int n2) {
            return BCategoryCheckList.this.rows[n + 1].display;
        }
    }
}

