/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfSerial.comm;

import com.tridium.ddf.BDdfCommDevice;
import com.tridium.ddf.BDdfCommNetwork;
import com.tridium.ddf.comm.BIDdfCommunicating;
import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddfSerial.BDdfSerialNetwork;
import com.tridium.ddfSerial.comm.BDdfSerialNullReceiver;
import com.tridium.ddfSerial.comm.BDdfSerialTransmitter;
import com.tridium.ddfSerial.comm.DdfSerialDriverCommLexicon;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.log.Log;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDdfSerialCommunicator
extends BDdfCommunicator
implements BISerialHelperParent {
    public static final Property serialPortParameters = BDdfSerialCommunicator.newProperty((int)0, (BValue)new BSerialHelper(), null);
    public static final Property transmitter = BDdfSerialCommunicator.newProperty((int)0, (BValue)new BDdfSerialTransmitter(), null);
    public static final Property receiver = BDdfSerialCommunicator.newProperty((int)0, (BValue)new BDdfSerialNullReceiver(), null);
    public static final Type TYPE;
    public static final int DEFAULT_SERIAL_RX_BUFFER_SIZE = 4096;
    protected BISerialPort serialPort;
    protected InputStream serialIn;
    protected OutputStream serialOut;
    private String portName;
    static /* synthetic */ Class class$com$tridium$ddfSerial$comm$BDdfSerialCommunicator;

    public BSerialHelper getSerialPortParameters() {
        return (BSerialHelper)this.get(serialPortParameters);
    }

    public void setSerialPortParameters(BSerialHelper bSerialHelper) {
        this.set(serialPortParameters, (BValue)bSerialHelper, null);
    }

    public BDdfTransmitter getTransmitter() {
        return (BDdfTransmitter)this.get(transmitter);
    }

    public void setTransmitter(BDdfTransmitter bDdfTransmitter) {
        this.set(transmitter, (BValue)bDdfTransmitter, null);
    }

    public BDdfReceiver getReceiver() {
        return (BDdfReceiver)this.get(receiver);
    }

    public void setReceiver(BDdfReceiver bDdfReceiver) {
        this.set(receiver, (BValue)bDdfReceiver, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BDdfSerialNetwork;
    }

    public void descendantsStarted() throws Exception {
        this.portName = this.getSerialPortParameters().getPortName();
        super.descendantsStarted();
    }

    public void reopenPort() {
        BIDdfCommunicating bIDdfCommunicating = this.getDdfCommunicatingParent();
        if (bIDdfCommunicating instanceof BDdfCommNetwork) {
            ((BDdfCommNetwork)bIDdfCommunicating).setEnabled(false);
        } else if (bIDdfCommunicating instanceof BDdfCommDevice) {
            ((BDdfCommDevice)bIDdfCommunicating).setEnabled(false);
        }
        this.stopCommunicating();
        this.closeSerialPort();
        try {
            this.openSerialPort();
            this.startCommunicating();
            this.updatePortSettings();
            if (bIDdfCommunicating instanceof BDdfCommNetwork) {
                ((BDdfCommNetwork)bIDdfCommunicating).setEnabled(true);
            } else if (bIDdfCommunicating instanceof BDdfCommDevice) {
                ((BDdfCommDevice)bIDdfCommunicating).setEnabled(true);
            }
        }
        catch (Exception exception) {
            this.getLog().error(DdfSerialDriverCommLexicon.reopenPortException(exception));
            this.closeSerialPort();
        }
    }

    public final void communicatorStarted() throws Exception {
        try {
            this.openSerialPort();
            this.serialCommunicatorStarted();
        }
        catch (Exception exception) {
            this.handleOpenSerialPortException(exception);
            throw exception;
        }
    }

    public final void communicatorStopped() throws Exception {
        this.closeSerialPort();
        this.serialCommunicatorStopped();
    }

    public Log getLog() {
        return Log.getLog((String)(this.getParent().getName() + '_' + this.portName));
    }

    public BDdfSerialNetwork getDdfSerialNetwork() {
        return (BDdfSerialNetwork)this.getParent();
    }

    public InputStream getSerialInputStream() {
        return this.serialIn;
    }

    public OutputStream getSerialOutputStream() {
        return this.serialOut;
    }

    protected void serialCommunicatorStarted() {
    }

    protected void serialCommunicatorStopped() {
    }

    private final void _configFail(BComplex bComplex, String string) {
        if (bComplex instanceof BDevice) {
            ((BDevice)bComplex).configFail(string);
        } else if (bComplex instanceof BDeviceNetwork) {
            ((BDeviceNetwork)bComplex).configFail(string);
        } else {
            this.getLog().error(string);
        }
    }

    private final void _configOk(BComplex bComplex) {
        if (bComplex instanceof BDevice) {
            ((BDevice)bComplex).configOk();
        } else if (bComplex instanceof BDeviceNetwork) {
            ((BDeviceNetwork)bComplex).configOk();
        } else {
            this.getLog().message(DdfSerialDriverCommLexicon.LEX.getText("OpenSerialPortSuccess"));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void openSerialPort() throws Exception {
        BComplex bComplex = this.getParent();
        while (true) {
            if (bComplex == null || bComplex instanceof BIDdfCommunicating) {
                if (bComplex != null) break;
                this.getLog().error(DdfSerialDriverCommLexicon.LEX.getText("SerialCommunicatorNotUnderBIDdfCommunicating", new Object[]{this.getSlotPath()}));
                return;
            }
            bComplex = bComplex.getParent();
        }
        if (this.getSerialPortParameters().getPortName().equals("none")) {
            this._configFail(bComplex, DdfSerialDriverCommLexicon.noPortSelected);
            return;
        }
        try {
            BISerialService bISerialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            this.serialPort = this.getSerialPortParameters().open(bComplex.getName());
            this.serialPort.enableReceiveTimeout(bISerialService.getMinTimeout());
            this.serialIn = new BufferedInputStream(this.serialPort.getInputStream(), this.getSerialRxBufferSize());
            this.serialOut = this.serialPort.getOutputStream();
            BComplex bComplex2 = this.getParent();
            while (true) {
                if (bComplex2 == null || bComplex2 instanceof BIDdfCommunicating) {
                    this._configOk(bComplex);
                    return;
                }
                bComplex2 = bComplex2.getParent();
            }
        }
        catch (Exception exception) {
            this._configFail(bComplex, DdfSerialDriverCommLexicon.errorOpeningSerialPort(exception));
            this.serialIn = null;
            this.serialOut = null;
            if (this.serialPort == null) return;
            try {
                this.serialPort.close();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.serialPort = null;
                throw throwable;
            }
            {
                Object var4_7 = null;
                this.serialPort = null;
                return;
            }
        }
    }

    protected int getSerialRxBufferSize() {
        return 4096;
    }

    protected void handleOpenSerialPortException(Exception exception) {
        this.getLog().error(DdfSerialDriverCommLexicon.errorOpeningSerialPort(exception));
        this.closeSerialPort();
    }

    protected void closeSerialInputStream() {
        if (this.serialIn != null) {
            try {
                this.serialIn.close();
            }
            catch (Exception exception) {
                this.getLog().error(DdfSerialDriverCommLexicon.unableToCloseSerialInputStream, (Throwable)exception);
            }
        }
    }

    protected void closeSerialOutputStream() {
        if (this.serialOut != null) {
            try {
                this.serialOut.close();
            }
            catch (Exception exception) {
                this.getLog().error(DdfSerialDriverCommLexicon.unableToCloseSerialOutputStream, (Throwable)exception);
            }
        }
    }

    protected void closeSerialPort() {
        if (this.serialPort != null) {
            this.serialPort.close();
        }
        this.serialPort = null;
        this.serialIn = null;
        this.serialOut = null;
    }

    private final void updatePortSettings() {
        String string = this.getSerialPortParameters().getPortName();
        if (this.portName != null) {
            int n;
            int n2;
            Log log;
            Log log2;
            String string2 = this.portName;
            if (!string2.equals(string) && (log2 = Log.getLog((String)(this.getParent().getName() + '_' + string2))) != null && (log = Log.getLog((String)(this.getParent().getName() + '_' + string))) != null && (n2 = log.getSeverity()) > (n = log2.getSeverity())) {
                log.setSeverity(log2.getSeverity());
            }
            this.portName = string;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.serialPort = null;
        this.serialIn = null;
        this.serialOut = null;
        this.portName = null;
    }

    public BDdfSerialCommunicator() {
        this.this();
        this.getSerialPortParameters().setPortName("COM1");
    }

    static {
        Class clazz = class$com$tridium$ddfSerial$comm$BDdfSerialCommunicator;
        if (clazz == null) {
            clazz = class$com$tridium$ddfSerial$comm$BDdfSerialCommunicator = BDdfSerialCommunicator.class("[Lcom.tridium.ddfSerial.comm.BDdfSerialCommunicator;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

