/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platMstp;

import com.tridium.platMstp.BBacnetMstpPlatformService;
import com.tridium.platMstp.MstpFrame;
import com.tridium.platMstp.MstpListener;
import com.tridium.platSerial.BSerialPort;
import com.tridium.platSerial.BSerialPortPlatformService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.TextUtil;
import javax.baja.serial.PortDeniedException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetMstpPlatformServiceNpsdk
extends BBacnetMstpPlatformService {
    public static final Type TYPE;
    private static boolean nativesLoaded;
    private static String STATION_PREFIX;
    private static BSerialPortPlatformService serialPortPlatformService;
    private IntHashMap trunkListeners;
    int numTrunks;
    private IntHashMap handleToName;
    static /* synthetic */ Class class$com$tridium$platMstp$BBacnetMstpPlatformServiceNpsdk;

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        File file = new File(Sys.getBajaHome() + File.separator + "bin" + File.separator + "libmstp-npsdk.so");
        if (file.exists()) {
            log.trace("BacnetMstpPlatformNpsdk platform is valid");
            return true;
        }
        return false;
    }

    protected synchronized boolean loadLibraries() {
        if (nativesLoaded) {
            return true;
        }
        try {
            System.loadLibrary("mstp-npsdk");
            nativesLoaded = true;
            log.trace("mstp-npsdk loaded");
        }
        catch (Throwable throwable) {
            log.error("Unable load mstp-npsdk native", throwable);
        }
        return nativesLoaded;
    }

    public void serviceStarted() throws Exception {
        if (!this.initMstpd()) {
            throw new RuntimeException("cannot run mstp daemon processes");
        }
        log.trace("mstp initialization complete");
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        this.cleanup0();
        log.trace("cleanupMstp done");
        super.serviceStopped();
    }

    public boolean initMstpd() {
        if (!this.loadLibraries()) {
            return false;
        }
        return this.init0();
    }

    public int startDriver(String string, String string2, int n, int n2, int n3, int n4, MstpListener mstpListener) {
        log.trace("Starting mstp driver: " + string2 + " at " + n + " baud, tsAddr=" + n2 + " maxMaster=" + n3 + " maxInfoFrames=" + n4);
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        try {
            this.lockSerial(string2);
        }
        catch (PortDeniedException portDeniedException) {
            log.error("Could not open mstp on serial port " + string2 + ", failed to obtain lock");
            throw new RuntimeException("Cannot open mstp");
        }
        int n5 = this.openDriver0(string2, n, n2, n3, n4);
        if (n5 == -1) {
            log.error("Could not open mstp on serial port: " + string2);
            try {
                this.unlockSerial(string2);
            }
            catch (PortDeniedException portDeniedException) {
                log.warning("Failed to unlock mstp serial device " + string2, (Throwable)portDeniedException);
            }
            throw new RuntimeException("Cannot open mstp");
        }
        this.handleToName.put(n5, (Object)string2);
        MstpTrunkListener mstpTrunkListener = new MstpTrunkListener(n5, mstpListener);
        Thread thread = new Thread((Runnable)mstpTrunkListener, "mstp" + n5);
        thread.start();
        mstpTrunkListener.myThread = thread;
        this.trunkListeners.put(n5, (Object)mstpTrunkListener);
        return n5;
    }

    public void stopDriver(int n) {
        log.trace("stopping mstp driver");
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        MstpTrunkListener mstpTrunkListener = (MstpTrunkListener)this.trunkListeners.get(n);
        if (mstpTrunkListener == null) {
            throw new RuntimeException("Invalid handle " + n);
        }
        mstpTrunkListener.done = true;
        mstpTrunkListener.myThread.interrupt();
        this.closeDriver0(n);
        String string = (String)this.handleToName.remove(n);
        try {
            this.unlockSerial(string);
        }
        catch (PortDeniedException portDeniedException) {
            log.error("Failed to unlock mstp serial device " + string, (Throwable)portDeniedException);
        }
        log.trace("mstp driver stopped");
    }

    private final synchronized void lockSerial(String string) throws PortDeniedException {
        String string2;
        log.trace("Attempting to lock " + string + " for owner mstp");
        String string3 = this.getLockFileName(string);
        if (string3 == null) {
            log.trace("Can not lock " + string + ", can not map lock file");
        }
        if (!"none".equalsIgnoreCase(string2 = this.getLockFileOwner(string3))) {
            throw new PortDeniedException("Unabled to create lock for osPortName for owner mstp, already owned by " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            fileOutputStream.write((STATION_PREFIX + "mstp").getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new PortDeniedException("Unable to create lock for " + string + " for owner mstp : " + exception.getMessage());
        }
        log.trace(string + " locked for owner mstp");
    }

    private final synchronized void unlockSerial(String string) throws PortDeniedException {
        String string2;
        log.trace("Attempting to unlock " + string + " as owner mstp");
        String string3 = this.getLockFileName(string);
        if (string3 == null) {
            log.trace("Can not unlock " + string + ", can not map lock file");
        }
        if ((string2 = this.getLockFileOwner(string3)) != null && !string2.equalsIgnoreCase(STATION_PREFIX + "mstp")) {
            throw new PortDeniedException("Unable to unlock " + string + ", mstp does not have the port lock");
        }
        File file = new File(string3);
        if (file.exists() && !file.delete()) {
            throw new PortDeniedException("Unable to unlock " + string + ", failed to delete " + string3);
        }
        log.trace(this.getName() + " unlocked");
    }

    private final String getLockFileOwner(String string) {
        Object var2_2 = null;
        File file = new File(string);
        if (!file.exists()) {
            return "none";
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            StringBuffer stringBuffer = new StringBuffer();
            int n = fileInputStream.read();
            while (n != -1) {
                stringBuffer.append((char)n);
                n = fileInputStream.read();
            }
            fileInputStream.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            log.trace("Problem reading lock file " + string + " for mstp defaulting to no ownership", (Throwable)iOException);
            return "none";
        }
    }

    private final String getLockFileName(String string) {
        if (BBacnetMstpPlatformServiceNpsdk.getSerialService() == null) {
            log.trace("Coult not obtain serial platform service reference, can not mimic locking behavior in mstp");
            return null;
        }
        String[] stringArray = serialPortPlatformService.getPortNames();
        int n = -1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            BSerialPort bSerialPort = (BSerialPort)serialPortPlatformService.get(stringArray[n2]);
            if (bSerialPort.getOsPortName().equalsIgnoreCase(string)) {
                n = bSerialPort.getPortIndex();
            }
            ++n2;
        }
        if (n == -1) {
            log.trace("Coult not obtain serial port index from serial platform service reference, can not mimic locking behavior in mstp");
            return null;
        }
        return System.getProperty("java.io.tmpdir", "/tmp") + File.separatorChar + "niagara-ser" + n + ".owner";
    }

    public void sendFrame(int n, byte by, byte[] byArray, boolean bl) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        if (byArray.length > 501) {
            throw new IllegalArgumentException("Invalid frame length " + byArray.length);
        }
        this.sendFrame0(n, by, byArray, bl);
    }

    public void setBaudRate(int n, int n2) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.trace("setting baud rate to " + n2);
        this.setBaudRate0(n, n2);
    }

    public void setMaxMaster(int n, int n2) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.trace("setting max master to " + n2);
        this.setMaxMaster0(n, n2);
    }

    public void setMaxInfoFrames(int n, int n2) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.trace("setting max info frames to " + n2);
        this.setMaxInfoFrames0(n, n2);
    }

    public void setAddress(int n, int n2) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.trace("setting this station address to " + n2);
        this.setAddress0(n, n2);
    }

    public int getAddress(int n) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        int n2 = this.getAddress0(n);
        log.trace("getAddress0 returned " + n2);
        return n2;
    }

    private final native boolean init0();

    private final native void cleanup0();

    private final native int openDriver0(String var1, int var2, int var3, int var4, int var5);

    private final native void closeDriver0(int var1);

    private final native void rcvFrame0(int var1, MstpFrame var2);

    private final native void sendFrame0(int var1, byte var2, byte[] var3, boolean var4);

    private final native void setBaudRate0(int var1, int var2);

    private final native void setMaxMaster0(int var1, int var2);

    private final native void setMaxInfoFrames0(int var1, int var2);

    private final native void setAddress0(int var1, int var2);

    private final native int getAddress0(int var1);

    private static final BSerialPortPlatformService getSerialService() {
        if (serialPortPlatformService == null) {
            try {
                serialPortPlatformService = (BSerialPortPlatformService)Sys.getService((Type)BSerialPortPlatformService.TYPE);
            }
            catch (Exception exception) {}
        }
        return serialPortPlatformService;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.trunkListeners = new IntHashMap();
        this.numTrunks = 6;
        this.handleToName = new IntHashMap();
    }

    public BBacnetMstpPlatformServiceNpsdk() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platMstp$BBacnetMstpPlatformServiceNpsdk;
        if (clazz == null) {
            clazz = class$com$tridium$platMstp$BBacnetMstpPlatformServiceNpsdk = BBacnetMstpPlatformServiceNpsdk.class("[Lcom.tridium.platMstp.BBacnetMstpPlatformServiceNpsdk;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        nativesLoaded = false;
        STATION_PREFIX = "station:";
        serialPortPlatformService = null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MstpTrunkListener
    implements Runnable {
        int handle;
        MstpListener linkListener;
        Thread myThread;
        boolean done;

        public void run() {
            MstpFrame mstpFrame = new MstpFrame();
            log.trace("mstp trunk listener starting");
            while (!this.done) {
                try {
                    BBacnetMstpPlatformServiceNpsdk.this.rcvFrame0(this.handle, mstpFrame);
                    log.trace("Frame received:\n" + TextUtil.bytesToHexString((byte[])mstpFrame.getData()));
                    if (this.linkListener == null) continue;
                    this.linkListener.receiveFrame(mstpFrame.getSrcAddr(), mstpFrame.getData(), mstpFrame.getDataExpectingReply());
                }
                catch (Exception exception) {
                    if (this.done) continue;
                    exception.printStackTrace();
                }
            }
            log.trace("mstp trunk listener done");
        }

        private final /* synthetic */ void this() {
            this.done = false;
        }

        public MstpTrunkListener(int n, MstpListener mstpListener) {
            this.this();
            this.handle = n;
            this.linkListener = mstpListener;
        }
    }
}

