/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.provisioningNiagara.backup;

import com.tridium.backup.BBackupChannel;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.backup.BBackupStationExt;
import com.tridium.provisioningNiagara.backup.BBackupStepDetails;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.backup.BBackupService;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.RemoteStation;
import javax.baja.provisioningNiagara.BNiagaraNetworkJob;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BProvisioningBackupStep
extends BDeviceJobStep
implements BFoxClientConnection.Interest {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$provisioningNiagara$backup$BProvisioningBackupStep == null ? (class$javax$baja$provisioningNiagara$backup$BProvisioningBackupStep = BProvisioningBackupStep.class$("javax.baja.provisioningNiagara.backup.BProvisioningBackupStep")) : class$javax$baja$provisioningNiagara$backup$BProvisioningBackupStep));
    private static final BIcon icon = BIcon.std((String)"backup.png");
    static /* synthetic */ Class class$javax$baja$provisioningNiagara$backup$BProvisioningBackupStep;

    public Type getType() {
        return TYPE;
    }

    public static BBatchJob makeJob(String string) {
        BNiagaraNetworkJob bNiagaraNetworkJob = new BNiagaraNetworkJob(string);
        bNiagaraNetworkJob.addStep(new BProvisioningBackupStep());
        return bNiagaraNetworkJob;
    }

    protected BDeviceStepDetails makeDetails(BDevice bDevice) {
        BNiagaraStation bNiagaraStation = (BNiagaraStation)bDevice;
        BBackupStepDetails bBackupStepDetails = new BBackupStepDetails(bNiagaraStation, this);
        this.add(SlotPath.escape((String)bNiagaraStation.getStationName()), (BValue)bBackupStepDetails, 4);
        return bBackupStepDetails;
    }

    protected void doRun(BBatchJobService bBatchJobService, BDeviceStepDetails bDeviceStepDetails, BDevice bDevice, DeviceNetworkJobOp deviceNetworkJobOp) throws Exception {
        BBackupService bBackupService;
        BNiagaraStation bNiagaraStation = (BNiagaraStation)bDevice;
        bDeviceStepDetails.message("provisioningNiagara", "ProvisioningBackupStep.backingUp", bNiagaraStation.getDisplayName(null));
        try {
            bBackupService = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            bBackupService = new BBackupService();
        }
        BBackupStationExt bBackupStationExt = (BBackupStationExt)bNiagaraStation.getMixIn(BBackupStationExt.TYPE);
        if (bBackupStationExt.isUnoperational()) {
            bDeviceStepDetails.failed("provisioningNiagara", "ProvisioningBackupStep.backupExtUnoperational", new String[]{bNiagaraStation.getDisplayName(null), BFormat.getEncodedPattern((BIEncodable)bBackupStationExt.getStatus())});
            bDeviceStepDetails.complete(BJobState.failed);
            return;
        }
        OrdQuery[] ordQueryArray = ((BBackupStepDetails)bDeviceStepDetails).getBackupFileOrd().parse();
        FilePath filePath = (FilePath)ordQueryArray[ordQueryArray.length - 1];
        BPlatformConnection bPlatformConnection = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
        this.checkCanceled((BDevice)bNiagaraStation);
        RemoteStation remoteStation = bPlatformConnection.getPlatformDaemon().getStationManager().getStation(bNiagaraStation.getStationName());
        this.checkCanceled((BDevice)bNiagaraStation);
        if (remoteStation == null) {
            bDeviceStepDetails.failed("provisioningNiagara", "ProvisioningBackupStep.stationNotFound", bNiagaraStation.getDisplayName(null));
            bDeviceStepDetails.complete(BJobState.failed);
        } else {
            BIFile bIFile = BFileSystem.INSTANCE.makeFile(filePath);
            if (remoteStation.getStatus() == BStationStatus.running) {
                int n;
                this.checkCanceled((BDevice)bNiagaraStation);
                bNiagaraStation.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
                BBackupChannel bBackupChannel = (BBackupChannel)bNiagaraStation.getClientConnection().getChannels().get("backup", BBackupChannel.TYPE);
                InputStream inputStream = bBackupChannel.backup(false);
                this.checkCanceled((BDevice)bNiagaraStation);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(bIFile.getOutputStream());
                int n2 = 4096;
                byte[] byArray = new byte[n2];
                while ((n = inputStream.read(byArray, 0, n2)) >= 0) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    this.checkCanceled((BDevice)bNiagaraStation);
                }
                try {
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bNiagaraStation.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                bDeviceStepDetails.message("provisioningNiagara", "ProvisioningBackupStep.backupFileWritten", bIFile.getFilePath().getBody());
            } else {
                bBackupService.zip(bDeviceStepDetails.log(), BBackupService.makeCanceler((BJob)this.getJob()), bPlatformConnection.getPlatformDaemon(), bIFile.getOutputStream(), true);
                bDeviceStepDetails.message("provisioningNiagara", "ProvisioningBackupStep.backupFileWritten", bIFile.getFilePath().getBody());
            }
        }
    }

    public void stepComplete(BDeviceStepDetails bDeviceStepDetails, DeviceNetworkJobOp deviceNetworkJobOp) {
        if (bDeviceStepDetails.getState() != BJobState.success) {
            return;
        }
        BNiagaraStation bNiagaraStation = (BNiagaraStation)bDeviceStepDetails.getDevice();
        BBackupStationExt bBackupStationExt = (BBackupStationExt)bNiagaraStation.getMixIn(BBackupStationExt.TYPE);
        bBackupStationExt.fireBackupCreated(((BBackupStepDetails)bDeviceStepDetails).getBackupFileOrd());
        bBackupStationExt.setLastBackupTime(bDeviceStepDetails.getStartTime());
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

