/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.station;

import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.station.BStationProxy;
import com.tridium.provisioningNiagara.ui.station.BStationProxyOutputPane;
import javax.baja.platform.BStationStatus;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;

public class StartCommand
extends Command {
    private BStationProxyOutputPane outputPane;
    private BStationProxy station = null;

    public StartCommand(BWidget bWidget, BStationProxyOutputPane bStationProxyOutputPane) {
        super(bWidget, Lexicon.make((String)"provisioningNiagara"), "ProvisioningStationDirector.command.startStation");
        this.outputPane = bStationProxyOutputPane;
        this.setEnabled(false);
    }

    public void loadStation(BStationProxy bStationProxy) {
        this.station = bStationProxy;
        this.checkEnabled();
    }

    public void checkEnabled() {
        if (this.station.getIsRestartEnabled()) {
            this.setEnabled(this.station.getStationStatus() != BStationStatus.running && this.station.getStationStatus() != BStationStatus.starting && this.station.getStationStatus() != BStationStatus.stopping);
        } else {
            this.setEnabled(this.station.getStationStatus() != BStationStatus.running && this.station.getStationStatus() != BStationStatus.halted && this.station.getStationStatus() != BStationStatus.failed && this.station.getStationStatus() != BStationStatus.starting && this.station.getStationStatus() != BStationStatus.stopping);
        }
    }

    public CommandArtifact doInvoke() {
        BWidgetShell bWidgetShell = this.getOwner().getShell();
        try {
            if (bWidgetShell != null) {
                bWidgetShell.enterBusy();
            }
            if (this.outputPane != null) {
                this.outputPane.stopUpdates();
                this.station.startStation();
                this.outputPane.load();
            } else {
                this.station.startStation();
            }
        }
        catch (Throwable throwable) {
            CommandUtil.error((Command)this, (Throwable)throwable);
        }
        finally {
            if (bWidgetShell != null) {
                bWidgetShell.exitBusy();
            }
        }
        return null;
    }
}

