/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.station;

import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.station.BStationProxy;
import com.tridium.provisioningNiagara.ui.station.BStationProxyOutputPane;
import javax.baja.gx.BImage;
import javax.baja.platform.BStationStatus;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.util.Lexicon;

public class RestartCommand
extends AsyncCommand {
    private BStationProxy station;
    private static Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public RestartCommand(BWidget bWidget, BStationProxyOutputPane bStationProxyOutputPane) {
        super(bWidget, lex, "ProvisioningStationDirector.command.restartStation");
        this.setEnabled(false);
    }

    public void loadStation(BStationProxy bStationProxy) {
        this.station = bStationProxy;
        this.checkEnabled();
    }

    public void checkEnabled() {
        this.setEnabled(this.station.getIsRestartEnabled() && this.station.getStationStatus() == BStationStatus.running && this.station.getIsAcceptingMessages());
    }

    public void doInvokeAsync() {
        try {
            String string = lex.getText("ProvisioningStationDirector.command.restartStation.dlgTitle", (Object[])new String[]{this.station.getStationDisplayName()});
            String string2 = lex.getText("ProvisioningStationDirector.command.restartStation.dlgMessage", (Object[])new String[]{this.station.getStationDisplayName()});
            if (BDialog.open((BWidget)this.getOwner(), (String)string, (Object)string2, (int)12, (BImage)BDialog.WARNING_ICON, (String)null) == 4) {
                this.station.restartStation();
            }
        }
        catch (Throwable throwable) {
            CommandUtil.error((Command)this, (Throwable)throwable);
        }
    }
}

