/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.BVersion;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.SortableTableUtil;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.software.BSoftwareStationExt;
import com.tridium.provisioningNiagara.software.ProvisioningRegistry;
import com.tridium.provisioningNiagara.ui.software.BStationSoftwareFilter;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableRow;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Array;
import javax.baja.util.IFilter;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;

public class SoftwareTableModel
extends TableModel {
    private long elapsed = 0L;
    public static final int NAME_COL = 0;
    public static final int CURRENT_VER_COL = 1;
    public static final int AVAIL_VER_COL = 2;
    public static final int COMMENT_COL = 3;
    public static final int STATUS_NONE = 0;
    public static final int STATUS_LATER = 1;
    public static final int STATUS_SAME = 2;
    public static final int STATUS_EARLIER = 3;
    public static final int STATUS_DIFFERENT = 4;
    public static final int STATUS_EQUIVALENT = 5;
    public static final int STATUS_NOT_INSTALLED = 6;
    public static final int STATUS_BAD_INSTALLABLE = 7;
    public static final int STATUS_BAD_TARGET = 8;
    public static final int STATUS_BOTH_BAD = 9;
    public static final int STATUS_NO_DETAILS = 10;
    public static final int STATUS_NO_LOCAL = 11;
    public static final int STATUS_EARLIER_COMMISSION = 12;
    public static final int STATUS_NOT_INSTALLED_COMMISSION = 13;
    private static int[] cols = new int[]{0, 1, 2, 3};
    private int sortColumn = 3;
    private boolean sortAscending = true;
    private boolean needsSort = true;
    protected InstallScenario scenario;
    protected InstallScenario oodScenario;
    private TreeMap rowsByPartSpec;
    protected Array rows;
    private BSoftwareStationExt stationExt;
    private BStationSoftwareFilter filter = null;
    private DaemonSessionTaskListener taskListener;
    private Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private static final Comparator COMMENT_COLUMN_COMPARATOR = new CommentColumnComparator();
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$ui$software$SoftwareTableRow;
    static /* synthetic */ Class class$com$tridium$install$BDependency;
    static /* synthetic */ Class class$com$tridium$install$part$BPart;

    public SoftwareTableModel() {
        this.rowsByPartSpec = new TreeMap();
        this.rows = new Array(class$com$tridium$provisioningNiagara$ui$software$SoftwareTableRow == null ? (class$com$tridium$provisioningNiagara$ui$software$SoftwareTableRow = SoftwareTableModel.class$("com.tridium.provisioningNiagara.ui.software.SoftwareTableRow")) : class$com$tridium$provisioningNiagara$ui$software$SoftwareTableRow);
    }

    public BPartInstallStatus getInstallStatusAt(int n) {
        return this.getRow(n).getInstallStatus();
    }

    public BImage getCellIcon(int n, int n2) {
        return null;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        switch (cols[n]) {
            case 0: {
                return this.lex.getText("StationSoftwareView.column.partName");
            }
            case 1: {
                return this.lex.getText("StationSoftwareView.column.currentVersion");
            }
            case 2: {
                return this.lex.getText("StationSoftwareView.column.availableVersion");
            }
            case 3: {
                return "";
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public BPart getCurrentPartFor(PartSpec partSpec) {
        SoftwareTableRow softwareTableRow = this.getRow(partSpec);
        return softwareTableRow == null ? null : softwareTableRow.getCurrentPart();
    }

    public int indexOf(PartSpec partSpec) {
        SoftwareTableRow softwareTableRow = this.getRow(partSpec);
        if (softwareTableRow == null) {
            return -1;
        }
        return this.rows.indexOf((Object)softwareTableRow);
    }

    public BPart getCurrentPartAt(int n) {
        return this.getRow(n).getCurrentPart();
    }

    public BVersion getCurrentVersionAt(int n) {
        return this.getRow(n).getCurrentVersion();
    }

    public BVersion getCurrentVersionFor(PartSpec partSpec) {
        SoftwareTableRow softwareTableRow = this.getRow(partSpec);
        return softwareTableRow == null ? null : softwareTableRow.getCurrentVersion();
    }

    public Array getForwardDependenciesAt(int n) {
        return this.getRow(n).getForwardDeps();
    }

    public Array getForwardDependenciesFor(PartSpec partSpec) {
        SoftwareTableRow softwareTableRow = this.getRow(partSpec);
        return softwareTableRow == null ? new Array(class$com$tridium$install$BDependency == null ? (class$com$tridium$install$BDependency = SoftwareTableModel.class$("com.tridium.install.BDependency")) : class$com$tridium$install$BDependency) : softwareTableRow.getForwardDeps();
    }

    public BInstallable getInstallableAt(int n) {
        return this.getRow(n).getInstallable();
    }

    public BInstallable getInstallableFor(PartSpec partSpec) {
        SoftwareTableRow softwareTableRow = this.getRow(partSpec);
        return softwareTableRow == null ? null : softwareTableRow.getInstallable();
    }

    public BPart getInstallablePartAt(int n) {
        return this.getRow(n).getInstallablePart();
    }

    public BPart getInstallablePartFor(PartSpec partSpec) {
        SoftwareTableRow softwareTableRow = this.getRow(partSpec);
        return softwareTableRow == null ? null : softwareTableRow.getInstallablePart();
    }

    public BVersion getInstallableVersionAt(int n) {
        return this.getRow(n).getHighestInstallableVersion();
    }

    public BVersion getInstallableVersionFor(PartSpec partSpec) {
        SoftwareTableRow softwareTableRow = this.getRow(partSpec);
        return softwareTableRow == null ? null : softwareTableRow.getInstallableVersion();
    }

    public String getNameAt(int n) {
        return this.getRow(n).getPartName();
    }

    public Array getReverseDependenciesAt(int n) {
        Map map = this.getRow(n).getReverseDeps();
        return new Array(map.keySet());
    }

    public Array getDependentPartsFor(PartSpec partSpec) {
        SoftwareTableRow softwareTableRow = this.getRow(partSpec);
        if (softwareTableRow == null) {
            return new Array(class$com$tridium$install$part$BPart == null ? (class$com$tridium$install$part$BPart = SoftwareTableModel.class$("com.tridium.install.part.BPart")) : class$com$tridium$install$part$BPart);
        }
        return softwareTableRow.getDependentParts();
    }

    public Array getDependentPartsAt(int n) {
        return this.getRow(n).getDependentParts();
    }

    public SortableTableUtil.SortableRow getSortableRow(int n) {
        return this.getRow(n);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public BImage getRowIcon(int n) {
        return this.getCellIcon(n, 0);
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public int getStatusAt(int n) {
        return this.getRow(n).getStatus();
    }

    public int getStatusFor(PartSpec partSpec) {
        SoftwareTableRow softwareTableRow = this.getRow(partSpec);
        if (softwareTableRow == null) {
            return 0;
        }
        return softwareTableRow.getStatus();
    }

    public String getTypeAt(int n) {
        return this.getRow(n).getType();
    }

    public DaemonSessionTaskListener getTaskListener() {
        return this.taskListener;
    }

    public InstallScenario getScenario() {
        return this.scenario;
    }

    public void setScenario(InstallScenario installScenario) {
        if (!installScenario.canCommit()) {
            throw new IllegalArgumentException("Install scenario has unmet dependencies");
        }
        this.scenario = installScenario;
        this.rebuild(false);
    }

    public Object getValueAt(int n, int n2) {
        switch (cols[n2]) {
            case 0: {
                return this.getRow(n).getPartName();
            }
            case 1: {
                return SoftwareTableModel.nvl(this.getRow(n).getCurrentVersion(), "-");
            }
            case 2: {
                return SoftwareTableModel.nvl(this.getRow(n).getHighestInstallableVersion(), "-");
            }
            case 3: {
                return this.getRow(n).getComment();
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public BSoftwareStationExt getStationExt() {
        return this.stationExt;
    }

    public BDaemonPlatform getTargetPlatform() {
        return this.stationExt.getPlatformSnapshot();
    }

    public ProvisioningRegistry getInstallableRegistry() {
        BProvisioningNiagaraNetworkExt bProvisioningNiagaraNetworkExt = (BProvisioningNiagaraNetworkExt)BOrd.make((String)"service:provisioningNiagara:ProvisioningNiagaraNetworkExt").get((BObject)this.stationExt);
        return bProvisioningNiagaraNetworkExt.getInstallableRegistry();
    }

    public void init(BSoftwareStationExt bSoftwareStationExt, DaemonSessionTaskListener daemonSessionTaskListener, boolean bl) throws AuthenticationException {
        try {
            this.taskListener = daemonSessionTaskListener;
            this.stationExt = bSoftwareStationExt;
            ProvisioningRegistry provisioningRegistry = this.getInstallableRegistry();
            this.scenario = new InstallScenario(bSoftwareStationExt.getPlatformSnapshot(), null, null, null, null, null, null, new SolutionParameters(daemonSessionTaskListener, true, "default"), (InstallableRegistry)provisioningRegistry);
            this.oodScenario = InstallScenario.upgradeOutOfDate((InstallScenario)this.scenario, (InstallableRegistry)provisioningRegistry).solve();
            this.rebuild(bl);
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public boolean isColumnSortable(int n) {
        return true;
    }

    public boolean isModule(int n) {
        return this.getRow(n).isModule();
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void rebuild() throws AuthenticationException {
        this.rebuild(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(boolean bl) throws AuthenticationException {
        this.rowsByPartSpec = new TreeMap();
        BDaemonPlatform bDaemonPlatform = this.stationExt.getPlatformSnapshot();
        DaemonSessionTask daemonSessionTask = new DaemonSessionTask(this.lex, "StationSoftwareView.rebuilding", "StationSoftwareView.rebuilding");
        try {
            Object object;
            Object object2;
            PartSpec partSpec;
            Object object3;
            if (this.taskListener != null) {
                this.taskListener.taskStarted(daemonSessionTask);
            }
            BDaemonSessionView.log.trace("model rebuild: fetched platform " + this.getElapsed());
            bDaemonPlatform.getModuleList().init(this.taskListener);
            Object object4 = bDaemonPlatform.getModuleList().getModules().getProperties();
            while (object4.next()) {
                this.addCurrentPart((BPart)((BModuleInstallable)object4.get()).getModulePart());
            }
            BDaemonSessionView.log.trace("model rebuild: added remote modules " + this.getElapsed());
            object4 = (BProvisioningNiagaraNetworkExt)BOrd.make((String)"service:provisioningNiagara:ProvisioningNiagaraNetworkExt").get((BObject)this.stationExt);
            ProvisioningRegistry provisioningRegistry = ((BProvisioningNiagaraNetworkExt)((Object)object4)).getInstallableRegistry();
            try {
                object3 = this.scenario.getToInstall();
                partSpec = new HashSet();
                for (int i = 0; i < ((BInstallable[])object3).length; ++i) {
                    if (!(object3[i] instanceof BModuleInstallable)) continue;
                    this.addInstallable(object3[i]);
                    partSpec.add(object3[i].getInstallableName());
                }
                object2 = provisioningRegistry.getInstallables(true, this.taskListener, null, "*.dist");
                while (object2.next()) {
                    object = (BInstallable)object2.get();
                    if (!(object instanceof BModuleInstallable) || object.getUnmetPlatformDependencies(bDaemonPlatform).size() != 0) continue;
                    if (partSpec.contains(object.getInstallableName())) {
                        this.getRow(object.getPartSpec()).setLatestAvailableInstallable((BInstallable)object);
                        continue;
                    }
                    this.addInstallable((BInstallable)object);
                }
            }
            catch (AuthenticationException authenticationException) {
                throw authenticationException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
            BDaemonSessionView.log.trace("model rebuild: added local modules " + this.getElapsed());
            object3 = this.rowsByPartSpec.keySet().iterator();
            while (object3.hasNext()) {
                partSpec = (PartSpec)object3.next();
                object2 = (SoftwareTableRow)this.rowsByPartSpec.get(partSpec);
                object = new TreeMap();
                Array array = new Array();
                this.checkDependencies(partSpec, (Map)object, array, null);
                ((SoftwareTableRow)object2).setForwardDeps(new Array(((TreeMap)object).values()));
            }
            this.updateValues(bl);
        }
        finally {
            if (this.taskListener != null) {
                this.taskListener.taskFinished(daemonSessionTask);
            }
        }
    }

    public void reload() throws Exception {
        this.getTable().getSelection().deselectAll();
        if (this.scenario != null) {
            this.scenario.getTargetPlatform().getModuleList().reload(this.taskListener);
            this.scenario.getTargetPlatform().getDaemonSession().reloadHostProperties();
        }
        this.rebuild();
    }

    public long getSizeDeltaOnCommit() {
        long l = 0L;
        for (int i = 0; i < this.getRowCount(); ++i) {
            l += this.getRow(i).getSizeDeltaOnCommit();
        }
        return l;
    }

    public void resetScenario() {
        try {
            this.scenario = new InstallScenario(this.scenario.getTargetPlatform(), this.taskListener, null, null, null, (InstallableRegistry)this.getInstallableRegistry());
            this.updateValues(true);
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void sortByColumn(int n, boolean bl) {
        if (!this.needsSort && n == this.sortColumn && bl == this.sortAscending) {
            return;
        }
        this.sortColumn = n;
        this.sortAscending = bl;
        this.updateValues(true);
    }

    public void setFilter(BStationSoftwareFilter bStationSoftwareFilter) {
        this.filter = bStationSoftwareFilter;
        if (this.filter != null) {
            this.updateValues(true);
        }
    }

    public BStationSoftwareFilter getFilter() {
        return this.filter;
    }

    private void addCurrentPart(BPart bPart) {
        if (bPart == null || bPart.isNull()) {
            return;
        }
        SoftwareTableRow softwareTableRow = (SoftwareTableRow)this.rowsByPartSpec.get(bPart.getPartSpec());
        if (softwareTableRow == null) {
            softwareTableRow = this.makeRow();
            this.rowsByPartSpec.put(bPart.getPartSpec(), softwareTableRow);
        }
        softwareTableRow.setCurrentPart(bPart);
        softwareTableRow.updateRow();
    }

    protected SoftwareTableRow makeRow() {
        return new SoftwareTableRow(this);
    }

    private void checkDependencies(PartSpec partSpec, Map map, Array array, BDependency bDependency) {
        if (array.contains((Object)partSpec)) {
            return;
        }
        array.add((Object)partSpec);
        SoftwareTableRow softwareTableRow = (SoftwareTableRow)this.rowsByPartSpec.get(partSpec);
        if (softwareTableRow == null) {
            return;
        }
        BPart bPart = null;
        if (bDependency == null) {
            bPart = softwareTableRow.getInstallablePart() == null ? softwareTableRow.getCurrentPart() : softwareTableRow.getInstallablePart();
        } else {
            bPart = softwareTableRow.getCurrentPart();
            if (bPart == null || !bPart.meets(bDependency)) {
                bPart = softwareTableRow.getHighestVersionedPart();
            }
            if (bPart == null) {
                bPart = softwareTableRow.getInstallablePart();
            }
        }
        BDependency[] bDependencyArray = bPart.getDependencyArray();
        for (int i = 0; i < bDependencyArray.length; ++i) {
            BDependency bDependency2 = (BDependency)map.get(bDependencyArray[i].getPartSpec());
            if (bDependency2 == null) {
                map.put(bDependencyArray[i].getPartSpec(), bDependencyArray[i]);
                this.checkDependencies(bDependencyArray[i].getPartSpec(), map, array, bDependencyArray[i]);
            } else if (bDependencyArray[i].supersedes(bDependency2)) {
                map.put(bDependencyArray[i].getPartSpec(), bDependencyArray[i]);
            }
            SoftwareTableRow softwareTableRow2 = (SoftwareTableRow)this.rowsByPartSpec.get(bDependencyArray[i].getPartSpec());
            if (softwareTableRow2 == null) continue;
            softwareTableRow2.addReverseDep(softwareTableRow, bDependencyArray[i]);
        }
    }

    private void addInstallable(BInstallable bInstallable) {
        BInstallable bInstallable2;
        if (bInstallable == null) {
            return;
        }
        SoftwareTableRow softwareTableRow = (SoftwareTableRow)this.rowsByPartSpec.get(bInstallable.getPart().getPartSpec());
        if (softwareTableRow == null) {
            softwareTableRow = this.makeRow();
            this.rowsByPartSpec.put(bInstallable.getPart().getPartSpec(), softwareTableRow);
        }
        if (this.isUpgrade(bInstallable, bInstallable2 = softwareTableRow.getInstallable())) {
            softwareTableRow.setInstallable(bInstallable);
            softwareTableRow.updateRow();
        }
    }

    private boolean isUpgrade(BInstallable bInstallable, BInstallable bInstallable2) {
        if (bInstallable == null) {
            return false;
        }
        if (bInstallable2 == null) {
            return true;
        }
        switch (bInstallable2.getVersion().checkVersionRequirement(bInstallable.getVersion())) {
            case 2: {
                if (bInstallable2 instanceof BModuleInstallable) {
                    BModulePart bModulePart = (BModulePart)bInstallable.getPart();
                    BModulePart bModulePart2 = (BModulePart)bInstallable2.getPart();
                    if (bModulePart.getBuildAbsTime() != null && bModulePart2.getBuildAbsTime() != null) {
                        int n = bModulePart.getBuildAbsTime().compareTo((Object)bModulePart2.getBuildAbsTime());
                        if (n > 0) {
                            return true;
                        }
                        if (n < 0) {
                            return false;
                        }
                    }
                }
                return false;
            }
            case 8: 
            case 16: {
                return false;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    protected SoftwareTableRow getRow(int n) {
        return (SoftwareTableRow)this.rows.get(n);
    }

    protected SoftwareTableRow getRow(PartSpec partSpec) {
        return (SoftwareTableRow)this.rowsByPartSpec.get(partSpec);
    }

    private static String nvl(Object object, String string) {
        return object == null ? string : object.toString();
    }

    protected void updateValues(boolean bl) {
        OriginalOrderComparator originalOrderComparator = new OriginalOrderComparator(this.rows);
        this.needsSort = false;
        this.rows = new Array(this.rowsByPartSpec.values());
        this.rows = bl ? this.rows.sort((Comparator)new SoftwareTableRowComparator()) : this.rows.sort((Comparator)originalOrderComparator);
        if (this.filter != null && this.filter.getIsEnabled()) {
            this.rows = this.rows.filter((IFilter)this.filter);
        }
        this.getTable().getSelection().deselectAll();
        this.updateTable(true);
    }

    public void updateTable(boolean bl) {
        this.needsSort = true;
        for (int i = 0; i < this.rows.size(); ++i) {
            ((SoftwareTableRow)this.rows.get(i)).updateRow();
        }
        super.updateTable(bl);
    }

    private String getElapsed() {
        long l = this.elapsed;
        this.elapsed = Clock.ticks();
        return l == 0L ? "" : this.elapsed - l + " ms";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SoftwareTableRowComparator
    implements Comparator {
        private Comparator[] comparators;

        public SoftwareTableRowComparator() {
            int n;
            int[] nArray = new int[4];
            nArray[0] = SoftwareTableModel.this.sortColumn;
            int n2 = 1;
            for (n = 0; n < nArray.length; ++n) {
                if (n == SoftwareTableModel.this.sortColumn) continue;
                nArray[n2++] = n;
            }
            this.comparators = new Comparator[4];
            for (n = 0; n < 4; ++n) {
                this.comparators[n] = new SoftwareColumnComparator(nArray[n], SoftwareTableModel.this.sortAscending);
            }
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            for (int i = 0; i < this.comparators.length && n == 0; ++i) {
                n = this.comparators[i].compare(object, object2);
            }
            return n;
        }
    }

    protected class OriginalOrderComparator
    implements Comparator {
        HashMap sequenceMapByPartName = new HashMap();

        public OriginalOrderComparator(Array array) {
            if (array != null) {
                for (int i = 0; i < array.size(); ++i) {
                    this.sequenceMapByPartName.put(((SoftwareTableRow)array.get(i)).getInstallableName(), new Integer(i));
                }
            }
        }

        public int compare(Object object, Object object2) {
            SoftwareTableRow softwareTableRow = (SoftwareTableRow)object;
            SoftwareTableRow softwareTableRow2 = (SoftwareTableRow)object2;
            Integer n = (Integer)this.sequenceMapByPartName.get(softwareTableRow.getInstallableName());
            Integer n2 = (Integer)this.sequenceMapByPartName.get(softwareTableRow2.getInstallableName());
            if (n == null) {
                if (n2 == null) {
                    return 0;
                }
                return -1;
            }
            if (n2 == null) {
                return 1;
            }
            return n.compareTo(n2);
        }
    }

    private static class SoftwareColumnComparator
    implements Comparator {
        private int comparatorSortColumn;
        private boolean comparatorAscending;

        public SoftwareColumnComparator(int n, boolean bl) {
            this.comparatorSortColumn = n;
            this.comparatorAscending = bl;
        }

        public int compare(Object object, Object object2) {
            SoftwareTableRow softwareTableRow = (SoftwareTableRow)object;
            SoftwareTableRow softwareTableRow2 = (SoftwareTableRow)object2;
            int n = this.comparatorAscending ? 1 : -1;
            switch (this.comparatorSortColumn) {
                case 3: {
                    return n * COMMENT_COLUMN_COMPARATOR.compare(softwareTableRow, softwareTableRow2);
                }
                case 0: {
                    if (softwareTableRow.getInstallableName() == null) {
                        if (softwareTableRow2.getInstallableName() == null) {
                            return 0;
                        }
                        return n;
                    }
                    if (softwareTableRow2.getInstallableName() == null) {
                        return n * -1;
                    }
                    return n * TextUtil.toLowerCase((String)softwareTableRow.getInstallableName()).compareTo(TextUtil.toLowerCase((String)softwareTableRow2.getInstallableName()));
                }
                case 1: {
                    if (softwareTableRow.getCurrentPart() == null) {
                        if (softwareTableRow2.getCurrentPart() == null) {
                            return 0;
                        }
                        return -1 * n;
                    }
                    if (softwareTableRow2.getCurrentPart() == null) {
                        return n;
                    }
                    return n * softwareTableRow.getCurrentPart().getVersion().compareTo((Object)softwareTableRow2.getCurrentPart().getVersion());
                }
                case 2: {
                    if (softwareTableRow.getInstallable() == null) {
                        if (softwareTableRow2.getInstallable() == null) {
                            return 0;
                        }
                        return -1 * n;
                    }
                    if (softwareTableRow2.getInstallable() == null) {
                        return n;
                    }
                    return n * softwareTableRow.getInstallable().getVersion().compareTo((Object)softwareTableRow2.getInstallable().getVersion());
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private static class CommentColumnComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            SoftwareTableRow softwareTableRow = (SoftwareTableRow)object;
            SoftwareTableRow softwareTableRow2 = (SoftwareTableRow)object2;
            return softwareTableRow.compareComment(softwareTableRow2);
        }
    }
}

