/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.DependencyMap;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.part.BPart;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableModel;
import com.tridium.ui.theme.Theme;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

public class CancelInstallCommand
extends AsyncCommand {
    private SoftwareTableModel tableModel;
    private static Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public static CancelInstallCommand makeCancelInstall(BWidget bWidget, SoftwareTableModel softwareTableModel) {
        return new CancelInstallCommand(bWidget, softwareTableModel, "StationSoftwareView.command.cancelInstallSelected");
    }

    public static CancelInstallCommand makeCancelReinstall(BWidget bWidget, SoftwareTableModel softwareTableModel) {
        return new CancelInstallCommand(bWidget, softwareTableModel, "StationSoftwareView.command.cancelReinstallSelected");
    }

    public static CancelInstallCommand makeCancelUpgrade(BWidget bWidget, SoftwareTableModel softwareTableModel) {
        return new CancelInstallCommand(bWidget, softwareTableModel, "StationSoftwareView.command.cancelUpgradeSelected");
    }

    public static CancelInstallCommand makeCancelDowngrade(BWidget bWidget, SoftwareTableModel softwareTableModel) {
        return new CancelInstallCommand(bWidget, softwareTableModel, "StationSoftwareView.command.cancelDowngradeSelected");
    }

    protected CancelInstallCommand(BWidget bWidget, SoftwareTableModel softwareTableModel, String string) {
        super(bWidget, lex, string);
        this.tableModel = softwareTableModel;
    }

    public static void cancelInstall(BWidget bWidget, SoftwareTableModel softwareTableModel, int[] nArray) {
        BWbShell bWbShell = BWbShell.getWbShell((BWidget)bWidget);
        try {
            int n;
            BDependency[] bDependencyArray;
            if (bWbShell != null) {
                bWbShell.enterBusy();
            }
            BInstallable[] bInstallableArray = softwareTableModel.getScenario().getToInstall();
            DependencyMap dependencyMap = new DependencyMap();
            TreeMap<PartSpec, BInstallable> treeMap = new TreeMap<PartSpec, BInstallable>();
            for (int i = 0; i < bInstallableArray.length; ++i) {
                treeMap.put(bInstallableArray[i].getPartSpec(), bInstallableArray[i]);
                bDependencyArray = bInstallableArray[i].getAllDependencies();
                for (n = 0; n < bDependencyArray.length; ++n) {
                    dependencyMap.addDependency(bInstallableArray[i].getPartSpec(), bDependencyArray[n]);
                }
            }
            TreeSet<PartSpec> treeSet = new TreeSet<PartSpec>();
            bDependencyArray = new TreeSet();
            for (n = 0; n < nArray.length; ++n) {
                treeSet.add(softwareTableModel.getInstallableAt(nArray[n]).getPartSpec());
            }
            for (n = 0; n < nArray.length; ++n) {
                BPart bPart = softwareTableModel.getInstallableAt(nArray[n]).getPart();
                if (bPart == null) continue;
                CancelInstallCommand.cascadeDepCancels(dependencyMap, bPart, softwareTableModel.getScenario().getTargetPlatform(), treeSet, (Set)bDependencyArray, treeMap);
            }
            if (bDependencyArray.size() == 0 || 1 == BDialog.confirm((BWidget)bWidget, (String)lex.getText("CancelInstallCommand.alsoCancel.title"), (Object)CancelInstallCommand.makeAlsoCancelDetailsPane((Set)bDependencyArray, treeMap), (int)3)) {
                BInstallable[] bInstallableArray2 = new BInstallable[bInstallableArray.length - treeSet.size()];
                int n2 = 0;
                for (int i = 0; i < bInstallableArray.length; ++i) {
                    if (treeSet.contains(bInstallableArray[i].getPartSpec())) continue;
                    bInstallableArray2[n2++] = bInstallableArray[i];
                }
                softwareTableModel.setScenario(InstallScenario.solve((BDaemonPlatform)softwareTableModel.getScenario().getTargetPlatform(), null, (String[])softwareTableModel.getScenario().getModulesToUninstall(), null, (BInstallable[])bInstallableArray2, (InstallableRegistry)softwareTableModel.getInstallableRegistry()));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        finally {
            if (bWbShell != null) {
                bWbShell.exitBusy();
            }
        }
    }

    public void doInvokeAsync() {
        try {
            CancelInstallCommand.cancelInstall(this.getOwner(), this.tableModel, this.tableModel.getTable().getSelection().getRows());
        }
        catch (Throwable throwable) {
            CommandUtil.error((Command)this, (Throwable)throwable);
        }
    }

    private static void cascadeDepCancels(DependencyMap dependencyMap, BPart bPart, BDaemonPlatform bDaemonPlatform, Set set, Set set2, Map map) {
        if (bPart == null) {
            return;
        }
        Map map2 = dependencyMap.getDependenciesOn(bPart);
        if (map2 == null) {
            return;
        }
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            BDependency bDependency;
            PartSpec partSpec = (PartSpec)iterator.next();
            if (set.contains(partSpec) || bDaemonPlatform.meets(bDependency = (BDependency)map2.get(partSpec))) continue;
            set.add(partSpec);
            set2.add(partSpec);
            BPart bPart2 = ((BInstallable)map.get(partSpec)).getPart();
            CancelInstallCommand.cascadeDepCancels(dependencyMap, bPart2, bDaemonPlatform, set, set2, map);
        }
    }

    private static BWidget makeAlsoCancelDetailsPane(Set set, Map map) {
        BIndentPane bIndentPane = new BIndentPane();
        bIndentPane.add(LexiconText.make((String)"provisioningNiagara", (String)"CancelInstallCommand.alsoCancel.heading"));
        bIndentPane.indent();
        BScrollPane bScrollPane = set.iterator();
        while (bScrollPane.hasNext()) {
            bIndentPane.add(((BInstallable)map.get(bScrollPane.next())).getInstallableFileName());
        }
        bIndentPane.unindent();
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bIndentPane, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
        bConstrainedPane.setFixedSize(275.0, 160.0);
        return new BEdgePane(null, null, null, null, (BWidget)bConstrainedPane);
    }
}

