/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.install.BPartInstallStatus;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableRow;
import com.tridium.ui.BOptionDialog;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Array;
import javax.baja.util.IFilter;
import javax.baja.util.PatternFilter;
import javax.baja.util.TextUtil;

public class BStationSoftwareFilter
extends BComponent
implements IFilter {
    public static final Property isStatusEnabled = BStationSoftwareFilter.newProperty((int)0, (boolean)false, null);
    public static final Property statusString = BStationSoftwareFilter.newProperty((int)0, (String)"", null);
    public static final Property isNameEnabled = BStationSoftwareFilter.newProperty((int)0, (boolean)false, null);
    public static final Property partNamePattern = BStationSoftwareFilter.newProperty((int)0, (String)"", null);
    public static final Property partNameExclude = BStationSoftwareFilter.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$ui$software$BStationSoftwareFilter == null ? (class$com$tridium$provisioningNiagara$ui$software$BStationSoftwareFilter = BStationSoftwareFilter.class$("com.tridium.provisioningNiagara.ui.software.BStationSoftwareFilter")) : class$com$tridium$provisioningNiagara$ui$software$BStationSoftwareFilter));
    private int[] statusValues = new int[0];
    private boolean formatting = false;
    private static Map statusTextMap = null;
    private PatternFilter[] nameFilters = null;
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$ui$software$BStationSoftwareFilter;

    public boolean getIsStatusEnabled() {
        return this.getBoolean(isStatusEnabled);
    }

    public void setIsStatusEnabled(boolean bl) {
        this.setBoolean(isStatusEnabled, bl, null);
    }

    public String getStatusString() {
        return this.getString(statusString);
    }

    public void setStatusString(String string) {
        this.setString(statusString, string, null);
    }

    public boolean getIsNameEnabled() {
        return this.getBoolean(isNameEnabled);
    }

    public void setIsNameEnabled(boolean bl) {
        this.setBoolean(isNameEnabled, bl, null);
    }

    public String getPartNamePattern() {
        return this.getString(partNamePattern);
    }

    public void setPartNamePattern(String string) {
        this.setString(partNamePattern, string, null);
    }

    public boolean getPartNameExclude() {
        return this.getBoolean(partNameExclude);
    }

    public void setPartNameExclude(boolean bl) {
        this.setBoolean(partNameExclude, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BStationSoftwareFilter() {
        this.formatStatusString();
    }

    public final boolean accept(Object object) {
        SoftwareTableRow softwareTableRow = (SoftwareTableRow)object;
        if (softwareTableRow.getInstallStatus() != BPartInstallStatus.noChange || softwareTableRow.getStatus() == 3 || softwareTableRow.getStatus() == 12 || softwareTableRow.getStatus() == 4) {
            return true;
        }
        return this.acceptStatus(softwareTableRow) && this.acceptName(softwareTableRow);
    }

    public boolean getIsEnabled() {
        return this.getIsStatusEnabled() || this.getIsNameEnabled();
    }

    protected synchronized boolean acceptStatus(SoftwareTableRow softwareTableRow) {
        if (!this.getIsStatusEnabled()) {
            return true;
        }
        for (int i = 0; i < this.statusValues.length; ++i) {
            if (softwareTableRow.getStatus() != this.statusValues[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean acceptName(SoftwareTableRow softwareTableRow) {
        if (!this.getIsNameEnabled()) {
            return true;
        }
        String string = softwareTableRow.getPartName() == null ? "" : softwareTableRow.getPartName();
        PatternFilter[] patternFilterArray = this.getNameFilters();
        boolean bl = false;
        for (int i = 0; i < patternFilterArray.length; ++i) {
            if (!patternFilterArray[i].accept(TextUtil.toLowerCase((String)string))) continue;
            bl = true;
            break;
        }
        return this.getPartNameExclude() ? !bl : bl;
    }

    public static BStationSoftwareFilter getFilter(BWidget bWidget, BStationSoftwareFilter bStationSoftwareFilter) {
        Prompt prompt = new Prompt(bWidget, bStationSoftwareFilter);
        BOptionDialog bOptionDialog = new BOptionDialog(bWidget, TYPE.getModule().getLexicon().getText("StationSoftwareFilter.dlgTitle"), (BWidget)prompt.getPane(), 3, null, null);
        bOptionDialog.getOkButton().setText(TYPE.getModule().getLexicon().getText("StationSoftwareFilter.applyButton"));
        bOptionDialog.setBoundsCenteredOnOwner();
        bOptionDialog.open();
        if (bOptionDialog.getResult() == 1) {
            return prompt.getFilter();
        }
        return null;
    }

    public PatternFilter[] getNameFilters() {
        if (this.nameFilters == null) {
            this.nameFilters = PatternFilter.parseList((String)TextUtil.toLowerCase((String)this.getPartNamePattern()));
        }
        return this.nameFilters;
    }

    public synchronized void includeStatus(int n) {
        this.includeStatus(new int[]{n});
    }

    public synchronized void includeStatus(int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            if (nArray[i] == 3 || nArray[i] == 12 || nArray[i] == 4 || (n = this.indexOfStatus(nArray[i])) >= 0) continue;
            int[] nArray2 = new int[this.statusValues.length + 1];
            nArray2[0] = nArray[i];
            System.arraycopy(this.statusValues, 0, nArray2, 1, this.statusValues.length);
            this.statusValues = nArray2;
            bl = true;
        }
        if (bl) {
            this.formatStatusString();
        }
    }

    public synchronized void excludeStatus(int n) {
        this.excludeStatus(new int[]{n});
    }

    public synchronized void excludeStatus(int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            if (nArray[i] == 3 || nArray[i] == 12 || nArray[i] == 4 || (n = this.indexOfStatus(nArray[i])) < 0) continue;
            int[] nArray2 = new int[this.statusValues.length - 1];
            if (n > 0) {
                System.arraycopy(this.statusValues, 0, nArray2, 0, n);
            }
            if (n < this.statusValues.length - 1) {
                System.arraycopy(this.statusValues, n + 1, nArray2, n, this.statusValues.length - n - 1);
            }
            this.statusValues = nArray2;
            bl = true;
        }
        if (bl) {
            this.formatStatusString();
        }
    }

    private synchronized int indexOfStatus(int n) {
        for (int i = 0; i < this.statusValues.length; ++i) {
            if (this.statusValues[i] != n) continue;
            return i;
        }
        return -1;
    }

    public String[] getStatusStrings() {
        return TextUtil.split((String)this.getStatusString(), (char)'|');
    }

    public static String[] getAvailableStrings() {
        return new String[]{BStationSoftwareFilter.statusToString(6), BStationSoftwareFilter.statusToString(13), BStationSoftwareFilter.statusToString(2), BStationSoftwareFilter.statusToString(7), BStationSoftwareFilter.statusToString(8), BStationSoftwareFilter.statusToString(11)};
    }

    public static String statusToString(int n) {
        switch (n) {
            case 6: {
                return TYPE.getModule().getLexicon().getText("StationSoftwareView.status.notInstalled");
            }
            case 13: {
                return TYPE.getModule().getLexicon().getText("StationSoftwareView.status.needCommissioningMissing");
            }
            case 1: 
            case 2: 
            case 5: {
                return TYPE.getModule().getLexicon().getText("StationSoftwareView.status.upToDate");
            }
            case 7: {
                return TYPE.getModule().getLexicon().getText("StationSoftwareView.status.badInstallable");
            }
            case 8: 
            case 9: {
                return TYPE.getModule().getLexicon().getText("StationSoftwareView.status.badTarget");
            }
            case 11: {
                return TYPE.getModule().getLexicon().getText("StationSoftwareView.status.noLocal");
            }
        }
        return "";
    }

    public static int[] stringToStatus(String string) {
        Array array = (Array)BStationSoftwareFilter.getStatusTextMap().get(string);
        if (array == null) {
            return new int[0];
        }
        int[] nArray = new int[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            nArray[i] = (Integer)array.get(i);
        }
        return nArray;
    }

    private static Map getStatusTextMap() {
        if (statusTextMap == null) {
            statusTextMap = new HashMap();
            BStationSoftwareFilter.updateStatusMapEntry(0, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(1, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(2, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(5, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(6, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(13, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(7, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(8, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(9, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(11, statusTextMap);
        }
        return statusTextMap;
    }

    private static void updateStatusMapEntry(int n, Map map) {
        String string = BStationSoftwareFilter.statusToString(n);
        Array array = (Array)map.get(string);
        if (array == null) {
            array = new Array();
            map.put(string, array);
        }
        array.add((Object)new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseStatusString() {
        if (this.formatting) {
            return;
        }
        Property property = statusString;
        synchronized (property) {
            String[] stringArray = this.getStatusStrings();
            int[] nArray = new int[50];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                int[] nArray2 = BStationSoftwareFilter.stringToStatus(stringArray[i]);
                for (int j = 0; j < nArray2.length; ++j) {
                    nArray[n++] = nArray2[j];
                }
            }
            int[] nArray3 = new int[n];
            System.arraycopy(nArray, 0, nArray3, 0, n);
            this.statusValues = nArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatStatusString() {
        Property property = statusString;
        synchronized (property) {
            this.formatting = true;
            StringBuffer stringBuffer = new StringBuffer();
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < this.statusValues.length; ++i) {
                hashSet.add(BStationSoftwareFilter.statusToString(this.statusValues[i]));
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append(iterator.next());
            }
            this.setStatusString(stringBuffer.toString());
            this.formatting = false;
        }
    }

    public void changed(Property property, Context context) {
        if (property == statusString) {
            this.parseStatusString();
        }
        if (property == partNamePattern) {
            this.nameFilters = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class EnableCommand
    extends ToggleCommand {
        private BWidget[] widgets;

        public EnableCommand(BWidget bWidget, BWidget[] bWidgetArray, boolean bl, String string) {
            super(bWidget, TYPE.getModule(), string);
            this.widgets = bWidgetArray;
            this.setSelected(bl);
            this.invoke();
        }

        public CommandArtifact doInvoke() {
            for (int i = 0; i < this.widgets.length; ++i) {
                this.widgets[i].setEnabled(this.isSelected());
            }
            return null;
        }
    }

    private static class CheckAllCommand
    extends Command {
        private BCheckList statusCheckList;

        public CheckAllCommand(BWidget bWidget, BCheckList bCheckList) {
            super(bWidget, TYPE.getModule(), "StationSoftwareFilter.CheckAllCommand");
            this.statusCheckList = bCheckList;
        }

        public CommandArtifact doInvoke() {
            for (int i = 0; i < this.statusCheckList.getItemCount(); ++i) {
                this.statusCheckList.getSelection().select(i);
            }
            return null;
        }
    }

    private static class ClearCommand
    extends Command {
        private BCheckList statusCheckList;

        public ClearCommand(BWidget bWidget, BCheckList bCheckList) {
            super(bWidget, TYPE.getModule(), "StationSoftwareFilter.ClearCommand");
            this.statusCheckList = bCheckList;
        }

        public CommandArtifact doInvoke() {
            this.statusCheckList.getSelection().deselectAll();
            return null;
        }
    }

    private static class ExcludeCommand
    extends ToggleCommand {
        public ExcludeCommand(BWidget bWidget) {
            super(bWidget, TYPE.getModule(), "StationSoftwareFilter.ExcludeCommand");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    private static class IncludeCommand
    extends ToggleCommand {
        public IncludeCommand(BWidget bWidget) {
            super(bWidget, TYPE.getModule(), "StationSoftwareFilter.IncludeCommand");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    private static class StatusListModel
    extends ListModel {
        private String[] strings = BStationSoftwareFilter.getAvailableStrings();

        public int getItemCount() {
            return this.strings.length;
        }

        public Object getItem(int n) {
            return this.strings[n];
        }
    }

    private static class Prompt {
        private BCheckList statusCheckList;
        private BTextField installableNameTextField;
        private BRadioButton includeButton;
        private BGridPane pane = new BGridPane(1);

        private Prompt(BWidget bWidget, BStationSoftwareFilter bStationSoftwareFilter) {
            int n;
            BGridPane bGridPane = new BGridPane(3);
            bGridPane.setRowGap(6.0);
            bGridPane.setColumnAlign(BHalign.fill);
            if (bStationSoftwareFilter == null) {
                bStationSoftwareFilter = new BStationSoftwareFilter();
            }
            this.statusCheckList = new BCheckList();
            this.statusCheckList.setModel((ListModel)new StatusListModel());
            ListSelection listSelection = this.statusCheckList.getSelection();
            String[] stringArray = bStationSoftwareFilter.getStatusStrings();
            HashSet<String> hashSet = new HashSet<String>();
            for (n = 0; n < stringArray.length; ++n) {
                hashSet.add(stringArray[n]);
            }
            for (n = 0; n < this.statusCheckList.getItemCount(); ++n) {
                if (!hashSet.contains(this.statusCheckList.getItem(n))) continue;
                listSelection.select(n);
            }
            BButton bButton = new BButton((Command)new CheckAllCommand(bWidget, this.statusCheckList));
            BButton bButton2 = new BButton((Command)new ClearCommand(bWidget, this.statusCheckList));
            bGridPane.add(null, (BValue)new BCheckBox((ToggleCommand)new EnableCommand(bWidget, new BWidget[]{this.statusCheckList, bButton, bButton2}, bStationSoftwareFilter.getIsStatusEnabled(), "InstallerTableFilterPrompt.enableStatus")));
            bGridPane.add(null, (BValue)this.statusCheckList);
            BGridPane bGridPane2 = new BGridPane(1);
            bGridPane2.setColumnAlign(BHalign.fill);
            bGridPane2.setHalign(BHalign.left);
            bGridPane2.add(null, (BValue)bButton);
            bGridPane2.add(null, (BValue)bButton2);
            bGridPane.add(null, (BValue)bGridPane2);
            this.installableNameTextField = new BTextField(bStationSoftwareFilter.getPartNamePattern());
            ToggleCommandGroup toggleCommandGroup = new ToggleCommandGroup();
            bGridPane2 = new BGridPane(1);
            ToggleCommand toggleCommand = new IncludeCommand(bWidget);
            this.includeButton = new BRadioButton(toggleCommand);
            bGridPane2.add(null, (BValue)this.includeButton);
            toggleCommandGroup.add(toggleCommand);
            toggleCommand.setSelected(!bStationSoftwareFilter.getPartNameExclude());
            toggleCommand = new ExcludeCommand(bWidget);
            BRadioButton bRadioButton = new BRadioButton(toggleCommand);
            bGridPane2.add(null, (BValue)bRadioButton);
            toggleCommandGroup.add(toggleCommand);
            toggleCommand.setSelected(bStationSoftwareFilter.getPartNameExclude());
            bGridPane.add(null, (BValue)new BCheckBox((ToggleCommand)new EnableCommand(bWidget, new BWidget[]{this.installableNameTextField, this.includeButton, bRadioButton}, bStationSoftwareFilter.getIsNameEnabled(), "InstallerTableFilterPrompt.enableName")));
            bGridPane.add(null, (BValue)this.installableNameTextField);
            bGridPane.add(null, (BValue)bGridPane2);
            this.pane.add(null, (BValue)bGridPane);
        }

        public BGridPane getPane() {
            return this.pane;
        }

        protected BStationSoftwareFilter getFilter() {
            BStationSoftwareFilter bStationSoftwareFilter = new BStationSoftwareFilter();
            bStationSoftwareFilter.setIsStatusEnabled(this.statusCheckList.isEnabled());
            for (int i = 0; i < this.statusCheckList.getItemCount(); ++i) {
                if (!this.statusCheckList.getSelection().isSelected(i)) continue;
                bStationSoftwareFilter.includeStatus(BStationSoftwareFilter.stringToStatus(this.statusCheckList.getItem(i).toString()));
            }
            bStationSoftwareFilter.setIsNameEnabled(this.installableNameTextField.isEnabled());
            bStationSoftwareFilter.setPartNamePattern(this.installableNameTextField.getText());
            bStationSoftwareFilter.setPartNameExclude(!this.includeButton.isSelected());
            return bStationSoftwareFilter;
        }
    }
}

