/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.ClosableCursor;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.software.BInstallableSummary;
import com.tridium.provisioningNiagara.software.BSoftwareContainer;
import com.tridium.provisioningNiagara.software.ProvisioningRegistry;
import com.tridium.provisioningNiagara.ui.software.BSupervisorSoftwareManager;
import com.tridium.ui.theme.Theme;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.space.Mark;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public class BSoftwareContainerTree
extends BTree {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$ui$software$BSoftwareContainerTree == null ? (class$com$tridium$provisioningNiagara$ui$software$BSoftwareContainerTree = BSoftwareContainerTree.class$("com.tridium.provisioningNiagara.ui.software.BSoftwareContainerTree")) : class$com$tridium$provisioningNiagara$ui$software$BSoftwareContainerTree));
    private BSupervisorSoftwareManager manager;
    private BButtonPane buttons;
    private CheckStationsCommand checkCommand;
    private static Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$ui$software$BSoftwareContainerTree;
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$software$BInstallableSummary;
    static /* synthetic */ Class class$com$tridium$install$installable$BInstallableSpec;
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$ui$software$BSoftwareContainerTree$VersionNode;
    static /* synthetic */ Class class$com$tridium$install$installable$BInstallable;

    public Type getType() {
        return TYPE;
    }

    public BSoftwareContainerTree() {
        throw new UnsupportedOperationException();
    }

    public BSoftwareContainerTree(BSupervisorSoftwareManager bSupervisorSoftwareManager) {
        this.manager = bSupervisorSoftwareManager;
        this.setModel(new Model());
        this.setSelection(new Selection());
        Command[] commandArray = new Command[3];
        commandArray[0] = new SyncCommand((BWidget)bSupervisorSoftwareManager);
        commandArray[1] = new RegisterCommand((BWidget)bSupervisorSoftwareManager);
        this.checkCommand = new CheckStationsCommand((BWidget)bSupervisorSoftwareManager);
        commandArray[2] = this.checkCommand;
        this.buttons = new BButtonPane(commandArray);
    }

    BButtonPane getButtons() {
        return this.buttons;
    }

    void load(BSoftwareContainer bSoftwareContainer) throws Exception {
        ((Model)this.getModel()).load(bSoftwareContainer);
    }

    BSoftwareContainer getSoftwareContainer() {
        return this.manager.getSoftwareContainer();
    }

    public int dragOver(TransferContext transferContext) {
        Mark mark;
        BObject[] bObjectArray;
        if (this.getSoftwareContainer() == null) {
            return 0;
        }
        if (transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.mark) && (bObjectArray = (mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark)).getValues()).length > 0) {
            for (int i = 0; i < bObjectArray.length; ++i) {
                BInstallable bInstallable = null;
                if (bObjectArray[i] instanceof BInstallable) {
                    bInstallable = (BInstallable)bObjectArray[i];
                } else if (bObjectArray[i] instanceof BIFile) {
                    bInstallable = BInstallable.make((BIFile)((BIFile)bObjectArray[i]));
                }
                if (bInstallable == null || bInstallable.getVersion().getVendorVersion().equals((Object)Version.ZERO)) continue;
                return 16;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        Mark mark;
        BObject[] bObjectArray;
        if (this.getSoftwareContainer() == null) {
            return null;
        }
        ProvisioningRegistry provisioningRegistry = null;
        if (transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.mark) && (bObjectArray = (mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark)).getValues()).length > 0) {
            for (int i = 0; i < bObjectArray.length; ++i) {
                BInstallableSpec bInstallableSpec;
                BInstallable bInstallable;
                BInstallable bInstallable2 = null;
                if (bObjectArray[i] instanceof BInstallable) {
                    bInstallable2 = (BInstallable)bObjectArray[i];
                } else if (bObjectArray[i] instanceof BIFile) {
                    bInstallable2 = BInstallable.make((BIFile)((BIFile)bObjectArray[i]));
                }
                if (bInstallable2 == null) continue;
                if (bInstallable2.getVersion().isNull()) {
                    BDialog.warning((BWidget)this, (String)lex.getText("SoftwareContainerTree.wrongType.dlgTitle"), (Object)lex.getText("SoftwareContainerTree.wrongType.dlgMessage", new Object[]{bInstallable2}));
                    continue;
                }
                if (provisioningRegistry == null) {
                    provisioningRegistry = this.getSoftwareContainer().getNetworkExt().getInstallableRegistry();
                }
                if ((bInstallable = provisioningRegistry.findInstallable((bInstallableSpec = BInstallableSpec.make((BInstallable)bInstallable2)).asDependency(), this.manager.getTaskListener())) == null) {
                    DaemonSessionTask daemonSessionTask = new DaemonSessionTask(lex, "SoftwareContainerTree.registering.title", "SoftwareContainerTree.registering.message", new Object[]{bInstallableSpec});
                    try {
                        this.manager.getTaskListener().taskStarted(daemonSessionTask);
                        provisioningRegistry.register(bInstallable2, null);
                        continue;
                    }
                    finally {
                        this.manager.getTaskListener().taskFinished(daemonSessionTask);
                    }
                }
                BDialog.warning((BWidget)this, (String)lex.getText("SoftwareContainerTree.alreadyRegistered.dlgTitle"), (Object)lex.getText("SoftwareContainerTree.alreadyRegistered.dlgMessage", new Object[]{bInstallableSpec}));
            }
        }
        return null;
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getId() == 1) {
            if (bComponentEvent.getValue() instanceof BInstallableSpec) {
                VersionNode versionNode = ((Model)this.getModel()).addVersionNode((BInstallableSpec)bComponentEvent.getValue());
                versionNode.getParent().setExpanded(true);
            } else if (bComponentEvent.getValue() instanceof BInstallableSummary) {
                SummaryNode summaryNode = ((Model)this.getModel()).addSummaryNode((BInstallableSummary)bComponentEvent.getValue());
                summaryNode.setExpanded(true);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CheckStationsCommand
    extends AsyncCommand {
        public CheckStationsCommand(BWidget bWidget) {
            super(bWidget, BSoftwareContainerTree.this.getLexicon(), "SoftwareContainerTree.checkStationsCommand");
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            try {
                TreeNode treeNode = BSoftwareContainerTree.this.getSelection().getNodes()[0];
                if (treeNode instanceof VersionNode) {
                    ((VersionNode)treeNode).checkStations(this.getOwner());
                } else {
                    ((SummaryNode)treeNode).getLatestVersionNode().checkStations(this.getOwner());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
        }
    }

    private class RegisterCommand
    extends AsyncCommand {
        public RegisterCommand(BWidget bWidget) {
            super(bWidget, BSoftwareContainerTree.this.getLexicon(), "SoftwareContainerTree.registerCommand");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            block7: {
                try {
                    BInstallableSpec bInstallableSpec;
                    BOrd bOrd = BFileChooser.showOpen((BWidget)this.getOwner());
                    if (bOrd == null) break block7;
                    BInstallable bInstallable = BInstallable.make((BIFile)((BIFile)bOrd.get()));
                    if (bInstallable == null || bInstallable.getVersion().isNull()) {
                        BDialog.warning((BWidget)this.getOwner(), (String)lex.getText("SoftwareContainerTree.wrongType.dlgTitle"), (Object)lex.getText("SoftwareContainerTree.wrongType.dlgMessage", new Object[]{bOrd}));
                        break block7;
                    }
                    ProvisioningRegistry provisioningRegistry = BSoftwareContainerTree.this.getSoftwareContainer().getNetworkExt().getInstallableRegistry();
                    BInstallable bInstallable2 = provisioningRegistry.findInstallable((bInstallableSpec = BInstallableSpec.make((BInstallable)bInstallable)).asDependency(), BSoftwareContainerTree.this.manager.getTaskListener());
                    if (bInstallable2 == null) {
                        DaemonSessionTask daemonSessionTask = new DaemonSessionTask(lex, "SoftwareContainerTree.registering.title", "SoftwareContainerTree.registering.message", new Object[]{bInstallableSpec});
                        try {
                            BSoftwareContainerTree.this.manager.getTaskListener().taskStarted(daemonSessionTask);
                            provisioningRegistry.register(bInstallable, null);
                            break block7;
                        }
                        finally {
                            BSoftwareContainerTree.this.manager.getTaskListener().taskFinished(daemonSessionTask);
                        }
                    }
                    BDialog.warning((BWidget)this.getOwner(), (String)lex.getText("SoftwareContainerTree.alreadyRegistered.dlgTitle"), (Object)lex.getText("SoftwareContainerTree.alreadyRegistered.dlgMessage", new Object[]{bInstallableSpec}));
                }
                catch (Exception exception) {
                    CommandUtil.error((Command)this, (Throwable)exception);
                }
            }
        }
    }

    private class SyncCommand
    extends AsyncCommand {
        public SyncCommand(BWidget bWidget) {
            super(bWidget, BSoftwareContainerTree.this.getLexicon(), "SoftwareContainerTree.syncCommand");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            block20: {
                Model model = (Model)BSoftwareContainerTree.this.getModel();
                try {
                    BInstallableSpec bInstallableSpec;
                    Object object;
                    ClosableCursor closableCursor;
                    HashMap<BInstallableSpec, Object> hashMap = new HashMap<BInstallableSpec, Object>();
                    CancelableDaemonSessionTask cancelableDaemonSessionTask = new CancelableDaemonSessionTask(lex, "SoftwareContainerTree.checking.title", "");
                    cancelableDaemonSessionTask.setImmediate(true);
                    BSoftwareContainerTree.this.manager.getTaskListener().taskStarted((DaemonSessionTask)cancelableDaemonSessionTask);
                    try {
                        closableCursor = LocalInstallableRegistry.getInstance().getInstallables(false, BSoftwareContainerTree.this.manager.getTaskListener());
                        try {
                            while (closableCursor.next(class$com$tridium$install$installable$BInstallable == null ? BSoftwareContainerTree.class$("com.tridium.install.installable.BInstallable") : class$com$tridium$install$installable$BInstallable)) {
                                if (cancelableDaemonSessionTask.isCanceled()) {
                                    break;
                                }
                                object = (BInstallable)closableCursor.get();
                                bInstallableSpec = BInstallableSpec.make((BInstallable)object);
                                cancelableDaemonSessionTask.setMessage(lex.getText("SoftwareContainerTree.checking.message", new Object[]{bInstallableSpec}));
                                BSoftwareContainerTree.this.manager.getTaskListener().taskUpdated((DaemonSessionTask)cancelableDaemonSessionTask);
                                if (model.getVersionNode(bInstallableSpec) != null) continue;
                                hashMap.put(bInstallableSpec, object);
                            }
                        }
                        finally {
                            closableCursor.close();
                        }
                    }
                    finally {
                        BSoftwareContainerTree.this.manager.getTaskListener().taskFinished((DaemonSessionTask)cancelableDaemonSessionTask);
                    }
                    if (cancelableDaemonSessionTask.isCanceled()) {
                        return;
                    }
                    if (hashMap.size() == 0) {
                        BDialog.message((BWidget)this.getOwner(), (String)lex.getText("SoftwareContainerTree.syncCommand.upToDate.dlgTitle"), (Object)lex.getText("SoftwareContainerTree.syncCommand.upToDate.dlgMessage"));
                        this.setEnabled(false);
                        break block20;
                    }
                    closableCursor = new BIndentPane();
                    closableCursor.add(lex.getText("SoftwareContainerTree.syncCommand.register.dlgHeader"));
                    closableCursor.indent();
                    object = hashMap.keySet().iterator();
                    while (object.hasNext()) {
                        closableCursor.add(object.next().toString());
                    }
                    closableCursor.unindent();
                    closableCursor.add(lex.getText("SoftwareContainerTree.syncCommand.register.dlgFooter"));
                    object = Theme.scrollPane().getControlBackground();
                    bInstallableSpec = new BScrollPane((BWidget)new BBorderPane((BWidget)closableCursor, 4.0, 4.0, 4.0, 4.0));
                    bInstallableSpec.setViewportBackground((BBrush)object);
                    bInstallableSpec.setBorderPolicy(BScrollBarPolicy.asNeeded);
                    BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bInstallableSpec);
                    bConstrainedPane.setMinSize(350.0, 250.0);
                    bConstrainedPane.setMaxSize(350.0, 500.0);
                    if (4 != BDialog.confirm((BWidget)this.getOwner(), (String)lex.getText("SoftwareContainerTree.syncCommand.register.dlgTitle"), (Object)bConstrainedPane)) {
                        return;
                    }
                    ProvisioningRegistry provisioningRegistry = BSoftwareContainerTree.this.getSoftwareContainer().getNetworkExt().getInstallableRegistry();
                    cancelableDaemonSessionTask = new CancelableDaemonSessionTask(lex, "SoftwareContainerTree.registering.title", "");
                    BSoftwareContainerTree.this.manager.getTaskListener().taskStarted((DaemonSessionTask)cancelableDaemonSessionTask);
                    try {
                        Iterator iterator = hashMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            if (cancelableDaemonSessionTask.isCanceled()) {
                                break;
                            }
                            BInstallableSpec bInstallableSpec2 = (BInstallableSpec)iterator.next();
                            BInstallable bInstallable = (BInstallable)hashMap.get(bInstallableSpec2);
                            cancelableDaemonSessionTask.setMessage(lex.getText("SoftwareContainerTree.registering.message", new Object[]{bInstallableSpec2}));
                            BSoftwareContainerTree.this.manager.getTaskListener().taskUpdated((DaemonSessionTask)cancelableDaemonSessionTask);
                            provisioningRegistry.register(bInstallable, null);
                        }
                    }
                    finally {
                        BSoftwareContainerTree.this.manager.getTaskListener().taskFinished((DaemonSessionTask)cancelableDaemonSessionTask);
                    }
                }
                catch (Exception exception) {
                    CommandUtil.error((Command)this, (Throwable)exception);
                }
            }
        }
    }

    private class Selection
    extends TreeSelection {
        public void updateTree() {
            super.updateTree();
            TreeNode[] treeNodeArray = this.getNodes();
            if (treeNodeArray.length == 0) {
                BSoftwareContainerTree.this.manager.showSpec(null);
                BSoftwareContainerTree.this.checkCommand.setEnabled(false);
            } else if (treeNodeArray.length > 1) {
                BSoftwareContainerTree.this.manager.showSpec(null);
                BSoftwareContainerTree.this.checkCommand.setEnabled(false);
            } else {
                BSoftwareContainerTree.this.checkCommand.setEnabled(true);
                if (treeNodeArray[0] instanceof VersionNode) {
                    ((VersionNode)treeNodeArray[0]).showDetails();
                } else {
                    BSoftwareContainerTree.this.manager.showSpec(null);
                }
            }
        }
    }

    private class VersionNode
    extends TreeNode
    implements Comparable {
        private BInstallableSpec spec;
        private BInstallable installable = null;

        public VersionNode(SummaryNode summaryNode, BInstallableSpec bInstallableSpec) {
            super((TreeNode)summaryNode);
            this.spec = bInstallableSpec;
        }

        public int compareTo(Object object) {
            return this.getInstallableSpec().getVersion().compareTo((Object)((VersionNode)object).getInstallableSpec().getVersion());
        }

        public String getText() {
            return this.spec.getVersion().toString();
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.spec.getInstallableType().getTypeInfo().getIcon(null));
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChild(int n) {
            throw new IllegalStateException();
        }

        public BInstallableSpec getInstallableSpec() {
            return this.spec;
        }

        public BInstallable getInstallable() throws Exception {
            if (this.installable == null) {
                BProvisioningNiagaraNetworkExt bProvisioningNiagaraNetworkExt = (BProvisioningNiagaraNetworkExt)BOrd.make((String)"service:provisioningNiagara:ProvisioningNiagaraNetworkExt").get((BObject)BSoftwareContainerTree.this.getSoftwareContainer());
                ProvisioningRegistry provisioningRegistry = bProvisioningNiagaraNetworkExt.getInstallableRegistry();
                this.installable = provisioningRegistry.findInstallable(this.spec.asDependency(), BSoftwareContainerTree.this.manager.getTaskListener());
            }
            return this.installable;
        }

        public void showDetails() {
            BSoftwareContainerTree.this.manager.showSpec(this.spec);
        }

        public void checkStations(BWidget bWidget) throws Exception {
            BSoftwareContainerTree.this.manager.checkStations(this.getInstallable());
        }
    }

    private class SummaryNode
    extends TreeNode
    implements Comparable {
        private String installableName;
        private BTypeSpec installableType;
        private Array kids = new Array(class$com$tridium$provisioningNiagara$ui$software$BSoftwareContainerTree$VersionNode == null ? (class$com$tridium$provisioningNiagara$ui$software$BSoftwareContainerTree$VersionNode = BSoftwareContainerTree.class$("com.tridium.provisioningNiagara.ui.software.BSoftwareContainerTree$VersionNode")) : class$com$tridium$provisioningNiagara$ui$software$BSoftwareContainerTree$VersionNode);
        private Map leafByVersion = new HashMap();

        public SummaryNode(Model model, BInstallableSummary bInstallableSummary) {
            this(model, bInstallableSummary.getInstallableName(), bInstallableSummary.getInstallableType());
        }

        private SummaryNode(Model model, String string, BTypeSpec bTypeSpec) {
            super((TreeModel)model);
            this.installableName = string;
            this.installableType = bTypeSpec;
        }

        public void updateTree() {
            this.kids.sort();
            this.getModel().updateTree();
        }

        public int getChildCount() {
            return this.kids.size();
        }

        public TreeNode getChild(int n) {
            return (TreeNode)this.kids.get(n);
        }

        public String getText() {
            return this.installableName;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.installableType.getTypeInfo().getIcon(null));
        }

        public int compareTo(Object object) {
            return this.getInstallableName().compareTo(((SummaryNode)object).getInstallableName());
        }

        public void load(BInstallableSummary bInstallableSummary) {
            SlotCursor slotCursor = bInstallableSummary.getProperties();
            while (slotCursor.next(class$com$tridium$install$installable$BInstallableSpec == null ? BSoftwareContainerTree.class$("com.tridium.install.installable.BInstallableSpec") : class$com$tridium$install$installable$BInstallableSpec)) {
                this.addVersionNode((BInstallableSpec)slotCursor.get());
            }
        }

        public synchronized VersionNode addVersionNode(BInstallableSpec bInstallableSpec) {
            VersionNode versionNode = this.getVersionNode(bInstallableSpec.getVersion().getVendorVersionString());
            if (versionNode == null) {
                versionNode = new VersionNode(this, bInstallableSpec);
                this.leafByVersion.put(bInstallableSpec.getVersion().getVendorVersionString(), versionNode);
                this.kids.add((Object)versionNode);
                this.updateTree();
            }
            return versionNode;
        }

        public VersionNode getVersionNode(String string) {
            return (VersionNode)this.leafByVersion.get(string);
        }

        public VersionNode getLatestVersionNode() {
            VersionNode versionNode = null;
            Version version = null;
            Iterator iterator = this.leafByVersion.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Version version2 = new Version(string);
                if (versionNode != null && version2.compareTo((Object)version) <= 0) continue;
                version = version2;
                versionNode = (VersionNode)this.leafByVersion.get(string);
            }
            return versionNode;
        }

        public String getInstallableName() {
            return this.installableName;
        }
    }

    private class Model
    extends TreeModel {
        private Map summaryByName = new TreeMap();

        public int getRootCount() {
            return this.summaryByName.size();
        }

        public TreeNode getRoot(int n) {
            Object[] objectArray = this.summaryByName.values().toArray();
            return (TreeNode)objectArray[n];
        }

        public void load(BSoftwareContainer bSoftwareContainer) {
            SlotCursor slotCursor = bSoftwareContainer.getProperties();
            while (slotCursor.next(class$com$tridium$provisioningNiagara$software$BInstallableSummary == null ? BSoftwareContainerTree.class$("com.tridium.provisioningNiagara.software.BInstallableSummary") : class$com$tridium$provisioningNiagara$software$BInstallableSummary)) {
                this.addSummaryNode((BInstallableSummary)slotCursor.get());
            }
        }

        public synchronized VersionNode addVersionNode(BInstallableSpec bInstallableSpec) {
            SummaryNode summaryNode = this.getSummaryNode(bInstallableSpec.getInstallableName());
            if (summaryNode == null) {
                summaryNode = new SummaryNode(this, bInstallableSpec.getInstallableName(), bInstallableSpec.getInstallableType());
                this.summaryByName.put(bInstallableSpec.getInstallableName(), summaryNode);
            }
            return summaryNode.addVersionNode(bInstallableSpec);
        }

        public VersionNode getVersionNode(BInstallableSpec bInstallableSpec) {
            SummaryNode summaryNode = this.getSummaryNode(bInstallableSpec.getInstallableName());
            return summaryNode == null ? null : summaryNode.getVersionNode(bInstallableSpec.getVersion().getVendorVersionString());
        }

        public synchronized SummaryNode addSummaryNode(BInstallableSummary bInstallableSummary) {
            SummaryNode summaryNode = this.getSummaryNode(bInstallableSummary.getInstallableName());
            if (summaryNode == null) {
                summaryNode = new SummaryNode(this, bInstallableSummary);
                this.summaryByName.put(bInstallableSummary.getInstallableName(), summaryNode);
            }
            summaryNode.load(bInstallableSummary);
            return summaryNode;
        }

        public SummaryNode getSummaryNode(String string) {
            return (SummaryNode)this.summaryByName.get(string);
        }
    }
}

