/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.program;

import com.tridium.program.BCode;
import com.tridium.program.BProgram;
import com.tridium.program.ui.Compiler;
import com.tridium.provisioningNiagara.program.BProvisioningRobot;
import com.tridium.provisioningNiagara.ui.program.BProvisioningRobotEditor;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BBlob;
import javax.baja.sys.Sys;
import javax.baja.ui.BWidget;
import javax.baja.util.Array;
import javax.baja.util.TextUtil;

public class ProvisioningCompiler
implements BConsole.ExecCallback {
    protected BProvisioningRobotEditor editor;
    protected String className = null;
    protected boolean submitOnSuccess = false;
    protected File temp = null;
    protected File java = null;
    protected File classFile = null;
    protected File[] innerClassFiles;
    protected int checksum = 0;
    static /* synthetic */ Class class$java$io$File;

    public ProvisioningCompiler(BProvisioningRobotEditor bProvisioningRobotEditor) {
        this.editor = bProvisioningRobotEditor;
    }

    public void load(BProvisioningRobot bProvisioningRobot) {
        this.className = bProvisioningRobot.getRobotCode().getClassName();
        this.checksum = bProvisioningRobot.getChecksum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(boolean bl) throws Exception {
        this.submitOnSuccess = bl;
        String string = this.editor.getSource();
        this.className = BCode.generateClassName();
        int n = string.indexOf("RobotImpl");
        if (n < 0) {
            throw new Exception("Class name must be RobotImpl");
        }
        string = TextUtil.replace((String)string, (String)"RobotImpl", (String)this.className);
        this.temp = new File(Sys.getBajaHome(), "temp");
        this.java = new File(this.temp, this.className + ".java");
        this.classFile = new File(this.temp, this.className + ".class");
        this.innerClassFiles = null;
        if (!this.temp.exists()) {
            this.temp.mkdirs();
        }
        FileWriter fileWriter = new FileWriter(this.java);
        try {
            this.writeSource(fileWriter, string);
        }
        finally {
            fileWriter.close();
        }
        String string2 = File.separator;
        String string3 = File.pathSeparator;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Sys.getBajaHome() + string2 + "lib" + string2 + "editions" + string2 + "j2me" + string2 + "classes.zip");
        File file = new File(Sys.getBajaHome(), "bin");
        String[] stringArray = file.list((FilenameFilter)new Compiler.JarFilenameFilter());
        String string4 = string3 + Sys.getBajaHome() + string2 + "bin" + string2;
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string4).append(stringArray[i]).append(string3);
        }
        stringBuffer.append(string3 + Sys.getBajaHome() + string2 + "modules" + string2 + "baja.jar");
        String[] stringArray2 = this.parseDependencies();
        String string5 = string3 + Sys.getBajaHome() + string2 + "modules" + string2;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].equals("baja")) continue;
            stringBuffer.append(string5).append(stringArray2[i]).append(".jar");
        }
        String string6 = null;
        String string7 = null;
        try {
            string7 = Compiler.getDevkitTargetEdition((BWidget)this.editor, null);
            string6 = Compiler.getCompileJavaCommand((String)string7, (String)stringBuffer.toString(), (String)this.temp.toString(), (String)this.java.toString());
        }
        catch (Exception exception) {
            System.out.println("Problem loading '" + string7 + "' command from devkit.properties.");
            exception.printStackTrace();
            string6 = "jikes +E -classpath " + stringBuffer + " " + this.java;
        }
        this.openConsole().exec(string6, (BConsole.ExecCallback)this);
    }

    public String[] parseDependencies() throws Exception {
        HashSet hashSet = new HashSet();
        StringTokenizer stringTokenizer = new StringTokenizer(this.editor.getDependencies(), ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            if (string.length() <= 0 || BProgram.isSpecialModule((String)string)) continue;
            this.accumDependencies(hashSet, string);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    protected void accumDependencies(Set set, String string) throws Exception {
        if (set.contains(string)) {
            return;
        }
        ModuleInfo moduleInfo = Sys.getRegistry().getModule(string);
        set.add(moduleInfo.getModuleName());
        DependencyInfo[] dependencyInfoArray = moduleInfo.getDependencies();
        for (int i = 0; i < dependencyInfoArray.length; ++i) {
            this.accumDependencies(set, dependencyInfoArray[i].getModuleName());
        }
    }

    public void writeSource(FileWriter fileWriter, String string) throws Exception {
        fileWriter.write(string);
    }

    public BConsole openConsole() {
        return ((BNiagaraWbShell)this.editor.getShell()).openConsole();
    }

    public void consoleExecDone(BConsole bConsole, int n) {
        try {
            if (n == 0) {
                this.compileSuccess(bConsole);
            } else {
                this.compileFailed(bConsole);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.cleanup();
    }

    public void compileSuccess(BConsole bConsole) throws Exception {
        this.editor.setModified();
        this.checksum = this.editor.computeChecksum();
        this.editor.notifyCodeTextUpToDate();
        this.editor.updateStatus();
        this.editor.saveValue();
        if (this.submitOnSuccess) {
            this.editor.submitJob();
        }
    }

    public void compileFailed(BConsole bConsole) throws Exception {
        bConsole.next();
        this.innerClassFiles = null;
        this.className = null;
        this.checksum = 0;
        this.editor.setModified();
        this.editor.updateStatusToError();
    }

    public void cleanup() {
        this.classFile.delete();
        if (this.innerClassFiles != null) {
            for (int i = 0; i < this.innerClassFiles.length; ++i) {
                this.innerClassFiles[i].delete();
            }
        }
        this.java.delete();
    }

    public String getClassName() {
        return this.className;
    }

    public void saveRobot(BProvisioningRobot bProvisioningRobot, String string, String string2) throws Exception {
        bProvisioningRobot.lease(Integer.MAX_VALUE);
        bProvisioningRobot.setSource(string);
        if (this.getClassName() == null) {
            bProvisioningRobot.getRobotCode().setClassName("");
            bProvisioningRobot.getRobotCode().setClassFile(BBlob.DEFAULT);
            bProvisioningRobot.getRobotCode().clearInnerClassFiles();
            bProvisioningRobot.getRobotCode().setDependencies("");
            bProvisioningRobot.setChecksum(0);
        } else if (this.classFile != null) {
            bProvisioningRobot.getRobotCode().setClassName(this.getClassName());
            bProvisioningRobot.getRobotCode().clearInnerClassFiles();
            byte[] byArray = new byte[(int)this.classFile.length()];
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.classFile)));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            bProvisioningRobot.getRobotCode().setClassFile(BBlob.make((byte[])byArray));
            File[] fileArray = this.classFile.getParentFile().listFiles();
            Array array = new Array(class$java$io$File == null ? (class$java$io$File = ProvisioningCompiler.class$("java.io.File")) : class$java$io$File);
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getName().startsWith(this.className + '$')) continue;
                array.add((Object)fileArray[i]);
                String string3 = fileArray[i].getName();
                string3 = string3.substring(0, string3.length() - 6);
                byArray = new byte[(int)fileArray[i].length()];
                dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(fileArray[i])));
                dataInputStream.readFully(byArray);
                dataInputStream.close();
                bProvisioningRobot.getRobotCode().addInnerClassFile(string3, BBlob.make((byte[])byArray));
            }
            this.innerClassFiles = (File[])array.trim();
            bProvisioningRobot.getRobotCode().setDependencies(string2);
            bProvisioningRobot.setChecksum(this.checksum);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

