/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.license;

import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.SortableTableUtil;
import com.tridium.provisioningNiagara.license.BLicenseStationExt;
import com.tridium.provisioningNiagara.license.BLicenseStatus;
import com.tridium.provisioningNiagara.license.BSupervisorLicenses;
import com.tridium.ui.theme.Theme;
import java.util.Comparator;
import javax.baja.batchJob.BValueList;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataTable;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BNetworkLicenseSummary
extends BWbComponentView
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$ui$license$BNetworkLicenseSummary == null ? (class$com$tridium$provisioningNiagara$ui$license$BNetworkLicenseSummary = BNetworkLicenseSummary.class$("com.tridium.provisioningNiagara.ui.license.BNetworkLicenseSummary")) : class$com$tridium$provisioningNiagara$ui$license$BNetworkLicenseSummary));
    private static final BIcon ICON = BIcon.std((String)"doc.png");
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");
    private StationStatusModel model;
    private DetailsCommand detailsCommand;
    private PollCommand pollCommand;
    private static final int COL_NAME = 0;
    private static final int COL_HOST_ID = 1;
    private static final int COL_STATUS = 2;
    private static final int COL_LAST_UPDATED = 3;
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$ui$license$BNetworkLicenseSummary;
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$ui$license$BNetworkLicenseSummary$StationStatusRow;

    public Type getType() {
        return TYPE;
    }

    public BNetworkLicenseSummary() {
        CommandBindings commandBindings = new CommandBindings();
        this.model = new StationStatusModel();
        commandBindings.setSupport((CommandBindings.Support)this);
        this.detailsCommand = new DetailsCommand();
        commandBindings.addCommand((Command)this.detailsCommand, BCommandEnablePolicy.singleSelection);
        this.pollCommand = new PollCommand();
        commandBindings.addCommand((Command)this.pollCommand, BCommandEnablePolicy.singleSelection);
        commandBindings.setDoubleClickCommand((Command)this.detailsCommand);
        BCommandBoundTable bCommandBoundTable = new BCommandBoundTable((TableModel)this.model, new CommandBindings.TableController(commandBindings));
        bCommandBoundTable.setSelection((TableSelection)new CommandBindings.TableSelection(commandBindings));
        BBrush bBrush = Theme.scrollPane().getControlBackground();
        BScrollPane bScrollPane = new BScrollPane((BWidget)bCommandBoundTable);
        bScrollPane.setViewportBackground(bBrush);
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        this.setContent((BWidget)new BEdgePane((BWidget)new BBox(550.0, 0.0), (BWidget)new BBorderPane((BWidget)new BButtonPane(new Command[]{this.pollCommand}), BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), (BWidget)new BBox(0.0, 250.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.DEFAULT), 0.0, 0.0, 4.0, 0.0)));
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BIDataTable bIDataTable = (BIDataTable)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork|bql:select slotPath from niagaraDriver:NiagaraStation stop").get((BObject)((BComponent)bObject).getComponentSpace());
        Column column = bIDataTable.getColumns().get(0);
        Array array = new Array(class$com$tridium$provisioningNiagara$ui$license$BNetworkLicenseSummary$StationStatusRow == null ? (class$com$tridium$provisioningNiagara$ui$license$BNetworkLicenseSummary$StationStatusRow = BNetworkLicenseSummary.class$("com.tridium.provisioningNiagara.ui.license.BNetworkLicenseSummary$StationStatusRow")) : class$com$tridium$provisioningNiagara$ui$license$BNetworkLicenseSummary$StationStatusRow);
        TableCursor tableCursor = (TableCursor)bIDataTable.cursor();
        while (tableCursor.next()) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)BOrd.make((String)tableCursor.getString(column)).get(bObject);
            bNiagaraStation.lease(1);
            BLicenseStationExt bLicenseStationExt = (BLicenseStationExt)bNiagaraStation.getMixIn(BLicenseStationExt.TYPE);
            array.add((Object)new StationStatusRow(bLicenseStationExt));
        }
        this.model.load(array);
    }

    protected BSupervisorLicenses getSupervisorLicenses() {
        return (BSupervisorLicenses)this.getCurrentValue();
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        command.setEnabled(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class StationStatusModel
    extends TableModel
    implements SortableTableUtil.Model {
        private int sortColumn = 2;
        private boolean sortAscending = true;
        private boolean needsSort = false;
        private Array rows = new Array(class$com$tridium$provisioningNiagara$ui$license$BNetworkLicenseSummary$StationStatusRow == null ? (class$com$tridium$provisioningNiagara$ui$license$BNetworkLicenseSummary$StationStatusRow = BNetworkLicenseSummary.class$("com.tridium.provisioningNiagara.ui.license.BNetworkLicenseSummary$StationStatusRow")) : class$com$tridium$provisioningNiagara$ui$license$BNetworkLicenseSummary$StationStatusRow);

        public void load(Array array) {
            this.rows = array;
            for (int i = 0; i < array.size(); ++i) {
                ((StationStatusRow)((Object)array.get(i))).setModel(this);
            }
            this.sortValues((Comparator)new SortableTableUtil.OriginalOrderComparator((SortableTableUtil.Model)this));
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return LEX.getText("NetworkLicenseSummary.col.name");
                }
                case 1: {
                    return LEX.getText("NetworkLicenseSummary.col.hostId");
                }
                case 2: {
                    return LEX.getText("NetworkLicenseSummary.col.status");
                }
                case 3: {
                    return LEX.getText("NetworkLicenseSummary.col.lastUpdated");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getRow(n).getStationDisplayName() + " " + this.getRow(n).getExtension().getStatus();
                }
                case 1: {
                    return this.getRow(n).getHostId();
                }
                case 2: {
                    return this.getRow(n).getExtension().getLicenseStatus();
                }
                case 3: {
                    return this.getRow(n).getExtension().getLicenseStatus() == BLicenseStatus.unknown ? "" : this.getRow(n).getExtension().getLastUpdate().toString();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public SortableTableUtil.SortableRow getSortableRow(int n) {
            return this.getRow(n);
        }

        public StationStatusRow getRow(int n) {
            return (StationStatusRow)((Object)this.rows.get(n));
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            if (!this.needsSort && n == this.sortColumn && bl == this.sortAscending) {
                return;
            }
            this.sortColumn = n;
            this.sortAscending = bl;
            this.sortValues(null);
        }

        protected void sortValues(Comparator comparator) {
            this.needsSort = false;
            this.rows = new Array(this.rows.trim()).sort((Comparator)new SortableTableUtil.RowComparator((SortableTableUtil.Model)this, comparator));
            if (this.getTable() != null) {
                this.getTable().getSelection().deselectAll();
                this.updateTable(true);
            }
        }

        public boolean isSortAscending() {
            return this.sortAscending;
        }

        public int getSortColumn() {
            return this.sortColumn;
        }
    }

    private static class StationStatusRow
    extends Subscriber
    implements SortableTableUtil.SortableRow {
        private BLicenseStationExt licenseExt;
        private TableModel model = null;

        public StationStatusRow(BLicenseStationExt bLicenseStationExt) {
            this.licenseExt = bLicenseStationExt;
            this.subscribe((BComponent)bLicenseStationExt, Integer.MAX_VALUE);
        }

        public void event(BComponentEvent bComponentEvent) {
            if (this.model != null) {
                this.model.updateTable();
            }
        }

        public String getHostId() {
            return this.licenseExt.getLicenseSummary().getHostId();
        }

        public String getStationName() {
            return this.getStation().getStationName();
        }

        public String getStationDisplayName() {
            return this.getStation().getDisplayName(null);
        }

        public BNiagaraStation getStation() {
            return this.licenseExt.getNiagaraStation();
        }

        public BLicenseStatus getLicenseStatus() {
            return this.licenseExt.getLicenseStatus();
        }

        public BLicenseStationExt getExtension() {
            return this.licenseExt;
        }

        public Object getRowId() {
            return this.getStationName();
        }

        public int compareToRowForColumn(SortableTableUtil.SortableRow sortableRow, int n) {
            StationStatusRow stationStatusRow = (StationStatusRow)sortableRow;
            switch (n) {
                case 0: {
                    return TextUtil.toLowerCase((String)this.getStationDisplayName()).compareTo(TextUtil.toLowerCase((String)stationStatusRow.getStationDisplayName()));
                }
                case 1: {
                    return this.getHostId().compareTo(stationStatusRow.getHostId());
                }
                case 2: {
                    if (this.getLicenseStatus() == stationStatusRow.getLicenseStatus()) {
                        return TextUtil.toLowerCase((String)this.getStationDisplayName()).compareTo(TextUtil.toLowerCase((String)stationStatusRow.getStationDisplayName()));
                    }
                    if (this.getLicenseStatus().getOrdinal() > stationStatusRow.getLicenseStatus().getOrdinal()) {
                        return 1;
                    }
                    return -1;
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public void setModel(TableModel tableModel) {
            this.model = tableModel;
        }
    }

    private class PollCommand
    extends AsyncCommand {
        public PollCommand() {
            super((BWidget)BNetworkLicenseSummary.this, BNetworkLicenseSummary.this.getLexicon(), "NetworkLicenseSummary.pollCommand");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            try {
                this.startActive();
                int[] nArray = BNetworkLicenseSummary.this.model.getSelection().getRows();
                int n = nArray.length;
                if (n == 0) {
                    n = BNetworkLicenseSummary.this.model.getRowCount();
                }
                BValueList bValueList = BValueList.DEFAULT;
                for (int i = 0; i < n; ++i) {
                    int n2 = nArray.length == 0 ? i : nArray[i];
                    bValueList = BValueList.add((BValueList)bValueList, (BValue)BString.make((String)BNetworkLicenseSummary.this.model.getRow(n2).getStation().getStationName()));
                }
                BNetworkLicenseSummary.this.getSupervisorLicenses().updateStationLicenseStatus(bValueList);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            finally {
                this.stopActive();
            }
        }
    }

    private class DetailsCommand
    extends Command {
        public DetailsCommand() {
            super((BWidget)BNetworkLicenseSummary.this, BNetworkLicenseSummary.this.getLexicon(), "NetworkLicenseSummary.detailsCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BWbShell bWbShell = BWbShell.getWbShell((BWidget)BNetworkLicenseSummary.this);
                if (bWbShell != null) {
                    bWbShell.hyperlink(BNetworkLicenseSummary.this.model.getRow(BNetworkLicenseSummary.this.model.getSelection().getRow()).getExtension().getNavOrd());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }
}

