/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.BAsyncActionEvent;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import javax.baja.driver.BDeviceExt;
import javax.baja.platform.ICancelHint;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public abstract class BProvisioningStationExt
extends BDeviceExt
implements BIMixIn,
BIStatus {
    public static final Property enabled = BProvisioningStationExt.newProperty((int)0, (boolean)true, null);
    public static final Property status = BProvisioningStationExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BProvisioningStationExt.newProperty((int)3, (String)"", null);
    public static final Action cancelAsyncAction = BProvisioningStationExt.newAction((int)20, (BValue)BString.DEFAULT, null);
    public static final Action makeInvokeId = BProvisioningStationExt.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Topic asyncActionComplete = BProvisioningStationExt.newTopic((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioningNiagara$BProvisioningStationExt == null ? (class$com$tridium$provisioningNiagara$BProvisioningStationExt = BProvisioningStationExt.class$("com.tridium.provisioningNiagara.BProvisioningStationExt")) : class$com$tridium$provisioningNiagara$BProvisioningStationExt));
    static final int FATAL_FAULT = 1;
    public static final String NOTIFY_ACTION_COMPLETE = "notifyActionComplete";
    private static Type[] TYPES;
    private int flags = 0;
    private int oldStatus = -1;
    private Map canceledListenersByInvokeId = new HashMap();
    private long asyncInvokeId = 1L;
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$BProvisioningStationExt;
    static /* synthetic */ Class class$com$tridium$provisioningNiagara$BProvisioningStationExt$CanceledListener;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public void cancelAsyncAction(BString bString) {
        this.invoke(cancelAsyncAction, (BValue)bString, null);
    }

    public BString makeInvokeId(BString bString) {
        return (BString)this.invoke(makeInvokeId, (BValue)bString, null);
    }

    public void fireAsyncActionComplete(BAsyncActionEvent bAsyncActionEvent) {
        this.fire(asyncActionComplete, (BValue)bAsyncActionEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public boolean isUnoperational() {
        return this.isDown() || this.isDisabled() || this.isFault();
    }

    protected boolean propagateDeviceDownStatus() {
        return false;
    }

    protected boolean propagatePlatformConnectionStatus() {
        return true;
    }

    public void updateStatus() {
        int n = this.getStatus().getBits();
        BNiagaraStation bNiagaraStation = this.getNiagaraStation();
        if (bNiagaraStation == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraStation");
        }
        BStatus bStatus = bNiagaraStation == null ? BStatus.ok : bNiagaraStation.getStatus();
        BProvisioningNiagaraNetworkExt bProvisioningNiagaraNetworkExt = null;
        try {
            bProvisioningNiagaraNetworkExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        BStatus bStatus2 = BStatus.ok;
        BPlatformConnection bPlatformConnection = null;
        if (bNiagaraStation != null) {
            bPlatformConnection = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
            bStatus2 = bPlatformConnection == null ? BStatus.fault : bPlatformConnection.getStatus();
        }
        n = !this.getEnabled() || bStatus.isDisabled() || bProvisioningNiagaraNetworkExt == null || bProvisioningNiagaraNetworkExt.isDisabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        n = this.propagateDeviceDownStatus() && bStatus.isDown() || this.propagatePlatformConnectionStatus() && bStatus2.isDown() ? (n |= 4) : (n &= 0xFFFFFFFB);
        if (this.fatalFault()) {
            n |= 2;
        } else if (bProvisioningNiagaraNetworkExt == null) {
            n |= 2;
            this.setFaultCause("No niagara provisioning network ext");
        } else if (bStatus.isFault()) {
            n |= 2;
            this.setFaultCause("Device fault: " + this.getNiagaraStation().getFaultCause());
        } else if (this.propagatePlatformConnectionStatus() && bStatus2.isFault()) {
            n |= 2;
            if (bPlatformConnection == null) {
                this.setFaultCause("No platform connection mix-in");
            } else {
                this.setFaultCause("Platform connection fault: " + bPlatformConnection.getFaultCause());
            }
        } else {
            n &= 0xFFFFFFFD;
            this.setFaultCause("");
        }
        if (this.oldStatus == n) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        this.oldStatus = n;
    }

    public final boolean isFatalFault() {
        return this.fatalFault();
    }

    private void checkFatalFault() {
        if (this.fatalFault()) {
            return;
        }
        try {
            BProvisioningNiagaraNetworkExt bProvisioningNiagaraNetworkExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            if (bProvisioningNiagaraNetworkExt.isFatalFault()) {
                this.fatalFault(true);
                this.setFaultCause("Provisioning niagara network ext fault: " + bProvisioningNiagaraNetworkExt.getFaultCause());
                return;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            this.fatalFault(true);
            this.setFaultCause("No niagara provisioning network ext");
            return;
        }
        if (this.getNiagaraStation() == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraStation");
            return;
        }
        if (this.getNiagaraStation().isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Device fault: " + this.getNiagaraStation().getFaultCause());
            return;
        }
        if (this.getNiagaraNetwork() == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraNetwork");
            return;
        }
        if (this.getNiagaraNetwork().isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Network fault: " + this.getNiagaraNetwork().getFaultCause());
            return;
        }
        this.setFaultCause("");
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BNiagaraStation;
    }

    public void started() throws Exception {
        this.checkFatalFault();
        this.updateStatus();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        }
    }

    public BValue invokeSync(Action action, ICancelHint iCancelHint, Context context) {
        if (!action.getDeclaringType().is(this.getType())) {
            throw new IllegalArgumentException(action.getName() + " is not an action for " + this.getType());
        }
        if (!action.getFacets().getb(NOTIFY_ACTION_COMPLETE, false)) {
            throw new IllegalArgumentException(action.getName() + " does not support synchronous invocation");
        }
        BString bString = this.makeInvokeId(action);
        AsyncActionCompleteSubscriber asyncActionCompleteSubscriber = new AsyncActionCompleteSubscriber(bString);
        asyncActionCompleteSubscriber.subscribe((BComponent)this, 1);
        this.invoke(action, (BValue)bString, context);
        while (!asyncActionCompleteSubscriber.isComplete()) {
            if (iCancelHint != null && iCancelHint.isCanceled()) {
                this.invoke(cancelAsyncAction, (BValue)bString, context);
                throw new ICancelHint.CanceledException();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new BajaRuntimeException((Throwable)interruptedException);
            }
        }
        return asyncActionCompleteSubscriber.getReturnValue();
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        return this.getPlatformConnection().getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancelAsyncAction(BString bString, Context context) {
        Map map = this.canceledListenersByInvokeId;
        synchronized (map) {
            Array array = (Array)this.canceledListenersByInvokeId.get(bString);
            if (array != null) {
                for (int i = 0; i < array.size(); ++i) {
                    ((CanceledListener)array.get(i)).setCanceled();
                }
            }
        }
    }

    protected BString makeInvokeId(Action action) {
        return this.makeInvokeId(BString.make((String)action.getName()));
    }

    public BString doMakeInvokeId(BString bString) {
        return BString.make((String)(bString.toString() + this.asyncInvokeId++));
    }

    protected void checkCanceled(CanceledListener canceledListener) {
        if (canceledListener != null) {
            canceledListener.checkCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CanceledListener startAsyncAction(BString bString, Context context) {
        if (bString == null) {
            return null;
        }
        Map map = this.canceledListenersByInvokeId;
        synchronized (map) {
            Array array = (Array)this.canceledListenersByInvokeId.get(bString);
            if (array == null) {
                array = new Array(class$com$tridium$provisioningNiagara$BProvisioningStationExt$CanceledListener == null ? (class$com$tridium$provisioningNiagara$BProvisioningStationExt$CanceledListener = BProvisioningStationExt.class$("com.tridium.provisioningNiagara.BProvisioningStationExt$CanceledListener")) : class$com$tridium$provisioningNiagara$BProvisioningStationExt$CanceledListener);
                this.canceledListenersByInvokeId.put(bString, array);
            }
            CanceledListener canceledListener = new CanceledListener(bString);
            array.add((Object)canceledListener);
            return canceledListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void asyncActionComplete(CanceledListener canceledListener, BValue bValue, Context context) {
        if (canceledListener == null) {
            return;
        }
        Map map = this.canceledListenersByInvokeId;
        synchronized (map) {
            Array array = (Array)this.canceledListenersByInvokeId.get(canceledListener.getInvokeId());
            if (array != null && array.remove((Object)canceledListener) && array.size() == 0) {
                this.canceledListenersByInvokeId.remove(canceledListener.getInvokeId());
            }
        }
        this.fireAsyncActionComplete(new BAsyncActionEvent(canceledListener.getInvokeId(), bValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void asyncActionException(CanceledListener canceledListener, Exception exception, Context context) throws Exception {
        if (canceledListener == null) {
            throw exception;
        }
        Map map = this.canceledListenersByInvokeId;
        synchronized (map) {
            Array array = (Array)this.canceledListenersByInvokeId.get(canceledListener.getInvokeId());
            if (array != null && array.remove((Object)canceledListener) && array.size() == 0) {
                this.canceledListenersByInvokeId.remove(canceledListener.getInvokeId());
            }
        }
        this.fireAsyncActionComplete(new BAsyncActionEvent(canceledListener.getInvokeId(), exception));
    }

    public BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getDevice();
    }

    public BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getNetwork();
    }

    public BPlatformConnection getPlatformConnection() {
        return (BPlatformConnection)this.getNiagaraStation().getMixIn(BPlatformConnection.TYPE);
    }

    public BDaemonSession getDaemonSession() throws Exception {
        BPlatformConnection bPlatformConnection = this.getPlatformConnection();
        if (bPlatformConnection == null || bPlatformConnection.getStatus().isFault()) {
            return null;
        }
        return bPlatformConnection.getDaemonSession();
    }

    public static Type[] getStationExtTypes() {
        if (TYPES == null) {
            TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(TYPE.getTypeInfo());
            Type[] typeArray = new Type[typeInfoArray.length];
            for (int i = 0; i < typeInfoArray.length; ++i) {
                typeArray[i] = typeInfoArray[i].getTypeSpec().getResolvedType();
            }
            TYPES = typeArray;
        }
        return TYPES;
    }

    protected void processException(Exception exception) throws Exception {
        if (!(exception instanceof AuthenticationException) && !(exception instanceof ConnectException)) {
            throw exception;
        }
    }

    private boolean fatalFault() {
        return (this.flags & 1) != 0;
    }

    private void fatalFault(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AsyncActionCompleteSubscriber
    extends Subscriber {
        private BString invokeId;
        private boolean complete = false;
        private BValue returnValue;

        public AsyncActionCompleteSubscriber(BString bString) {
            this.invokeId = bString;
        }

        public void event(BComponentEvent bComponentEvent) {
            BAsyncActionEvent bAsyncActionEvent;
            if (bComponentEvent.getId() == 5 && bComponentEvent.getSlot() == asyncActionComplete && (bAsyncActionEvent = (BAsyncActionEvent)bComponentEvent.getValue()).getInvokeId().equals((Object)this.invokeId)) {
                this.unsubscribeAll();
                this.returnValue = bAsyncActionEvent.getReturnValue();
                this.complete = true;
            }
        }

        public boolean isComplete() {
            return this.complete;
        }

        public BValue getReturnValue() {
            return this.returnValue;
        }
    }

    protected static class CanceledListener
    implements ICancelHint {
        private boolean isCanceled;
        private BString invokeId;

        public CanceledListener(BString bString) {
            this.invokeId = bString;
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public void checkCanceled() {
            if (this.isCanceled) {
                throw new ICancelHint.CanceledException();
            }
        }

        public void setCanceled() {
            this.isCanceled = true;
        }

        public boolean equals(Object object) {
            return object == this;
        }

        public BString getInvokeId() {
            return this.invokeId;
        }
    }
}

