/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp.util;

import com.tridium.eibnetIp.datatypes.BKnxTime;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import javax.baja.sys.BAbsTime;

public final class EibUtil {
    public static final String groupIntegerToString(int n, int n2) {
        if (n2 == 2) {
            int n3 = (n & 0x7F00) >>> 8;
            int n4 = n & 0xFF;
            return "" + n3 + '/' + n4;
        }
        int n5 = (n & 0x7800) >>> 11;
        int n6 = (n & 0x700) >>> 8;
        int n7 = n & 0xFF;
        return "" + n5 + '/' + n6 + '/' + n7;
    }

    public static final String groupIntegerToString(int n) {
        return EibUtil.groupIntegerToString(n, 3);
    }

    public static final int groupStringToInteger(String string) throws IllegalArgumentException {
        int n = string.indexOf("/");
        int n2 = string.indexOf("/", n + 1);
        boolean bl = false;
        if (n < 1) {
            bl = true;
        }
        boolean bl2 = false;
        if (n2 == n + 1) {
            bl2 = true;
        }
        if (bl | bl2) {
            throw new IllegalArgumentException("incorrectly formatted group address");
        }
        try {
            if (n2 == -1) {
                Integer n3 = new Integer(string.substring(0, n));
                Integer n4 = new Integer(string.substring(n + 1));
                boolean bl3 = false;
                if (n3 > 15) {
                    bl3 = true;
                }
                boolean bl4 = false;
                if (n4 > 2047) {
                    bl4 = true;
                }
                if (bl3 | bl4) {
                    throw new IllegalArgumentException("group value out of range");
                }
                int n5 = n3 << 11 | n4;
                return n5;
            }
            Integer n6 = new Integer(string.substring(0, n));
            Integer n7 = new Integer(string.substring(n + 1, n2));
            Integer n8 = new Integer(string.substring(n2 + 1));
            boolean bl5 = false;
            if (n6 > 15) {
                bl5 = true;
            }
            boolean bl6 = false;
            if (n7 > 7) {
                bl6 = true;
            }
            boolean bl7 = bl5 | bl6;
            boolean bl8 = false;
            if (n8 > 255) {
                bl8 = true;
            }
            if (bl7 | bl8) {
                throw new IllegalArgumentException("group value out of range");
            }
            int n9 = n6 << 11 | n7 << 8 | n8;
            return n9;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("group value field1 not a number");
        }
    }

    public static final boolean isValidGroupAddress(String string) {
        try {
            EibUtil.groupStringToInteger(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final String individualIntegerToString(int n) {
        int n2 = (n & 0xF000) >>> 12;
        int n3 = (n & 0xF00) >>> 8;
        int n4 = n & 0xFF;
        return "" + n2 + '.' + n3 + '.' + n4;
    }

    public static final String byteArrayIpToStringIp(byte[] byArray) {
        return Integer.toString(byArray[0] & 0xFF) + '.' + Integer.toString(byArray[1] & 0xFF) + '.' + Integer.toString(byArray[2] & 0xFF) + '.' + Integer.toString(byArray[3] & 0xFF);
    }

    public static final byte[] stringIpToByteArrayIp(String string) throws UnknownHostException {
        int n;
        int n2;
        int n3;
        int n4;
        if (string == null || string.equals("")) {
            throw new UnknownHostException("Invalid IP address! " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new UnknownHostException("Invalid IP address! " + string);
        }
        try {
            n4 = Integer.parseInt(stringTokenizer.nextToken());
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnknownHostException("Invalid IP address! " + string);
        }
        if (n4 < 0 || n4 > 255) {
            throw new UnknownHostException("Invalid IP address! " + string);
        }
        if (n3 < 0 || n3 > 255) {
            throw new UnknownHostException("Invalid IP address! " + string);
        }
        if (n2 < 0 || n2 > 255) {
            throw new UnknownHostException("Invalid IP address! " + string);
        }
        if (n < 0 || n > 255) {
            throw new UnknownHostException("Invalid IP address! " + string);
        }
        byte[] byArray = new byte[]{(byte)n4, (byte)n3, (byte)n2, (byte)n};
        return byArray;
    }

    public static final int ipHash(byte[] byArray) {
        int n = byArray[3] & 0xFF;
        n |= byArray[2] << 8 & 0xFF00;
        n |= byArray[1] << 16 & 0xFF0000;
        return n |= byArray[0] << 24 & 0xFF000000;
    }

    public static final float getFloat16Value(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 2) {
            throw new IllegalArgumentException("Invalid data length for float value");
        }
        int n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        boolean bl = false;
        if ((n & 0x8000) == 32768) {
            bl = true;
        }
        boolean bl2 = bl;
        int n2 = n & 0x7FF;
        int n3 = n >>> 11 & 0xF;
        if (bl2) {
            n2 = (~n2 & 0x7FF) + 1;
        }
        float f = (float)((double)n2 / 100.0 * (double)((float)Math.pow(2, n3)));
        if (bl2) {
            f = -1.0f * f;
        }
        return f;
    }

    public static final float getFloat32Value(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Invalid data length for float value");
        }
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return Float.intBitsToFloat(n);
    }

    public static final byte[] encodeFloat16ToBytes(double d) {
        int n;
        if (d < -671088.64) {
            d = -671088.64;
        }
        if (d > 670760.96) {
            d = 670760.96;
        }
        byte[] byArray = new byte[2];
        int n2 = (int)(d * 100.0);
        int n3 = 0;
        int n4 = 0;
        if (d >= 0.0) {
            n = n2;
            while (n > 2047) {
                n = n2 / (int)Math.pow(2, ++n3);
            }
            n2 = n;
            n4 = 0;
        } else {
            n = -n2 - 1;
            while (n > 2048) {
                n = (-n2 - 1) / (int)Math.pow(2, ++n3);
            }
            n2 = ~n & 0x7FF;
            n4 = 32768;
        }
        n = n4 | n3 << 11 | n2;
        byArray[0] = (byte)(n >>> 8 & 0xFF);
        byArray[1] = (byte)(n & 0xFF);
        return byArray;
    }

    public static final byte[] encodeFloat32ToBytes(double d) {
        if (d < (double)1.4E-45f) {
            d = 1.4E-45f;
        }
        if (d > 3.4028234663852886E38) {
            d = 3.4028234663852886E38;
        }
        byte[] byArray = new byte[4];
        int n = Float.floatToIntBits((float)d);
        byArray[0] = (byte)(n >>> 24 & 0xFF);
        byArray[1] = (byte)(n >>> 16 & 0xFF);
        byArray[2] = (byte)(n >>> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        return byArray;
    }

    public static final byte[] timeToBytes(BKnxTime bKnxTime) throws IllegalArgumentException {
        byte[] byArray = new byte[3];
        byArray[2] = (byte)bKnxTime.getTime().getSecond();
        byArray[1] = (byte)bKnxTime.getTime().getMinute();
        byArray[0] = (byte)bKnxTime.getTime().getHour();
        int n = bKnxTime.getDayOfWeek().getOrdinal();
        byArray[0] = (byte)(byArray[0] | (byte)(n << 5));
        return byArray;
    }

    public static final byte[] dateToBytes(BAbsTime bAbsTime) throws IllegalArgumentException {
        byte[] byArray = new byte[3];
        byArray[2] = (byte)(bAbsTime.getYear() % 100);
        byArray[1] = (byte)bAbsTime.getMonth().getMonthOfYear();
        byArray[0] = (byte)bAbsTime.getDay();
        return byArray;
    }
}

