/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp.stack;

import com.tridium.eibnetIp.BEibnetIpDevice;
import com.tridium.eibnetIp.BEibnetIpNetwork;
import com.tridium.eibnetIp.EibnetConst;
import com.tridium.eibnetIp.datatypes.ConnectionHeader;
import com.tridium.eibnetIp.enums.BEibnetIpConnectionTypeEnum;
import com.tridium.eibnetIp.messages.EibnetIpInputStream;
import com.tridium.eibnetIp.messages.LDataReq;
import com.tridium.eibnetIp.stack.KnxSearchResponseListener;
import com.tridium.eibnetIp.stack.LinkLayerConnectRequest;
import com.tridium.eibnetIp.stack.LinkLayerConnectionStateRequest;
import com.tridium.eibnetIp.stack.LinkLayerDescriptionRequest;
import com.tridium.eibnetIp.stack.LinkLayerDisconnectRequest;
import com.tridium.eibnetIp.stack.TunnelAck;
import com.tridium.eibnetIp.stack.TunnelRequest;
import com.tridium.eibnetIp.util.BEibnetWorker;
import com.tridium.eibnetIp.util.EibUtil;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BEibnetIpLinkLayer
extends BComponent
implements EibnetConst {
    private static Lexicon lex = Lexicon.make((String)"eibnetIp");
    private static String NONE = lex.getText("ip.adapter.none");
    private static String[] noAdapterArray = new String[]{NONE};
    private static String[] noAdapterIdArray = new String[]{NONE};
    private static String[] noAdapterIpArray = new String[]{NONE};
    private static int[] noneOrdinals = new int[]{-1};
    public static final Property localAdapter = BEibnetIpLinkLayer.newProperty((int)64, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noAdapterArray)), null);
    public static final Property localAdapterId = BEibnetIpLinkLayer.newProperty((int)65, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noAdapterIdArray)), null);
    public static final Property localIpAddress = BEibnetIpLinkLayer.newProperty((int)65, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noAdapterIpArray)), null);
    public static final Property localPortMin = BEibnetIpLinkLayer.newProperty((int)0, (int)3500, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE, (int)10));
    public static final Property localPortMax = BEibnetIpLinkLayer.newProperty((int)0, (int)4000, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE, (int)10));
    public static final Property localPort = BEibnetIpLinkLayer.newProperty((int)3, (int)3500, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE, (int)10));
    public static final Property adapterDebug = BEibnetIpLinkLayer.newProperty((int)0, (boolean)false, null);
    public static final Property packetWorker = BEibnetIpLinkLayer.newProperty((int)4, (BValue)new BEibnetWorker("EibPktRx"), null);
    public static final Property tunnelTrace = BEibnetIpLinkLayer.newProperty((int)0, (boolean)true, null);
    public static final Property telegramTrace = BEibnetIpLinkLayer.newProperty((int)0, (boolean)true, null);
    public static final Action refreshAdapterList = BEibnetIpLinkLayer.newAction((int)0, null);
    public static final Type TYPE;
    public static final int PACKET_LENGTH = 512;
    private static final Log log;
    static boolean alive;
    private static final long MIN_SLEEP_TIME = 10L;
    public static IntHashMap connectErrors;
    boolean goodSocket;
    DatagramSocket tunnelSocket;
    DatagramPacket datagramOut;
    SocketReceiver tunnelRx;
    int tunnelPort;
    private Thread tunnelRxThread;
    private InetAddress myIp;
    private String oldIpAddr;
    private IntHashMap inetAddressTable;
    private IntHashMap devices;
    private long lastTxMessageTicks;
    private Object searchResponseListenersLock;
    private Vector searchResponseListeners;
    private Object transmitLock;
    static /* synthetic */ Class class$com$tridium$eibnetIp$stack$BEibnetIpLinkLayer;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$platform$tcpip$BTcpIpAdapterSettings;

    public BEnum getLocalAdapter() {
        return (BEnum)this.get(localAdapter);
    }

    public void setLocalAdapter(BEnum bEnum) {
        this.set(localAdapter, (BValue)bEnum, null);
    }

    public BEnum getLocalAdapterId() {
        return (BEnum)this.get(localAdapterId);
    }

    public void setLocalAdapterId(BEnum bEnum) {
        this.set(localAdapterId, (BValue)bEnum, null);
    }

    public BEnum getLocalIpAddress() {
        return (BEnum)this.get(localIpAddress);
    }

    public void setLocalIpAddress(BEnum bEnum) {
        this.set(localIpAddress, (BValue)bEnum, null);
    }

    public int getLocalPortMin() {
        return this.getInt(localPortMin);
    }

    public void setLocalPortMin(int n) {
        this.setInt(localPortMin, n, null);
    }

    public int getLocalPortMax() {
        return this.getInt(localPortMax);
    }

    public void setLocalPortMax(int n) {
        this.setInt(localPortMax, n, null);
    }

    public int getLocalPort() {
        return this.getInt(localPort);
    }

    public void setLocalPort(int n) {
        this.setInt(localPort, n, null);
    }

    public boolean getAdapterDebug() {
        return this.getBoolean(adapterDebug);
    }

    public void setAdapterDebug(boolean bl) {
        this.setBoolean(adapterDebug, bl, null);
    }

    public BEibnetWorker getPacketWorker() {
        return (BEibnetWorker)this.get(packetWorker);
    }

    public void setPacketWorker(BEibnetWorker bEibnetWorker) {
        this.set(packetWorker, (BValue)bEibnetWorker, null);
    }

    public boolean getTunnelTrace() {
        return this.getBoolean(tunnelTrace);
    }

    public void setTunnelTrace(boolean bl) {
        this.setBoolean(tunnelTrace, bl, null);
    }

    public boolean getTelegramTrace() {
        return this.getBoolean(telegramTrace);
    }

    public void setTelegramTrace(boolean bl) {
        this.setBoolean(telegramTrace, bl, null);
    }

    public void refreshAdapterList() {
        this.invoke(refreshAdapterList, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void receiveDatagramPacket(DatagramPacket datagramPacket) {
        this.getPacketWorker().post(new BEibnetIpDatagramTodo(datagramPacket));
    }

    public void started() {
        BEibnetIpNetwork.eibnet().postAsync(new Runnable(){

            public final void run() {
                BEibnetIpLinkLayer.this.setTcpIpAdapter();
            }
        });
        BEibnetIpNetwork.eibnet().postAsync(new Runnable(){

            public final void run() {
                BEibnetIpLinkLayer.this.linkStart();
            }
        });
    }

    public void stopped() {
        this.linkStop();
        this.inetAddressTable = null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals((Object)localAdapter)) {
            if (!this.isRunning()) {
                return;
            }
            int n = this.getLocalAdapter().getOrdinal();
            BEnum bEnum = this.getLocalAdapterId();
            BEnumRange bEnumRange = bEnum.getRange();
            this.setLocalAdapterId((BEnum)BDynamicEnum.make((int)n, (BEnumRange)bEnumRange));
            BEnum bEnum2 = this.getLocalIpAddress();
            BEnumRange bEnumRange2 = bEnum2.getRange();
            this.setLocalIpAddress((BEnum)BDynamicEnum.make((int)n, (BEnumRange)bEnumRange2));
            this.linkStop();
            this.updateLocalAddress();
            if (n != -1) {
                this.linkStart();
            }
        }
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BEibnetIpNetwork;
    }

    protected BEibnetIpNetwork getNetwork() {
        return (BEibnetIpNetwork)this.getParent();
    }

    public void doRefreshAdapterList() {
        this.setTcpIpAdapter();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void setTcpIpAdapter() {
        try {
            var1_1 = this.getLocalAdapterId().getTag();
            var2_3 = this.getLocalAdapterId().getOrdinal();
            System.out.println("localAdapterId:currentTag=" + var1_1 + ", currentOrdinal=" + var2_3);
            var3_5 = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
            var3_5.lease();
            var4_6 = var3_5.getSettings();
            v0 = BEibnetIpLinkLayer.class$java$lang$Integer;
            if (v0 == null) {
                v0 = BEibnetIpLinkLayer.class$java$lang$Integer = BEibnetIpLinkLayer.class("[Ljava.lang.Integer;", false);
            }
            var5_7 = new Array(v0);
            var5_7.add((Object)new Integer(-1));
            v1 = BEibnetIpLinkLayer.class$java$lang$String;
            if (v1 == null) {
                v1 = BEibnetIpLinkLayer.class$java$lang$String = BEibnetIpLinkLayer.class("[Ljava.lang.String;", false);
            }
            var6_8 = new Array(v1);
            var6_8.add((Object)BEibnetIpLinkLayer.NONE);
            v2 = BEibnetIpLinkLayer.class$java$lang$String;
            if (v2 == null) {
                v2 = BEibnetIpLinkLayer.class$java$lang$String = BEibnetIpLinkLayer.class("[Ljava.lang.String;", false);
            }
            var7_9 = new Array(v2);
            var7_9.add((Object)BEibnetIpLinkLayer.NONE);
            v3 = BEibnetIpLinkLayer.class$java$lang$String;
            if (v3 == null) {
                v3 = BEibnetIpLinkLayer.class$java$lang$String = BEibnetIpLinkLayer.class("[Ljava.lang.String;", false);
            }
            var8_10 = new Array(v3);
            var8_10.add((Object)BEibnetIpLinkLayer.NONE);
            var9_11 = false;
            var10_12 = 0;
            var11_13 = var4_6.getAdapters().getProperties();
            if (true) ** GOTO lbl68
            do {
                var12_14 = (String[])var11_13.get();
                if (this.getAdapterDebug()) {
                    this.dumpAdapter((BTcpIpAdapterSettings)var12_14);
                }
                if (var12_14.getIsAdapterEnabled() && !var12_14.getIpAddress().equals("")) {
                    var13_15 /* !! */  = SlotPath.escape((String)var12_14.getDescription());
                    var14_16 /* !! */  = SlotPath.escape((String)var12_14.getIpAddress());
                    var15_17 /* !! */  = (int[])SlotPath.escape((String)var12_14.getAdapterId());
                    if (var1_1.equals(var15_17 /* !! */ )) {
                        var9_11 = true;
                    }
                    var16_18 = 0;
                    while (var16_18 < var6_8.size()) {
                        var17_20 = (String)var6_8.get(var16_18);
                        if (var17_20.equals(var13_15 /* !! */ )) {
                            var13_15 /* !! */  = (String)var13_15 /* !! */  + "$20";
                        }
                        ++var16_18;
                    }
                    var16_18 = 0;
                    while (var16_18 < var8_10.size()) {
                        var17_20 = (String)var8_10.get(var16_18);
                        if (var17_20.equals(var14_16 /* !! */ )) {
                            var14_16 /* !! */  = (String)var14_16 /* !! */  + "$20";
                        }
                        ++var16_18;
                    }
                    var5_7.add((Object)new Integer(var10_12++));
                    var6_8.add((Object)var13_15 /* !! */ );
                    var8_10.add((Object)var14_16 /* !! */ );
                    var7_9.add((Object)var15_17 /* !! */ );
                }
lbl68:
                // 4 sources

                if ((v4 = BEibnetIpLinkLayer.class$com$tridium$platform$tcpip$BTcpIpAdapterSettings) != null) continue;
                v4 = BEibnetIpLinkLayer.class("[Lcom.tridium.platform.tcpip.BTcpIpAdapterSettings;", false);
            } while (var11_13.next(v4));
            var11_13 = (Integer[])var5_7.trim();
            var12_14 = (String[])var6_8.trim();
            var13_15 /* !! */  = (String[])var8_10.trim();
            var14_16 /* !! */  = (String[])var7_9.trim();
            var15_17 /* !! */  = new int[var11_13.length];
            var16_18 = 0;
            while (var16_18 < var11_13.length) {
                var15_17 /* !! */ [var16_18] = var11_13[var16_18];
                ++var16_18;
            }
            if (var9_11) {
                var16_19 = BDynamicEnum.make((int)var2_3, (BEnumRange)BEnumRange.make((int[])var15_17 /* !! */ , (String[])var12_14));
                var17_20 = BDynamicEnum.make((int)var2_3, (BEnumRange)BEnumRange.make((int[])var15_17 /* !! */ , (String[])var13_15 /* !! */ ));
                var18_21 = BDynamicEnum.make((int)var2_3, (BEnumRange)BEnumRange.make((int[])var15_17 /* !! */ , (String[])var14_16 /* !! */ ));
            } else if (var15_17 /* !! */ .length == 2) {
                var16_19 = BDynamicEnum.make((int)var15_17 /* !! */ [1], (BEnumRange)BEnumRange.make((int[])var15_17 /* !! */ , (String[])var12_14));
                var17_20 = BDynamicEnum.make((int)var15_17 /* !! */ [1], (BEnumRange)BEnumRange.make((int[])var15_17 /* !! */ , (String[])var13_15 /* !! */ ));
                var18_21 = BDynamicEnum.make((int)var15_17 /* !! */ [1], (BEnumRange)BEnumRange.make((int[])var15_17 /* !! */ , (String[])var14_16 /* !! */ ));
            } else {
                var16_19 = BDynamicEnum.make((int)var15_17 /* !! */ [0], (BEnumRange)BEnumRange.make((int[])var15_17 /* !! */ , (String[])var12_14));
                var17_20 = BDynamicEnum.make((int)var15_17 /* !! */ [0], (BEnumRange)BEnumRange.make((int[])var15_17 /* !! */ , (String[])var13_15 /* !! */ ));
                var18_21 = BDynamicEnum.make((int)var15_17 /* !! */ [0], (BEnumRange)BEnumRange.make((int[])var15_17 /* !! */ , (String[])var14_16 /* !! */ ));
            }
            this.setLocalAdapterId((BEnum)var18_21);
            this.setLocalIpAddress((BEnum)var17_20);
            this.setLocalAdapter((BEnum)var16_19);
        }
        catch (ActionInvokeException var1_2) {
            var1_2.printStackTrace();
            var2_4 = var1_2.getCause();
            if (var2_4 != null) {
                var2_4.printStackTrace();
            }
            throw var1_2;
        }
    }

    public synchronized void createSockets() throws SocketException {
        this.tunnelPort = -1;
        log.message("createSockets");
        if (this.tunnelSocket != null) {
            this.tunnelSocket.close();
            this.tunnelSocket = null;
        }
        int n = this.getLocalPortMin();
        while (n < this.getLocalPortMax() + 1) {
            log.message("checking if port " + n + " is available");
            try {
                this.tunnelSocket = new DatagramSocket(n, this.myIp);
                this.tunnelSocket.setSoTimeout(1000);
                this.tunnelRx.setSocket(this.tunnelSocket);
                this.tunnelPort = n;
                this.setLocalPort(n);
                break;
            }
            catch (SocketException socketException) {
                log.error("unable to create controlEnpoint " + n, (Throwable)socketException);
                ++n;
            }
        }
        log.message("using port " + this.tunnelPort);
        if (this.tunnelPort == -1) {
            throw new SocketException("unable to find available port");
        }
    }

    public void sendConnectRequest(BEibnetIpDevice bEibnetIpDevice) {
        if (!alive) {
            return;
        }
        try {
            InetAddress inetAddress = this.myIp;
            LinkLayerConnectRequest linkLayerConnectRequest = new LinkLayerConnectRequest(inetAddress, this.tunnelPort, this.tunnelPort);
            InetAddress inetAddress2 = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)bEibnetIpDevice.getIpAddress()));
            DatagramPacket datagramPacket = new DatagramPacket(linkLayerConnectRequest.toBytes(), linkLayerConnectRequest.length(), inetAddress2, 3671);
            log.trace("tx CONNECT_REQUEST to " + bEibnetIpDevice.getIpAddress());
            this.tunnelSocket.send(datagramPacket);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            if (bEibnetIpDevice == null) {
                log.error("device is null");
            }
            nullPointerException.printStackTrace();
            return;
        }
    }

    public void sendConnectionStateRequest(BEibnetIpDevice bEibnetIpDevice) throws IOException {
        try {
            InetAddress inetAddress = this.myIp;
            LinkLayerConnectionStateRequest linkLayerConnectionStateRequest = new LinkLayerConnectionStateRequest(inetAddress, this.tunnelPort, bEibnetIpDevice.getConnection().getChannelId());
            InetAddress inetAddress2 = bEibnetIpDevice.getDeviceIpAddress();
            DatagramPacket datagramPacket = new DatagramPacket(linkLayerConnectionStateRequest.toBytes(), linkLayerConnectionStateRequest.length(), inetAddress2, 3671);
            this.tunnelSocket.send(datagramPacket);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new IOException("unknown host");
        }
    }

    public void sendDescriptionRequest(BEibnetIpDevice bEibnetIpDevice) throws IOException {
        try {
            InetAddress inetAddress = this.myIp;
            LinkLayerDescriptionRequest linkLayerDescriptionRequest = new LinkLayerDescriptionRequest(inetAddress, this.tunnelPort);
            InetAddress inetAddress2 = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)bEibnetIpDevice.getIpAddress()));
            DatagramPacket datagramPacket = new DatagramPacket(linkLayerDescriptionRequest.toBytes(), linkLayerDescriptionRequest.length(), inetAddress2, 3671);
            log.trace("tx DESCRIPTION_REQUEST to " + bEibnetIpDevice.getIpAddress());
            this.tunnelSocket.send(datagramPacket);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new IOException("unknown host");
        }
    }

    public void sendDisconnectRequest(BEibnetIpDevice bEibnetIpDevice, int n) throws IOException {
        try {
            LinkLayerDisconnectRequest linkLayerDisconnectRequest = new LinkLayerDisconnectRequest(this.myIp, this.tunnelPort, n);
            InetAddress inetAddress = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)bEibnetIpDevice.getIpAddress()));
            DatagramPacket datagramPacket = new DatagramPacket(linkLayerDisconnectRequest.toBytes(), linkLayerDisconnectRequest.length(), inetAddress, 3671);
            log.trace("tx DISCONNECT_REQUEST to " + bEibnetIpDevice.getIpAddress());
            this.tunnelSocket.send(datagramPacket);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new IOException("unknown host");
        }
    }

    public void sendAck(BEibnetIpDevice bEibnetIpDevice, int n) throws IOException {
        try {
            TunnelAck tunnelAck = new TunnelAck(bEibnetIpDevice.getConnection().getChannelId(), n, 0);
            InetAddress inetAddress = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)bEibnetIpDevice.getIpAddress()));
            DatagramPacket datagramPacket = new DatagramPacket(tunnelAck.toBytes(), tunnelAck.length(), inetAddress, bEibnetIpDevice.getDataEndpoint().getPort());
            if (this.getTunnelTrace()) {
                log.trace("tx TUNNELLING_ACK to " + bEibnetIpDevice.getIpAddress() + " seq=" + n);
                log.trace("tx packet " + ByteArrayUtil.toHexString((byte[])datagramPacket.getData()) + " to " + datagramPacket.getAddress().getHostAddress());
            }
            this.tunnelSocket.send(datagramPacket);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new IOException("unknown host");
        }
    }

    public void sendTunnelRequest(BEibnetIpDevice bEibnetIpDevice, LDataReq lDataReq, int n) throws IOException {
        if (!bEibnetIpDevice.isConnected()) {
            throw new IOException("tunnel not connected");
        }
        try {
            lDataReq.getSource().setAddress(bEibnetIpDevice.getConnection().getIndividualAddress().getAddress());
            lDataReq.toBytes();
            if (this.getTelegramTrace()) {
                log.trace("tx " + lDataReq.toString());
            }
            TunnelRequest tunnelRequest = new TunnelRequest(bEibnetIpDevice.getConnection().getChannelId(), n, lDataReq);
            InetAddress inetAddress = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)bEibnetIpDevice.getDataEndpoint().getAddress()));
            int n2 = bEibnetIpDevice.getDataEndpoint().getPort();
            DatagramPacket datagramPacket = new DatagramPacket(tunnelRequest.toBytes(), tunnelRequest.length(), inetAddress, n2);
            if (this.getTunnelTrace()) {
                log.trace("tx TUNNELLING_REQUEST to " + bEibnetIpDevice.getIpAddress());
            }
            this.transmit(datagramPacket);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new IOException("unknown host");
        }
    }

    /*
     * Unable to fully structure code
     */
    private final BTcpIpAdapterSettings getTcpIpAdapter() {
        var1_1 = SlotPath.unescape((String)this.getLocalAdapterId().getTag());
        var2_2 = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        var2_2.lease();
        var3_3 = var2_2.getSettings();
        var4_4 = var3_3.getAdapters().getProperties();
        if (true) ** GOTO lbl10
        do {
            if (var1_1.equals((var5_5 = (BTcpIpAdapterSettings)var4_4.get()).getAdapterId())) {
                return var5_5;
            }
lbl10:
            // 3 sources

            if ((v0 = BEibnetIpLinkLayer.class$com$tridium$platform$tcpip$BTcpIpAdapterSettings) != null) continue;
            v0 = BEibnetIpLinkLayer.class("[Lcom.tridium.platform.tcpip.BTcpIpAdapterSettings;", false);
        } while (var4_4.next(v0));
        return null;
    }

    private final void updateLocalAddress() {
        if (!this.isRunning()) {
            return;
        }
        try {
            BTcpIpAdapterSettings bTcpIpAdapterSettings = this.getTcpIpAdapter();
            if (bTcpIpAdapterSettings == null) {
                return;
            }
            this.myIp = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)bTcpIpAdapterSettings.getIpAddress()));
        }
        catch (Exception exception) {
            log.error("Invalid Eibnet/IP Link layer configuration!", (Throwable)exception);
        }
    }

    public InetAddress getLocalAddress() {
        if (this.myIp == null) {
            this.updateLocalAddress();
        }
        return this.myIp;
    }

    public synchronized void linkStart() {
        log.trace("link start");
        if (this.getLocalAdapter().getOrdinal() == -1) {
            return;
        }
        this.updateLocalAddress();
        if (this.myIp == null) {
            return;
        }
        if (this.tunnelRx == null) {
            this.tunnelRx = new SocketReceiver();
        }
        try {
            this.createSockets();
            this.goodSocket = true;
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            this.goodSocket = false;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.tunnelRxThread = new Thread((Runnable)this.tunnelRx, "EibLRx");
        this.tunnelRxThread.start();
    }

    public synchronized void linkStop() {
        if (!alive) {
            return;
        }
        log.trace("link stop");
        alive = false;
        this.tunnelRxThread.interrupt();
        if (this.tunnelSocket != null) {
            this.tunnelSocket.close();
        }
        this.tunnelSocket = null;
        this.tunnelRxThread = null;
        this.tunnelRx = null;
        this.myIp = null;
    }

    private final void processPacket(DatagramPacket datagramPacket) {
        EibnetIpInputStream eibnetIpInputStream;
        int n;
        InetAddress inetAddress = datagramPacket.getAddress();
        int n2 = datagramPacket.getLength();
        BEibnetIpDevice bEibnetIpDevice = (BEibnetIpDevice)this.devices.get(inetAddress.hashCode());
        if (bEibnetIpDevice == null) {
            log.trace(inetAddress.getHostAddress() + " does not map to a configured device");
        }
        if (inetAddress.equals(this.myIp)) {
            log.trace(inetAddress.getHostAddress() + " is myIp, discard!");
            return;
        }
        byte[] byArray = new byte[n2];
        byte[] byArray2 = datagramPacket.getData();
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        if (this.getTunnelTrace()) {
            log.trace("rx packet " + ByteArrayUtil.toHexString((byte[])byArray) + " from " + inetAddress.getHostAddress());
        }
        if ((n = (eibnetIpInputStream = EibnetIpInputStream.make(byArray, 0, byArray.length)).read()) != 6) {
            if (log.isTraceOn()) {
                log.error("Unexpected header size read");
            }
            return;
        }
        int n3 = eibnetIpInputStream.read();
        if (n3 != 16) {
            if (log.isTraceOn()) {
                log.error("Unexpected version read");
            }
            return;
        }
        int n4 = eibnetIpInputStream.read();
        int n5 = eibnetIpInputStream.read();
        int n6 = eibnetIpInputStream.readInt();
        if (eibnetIpInputStream.available() < n6 - 6) {
            log.error("incomplete packet received");
            return;
        }
        switch (n4) {
            case 2: {
                this.processEibnetIpCore(bEibnetIpDevice, eibnetIpInputStream, n5);
                break;
            }
            case 3: {
                log.trace("rx EIBNETIP_DEVMGMT packet");
                break;
            }
            case 4: {
                if (bEibnetIpDevice == null) break;
                this.processEibnetIpTunnel(bEibnetIpDevice, eibnetIpInputStream, n5, n6);
                break;
            }
            case 5: {
                log.trace("rx EIBNETIP_ROUTING packet");
                break;
            }
            case 6: {
                log.trace("rx EIBNETIP_REMLOG packet");
                break;
            }
            case 7: {
                log.trace("rx EIBNETIP_REMCONF packet");
                break;
            }
            case 8: {
                log.trace("rx EIBNETIP_OBJSRV packet");
                break;
            }
            default: {
                log.error("rx unknown service type " + n4 + " received from " + inetAddress.getHostAddress());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processEibnetIpCore(BEibnetIpDevice var1_1, EibnetIpInputStream var2_2, int var3_3) {
        switch (var3_3) {
            case 1: {
                if (var1_1 == null) {
                    return;
                }
                BEibnetIpLinkLayer.log.trace("rx SEARCH_REQUEST, processing not implemented");
                return;
            }
            case 2: {
                if (BEibnetIpLinkLayer.log.isTraceOn()) {
                    if (var1_1 != null) {
                        BEibnetIpLinkLayer.log.trace("rx SEARCH_RESPONSE from " + var1_1.getIpAddress());
                    } else {
                        BEibnetIpLinkLayer.log.trace("rx SEARCH RESPONSE");
                    }
                }
                var4_4 = new byte[var2_2.available()];
                var2_2.read(var4_4, 0, var4_4.length);
                try {
                    var5_5 = this.searchResponseListenersLock;
                    synchronized (var5_5) {
                        var7_12 = 0;
                        while (true) {
                            if (var7_12 >= this.searchResponseListeners.size()) {
                                return;
                            }
                            ((KnxSearchResponseListener)this.searchResponseListeners.elementAt(var7_12)).rcvSearchResponse(var4_4);
                            ++var7_12;
                        }
                    }
                }
                catch (IOException var5_6) {
                    var5_6.printStackTrace();
                    return;
                }
            }
            case 3: {
                if (var1_1 == null) {
                    return;
                }
                BEibnetIpLinkLayer.log.trace("rx DESCRIPTION_REQUEST from " + var1_1.getIpAddress() + ", processing not implemented");
                return;
            }
            case 4: {
                if (var1_1 == null) {
                    return;
                }
                BEibnetIpLinkLayer.log.trace("rx DESCRIPTION_RESPONSE from " + var1_1.getIpAddress());
                try {
                    var5_7 = var2_2.readHardwareDib();
                    var1_1.setDeviceInfo(var5_7);
                    var6_15 = var2_2.readServices();
                    var1_1.setServicesInfo(var6_15);
                    var1_1.setDescription(var5_7.getFriendlyName());
                    var1_1.setMacAddress(var5_7.getMacAddress());
                    return;
                }
                catch (IOException var5_8) {
                    var5_8.printStackTrace();
                    return;
                }
            }
            case 5: {
                if (var1_1 == null) {
                    return;
                }
                BEibnetIpLinkLayer.log.message("rx CONNECT_REQUEST from " + var1_1.getIpAddress() + ", processing not implemented");
                return;
            }
            case 6: {
                if (var1_1 == null) {
                    return;
                }
                var5_9 = 0;
                var6_16 = 0;
                try {
                    var5_9 = var2_2.read();
                    var6_16 = var2_2.read();
                    if (var6_16 != 0) ** GOTO lbl80
                    BEibnetIpLinkLayer.log.trace("rx CONNECT_RESPONSE from " + var1_1.getIpAddress() + " :channel=" + var5_9);
                    var1_1.getConnection().setChannelId(var5_9);
                    var1_1.setDataEndpoint(var2_2.readHpai());
                    if (var2_2.read() != 4) {
                        throw new IOException("incorrect struct length for CRI_CRD");
                    }
                    var1_1.getConnection().setTypeCode(BEibnetIpConnectionTypeEnum.make(var2_2.read()));
                    if (!var1_1.getConnection().getTypeCode().equals((Object)BEibnetIpConnectionTypeEnum.tunnelConnection)) {
                        throw new IOException("connection type not tunnel");
                    }
                    var1_1.getConnection().setIndividualAddress(var2_2.readIndividualAddress());
                    var1_1.getConnection().setSequenceCounter(0);
                    var1_1.resetTunnelSendCounter();
                    var1_1.setTimeOfLastMessage();
                    ** GOTO lbl93
lbl80:
                    // 1 sources

                    if (var6_16 != 34) ** GOTO lbl83
                    BEibnetIpLinkLayer.log.error("rx CONNECT_RESPONSE, error=E_CONNECTION_TYPE");
                    ** GOTO lbl93
lbl83:
                    // 1 sources

                    if (var6_16 != 35) ** GOTO lbl86
                    BEibnetIpLinkLayer.log.error("rx CONNECT_RESPONSE, error=E_CONNECTION_OPTION");
                    ** GOTO lbl93
lbl86:
                    // 1 sources

                    if (var6_16 == 36) {
                        BEibnetIpLinkLayer.log.error("rx CONNECT_RESPONSE, error=E_NO_MORE_CONNECTIONS");
                    } else {
                        BEibnetIpLinkLayer.log.error("rx CONNECT_RESPONSE, unrecongnized error code:" + var6_16);
                    }
                }
                catch (Exception var7_13) {
                    var7_13.printStackTrace();
                }
lbl93:
                // 6 sources

                var1_1.handleConnectionMessage(var5_9, var6_16);
                return;
            }
            case 7: {
                if (var1_1 == null) {
                    return;
                }
                BEibnetIpLinkLayer.log.trace("rx CONNECTIONSTATE_REQUEST from " + var1_1.getIpAddress() + ":, processing not implemented");
                return;
            }
            case 8: {
                if (var1_1 == null) {
                    return;
                }
                if (this.getTunnelTrace()) {
                    BEibnetIpLinkLayer.log.trace("rx CONNECTIONSTATE_RESPONSE from " + var1_1.getIpAddress());
                }
                var5_10 = var2_2.read();
                var6_17 = var2_2.read();
                if (var5_10 != var1_1.getConnection().getChannelId()) ** GOTO lbl113
                if (var6_17 != 0) {
                    var1_1.setConnected(false);
                } else {
                    var1_1.setConnected(true);
                }
                ** GOTO lbl115
lbl113:
                // 1 sources

                var1_1.setConnected(false);
                var6_17 = 33;
lbl115:
                // 3 sources

                if (this.getTunnelTrace()) {
                    if (var1_1.isConnected()) {
                        BEibnetIpLinkLayer.log.trace("device " + var1_1.getIpAddress() + " is connected on channel " + var5_10);
                    } else {
                        BEibnetIpLinkLayer.log.message(var1_1.getIpAddress() + ":channel " + var5_10 + " is disconnected, error=" + BEibnetIpLinkLayer.connectErrors.get(var6_17).toString());
                    }
                }
                var1_1.handleConnectionMessage(var5_10, var6_17);
                return;
            }
            case 9: {
                if (var1_1 == null) {
                    return;
                }
                var5_11 = var2_2.read();
                BEibnetIpLinkLayer.log.message("rx DISCONNECT_REQUEST from " + var1_1.getIpAddress() + ": for channel " + var5_11);
                var2_2.read();
                try {
                    var7_14 = var2_2.readHpai();
                }
                catch (IOException var8_18) {
                    var8_18.printStackTrace();
                    return;
                }
                BEibnetIpLinkLayer.log.trace("tx DISCONNECT_RESPONSE, channel=" + var5_11);
                var8_19 = new ByteArrayOutputStream();
                var8_19.write(6);
                var8_19.write(16);
                var8_19.write(2);
                var8_19.write(10);
                var8_19.write(0);
                var8_19.write(8);
                var8_19.write(var5_11);
                var8_19.write(var5_11 == var1_1.getConnection().getChannelId() ? 0 : 33);
                try {
                    var9_20 = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)var7_14.getAddress()));
                    var10_21 = new DatagramPacket(var8_19.toByteArray(), var8_19.size(), var9_20, var7_14.getPort());
                    BEibnetIpLinkLayer.log.trace("tx packet " + ByteArrayUtil.toHexString((byte[])var10_21.getData()) + " to " + var10_21.getAddress().getHostAddress());
                    this.tunnelSocket.send(var10_21);
                }
                catch (UnknownHostException var10_22) {
                    var10_22.printStackTrace();
                }
                catch (IOException var10_23) {
                    var10_23.printStackTrace();
                }
                if (var5_11 != var1_1.getConnection().getChannelId()) return;
                var1_1.setConnected(false);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException var10_24) {
                    var10_24.printStackTrace();
                }
                var1_1.connect();
                return;
            }
            case 10: {
                var10_25 = var2_2.read();
                var11_26 = var2_2.read();
                BEibnetIpLinkLayer.log.message("rx DISCONNECT_RESPONSE from " + var1_1.getIpAddress() + ":channel " + var10_25 + ':' + BEibnetIpLinkLayer.connectErrors.get(var11_26).toString());
                var1_1.setConnected(false);
                return;
            }
        }
        BEibnetIpLinkLayer.log.error("received CORE UNKNOWN command, processing not implemented");
    }

    void processEibnetIpTunnel(BEibnetIpDevice bEibnetIpDevice, EibnetIpInputStream eibnetIpInputStream, int n, int n2) {
        ConnectionHeader connectionHeader;
        try {
            connectionHeader = eibnetIpInputStream.readConnectionHeader();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (connectionHeader.getId() != bEibnetIpDevice.getConnection().getChannelId()) {
            log.error("incorrect header id:" + connectionHeader.getId() + " endpoint:" + bEibnetIpDevice.getConnection().getChannelId());
            return;
        }
        switch (n) {
            case 32: {
                if (this.getTunnelTrace()) {
                    log.trace("rx TUNNELLING_REQUEST from " + bEibnetIpDevice.getIpAddress() + " seq=" + connectionHeader.getSequenceCounter());
                }
                if (connectionHeader.getSequenceCounter() == bEibnetIpDevice.getConnection().getSequenceCounter()) {
                    try {
                        this.sendAck(bEibnetIpDevice, connectionHeader.getSequenceCounter());
                        bEibnetIpDevice.getConnection().incrementSequenceCounter();
                        byte[] byArray = new byte[n2 - 10];
                        eibnetIpInputStream.read(byArray);
                        this.getNetwork().getTunnelLayer().processTunnelingResponse(bEibnetIpDevice, byArray);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else if (connectionHeader.getSequenceCounter() == bEibnetIpDevice.getConnection().getSequenceCounter() - 1) {
                    log.message("incoming seq of " + connectionHeader.getSequenceCounter() + " from " + bEibnetIpDevice.getIpAddress() + " is one less than expected");
                    try {
                        this.sendAck(bEibnetIpDevice, connectionHeader.getSequenceCounter());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    log.message("incoming seq count of " + connectionHeader.getSequenceCounter() + " from " + bEibnetIpDevice.getIpAddress() + " does not equal expected value of " + bEibnetIpDevice.getConnection().getSequenceCounter());
                    bEibnetIpDevice.getConnection().setSequenceCounter(connectionHeader.getSequenceCounter());
                }
                return;
            }
            case 33: {
                if (this.getTunnelTrace()) {
                    log.trace("rx TUNNELLING_ACK from " + bEibnetIpDevice.getIpAddress() + ":seq=" + connectionHeader.getSequenceCounter());
                }
                if (connectionHeader.getStatus() == 0) {
                    this.getNetwork().getTunnelLayer().processTunnelingAck(connectionHeader, bEibnetIpDevice);
                    break;
                }
                if (connectionHeader.getStatus() == 4) {
                    log.message("TUNNELING_ACK E_SEQUENCE_NUMBER error with incoming seq count of " + connectionHeader.getSequenceCounter() + " from " + bEibnetIpDevice.getIpAddress() + ", seq counter currently at seq " + bEibnetIpDevice.getConnection().getSequenceCounter());
                    break;
                }
                log.error("TUNNELING_ACK error " + connectionHeader.getStatus() + " from " + bEibnetIpDevice.getIpAddress() + ", seq=" + connectionHeader.getSequenceCounter());
                bEibnetIpDevice.doDisconnect();
                break;
            }
            default: {
                log.error(bEibnetIpDevice.getIpAddress() + ":invalid tunnel subcode");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transmit(DatagramPacket datagramPacket) throws IOException {
        if (this.getTunnelTrace()) {
            log.trace("tx packet " + ByteArrayUtil.toHexString((byte[])datagramPacket.getData()) + " to " + datagramPacket.getAddress().getHostAddress());
        }
        Object object = this.transmitLock;
        synchronized (object) {
            block7: {
                block6: {
                    this.performInterMessageDelay();
                    if (this.tunnelSocket == null) break block6;
                    try {
                        this.tunnelSocket.send(datagramPacket);
                        this.lastTxMessageTicks = Clock.ticks();
                    }
                    catch (BindException bindException) {
                        log.error(datagramPacket.getAddress().getHostAddress() + ' ' + bindException.getMessage());
                    }
                    break block7;
                }
                log.warning("cannot send datagram because socket is null");
            }
            return;
        }
    }

    protected void performInterMessageDelay() {
        long l = Math.max(this.getNetwork().getInterMessageDelay().getMillis(), 10L);
        long l2 = Clock.ticks() - this.lastTxMessageTicks;
        if (l2 >= l) {
            return;
        }
        long l3 = Math.max(l - l2, 10L);
        try {
            Thread.sleep(l3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public InetAddress lookupInetAddr(byte[] byArray) throws UnknownHostException {
        if (byArray == null || byArray.length < 4) {
            throw new UnknownHostException("Invalid IP address! " + ByteArrayUtil.toHexString((byte[])byArray));
        }
        int n = EibUtil.ipHash(byArray);
        InetAddress inetAddress = (InetAddress)this.inetAddressTable.get(n);
        if (inetAddress == null) {
            inetAddress = InetAddress.getByAddress(byArray);
            this.inetAddressTable.put(n, (Object)inetAddress);
        }
        return inetAddress;
    }

    private final void dumpAdapter(BTcpIpAdapterSettings bTcpIpAdapterSettings) {
        if (bTcpIpAdapterSettings == null) {
            System.out.println("Adapter is NULL!");
            return;
        }
        System.out.println("  adapterId = " + bTcpIpAdapterSettings.getAdapterId());
        System.out.println("  isAdapterEnabled = " + bTcpIpAdapterSettings.getIsAdapterEnabled());
        System.out.println("  canDisableAdapter = " + bTcpIpAdapterSettings.getCanDisableAdapter());
        System.out.println("  description = " + bTcpIpAdapterSettings.getDescription());
        System.out.println("  isDhcpEnabled = " + bTcpIpAdapterSettings.getIsDhcpEnabled());
        System.out.println("  canUseDhcp = " + bTcpIpAdapterSettings.getCanUseDhcp());
        System.out.println("  defaultGateway = " + bTcpIpAdapterSettings.getDefaultGateway());
        System.out.println("  dnsHosts = " + this.dumpVec(bTcpIpAdapterSettings.getDnsHosts()));
        System.out.println("  domain = " + bTcpIpAdapterSettings.getDomain());
        System.out.println("  ipaddress = " + bTcpIpAdapterSettings.getIpAddress());
        System.out.println("  subnetmask = " + bTcpIpAdapterSettings.getSubnetMask());
        System.out.println("  dhcpHost = " + bTcpIpAdapterSettings.getDhcpHost());
        System.out.println("  dchpLeaseGranted = " + bTcpIpAdapterSettings.getDhcpLeaseGranted());
        System.out.println("  dhcpLeaseExpires = " + bTcpIpAdapterSettings.getDhcpLeaseExpires());
    }

    private final String dumpVec(BVector bVector) {
        StringBuffer stringBuffer = new StringBuffer();
        SlotCursor slotCursor = bVector.getProperties();
        while (slotCursor.next()) {
            stringBuffer.append(slotCursor.get().toString()).append(';');
        }
        return stringBuffer.toString();
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        if (!this.isRunning()) {
            return;
        }
        spyWriter.startProps();
        spyWriter.trTitle((Object)"EibnetIpLinkLayer", 2);
        BTcpIpAdapterSettings bTcpIpAdapterSettings = this.getTcpIpAdapter();
        spyWriter.prop((Object)"TCP/IP Adapter:", (Object)bTcpIpAdapterSettings);
        if (bTcpIpAdapterSettings != null) {
            spyWriter.prop((Object)"  adapterId", (Object)bTcpIpAdapterSettings.getAdapterId());
            spyWriter.prop((Object)"  isAdapterEnabled", bTcpIpAdapterSettings.getIsAdapterEnabled());
            spyWriter.prop((Object)"  canDisableAdapter", bTcpIpAdapterSettings.getCanDisableAdapter());
            spyWriter.prop((Object)"  description", (Object)bTcpIpAdapterSettings.getDescription());
            spyWriter.prop((Object)"  isDhcpEnabled", bTcpIpAdapterSettings.getIsDhcpEnabled());
            spyWriter.prop((Object)"  canUseDhcp", bTcpIpAdapterSettings.getCanUseDhcp());
            spyWriter.prop((Object)"  defaultGateway", (Object)bTcpIpAdapterSettings.getDefaultGateway());
            spyWriter.prop((Object)"  dnsHosts", (Object)this.dumpVec(bTcpIpAdapterSettings.getDnsHosts()));
            spyWriter.prop((Object)"  domain", (Object)bTcpIpAdapterSettings.getDomain());
            spyWriter.prop((Object)"  ipaddress", (Object)bTcpIpAdapterSettings.getIpAddress());
            spyWriter.prop((Object)"  subnetmask", (Object)bTcpIpAdapterSettings.getSubnetMask());
            spyWriter.prop((Object)"  dhcpHost", (Object)bTcpIpAdapterSettings.getDhcpHost());
            spyWriter.prop((Object)"  dchpLeaseGranted", (Object)bTcpIpAdapterSettings.getDhcpLeaseGranted());
            spyWriter.prop((Object)"  dhcpLeaseExpires", (Object)bTcpIpAdapterSettings.getDhcpLeaseExpires());
        }
        spyWriter.prop((Object)"control localAddress", (Object)this.tunnelSocket.getLocalAddress());
        spyWriter.prop((Object)"control localPort", this.tunnelSocket.getLocalPort());
        spyWriter.prop((Object)"data localAddress", (Object)this.tunnelSocket.getLocalAddress());
        spyWriter.prop((Object)"data localPort", this.tunnelSocket.getLocalPort());
        spyWriter.prop((Object)"myIp", (Object)this.myIp.getHostAddress());
        spyWriter.prop((Object)"oldIpAddr", (Object)this.oldIpAddr);
        spyWriter.prop((Object)"tunnelPort", this.tunnelPort);
        spyWriter.endProps();
    }

    public void registerDevice(BEibnetIpDevice bEibnetIpDevice) {
        int n = bEibnetIpDevice.getDeviceIpAddress().hashCode();
        if (this.devices.get(n) == null) {
            this.devices.put(n, (Object)bEibnetIpDevice);
        }
    }

    public void unregisterDevice(BEibnetIpDevice bEibnetIpDevice) {
        this.devices.remove(bEibnetIpDevice.getDeviceIpAddress().hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerSearchResponseListener(KnxSearchResponseListener knxSearchResponseListener) {
        Object object = this.searchResponseListenersLock;
        synchronized (object) {
            if (!this.searchResponseListeners.contains(knxSearchResponseListener)) {
                this.searchResponseListeners.add(knxSearchResponseListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterSearchResponseListener(KnxSearchResponseListener knxSearchResponseListener) {
        Object object = this.searchResponseListenersLock;
        synchronized (object) {
            while (this.searchResponseListeners.contains(knxSearchResponseListener)) {
                this.searchResponseListeners.remove(knxSearchResponseListener);
            }
            return;
        }
    }

    public boolean isAlive() {
        return alive;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.goodSocket = false;
        this.datagramOut = new DatagramPacket(new byte[0], 0);
        this.inetAddressTable = new IntHashMap();
        this.devices = new IntHashMap();
        this.lastTxMessageTicks = 0L;
        this.searchResponseListenersLock = new Object();
        this.searchResponseListeners = new Vector();
        this.transmitLock = new Object();
    }

    public BEibnetIpLinkLayer() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$eibnetIp$stack$BEibnetIpLinkLayer;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$stack$BEibnetIpLinkLayer = BEibnetIpLinkLayer.class("[Lcom.tridium.eibnetIp.stack.BEibnetIpLinkLayer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"eibnetIp");
        alive = false;
        connectErrors = new IntHashMap(4);
        connectErrors.put(0, (Object)BString.make((String)lex.get("error.eNoError")));
        connectErrors.put(34, (Object)BString.make((String)lex.get("error.eConnectionType")));
        connectErrors.put(35, (Object)BString.make((String)lex.get("error.eConnectionOption")));
        connectErrors.put(36, (Object)BString.make((String)lex.get("error.eNoMoreConnections")));
        connectErrors.put(256, (Object)BString.make((String)lex.get("error.eNoErrorWaiting")));
        connectErrors.put(33, (Object)BString.make((String)lex.get("error.eConnectionId")));
        connectErrors.put(38, (Object)BString.make((String)lex.get("error.eDataConnection")));
        connectErrors.put(39, (Object)BString.make((String)lex.get("error.eKnxConnection")));
        connectErrors.put(257, (Object)BString.make((String)lex.get("error.eResponseTimeout")));
        connectErrors.put(258, (Object)BString.make((String)lex.get("error.eInterruptedException")));
        connectErrors.put(258, (Object)BString.make((String)lex.get("error.eIOException")));
        connectErrors.put(259, (Object)BString.make((String)lex.get("error.eDeviceDisabled")));
        connectErrors.put(260, (Object)BString.make((String)lex.get("error.eNotRunning")));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BEibnetIpDatagramTodo
    implements Runnable {
        DatagramPacket packet;

        public void run() {
            if (this.packet != null) {
                try {
                    BEibnetIpLinkLayer.this.processPacket(this.packet);
                }
                catch (Exception exception) {}
            }
        }

        BEibnetIpDatagramTodo(DatagramPacket datagramPacket) {
            this.packet = datagramPacket;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class SocketReceiver
    implements Runnable {
        DatagramSocket socket;

        public final void run() {
            alive = true;
            while (alive) {
                if (!BEibnetIpLinkLayer.this.goodSocket) {
                    try {
                        BEibnetIpLinkLayer.this.createSockets();
                        BEibnetIpLinkLayer.this.goodSocket = true;
                        Thread.sleep(1000L);
                    }
                    catch (IOException iOException) {
                    }
                    catch (InterruptedException interruptedException) {
                        alive = false;
                    }
                    continue;
                }
                try {
                    byte[] byArray = new byte[512];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, 512);
                    this.socket.receive(datagramPacket);
                    BEibnetIpLinkLayer.this.receiveDatagramPacket(datagramPacket);
                }
                catch (NullPointerException nullPointerException) {
                    if (this.socket == null) {
                        log.error("DatagramSocket is null");
                    }
                    nullPointerException.printStackTrace();
                    break;
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (SocketException socketException) {
                    socketException.printStackTrace();
                    if (!alive) continue;
                    BEibnetIpLinkLayer.this.goodSocket = false;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    log.error("Error receiving Eibnet/IP packet!", (Throwable)iOException);
                }
                catch (Throwable throwable) {
                    log.error("Unknown exception in IP Link Layer:", throwable);
                }
            }
        }

        public final DatagramSocket getSocket() {
            return this.socket;
        }

        public final void setSocket(DatagramSocket datagramSocket) {
            this.socket = datagramSocket;
        }

        SocketReceiver() {
        }
    }
}

