/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp.point;

import com.tridium.eibnetIp.messages.LDataInd;
import com.tridium.eibnetIp.messages.LDataReq;
import com.tridium.eibnetIp.point.BKnxProxyExt;
import com.tridium.eibnetIp.util.EibUtil;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BKnxNumericProxyExt
extends BKnxProxyExt {
    public static final Type TYPE;
    int previousDimmingCommand;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxNumericProxyExt;

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BNumericPoint;
    }

    public void setValue(LDataInd lDataInd) {
        byte[] byArray;
        try {
            byArray = lDataInd.getData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.readFail("data unavailable");
            return;
        }
        try {
            BValue bValue = this.readOk(byArray);
            this.fireBusDataReceived(bValue);
            this.checkPollOnceSatisfied(lDataInd);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail(illegalArgumentException.getMessage());
        }
    }

    protected double bytesToNumeric(byte[] byArray) throws IllegalArgumentException {
        switch (this.getDataType().getOrdinal()) {
            case 0: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return byArray[0] & 1;
            }
            case 1: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return byArray[0] & 3;
            }
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2010: 
            case 2011: 
            case 2012: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return byArray[0] & 1;
            }
            case 2: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return byArray[0] & 0xF;
            }
            case 3007: 
            case 3008: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return byArray[0] & 0xF;
            }
            case 3009: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                if ((byArray[0] & 7) == 1) {
                    return 0.0;
                }
                if ((byArray[0] & 7) == 2) {
                    return 1.0;
                }
                if ((byArray[0] & 7) == 4) {
                    return 2;
                }
                throw new IllegalArgumentException("data invalid for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 4001: 
            case 4002: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                int n = Character.digit((char)(byArray[0] & 0xFF), 16);
                if (n == -1) {
                    throw new IllegalArgumentException((Object)((Object)this.getDataType()) + " data could not be converted to numeric:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return n;
            }
            case 5001: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return 0.39215686274509803 * (double)(byArray[0] & 0xFF);
            }
            case 5003: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return 1.411764705882353 * (double)(byArray[0] & 0xFF);
            }
            case 3: 
            case 5004: 
            case 5010: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return byArray[0] & 0xFF;
            }
            case 6010: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return byArray[0];
            }
            case 6020: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                if ((byArray[0] & 7) == 1) {
                    return 0.0;
                }
                if ((byArray[0] & 7) == 2) {
                    return 1.0;
                }
                if ((byArray[0] & 7) == 4) {
                    return 2;
                }
                throw new IllegalArgumentException("data type " + (Object)((Object)this.getDataType()) + " cannot be converted to numeric:" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 4: 
            case 7001: 
            case 7010: {
                if (byArray.length != 2) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                long l = ((long)byArray[0] & 0xFFL) << 8 | (long)byArray[1] & 0xFFL;
                return l;
            }
            case 8001: {
                if (byArray.length != 2) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                long l = (long)byArray[0] << 8 | (long)byArray[1] & 0xFFL;
                return l;
            }
            case 9001: 
            case 9002: 
            case 9003: 
            case 9004: 
            case 9005: 
            case 9006: 
            case 9010: 
            case 9011: 
            case 9020: 
            case 9021: {
                if (byArray.length != 2) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return EibUtil.getFloat16Value(byArray);
            }
            case 5: {
                if (byArray.length != 3) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                long l = (long)byArray[2] & 0xFFL | ((long)byArray[1] & 0xFFL) << 8 | ((long)byArray[0] & 0xFFL) << 16;
                return l;
            }
            case 10001: {
                throw new IllegalArgumentException("data type " + (Object)((Object)this.getDataType()) + " cannot be converted to numeric:" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 11001: {
                throw new IllegalArgumentException("data type " + (Object)((Object)this.getDataType()) + " cannot be converted to numeric:" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 6: 
            case 12001: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                long l = (long)byArray[3] & 0xFFL | ((long)byArray[2] & 0xFFL) << 8 | ((long)byArray[1] & 0xFFL) << 16 | ((long)byArray[0] & 0xFFL) << 24;
                return l;
            }
            case 13001: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                long l = (long)byArray[3] & 0xFFL | ((long)byArray[2] & 0xFFL) << 8 | ((long)byArray[1] & 0xFFL) << 16 | (long)byArray[0] << 24;
                return l;
            }
            case 14000: 
            case 14001: 
            case 14002: 
            case 14003: 
            case 14004: 
            case 14005: 
            case 14006: 
            case 14007: 
            case 14008: 
            case 14009: 
            case 14010: 
            case 14011: 
            case 14012: 
            case 14013: 
            case 14014: 
            case 14015: 
            case 14016: 
            case 14017: 
            case 14018: 
            case 14019: 
            case 14020: 
            case 14021: 
            case 14022: 
            case 14023: 
            case 14024: 
            case 14025: 
            case 14026: 
            case 14027: 
            case 14028: 
            case 14029: 
            case 14030: 
            case 14031: 
            case 14032: 
            case 14033: 
            case 14034: 
            case 14035: 
            case 14036: 
            case 14037: 
            case 14038: 
            case 14039: 
            case 14040: 
            case 14041: 
            case 14042: 
            case 14043: 
            case 14044: 
            case 14045: 
            case 14046: 
            case 14047: 
            case 14048: 
            case 14049: 
            case 14050: 
            case 14051: 
            case 14052: 
            case 14053: 
            case 14054: 
            case 14055: 
            case 14056: 
            case 14057: 
            case 14058: 
            case 14059: 
            case 14060: 
            case 14061: 
            case 14062: 
            case 14063: 
            case 14064: 
            case 14065: 
            case 14066: 
            case 14067: 
            case 14068: 
            case 14069: 
            case 14070: 
            case 14071: 
            case 14072: 
            case 14073: 
            case 14074: 
            case 14075: 
            case 14076: 
            case 14077: 
            case 14078: 
            case 14079: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return EibUtil.getFloat32Value(byArray);
            }
            case 15000: {
                throw new IllegalArgumentException("data type " + (Object)((Object)this.getDataType()) + " cannot be converted to numeric:" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 16000: 
            case 16001: {
                try {
                    return Long.parseLong(new String(byArray));
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return Double.parseDouble(new String(byArray));
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new IllegalArgumentException("data cannot be converted to numeric:" + ByteArrayUtil.toHexString((byte[])byArray));
                    }
                }
            }
        }
        throw new IllegalArgumentException("data type not supported:" + ByteArrayUtil.toHexString((byte[])byArray));
    }

    public void updateOutput(BStatusValue bStatusValue) {
        byte[] byArray;
        if (!(bStatusValue instanceof BStatusNumeric)) {
            this.writeFail("unsupported data type");
            return;
        }
        BStatusNumeric bStatusNumeric = (BStatusNumeric)bStatusValue;
        try {
            byArray = this.numericToBytes(bStatusNumeric.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.writeFail(illegalArgumentException.getMessage());
            return;
        }
        boolean bl = this.getDataType().shouldOptimize();
        LDataReq lDataReq = new LDataReq(this.getGroupAddresses().getPrimaryGroupAddress(), byArray, bl);
        boolean bl2 = this.network().getTunnelLayer().sendTunnelRequest(this.device(), lDataReq);
        if (!bl2) {
            this.writeFail("no confirmation");
        } else {
            this.writeOk(bStatusValue);
            this.readOkAll(byArray);
        }
        if (this.getParentPoint().isSubscribed() && this.getPollAfterWrite()) {
            this.pollNow();
        }
    }

    public BValue readOk(byte[] byArray) throws IllegalArgumentException {
        BStatusNumeric bStatusNumeric = new BStatusNumeric(this.bytesToNumeric(byArray));
        this.readOk((BStatusValue)bStatusNumeric);
        return bStatusNumeric;
    }

    protected byte[] numericToBytes(double d) throws IllegalArgumentException {
        switch (this.getDataType().getOrdinal()) {
            case 0: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: {
                if (d == 0.0) {
                    return new byte[1];
                }
                return new byte[]{1};
            }
            case 1: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2010: 
            case 2011: 
            case 2012: {
                if (d == 0.0) {
                    return new byte[1];
                }
                if (d == 1.0) {
                    return new byte[]{1};
                }
                if (d == (double)2) {
                    return new byte[]{2};
                }
                if (d == (double)3) {
                    return new byte[]{3};
                }
                throw new IllegalArgumentException("numeric cannot be converted to " + (Object)((Object)this.getDataType()) + ':' + d);
            }
            case 2: 
            case 3007: 
            case 3008: {
                int n = (int)d;
                if (n > 15 || n < 0) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + n);
                }
                return new byte[]{(byte)n};
            }
            case 3009: {
                throw new IllegalArgumentException("numeric cannot be converted to " + (Object)((Object)this.getDataType()) + ':' + d);
            }
            case 4001: 
            case 4002: {
                int n = (int)d;
                if (d < 0.0) {
                    throw new IllegalArgumentException("numeric cannot be converted to " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                if (d < 10.0) {
                    return new byte[]{(byte)(n + 48)};
                }
                if (d < 16.0) {
                    return new byte[]{(byte)(n + 55)};
                }
                throw new IllegalArgumentException("numeric cannot be converted to " + (Object)((Object)this.getDataType()) + ':' + d);
            }
            case 5001: {
                if (d > 100.0 || d < 0.0) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                return new byte[]{(byte)(d * 255.0 / 100.0)};
            }
            case 5003: {
                if (d > 360.0 || d < 0.0) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                return new byte[]{(byte)(d * 255.0 / 360.0)};
            }
            case 3: 
            case 5004: 
            case 5010: {
                if (d > 255.0 || d < 0.0) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                return new byte[]{(byte)((int)d & 0xFF)};
            }
            case 6010: {
                if (d > 127.0) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                if (d < -128.0) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                int n = (int)d;
                if (d < 0.0) {
                    n = -1 * n & 0x7F;
                    n = (~n & 0x7F) + 1;
                    n |= 0x80;
                }
                return new byte[]{(byte)n};
            }
            case 6020: {
                throw new IllegalArgumentException("numeric cannot be converted to " + (Object)((Object)this.getDataType()) + ':' + d);
            }
            case 4: 
            case 7001: 
            case 7010: {
                if (d > 65535.0) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                if (d < 0.0) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                int n = (int)d;
                byte[] byArray = new byte[2];
                byArray[1] = (byte)n;
                byArray[0] = (byte)(n >> 8);
                return byArray;
            }
            case 8001: {
                if (d > 32767.0) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                if (d < -32768.0) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                int n = (int)d;
                if (d < 0.0) {
                    n = -1 * n & Short.MAX_VALUE;
                    n = (~n & Short.MAX_VALUE) + 1;
                    n |= 0x8000;
                }
                byte[] byArray = new byte[2];
                byArray[1] = (byte)n;
                byArray[0] = (byte)(n >> 8);
                return byArray;
            }
            case 9001: 
            case 9002: 
            case 9003: 
            case 9004: 
            case 9005: 
            case 9006: 
            case 9010: 
            case 9011: 
            case 9020: 
            case 9021: {
                if (d > 670760.96) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                if (d < -671088.64) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                return EibUtil.encodeFloat16ToBytes(d);
            }
            case 5: {
                throw new IllegalArgumentException("numeric cannot be converted to " + (Object)((Object)this.getDataType()) + ':' + d);
            }
            case 10001: {
                throw new IllegalArgumentException("numeric cannot be converted to " + (Object)((Object)this.getDataType()) + ':' + d);
            }
            case 11001: {
                throw new IllegalArgumentException("numeric cannot be converted to " + (Object)((Object)this.getDataType()) + ':' + d);
            }
            case 6: 
            case 12001: {
                if (d > -1.0) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                if (d < 0.0) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                long l = (long)d;
                byte[] byArray = new byte[4];
                byArray[3] = (byte)l;
                byArray[2] = (byte)(l >> 8);
                byArray[1] = (byte)(l >> 16);
                byArray[0] = (byte)(l >> 24);
                return byArray;
            }
            case 13001: {
                if (d > 2.147483647E9) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                if (d < -2.147483648E9) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                long l = (int)d;
                if (d < 0.0) {
                    l = (long)-1 * l & Integer.MAX_VALUE;
                    l = ((l ^ -1L) & Integer.MAX_VALUE) + 1L;
                    l |= Integer.MIN_VALUE;
                }
                byte[] byArray = new byte[2];
                byArray[3] = (byte)l;
                byArray[2] = (byte)(l >> 8);
                byArray[1] = (byte)(l >> 16);
                byArray[0] = (byte)(l >> 24);
                return byArray;
            }
            case 14000: 
            case 14001: 
            case 14002: 
            case 14003: 
            case 14004: 
            case 14005: 
            case 14006: 
            case 14007: 
            case 14008: 
            case 14009: 
            case 14010: 
            case 14011: 
            case 14012: 
            case 14013: 
            case 14014: 
            case 14015: 
            case 14016: 
            case 14017: 
            case 14018: 
            case 14019: 
            case 14020: 
            case 14021: 
            case 14022: 
            case 14023: 
            case 14024: 
            case 14025: 
            case 14026: 
            case 14027: 
            case 14028: 
            case 14029: 
            case 14030: 
            case 14031: 
            case 14032: 
            case 14033: 
            case 14034: 
            case 14035: 
            case 14036: 
            case 14037: 
            case 14038: 
            case 14039: 
            case 14040: 
            case 14041: 
            case 14042: 
            case 14043: 
            case 14044: 
            case 14045: 
            case 14046: 
            case 14047: 
            case 14048: 
            case 14049: 
            case 14050: 
            case 14051: 
            case 14052: 
            case 14053: 
            case 14054: 
            case 14055: 
            case 14056: 
            case 14057: 
            case 14058: 
            case 14059: 
            case 14060: 
            case 14061: 
            case 14062: 
            case 14063: 
            case 14064: 
            case 14065: 
            case 14066: 
            case 14067: 
            case 14068: 
            case 14069: 
            case 14070: 
            case 14071: 
            case 14072: 
            case 14073: 
            case 14074: 
            case 14075: 
            case 14076: 
            case 14077: 
            case 14078: 
            case 14079: {
                if (d > 3.4028234663852886E38) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                if (d < (double)1.4E-45f) {
                    throw new IllegalArgumentException("value out of range for " + (Object)((Object)this.getDataType()) + ':' + d);
                }
                return EibUtil.encodeFloat32ToBytes(d);
            }
            case 15000: {
                throw new IllegalArgumentException("numeric cannot be converted to " + (Object)((Object)this.getDataType()) + ':' + d);
            }
            case 16000: 
            case 16001: {
                String string = Double.toString(d);
                if (string.length() > 14) {
                    string = string.substring(0, 14);
                }
                return string.getBytes();
            }
        }
        throw new IllegalArgumentException("unsupported data type");
    }

    public void doIncrementCount(BValue bValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        final BDouble bDouble = (BDouble)bValue;
        this.network().postWrite(new Runnable(){

            public final void run() {
                BStatusNumeric bStatusNumeric = new BStatusNumeric();
                BStatusNumeric bStatusNumeric2 = (BStatusNumeric)BKnxNumericProxyExt.this.getParentPoint().getOutStatusValue();
                bStatusNumeric2 = new BStatusNumeric(bStatusNumeric2.getNumeric() + bDouble.getNumeric(), bStatusNumeric2.getStatus());
                BKnxNumericProxyExt.this.convertProxyToDevice((BStatusValue)bStatusNumeric2, (BStatusValue)bStatusNumeric);
                bStatusNumeric = new BStatusNumeric((double)Math.round(bStatusNumeric.getNumeric()), bStatusNumeric.getStatus());
                BKnxNumericProxyExt.this.updateOutput((BStatusValue)bStatusNumeric);
            }
        });
    }

    public void doDecrementCount(BValue bValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        final BDouble bDouble = (BDouble)bValue;
        this.network().postWrite(new Runnable(){

            public final void run() {
                BStatusNumeric bStatusNumeric = new BStatusNumeric();
                BStatusNumeric bStatusNumeric2 = (BStatusNumeric)BKnxNumericProxyExt.this.getParentPoint().getOutStatusValue();
                bStatusNumeric2 = new BStatusNumeric(bStatusNumeric2.getNumeric() - bDouble.getNumeric(), bStatusNumeric2.getStatus());
                BKnxNumericProxyExt.this.convertProxyToDevice((BStatusValue)bStatusNumeric2, (BStatusValue)bStatusNumeric);
                bStatusNumeric = new BStatusNumeric((double)Math.round(bStatusNumeric.getNumeric()), bStatusNumeric.getStatus());
                BKnxNumericProxyExt.this.updateOutput((BStatusValue)bStatusNumeric);
            }
        });
    }

    public void doResetCount(Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.network().postWrite(new Runnable(){

            public final void run() {
                BStatusNumeric bStatusNumeric = new BStatusNumeric();
                BStatusNumeric bStatusNumeric2 = new BStatusNumeric(0.0);
                BKnxNumericProxyExt.this.convertProxyToDevice((BStatusValue)bStatusNumeric2, (BStatusValue)bStatusNumeric);
                if (bStatusNumeric.getNumeric() < 0.0) {
                    bStatusNumeric = new BStatusNumeric(0.0, bStatusNumeric.getStatus());
                }
                bStatusNumeric = new BStatusNumeric((double)Math.round(bStatusNumeric.getNumeric()), bStatusNumeric.getStatus());
                BKnxNumericProxyExt.this.updateOutput((BStatusValue)bStatusNumeric);
            }
        });
    }

    public void doPresetCount(BValue bValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        final BDouble bDouble = (BDouble)bValue;
        this.network().postWrite(new Runnable(){

            public final void run() {
                BStatusNumeric bStatusNumeric = new BStatusNumeric();
                BStatusNumeric bStatusNumeric2 = new BStatusNumeric(bDouble.getNumeric());
                BKnxNumericProxyExt.this.convertProxyToDevice((BStatusValue)bStatusNumeric2, (BStatusValue)bStatusNumeric);
                bStatusNumeric = new BStatusNumeric((double)Math.round(bStatusNumeric.getNumeric()), bStatusNumeric.getStatus());
                BKnxNumericProxyExt.this.updateOutput((BStatusValue)bStatusNumeric);
            }
        });
    }

    public void doStepDownAction(Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.network().postWrite(new Runnable(){

            public final void run() {
                BInteger bInteger;
                int n;
                if (BKnxNumericProxyExt.this.previouslyDecreasing()) {
                    n = 0;
                } else {
                    bInteger = (BInteger)BKnxNumericProxyExt.this.get("stepSize");
                    if (bInteger == null) {
                        bInteger = BInteger.make((int)1);
                    }
                    if ((n = bInteger.getInt()) > 7) {
                        n = 7;
                    }
                    if (n < 1) {
                        n = 1;
                    }
                }
                bInteger = new BStatusNumeric((double)n);
                BKnxNumericProxyExt.this.updateOutput((BStatusValue)bInteger);
                BKnxNumericProxyExt.this.previousDimmingCommand = n;
            }
        });
    }

    public void doStepUpAction(Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.network().postWrite(new Runnable(){

            public final void run() {
                BInteger bInteger;
                int n;
                if (BKnxNumericProxyExt.this.previouslyIncreasing()) {
                    n = 0;
                } else {
                    bInteger = (BInteger)BKnxNumericProxyExt.this.get("stepSize");
                    if (bInteger == null) {
                        bInteger = BInteger.make((int)1);
                    }
                    if ((n = bInteger.getInt()) > 7) {
                        n = 7;
                    }
                    if (n < 1) {
                        n = 1;
                    }
                }
                bInteger = new BStatusNumeric((double)(n |= 8));
                BKnxNumericProxyExt.this.updateOutput((BStatusValue)bInteger);
                BKnxNumericProxyExt.this.previousDimmingCommand = n;
            }
        });
    }

    public void doStepBreakAction(Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.network().postWrite(new Runnable(){

            public final void run() {
                BStatusNumeric bStatusNumeric = new BStatusNumeric(0.0);
                BKnxNumericProxyExt.this.updateOutput((BStatusValue)bStatusNumeric);
                BKnxNumericProxyExt.this.previousDimmingCommand &= 8;
            }
        });
    }

    private final boolean previouslyDecreasing() {
        boolean bl = false;
        if ((this.previousDimmingCommand & 8) != 8) {
            bl = true;
        }
        boolean bl2 = false;
        if ((this.previousDimmingCommand & 7) > 0) {
            bl2 = true;
        }
        return bl & bl2;
    }

    private final boolean previouslyIncreasing() {
        boolean bl = false;
        if ((this.previousDimmingCommand & 8) == 8) {
            bl = true;
        }
        boolean bl2 = false;
        if ((this.previousDimmingCommand & 7) > 0) {
            bl2 = true;
        }
        return bl & bl2;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.previousDimmingCommand = 0;
    }

    public BKnxNumericProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$eibnetIp$point$BKnxNumericProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$point$BKnxNumericProxyExt = BKnxNumericProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxNumericProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

