/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp.point;

import com.tridium.eibnetIp.messages.LDataInd;
import com.tridium.eibnetIp.messages.LDataReq;
import com.tridium.eibnetIp.point.BKnxProxyExt;
import com.tridium.eibnetIp.util.EibUtil;
import javax.baja.control.BEnumPoint;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BKnxEnumProxyExt
extends BKnxProxyExt {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxEnumProxyExt;

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BEnumPoint;
    }

    public void setValue(LDataInd lDataInd) {
        byte[] byArray;
        try {
            byArray = lDataInd.getData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.readFail("data unavailable");
            return;
        }
        try {
            BValue bValue = this.readOk(byArray);
            this.fireBusDataReceived(bValue);
            this.checkPollOnceSatisfied(lDataInd);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail(illegalArgumentException.getMessage());
        }
    }

    protected BEnum bytesToEnum(byte[] byArray, BDynamicEnum bDynamicEnum) throws IllegalArgumentException {
        switch (this.getDataType().getOrdinal()) {
            case 0: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return bDynamicEnum.getRange().get(byArray[0] & 1);
            }
            case 1: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2010: 
            case 2011: 
            case 2012: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return bDynamicEnum.getRange().get(byArray[0] & 3);
            }
            case 2: 
            case 3007: 
            case 3008: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return bDynamicEnum.getRange().get(byArray[0] & 0xF);
            }
            case 3009: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                int n = byArray[0] & 7;
                if (n == 1) {
                    return bDynamicEnum.getRange().get(0);
                }
                if (n == 2) {
                    return bDynamicEnum.getRange().get(1);
                }
                if (n == 4) {
                    return bDynamicEnum.getRange().get(2);
                }
                throw new IllegalArgumentException("data type cannot be converted to enum:" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 4001: 
            case 4002: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                int n = Character.digit((char)(byArray[0] & 0xFF), 16);
                if (n == -1) {
                    throw new IllegalArgumentException((Object)((Object)this.getDataType()) + " data could not be converted to numeric:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return bDynamicEnum.getRange().get(n);
            }
            case 5001: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return bDynamicEnum.getRange().get((int)Math.round(0.39215686274509803 * (double)(byArray[0] & 0xFF)));
            }
            case 5003: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return bDynamicEnum.getRange().get((int)Math.round(1.411764705882353 * (double)(byArray[0] & 0xFF)));
            }
            case 3: 
            case 5004: 
            case 5010: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return bDynamicEnum.getRange().get((int)byArray[0]);
            }
            case 6010: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return bDynamicEnum.getRange().get((int)byArray[0]);
            }
            case 6020: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                if ((byArray[0] & 7) == 1) {
                    return bDynamicEnum.getRange().get(0);
                }
                if ((byArray[0] & 7) == 2) {
                    return bDynamicEnum.getRange().get(1);
                }
                if ((byArray[0] & 7) == 4) {
                    return bDynamicEnum.getRange().get(2);
                }
                throw new IllegalArgumentException("data does not map to valid mode:" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 4: 
            case 7001: 
            case 7010: {
                if (byArray.length != 2) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                int n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
                return bDynamicEnum.getRange().get(n);
            }
            case 8001: {
                if (byArray.length != 2) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                int n = byArray[0] << 8 | byArray[1] & 0xFF;
                return bDynamicEnum.getRange().get(n);
            }
            case 9001: 
            case 9002: 
            case 9003: 
            case 9004: 
            case 9005: 
            case 9006: 
            case 9010: 
            case 9011: 
            case 9020: 
            case 9021: {
                if (byArray.length != 2) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return bDynamicEnum.getRange().get((int)EibUtil.getFloat16Value(byArray));
            }
            case 5: {
                if (byArray.length != 3) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                int n = byArray[2] & 0xFF | byArray[1] << 8 | byArray[0] << 16;
                return bDynamicEnum.getRange().get(n);
            }
            case 10001: 
            case 11001: {
                throw new IllegalArgumentException("data type cannot be converted to enum:" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 6: 
            case 12001: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                long l = (long)byArray[3] & 0xFFL | ((long)byArray[2] & 0xFFL) << 8 | ((long)byArray[1] & 0xFFL) << 16 | ((long)byArray[0] & 0xFFL) << 24;
                return bDynamicEnum.getRange().get((int)l);
            }
            case 13001: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                long l = (long)byArray[3] & 0xFFL | ((long)byArray[2] & 0xFFL) << 8 | ((long)byArray[1] & 0xFFL) << 16 | (long)byArray[0] << 24;
                return bDynamicEnum.getRange().get((int)l);
            }
            case 14000: 
            case 14001: 
            case 14002: 
            case 14003: 
            case 14004: 
            case 14005: 
            case 14006: 
            case 14007: 
            case 14008: 
            case 14009: 
            case 14010: 
            case 14011: 
            case 14012: 
            case 14013: 
            case 14014: 
            case 14015: 
            case 14016: 
            case 14017: 
            case 14018: 
            case 14019: 
            case 14020: 
            case 14021: 
            case 14022: 
            case 14023: 
            case 14024: 
            case 14025: 
            case 14026: 
            case 14027: 
            case 14028: 
            case 14029: 
            case 14030: 
            case 14031: 
            case 14032: 
            case 14033: 
            case 14034: 
            case 14035: 
            case 14036: 
            case 14037: 
            case 14038: 
            case 14039: 
            case 14040: 
            case 14041: 
            case 14042: 
            case 14043: 
            case 14044: 
            case 14045: 
            case 14046: 
            case 14047: 
            case 14048: 
            case 14049: 
            case 14050: 
            case 14051: 
            case 14052: 
            case 14053: 
            case 14054: 
            case 14055: 
            case 14056: 
            case 14057: 
            case 14058: 
            case 14059: 
            case 14060: 
            case 14061: 
            case 14062: 
            case 14063: 
            case 14064: 
            case 14065: 
            case 14066: 
            case 14067: 
            case 14068: 
            case 14069: 
            case 14070: 
            case 14071: 
            case 14072: 
            case 14073: 
            case 14074: 
            case 14075: 
            case 14076: 
            case 14077: 
            case 14078: 
            case 14079: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return bDynamicEnum.getRange().get((int)EibUtil.getFloat32Value(byArray));
            }
            case 15000: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                throw new IllegalArgumentException("data cannot be converted to enum:" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 16000: {
                String string = new String(byArray);
                try {
                    return bDynamicEnum.getRange().get(string);
                }
                catch (InvalidEnumException invalidEnumException) {
                    throw new IllegalArgumentException("data cannot be converted to enum:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
            }
            case 16001: {
                try {
                    String string = new String(byArray, "ISO-8859-1");
                    return bDynamicEnum.getRange().get(string);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("data cannot be converted to enum:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
            }
        }
        throw new IllegalArgumentException("data type not supported:" + ByteArrayUtil.toHexString((byte[])byArray));
    }

    public void updateOutput(BStatusValue bStatusValue) {
        byte[] byArray;
        if (!(bStatusValue instanceof BStatusEnum)) {
            this.writeFail("unsupported data type");
            return;
        }
        try {
            byArray = this.enumToBytes(((BStatusEnum)bStatusValue).getEnum());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.writeFail(illegalArgumentException.getMessage());
            return;
        }
        boolean bl = this.getDataType().shouldOptimize();
        LDataReq lDataReq = new LDataReq(this.getGroupAddresses().getPrimaryGroupAddress(), byArray, bl);
        boolean bl2 = this.network().getTunnelLayer().sendTunnelRequest(this.device(), lDataReq);
        if (!bl2) {
            this.writeFail("no confirmation");
        } else {
            this.writeOk(bStatusValue);
            this.readOkAll(byArray);
        }
        if (this.getParentPoint().isSubscribed() && this.getPollAfterWrite()) {
            this.pollNow();
        }
    }

    public BValue readOk(byte[] byArray) throws IllegalArgumentException {
        BStatusEnum bStatusEnum = (BStatusEnum)this.getReadValue().newCopy();
        BDynamicEnum bDynamicEnum = bStatusEnum.getValue();
        bStatusEnum.setValue(this.bytesToEnum(byArray, bDynamicEnum));
        this.readOk((BStatusValue)bStatusEnum);
        return bStatusEnum;
    }

    protected byte[] enumToBytes(BEnum bEnum) throws IllegalArgumentException {
        switch (this.getDataType().getOrdinal()) {
            case 0: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: {
                byte[] byArray;
                if (bEnum.getOrdinal() == 0) {
                    byArray = new byte[1];
                } else {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 1;
                }
                return byArray;
            }
            case 1: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2010: 
            case 2011: 
            case 2012: {
                if (bEnum.getOrdinal() > 3 || bEnum.getOrdinal() < 0) {
                    throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
                }
                return new byte[]{(byte)(bEnum.getOrdinal() & 3)};
            }
            case 2: 
            case 3007: 
            case 3008: {
                if (bEnum.getOrdinal() > 15 || bEnum.getOrdinal() < 0) {
                    throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
                }
                return new byte[]{(byte)(bEnum.getOrdinal() & 0xF)};
            }
            case 3009: {
                if (bEnum.getOrdinal() == 0) {
                    return new byte[]{1};
                }
                if (bEnum.getOrdinal() == 1) {
                    return new byte[]{2};
                }
                if (bEnum.getOrdinal() == 2) {
                    return new byte[]{4};
                }
                throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
            }
            case 4001: 
            case 4002: {
                int n = bEnum.getOrdinal();
                if (n < 0) {
                    throw new IllegalArgumentException("enum cannot be converted to " + (Object)((Object)this.getDataType()) + ':' + bEnum);
                }
                if (n < 10) {
                    return new byte[]{(byte)(n + 48)};
                }
                if (n < 16) {
                    return new byte[]{(byte)(n + 55)};
                }
                throw new IllegalArgumentException("enum cannot be converted to " + (Object)((Object)this.getDataType()) + ':' + bEnum);
            }
            case 5001: {
                int n = bEnum.getOrdinal();
                if (n > 100 || n < 0) {
                    throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
                }
                return new byte[]{(byte)((double)n * 255.0 / 100.0)};
            }
            case 5003: {
                int n = bEnum.getOrdinal();
                if (n > 360 || n < 0) {
                    throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
                }
                return new byte[]{(byte)((double)n * 255.0 / 360.0)};
            }
            case 3: 
            case 5004: 
            case 5010: {
                int n = bEnum.getOrdinal();
                if (n > 255 || n < 0) {
                    throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
                }
                return new byte[]{(byte)n};
            }
            case 6010: {
                int n = bEnum.getOrdinal();
                if (n > 127) {
                    throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
                }
                if (n < -128) {
                    throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
                }
                if (n < 0) {
                    n = -1 * n & 0x7F;
                    n = (~n & 0x7F) + 1;
                    n |= 0x80;
                }
                return new byte[]{(byte)n};
            }
            case 6020: {
                int n = bEnum.getOrdinal();
                if (n == 0) {
                    return new byte[]{1};
                }
                if (n == 1) {
                    return new byte[]{2};
                }
                if (n == 2) {
                    return new byte[]{4};
                }
                throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
            }
            case 4: 
            case 7001: 
            case 7010: {
                int n = bEnum.getOrdinal();
                if (n > (char)-1) {
                    throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
                }
                if (n < 0) {
                    throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
                }
                byte[] byArray = new byte[2];
                byArray[1] = (byte)n;
                byArray[0] = (byte)(n >> 8);
                return byArray;
            }
            case 8001: {
                int n = bEnum.getOrdinal();
                if (n > Short.MAX_VALUE) {
                    throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
                }
                if (n < Short.MIN_VALUE) {
                    throw new IllegalArgumentException("ordinal out of range for dataType " + (Object)((Object)this.getDataType()) + ':' + bEnum);
                }
                if (n < 0) {
                    n = -1 * n & Short.MAX_VALUE;
                    n = (~n & Short.MAX_VALUE) + 1;
                    n |= 0x8000;
                }
                byte[] byArray = new byte[2];
                byArray[1] = (byte)n;
                byArray[0] = (byte)(n >> 8);
                return byArray;
            }
            case 9001: 
            case 9002: 
            case 9003: 
            case 9004: 
            case 9005: 
            case 9006: 
            case 9010: 
            case 9011: 
            case 9020: 
            case 9021: {
                int n = bEnum.getOrdinal();
                return EibUtil.encodeFloat16ToBytes(n);
            }
            case 5: 
            case 10001: {
                throw new IllegalArgumentException("ordinal cannot be converted to data type " + (Object)((Object)this.getDataType()));
            }
            case 11001: {
                throw new IllegalArgumentException("ordinal cannot be converted to data type " + (Object)((Object)this.getDataType()));
            }
            case 6: 
            case 12001: {
                long l = bEnum.getOrdinal();
                byte[] byArray = new byte[4];
                byArray[3] = (byte)l;
                byArray[2] = (byte)(l >> 8);
                byArray[1] = (byte)(l >> 16);
                byArray[0] = (byte)(l >> 24);
                return byArray;
            }
            case 13001: {
                long l = bEnum.getOrdinal();
                if (l < 0L) {
                    l = (long)-1 * l & Integer.MAX_VALUE;
                    l = ((l ^ -1L) & Integer.MAX_VALUE) + 1L;
                    l |= Integer.MIN_VALUE;
                }
                byte[] byArray = new byte[2];
                byArray[3] = (byte)l;
                byArray[2] = (byte)(l >> 8);
                byArray[1] = (byte)(l >> 16);
                byArray[0] = (byte)(l >> 24);
                return byArray;
            }
            case 14000: 
            case 14001: 
            case 14002: 
            case 14003: 
            case 14004: 
            case 14005: 
            case 14006: 
            case 14007: 
            case 14008: 
            case 14009: 
            case 14010: 
            case 14011: 
            case 14012: 
            case 14013: 
            case 14014: 
            case 14015: 
            case 14016: 
            case 14017: 
            case 14018: 
            case 14019: 
            case 14020: 
            case 14021: 
            case 14022: 
            case 14023: 
            case 14024: 
            case 14025: 
            case 14026: 
            case 14027: 
            case 14028: 
            case 14029: 
            case 14030: 
            case 14031: 
            case 14032: 
            case 14033: 
            case 14034: 
            case 14035: 
            case 14036: 
            case 14037: 
            case 14038: 
            case 14039: 
            case 14040: 
            case 14041: 
            case 14042: 
            case 14043: 
            case 14044: 
            case 14045: 
            case 14046: 
            case 14047: 
            case 14048: 
            case 14049: 
            case 14050: 
            case 14051: 
            case 14052: 
            case 14053: 
            case 14054: 
            case 14055: 
            case 14056: 
            case 14057: 
            case 14058: 
            case 14059: 
            case 14060: 
            case 14061: 
            case 14062: 
            case 14063: 
            case 14064: 
            case 14065: 
            case 14066: 
            case 14067: 
            case 14068: 
            case 14069: 
            case 14070: 
            case 14071: 
            case 14072: 
            case 14073: 
            case 14074: 
            case 14075: 
            case 14076: 
            case 14077: 
            case 14078: 
            case 14079: {
                int n = bEnum.getOrdinal();
                return EibUtil.encodeFloat32ToBytes(n);
            }
            case 15000: {
                throw new IllegalArgumentException("ordinal cannot be converted to data type " + (Object)((Object)this.getDataType()));
            }
            case 16000: 
            case 16001: {
                String string = bEnum.toString();
                if (string.length() > 14) {
                    string = string.substring(0, 14);
                }
                return string.getBytes();
            }
        }
        throw new IllegalArgumentException("data type not supported:" + (Object)((Object)this.getDataType()));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$eibnetIp$point$BKnxEnumProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$point$BKnxEnumProxyExt = BKnxEnumProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxEnumProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

