/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp.point;

import com.tridium.eibnetIp.messages.LDataInd;
import com.tridium.eibnetIp.messages.LDataReq;
import com.tridium.eibnetIp.point.BKnxProxyExt;
import com.tridium.eibnetIp.util.EibUtil;
import java.io.UnsupportedEncodingException;
import javax.baja.control.BBooleanPoint;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BKnxBooleanProxyExt
extends BKnxProxyExt {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxBooleanProxyExt;

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBooleanPoint;
    }

    public void setValue(LDataInd lDataInd) {
        byte[] byArray;
        try {
            byArray = lDataInd.getData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.readFail("data unavailable");
            return;
        }
        try {
            BValue bValue = this.readOk(byArray);
            this.fireBusDataReceived(bValue);
            this.checkPollOnceSatisfied(lDataInd);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail(illegalArgumentException.getMessage());
        }
    }

    private final boolean bytesToBoolean(byte[] byArray) throws IllegalArgumentException {
        switch (this.getDataType().getOrdinal()) {
            case 0: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                boolean bl = false;
                if (byArray[0] != 0) {
                    bl = true;
                }
                return bl;
            }
            case 1: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2010: 
            case 2011: 
            case 2012: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                boolean bl = false;
                if ((byArray[0] & 1) == 1) {
                    bl = true;
                }
                return bl;
            }
            case 2: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                boolean bl = false;
                if (byArray[0] > 0) {
                    bl = true;
                }
                return bl;
            }
            case 3007: 
            case 3008: 
            case 3009: {
                throw new IllegalArgumentException("data type " + (Object)((Object)this.getDataType()) + " cannot be converted to a boolean:" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 4001: 
            case 4002: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                if (byArray[0] == 48) {
                    return false;
                }
                if (byArray[0] == 49) {
                    return true;
                }
                throw new IllegalArgumentException("data is not a 0(0x30) or 1(0x31):" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 3: 
            case 5001: 
            case 5003: 
            case 5004: 
            case 5010: 
            case 6010: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                boolean bl = false;
                if (byArray[0] != 0) {
                    bl = true;
                }
                return bl;
            }
            case 6020: {
                if ((byArray[0] & 7) == 1) {
                    return false;
                }
                if ((byArray[0] & 7) == 2) {
                    return true;
                }
                if ((byArray[0] & 7) == 4) {
                    return true;
                }
                throw new IllegalArgumentException("data type " + (Object)((Object)this.getDataType()) + " cannot be converted to boolean" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 4: 
            case 7001: 
            case 7010: 
            case 8001: {
                if (byArray.length != 2) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return byArray[0] != 0 || byArray[1] != 0;
            }
            case 9001: 
            case 9002: 
            case 9003: 
            case 9004: 
            case 9005: 
            case 9006: 
            case 9010: 
            case 9011: 
            case 9020: 
            case 9021: {
                if (byArray.length != 2) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                boolean bl = false;
                if (EibUtil.getFloat16Value(byArray) != 0.0f) {
                    bl = true;
                }
                return bl;
            }
            case 5: {
                if (byArray.length != 3) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return byArray[0] != 0 || byArray[1] != 0 || byArray[2] != 0;
            }
            case 10001: 
            case 11001: {
                throw new IllegalArgumentException("data type cannot be converted to boolean" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 6: 
            case 12001: 
            case 13001: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return byArray[0] != 0 || byArray[1] != 0 || byArray[2] != 0 || byArray[3] != 0;
            }
            case 14000: 
            case 14001: 
            case 14002: 
            case 14003: 
            case 14004: 
            case 14005: 
            case 14006: 
            case 14007: 
            case 14008: 
            case 14009: 
            case 14010: 
            case 14011: 
            case 14012: 
            case 14013: 
            case 14014: 
            case 14015: 
            case 14016: 
            case 14017: 
            case 14018: 
            case 14019: 
            case 14020: 
            case 14021: 
            case 14022: 
            case 14023: 
            case 14024: 
            case 14025: 
            case 14026: 
            case 14027: 
            case 14028: 
            case 14029: 
            case 14030: 
            case 14031: 
            case 14032: 
            case 14033: 
            case 14034: 
            case 14035: 
            case 14036: 
            case 14037: 
            case 14038: 
            case 14039: 
            case 14040: 
            case 14041: 
            case 14042: 
            case 14043: 
            case 14044: 
            case 14045: 
            case 14046: 
            case 14047: 
            case 14048: 
            case 14049: 
            case 14050: 
            case 14051: 
            case 14052: 
            case 14053: 
            case 14054: 
            case 14055: 
            case 14056: 
            case 14057: 
            case 14058: 
            case 14059: 
            case 14060: 
            case 14061: 
            case 14062: 
            case 14063: 
            case 14064: 
            case 14065: 
            case 14066: 
            case 14067: 
            case 14068: 
            case 14069: 
            case 14070: 
            case 14071: 
            case 14072: 
            case 14073: 
            case 14074: 
            case 14075: 
            case 14076: 
            case 14077: 
            case 14078: 
            case 14079: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                boolean bl = false;
                if (EibUtil.getFloat32Value(byArray) != 0.0f) {
                    bl = true;
                }
                return bl;
            }
            case 15000: {
                throw new IllegalArgumentException("data type " + (Object)((Object)this.getDataType()) + " cannot be converted to boolean" + ByteArrayUtil.toHexString((byte[])byArray));
            }
            case 16000: 
            case 16001: {
                String string = new String(byArray);
                if (string.equalsIgnoreCase(lex.getText("stringToBoolean.trueTxt"))) {
                    return true;
                }
                if (string.equalsIgnoreCase(lex.getText("stringToBoolean.falseTxt"))) {
                    return false;
                }
                throw new IllegalArgumentException("data type " + (Object)((Object)this.getDataType()) + " cannot be converted to boolean" + ByteArrayUtil.toHexString((byte[])byArray));
            }
        }
        throw new IllegalArgumentException("data type " + (Object)((Object)this.getDataType()) + " cannot be converted to boolean" + ByteArrayUtil.toHexString((byte[])byArray));
    }

    public void updateOutput(BStatusValue bStatusValue) {
        byte[] byArray;
        if (!(bStatusValue instanceof BStatusBoolean)) {
            this.writeFail("unsupported data type");
            return;
        }
        BStatusBoolean bStatusBoolean = (BStatusBoolean)bStatusValue;
        try {
            byArray = this.booleanToBytes(bStatusBoolean);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.writeFail(illegalArgumentException.getMessage());
            return;
        }
        log.trace(this.getGroupAddresses().getPrimaryGroupAddress() + " writing " + ByteArrayUtil.toHexString((byte[])byArray) + '(' + bStatusBoolean.getBoolean() + ')');
        boolean bl = this.getDataType().shouldOptimize();
        LDataReq lDataReq = new LDataReq(this.getGroupAddresses().getPrimaryGroupAddress(), byArray, bl);
        boolean bl2 = this.network().getTunnelLayer().sendTunnelRequest(this.device(), lDataReq);
        if (!bl2) {
            this.writeFail("no confirmation");
        } else {
            this.writeOk(bStatusValue);
            this.readOkAll(byArray);
        }
        if (this.getParentPoint().isSubscribed() && this.getPollAfterWrite()) {
            this.pollNow();
        }
    }

    public BValue readOk(byte[] byArray) throws IllegalArgumentException {
        BStatusBoolean bStatusBoolean = new BStatusBoolean(this.bytesToBoolean(byArray));
        this.readOk((BStatusValue)bStatusBoolean);
        return bStatusBoolean;
    }

    private final byte[] booleanToBytes(BStatusBoolean bStatusBoolean) throws IllegalArgumentException {
        boolean bl = bStatusBoolean.getBoolean();
        switch (this.getDataType().getOrdinal()) {
            case 0: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: {
                byte[] byArray;
                if (bl) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 1;
                } else {
                    byArray = new byte[1];
                }
                return byArray;
            }
            case 1: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2010: 
            case 2011: 
            case 2012: {
                byte[] byArray;
                if (bStatusBoolean.getStatus().isOverridden()) {
                    byte[] byArray3;
                    if (bl) {
                        byte[] byArray4 = new byte[1];
                        byArray3 = byArray4;
                        byArray4[0] = 3;
                    } else {
                        byte[] byArray5 = new byte[1];
                        byArray3 = byArray5;
                        byArray5[0] = 2;
                    }
                    return byArray3;
                }
                if (bl) {
                    byte[] byArray6 = new byte[1];
                    byArray = byArray6;
                    byArray6[0] = 1;
                } else {
                    byArray = new byte[1];
                }
                return byArray;
            }
            case 2: 
            case 3007: 
            case 3008: 
            case 3009: {
                throw new IllegalArgumentException("boolean cannot be converted to data type " + (Object)((Object)this.getDataType()));
            }
            case 4001: 
            case 4002: {
                byte[] byArray;
                if (bl) {
                    byte[] byArray7 = new byte[1];
                    byArray = byArray7;
                    byArray7[0] = 49;
                } else {
                    byte[] byArray8 = new byte[1];
                    byArray = byArray8;
                    byArray8[0] = 49;
                }
                return byArray;
            }
            case 3: 
            case 5001: {
                byte[] byArray;
                if (bl) {
                    byte[] byArray9 = new byte[1];
                    byArray = byArray9;
                    byArray9[0] = -1;
                } else {
                    byArray = new byte[1];
                }
                return byArray;
            }
            case 5003: {
                byte[] byArray;
                if (bl) {
                    byte[] byArray10 = new byte[1];
                    byArray = byArray10;
                    byArray10[0] = 1;
                } else {
                    byArray = new byte[1];
                }
                return byArray;
            }
            case 5004: {
                byte[] byArray;
                if (bl) {
                    byte[] byArray11 = new byte[1];
                    byArray = byArray11;
                    byArray11[0] = 100;
                } else {
                    byArray = new byte[1];
                }
                return byArray;
            }
            case 5010: {
                byte[] byArray;
                if (bl) {
                    byte[] byArray12 = new byte[1];
                    byArray = byArray12;
                    byArray12[0] = 1;
                } else {
                    byArray = new byte[1];
                }
                return byArray;
            }
            case 6010: {
                byte[] byArray;
                if (bl) {
                    byte[] byArray13 = new byte[1];
                    byArray = byArray13;
                    byArray13[0] = 1;
                } else {
                    byArray = new byte[1];
                }
                return byArray;
            }
            case 6020: {
                throw new IllegalArgumentException("boolean cannot be converted to data type " + (Object)((Object)this.getDataType()));
            }
            case 4: 
            case 7001: 
            case 7010: 
            case 8001: {
                if (bl) {
                    byte[] byArray = new byte[2];
                    byArray[1] = 1;
                    return byArray;
                }
                return new byte[2];
            }
            case 9001: 
            case 9002: 
            case 9003: 
            case 9004: 
            case 9005: 
            case 9006: 
            case 9010: 
            case 9011: 
            case 9020: 
            case 9021: {
                if (bl) {
                    return EibUtil.encodeFloat16ToBytes(1.0);
                }
                return EibUtil.encodeFloat16ToBytes(0.0);
            }
            case 5: 
            case 10001: 
            case 11001: {
                throw new IllegalArgumentException("boolean cannot be converted to data type " + (Object)((Object)this.getDataType()));
            }
            case 6: 
            case 12001: 
            case 13001: {
                if (bl) {
                    byte[] byArray = new byte[4];
                    byArray[3] = 1;
                    return byArray;
                }
                return new byte[4];
            }
            case 14000: 
            case 14001: 
            case 14002: 
            case 14003: 
            case 14004: 
            case 14005: 
            case 14006: 
            case 14007: 
            case 14008: 
            case 14009: 
            case 14010: 
            case 14011: 
            case 14012: 
            case 14013: 
            case 14014: 
            case 14015: 
            case 14016: 
            case 14017: 
            case 14018: 
            case 14019: 
            case 14020: 
            case 14021: 
            case 14022: 
            case 14023: 
            case 14024: 
            case 14025: 
            case 14026: 
            case 14027: 
            case 14028: 
            case 14029: 
            case 14030: 
            case 14031: 
            case 14032: 
            case 14033: 
            case 14034: 
            case 14035: 
            case 14036: 
            case 14037: 
            case 14038: 
            case 14039: 
            case 14040: 
            case 14041: 
            case 14042: 
            case 14043: 
            case 14044: 
            case 14045: 
            case 14046: 
            case 14047: 
            case 14048: 
            case 14049: 
            case 14050: 
            case 14051: 
            case 14052: 
            case 14053: 
            case 14054: 
            case 14055: 
            case 14056: 
            case 14057: 
            case 14058: 
            case 14059: 
            case 14060: 
            case 14061: 
            case 14062: 
            case 14063: 
            case 14064: 
            case 14065: 
            case 14066: 
            case 14067: 
            case 14068: 
            case 14069: 
            case 14070: 
            case 14071: 
            case 14072: 
            case 14073: 
            case 14074: 
            case 14075: 
            case 14076: 
            case 14077: 
            case 14078: 
            case 14079: {
                if (bl) {
                    return EibUtil.encodeFloat32ToBytes(1.0);
                }
                return EibUtil.encodeFloat32ToBytes(0.0);
            }
            case 15000: {
                throw new IllegalArgumentException("boolean cannot be converted to data type " + (Object)((Object)this.getDataType()));
            }
            case 16000: 
            case 16001: {
                String string;
                BString bString;
                if (bl) {
                    bString = (BString)this.get("trueTxt");
                    if (bString == null) {
                        throw new IllegalArgumentException("slot trueTxt does not exist");
                    }
                } else {
                    bString = (BString)this.get("falseTxt");
                    if (bString == null) {
                        throw new IllegalArgumentException("slot falseTxt does not exist");
                    }
                }
                if ((string = bString.getString()).length() > 14) {
                    string = string.substring(0, 14);
                }
                if (this.getDataType().getOrdinal() == 16001) {
                    try {
                        return string.getBytes("ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                return string.getBytes();
            }
        }
        throw new IllegalArgumentException("data type not supported");
    }

    public void doTriggerOnAction(Context context) {
        if (!this.isRunning()) {
            return;
        }
        log.trace("BKnxBoolean:doTriggerOnAction " + this.getGroupAddresses().getPrimaryGroupAddress());
        this.network().postWrite(new Runnable(){

            public final void run() {
                BStatusBoolean bStatusBoolean = new BStatusBoolean();
                BStatusBoolean bStatusBoolean2 = new BStatusBoolean(true);
                BKnxBooleanProxyExt.this.convertProxyToDevice((BStatusValue)bStatusBoolean2, (BStatusValue)bStatusBoolean);
                BKnxBooleanProxyExt.this.updateOutput((BStatusValue)bStatusBoolean);
            }
        });
    }

    public void doTriggerOffAction(Context context) {
        if (!this.isRunning()) {
            return;
        }
        log.trace("BKnxBoolean:doTriggerOnAction " + this.getGroupAddresses().getPrimaryGroupAddress());
        this.network().postWrite(new Runnable(){

            public final void run() {
                BStatusBoolean bStatusBoolean = new BStatusBoolean();
                BStatusBoolean bStatusBoolean2 = new BStatusBoolean(false);
                BKnxBooleanProxyExt.this.convertProxyToDevice((BStatusValue)bStatusBoolean2, (BStatusValue)bStatusBoolean);
                BKnxBooleanProxyExt.this.updateOutput((BStatusValue)bStatusBoolean);
            }
        });
    }

    public void doToggleAction(Context context) {
        if (!this.isRunning()) {
            return;
        }
        log.trace("BKnxBoolean:doTriggerOnAction " + this.getGroupAddresses().getPrimaryGroupAddress());
        BBooleanPoint bBooleanPoint = (BBooleanPoint)this.getParentPoint();
        final boolean bl = bBooleanPoint.getOut().getBoolean() ^ true;
        this.network().postWrite(new Runnable(){

            public final void run() {
                BStatusBoolean bStatusBoolean = new BStatusBoolean();
                BStatusBoolean bStatusBoolean2 = new BStatusBoolean(bl);
                BKnxBooleanProxyExt.this.convertProxyToDevice((BStatusValue)bStatusBoolean2, (BStatusValue)bStatusBoolean);
                BKnxBooleanProxyExt.this.updateOutput((BStatusValue)bStatusBoolean);
            }
        });
    }

    public void doSwitchControlOnAction(Context context) {
        if (!this.isRunning()) {
            return;
        }
        log.trace("BKnxBoolean:doSwitchControlOnAction " + this.getGroupAddresses().getPrimaryGroupAddress());
        this.network().postWrite(new Runnable(){

            public final void run() {
                BStatusBoolean bStatusBoolean = new BStatusBoolean();
                BStatusBoolean bStatusBoolean2 = new BStatusBoolean(true, BStatus.make((int)32));
                BKnxBooleanProxyExt.this.convertProxyToDevice((BStatusValue)bStatusBoolean2, (BStatusValue)bStatusBoolean);
                BKnxBooleanProxyExt.this.updateOutput((BStatusValue)bStatusBoolean);
            }
        });
    }

    public void doSwitchControlOffAction(Context context) {
        if (!this.isRunning()) {
            return;
        }
        log.trace("BKnxBoolean:doSwitchControlOffAction " + this.getGroupAddresses().getPrimaryGroupAddress());
        this.network().postWrite(new Runnable(){

            public final void run() {
                BStatusBoolean bStatusBoolean = new BStatusBoolean();
                BStatusBoolean bStatusBoolean2 = new BStatusBoolean(false, BStatus.make((int)32));
                BKnxBooleanProxyExt.this.convertProxyToDevice((BStatusValue)bStatusBoolean2, (BStatusValue)bStatusBoolean);
                BKnxBooleanProxyExt.this.updateOutput((BStatusValue)bStatusBoolean);
            }
        });
    }

    public void doSwitchControlAutoAction(Context context) {
        if (!this.isRunning()) {
            return;
        }
        log.trace("BKnxBoolean:doSwitchControlAutoAction " + this.getGroupAddresses().getPrimaryGroupAddress());
        this.network().postWrite(new Runnable(){

            public final void run() {
                BStatusBoolean bStatusBoolean = new BStatusBoolean();
                BStatusBoolean bStatusBoolean2 = new BStatusBoolean(false, BStatus.make((int)64));
                BKnxBooleanProxyExt.this.convertProxyToDevice((BStatusValue)bStatusBoolean2, (BStatusValue)bStatusBoolean);
                BKnxBooleanProxyExt.this.updateOutput((BStatusValue)bStatusBoolean);
            }
        });
    }

    public void doSet(BValue bValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        log.trace("BKnxBoolean:doSet " + this.getGroupAddresses().getPrimaryGroupAddress());
        final BStatusBoolean bStatusBoolean = new BStatusBoolean(((BBoolean)bValue).getBoolean(), BStatus.make((int)64));
        this.network().postWrite(new Runnable(){

            public final void run() {
                BStatusBoolean bStatusBoolean2 = new BStatusBoolean();
                BKnxBooleanProxyExt.this.convertProxyToDevice((BStatusValue)bStatusBoolean, (BStatusValue)bStatusBoolean2);
                BKnxBooleanProxyExt.this.updateOutput((BStatusValue)bStatusBoolean2);
            }
        });
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$eibnetIp$point$BKnxBooleanProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$point$BKnxBooleanProxyExt = BKnxBooleanProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxBooleanProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

