/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp.messages;

import com.tridium.eibnetIp.EibnetConst;
import com.tridium.eibnetIp.datatypes.BGroupAddress;
import com.tridium.eibnetIp.datatypes.BIndividualAddress;
import com.tridium.eibnetIp.datatypes.EibAddress;
import com.tridium.eibnetIp.messages.EibnetIpInputStream;
import com.tridium.eibnetIp.messages.EibnetIpOutputStream;
import com.tridium.eibnetIp.messages.LDataCon;
import com.tridium.eibnetIp.messages.LDataInd;
import com.tridium.eibnetIp.messages.LDataReq;
import java.io.IOException;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class CEmiMessage
implements EibnetConst {
    EibAddress destination;
    BIndividualAddress source;
    byte[] bytes;
    byte[] data;
    int pduType;
    boolean optimized;
    int routeCount;
    int priority;
    boolean decoded;
    int telegramType;
    int ctrl1;
    int ctrl2;
    int appControlField;
    boolean confirmOk;

    public byte[] toBytes() {
        EibnetIpOutputStream eibnetIpOutputStream = EibnetIpOutputStream.make();
        eibnetIpOutputStream.write(this.telegramType);
        eibnetIpOutputStream.write(0);
        eibnetIpOutputStream.write(188);
        eibnetIpOutputStream.write(224);
        eibnetIpOutputStream.writeInt(this.source.toInteger());
        eibnetIpOutputStream.writeInt(this.destination.toInteger());
        if (this.optimized) {
            eibnetIpOutputStream.write(this.data.length);
        } else {
            eibnetIpOutputStream.write(this.data.length + 1);
        }
        if (this.pduType == 64 || this.pduType == 128) {
            if (this.optimized) {
                eibnetIpOutputStream.writeInt(this.data[0] & 0x3F | this.pduType);
            } else {
                eibnetIpOutputStream.writeInt(this.pduType);
                try {
                    eibnetIpOutputStream.write(this.data);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else if (this.pduType == 0) {
            eibnetIpOutputStream.write(this.pduType);
            eibnetIpOutputStream.write(0);
        }
        this.bytes = eibnetIpOutputStream.toByteArray();
        return this.bytes;
    }

    public void writeAppControlField(EibnetIpOutputStream eibnetIpOutputStream) {
        eibnetIpOutputStream.writeInt(0);
    }

    public static CEmiMessage fromBytes(byte[] byArray) {
        switch (byArray[0] & 0xFF) {
            case 17: {
                return new LDataReq(byArray);
            }
            case 46: {
                LDataCon lDataCon = new LDataCon(byArray);
                try {
                    lDataCon.decodeBytes();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
                return lDataCon;
            }
            case 41: {
                LDataInd lDataInd = new LDataInd(byArray);
                try {
                    lDataInd.decodeBytes();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
                return lDataInd;
            }
        }
        return null;
    }

    public void decodeBytes() throws IOException {
        if (this.decoded) {
            return;
        }
        if (this.bytes == null) {
            throw new IOException("no message bytes");
        }
        EibnetIpInputStream eibnetIpInputStream = EibnetIpInputStream.make(this.getBytes());
        this.telegramType = eibnetIpInputStream.read();
        int n = 0;
        while (n < eibnetIpInputStream.read()) {
            eibnetIpInputStream.read();
            ++n;
        }
        this.ctrl1 = eibnetIpInputStream.read();
        this.ctrl2 = eibnetIpInputStream.read();
        this.setSource(eibnetIpInputStream.readIndividualAddress());
        if ((this.ctrl2 & 0x80) == 128) {
            this.setDestination(eibnetIpInputStream.readGroupAddress());
        } else {
            this.setDestination(eibnetIpInputStream.readIndividualAddress());
        }
        this.routeCount = (this.ctrl2 & 0x70) >> 4;
        this.priority = (this.ctrl1 & 0xC) >> 2;
        boolean bl = false;
        if ((this.ctrl1 & 1) == 0) {
            bl = true;
        }
        this.confirmOk = bl;
        this.data = new byte[eibnetIpInputStream.read()];
        n = eibnetIpInputStream.read();
        eibnetIpInputStream.read(this.data, 0, this.data.length);
        this.appControlField = (n & 3) << 8 | this.data[0] & 0xFF;
        if ((this.appControlField & 0x3C0) == 64) {
            this.appControlField = 64;
        } else if ((this.appControlField & 0x3C0) == 128) {
            this.appControlField = 128;
        }
        if (this.data.length == 1) {
            this.data[0] = (byte)(this.data[0] & 0x3F);
        } else {
            byte[] byArray = new byte[this.data.length - 1];
            System.arraycopy(this.data, 1, byArray, 0, this.data.length - 1);
            this.data = byArray;
        }
        this.decoded = true;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    public EibAddress getDestination() {
        return this.destination;
    }

    public void setDestination(EibAddress eibAddress) {
        this.destination = eibAddress;
    }

    public BIndividualAddress getSource() {
        return this.source;
    }

    public void setSource(BIndividualAddress bIndividualAddress) {
        this.source = bIndividualAddress;
    }

    public String getPduDescription(int n) {
        switch (n) {
            case 0: {
                return "Read    ";
            }
            case 64: {
                return "Response";
            }
            case 128: {
                return "Write   ";
            }
        }
        return "illegal pdu type";
    }

    public String toString() {
        if (this.getBytes() == null) {
            return "cemi message bytes null";
        }
        if (!this.decoded) {
            try {
                this.decodeBytes();
            }
            catch (IOException iOException) {
                return "cemi error decoding";
            }
        }
        String string = "low";
        switch (this.priority) {
            case 0: {
                string = "sys";
                break;
            }
            case 1: {
                string = "nor";
                break;
            }
            case 2: {
                string = "urg";
                break;
            }
            default: {
                string = "low";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.telegramType == 41) {
            stringBuffer.append("LDataInd:");
        } else if (this.telegramType == 46) {
            stringBuffer.append("LDataCon:");
        } else if (this.telegramType == 17) {
            stringBuffer.append("LDataReq:");
        } else {
            stringBuffer.append("unknown telegram type:");
        }
        stringBuffer.append("priority=").append(string).append(" ").append(this.getSource().getAddress()).append("-->").append(this.getDestination()).append(" rout=").append(Integer.toString(this.routeCount)).append(" pdu=").append(this.getPduDescription(this.appControlField));
        if (this.appControlField != 0) {
            stringBuffer.append(" data=" + ByteArrayUtil.toHexString((byte[])this.data));
        }
        if (this.telegramType == 46) {
            stringBuffer.append(this.confirmOk ? " confirm-ok" : " confirm-error");
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.destination = new BGroupAddress();
        this.source = new BIndividualAddress();
        this.bytes = null;
        this.routeCount = 6;
        this.priority = 3;
        this.appControlField = -1;
    }

    public CEmiMessage() {
        this.this();
        this.data = new byte[1];
        this.data[0] = 0;
        this.optimized = true;
    }

    public CEmiMessage(BGroupAddress bGroupAddress) {
        this.this();
        this.data = new byte[1];
        this.destination = bGroupAddress;
        this.pduType = 0;
        this.optimized = true;
    }

    public CEmiMessage(BGroupAddress bGroupAddress, byte[] byArray, boolean bl) {
        this.this();
        this.data = byArray;
        this.destination = bGroupAddress;
        this.pduType = 128;
        this.optimized = byArray.length > 1 ? false : bl;
    }
}

