/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetOws.ui.device;

import com.tridium.bacnet.ui.device.BBacnetDeviceManager;
import com.tridium.bacnet.ui.device.BacnetDeviceController;
import com.tridium.bacnetOws.datatypes.BGetESummConfig;
import com.tridium.bacnetOws.datatypes.BGetEventInfoConfig;
import com.tridium.bacnetOws.ui.device.BBacnetOwsDeviceManager;
import java.text.MessageFormat;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrController;

public class BacnetOwsDeviceController
extends BacnetDeviceController {
    public final MgrController.MgrCommand getEventInformation;
    public final MgrController.MgrCommand getEnrollmentSummary;

    protected MgrController.IMgrCommand[] makeBacnetCommands() {
        return BacnetOwsDeviceController.append((MgrController.IMgrCommand[])super.makeBacnetCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.getEventInformation, this.getEnrollmentSummary});
    }

    protected void setBacnetCommandsEnable(boolean bl) {
        super.setBacnetCommandsEnable(bl);
        if (bl) {
            BComponent[] bComponentArray = this.getSelectedComponentsWithoutFolders();
            boolean bl2 = false;
            if (bComponentArray.length == 1) {
                bl2 = true;
            }
            this.getEventInformation.setEnabled(bl2);
            this.getEnrollmentSummary.setEnabled(bl2);
        } else {
            this.getEventInformation.setEnabled(false);
            this.getEnrollmentSummary.setEnabled(false);
        }
    }

    public CommandArtifact doGetEventInformation() throws Exception {
        try {
            int n = BDialog.confirm((BWidget)this.getManager(), (String)this.lex().get("getEventInfo.label"), (Object)this.lex().get("getEventInfo.confirm"), (int)3);
            if (n == 2) {
                return null;
            }
            BComponent[] bComponentArray = this.getSelectedComponentsWithoutFolders();
            BBacnetDevice bBacnetDevice = (BBacnetDevice)bComponentArray[0];
            BBacnetNetwork bBacnetNetwork = ((BBacnetDeviceManager)this.getManager()).getNetwork();
            BGetEventInfoConfig bGetEventInfoConfig = new BGetEventInfoConfig();
            bGetEventInfoConfig.setObjectId(bBacnetDevice.getObjectId());
            this.setJob(bBacnetNetwork.submitDeviceManagerJob((BValue)bGetEventInfoConfig));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = MessageFormat.format(this.lex().get("getEventInfo.fail"), exception);
            BDialog.message((BWidget)this.getManager(), (String)this.lex().get("getEventInfo.title"), (Object)string);
        }
        return null;
    }

    public CommandArtifact doGetEnrollmentSummary() throws Exception {
        try {
            BGetESummConfig bGetESummConfig = (BGetESummConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)this.lex().get("getESumm.title"), (BObject)new BGetESummConfig());
            if (bGetESummConfig != null) {
                BComponent[] bComponentArray = this.getSelectedComponentsWithoutFolders();
                BBacnetDevice bBacnetDevice = (BBacnetDevice)bComponentArray[0];
                BBacnetNetwork bBacnetNetwork = ((BBacnetDeviceManager)this.getManager()).getNetwork();
                bGetESummConfig.setDeviceAddress((BBacnetAddress)bBacnetDevice.getAddress().newCopy());
                this.setJob(bBacnetNetwork.submitDeviceManagerJob((BValue)bGetESummConfig));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BDialog.message((BWidget)this.getManager(), (String)this.lex().get("getESumm.title"), (Object)this.lex().get("getESumm.fail"));
        }
        return null;
    }

    private final UiLexicon lex() {
        return BBacnetOwsDeviceManager.owslex;
    }

    protected BacnetOwsDeviceController(BBacnetOwsDeviceManager bBacnetOwsDeviceManager) {
        super((BBacnetDeviceManager)bBacnetOwsDeviceManager);
        this.getEventInformation = new GetEventInformation((BWidget)bBacnetOwsDeviceManager);
        this.getEnrollmentSummary = new GetEnrollmentSummary((BWidget)bBacnetOwsDeviceManager);
        this.getEventInformation.setFlags(7);
        this.getEnrollmentSummary.setFlags(7);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class GetEventInformation
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return BacnetOwsDeviceController.this.doGetEventInformation();
        }

        GetEventInformation(BWidget bWidget) {
            super(bWidget, (Lexicon)BacnetOwsDeviceController.this.lex(), "getEventInfo");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class GetEnrollmentSummary
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return BacnetOwsDeviceController.this.doGetEnrollmentSummary();
        }

        GetEnrollmentSummary(BWidget bWidget) {
            super(bWidget, (Lexicon)BacnetOwsDeviceController.this.lex(), "getESumm");
        }
    }
}

