/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetOws.job;

import com.tridium.bacnet.asn.NEnrollmentSummary;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnetOws.datatypes.BGetESummConfig;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.job.BJobState;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BGetEnrollmentSummaryJob
extends BDeviceManagerJob {
    public static final Type TYPE;
    static Lexicon lex;
    private BGetESummConfig params;
    static /* synthetic */ Class class$com$tridium$bacnetOws$job$BGetEnrollmentSummaryJob;

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        if (log.isTraceOn()) {
            log.trace("Getting enrollment information from " + this.params.getDeviceAddress() + "\nCriteria:" + (Object)((Object)this.params));
        }
        try {
            Vector vector = this.client().getEnrollmentSummary(this.params.getDeviceAddress(), this.params.getAcknowledgmentFilter().getOrdinal(), this.params.getEnrollmentFilter(), this.params.getEventState().getOrdinal(), this.params.getEventTypeFilter(), new int[]{this.params.getPriority().getMinPriority(), this.params.getPriority().getMaxPriority()}, this.params.getNotificationClassFilter());
            log.trace("Enrollment Summary response:");
            Iterator iterator = vector.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                NEnrollmentSummary nEnrollmentSummary = (NEnrollmentSummary)iterator.next();
                System.out.println("\nEnrollmentSummary #" + ++n + ':' + nEnrollmentSummary);
                this.add(null, (BValue)nEnrollmentSummary.toJob());
            }
            System.out.println("\n");
            this.log().success(lex.getText("getESumm.success"));
            this.complete(BJobState.success);
        }
        catch (Exception exception) {
            log.message("Exception sending GetEnrollmentSummary to " + this.params.getDeviceAddress() + ": " + exception, (Throwable)exception);
            String string = MessageFormat.format(lex.getText("getESumm.fail"), exception);
            this.add("failureCause", (BValue)BString.make((String)exception.toString()));
            this.log().failed(string);
            throw exception;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BGetEnrollmentSummaryJob() {
    }

    public BGetEnrollmentSummaryJob(BBacnetNetwork bBacnetNetwork, BGetESummConfig bGetESummConfig) {
        super(bBacnetNetwork);
        this.params = bGetESummConfig;
        this.add("filter", (BValue)bGetESummConfig);
    }

    static {
        Class clazz = class$com$tridium$bacnetOws$job$BGetEnrollmentSummaryJob;
        if (clazz == null) {
            clazz = class$com$tridium$bacnetOws$job$BGetEnrollmentSummaryJob = BGetEnrollmentSummaryJob.class("[Lcom.tridium.bacnetOws.job.BGetEnrollmentSummaryJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"bacnetOws");
    }
}

