/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platUsbmon;

import com.tridium.platUsbmon.BUsbmonNotification;
import com.tridium.platform.BPlatformService;
import com.tridium.usbmon.BIUsbMonitorService;
import com.tridium.usbmon.BUsbDevice;
import com.tridium.usbmon.BUsbFlashDrive;
import com.tridium.usbmon.BUsbKeyboard;
import com.tridium.usbmon.BUsbMouse;
import com.tridium.usbmon.BUsbTouchscreen;
import com.tridium.usbmon.UsbMonitorListener;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BUsbMonitorPlatformService
extends BPlatformService
implements BIUsbMonitorService,
UsbMonitorListener {
    public static final Type TYPE;
    private static final BIcon icon;
    public static final int DCLASS_MASS_STORAGE = 8;
    public static final int DCLASS_HID = 3;
    public static final int PROTOCOL_HID_MOUSE = 2;
    public static final int PROTOCOL_HID_KEYBOARD = 1;
    public static final int VID_DIALOGUE = 5345;
    public static final int DID_PENMOUNT1 = 20480;
    public static final int DID_PENMOUNT2 = 24576;
    public static Log log;
    private Queue queue;
    private Vector listeners;
    private UsbProcessThread usbProcessThread;
    private int mouseCount;
    private int keyboardCount;
    private int touchscreenCount;
    private boolean running;
    static /* synthetic */ Class class$com$tridium$platUsbmon$BUsbMonitorPlatformService;
    static /* synthetic */ Class class$com$tridium$usbmon$BUsbFlashDrive;

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.setPlatformServiceDescription(this.getLexicon().getText("UsbMonitorPlatformService.description"));
        this.setHasMouse(false);
        this.setHasKeyboard(false);
        this.setHasTouchscreen(false);
        this.addListener(this);
        this.usbProcessThread = new UsbProcessThread();
        this.running = true;
        this.usbProcessThread.start();
        this.loadLibraries();
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        Class clazz = class$com$tridium$usbmon$BUsbFlashDrive;
        if (clazz == null) {
            clazz = class$com$tridium$usbmon$BUsbFlashDrive = BUsbMonitorPlatformService.class("[Lcom.tridium.usbmon.BUsbFlashDrive;", false);
        }
        BUsbFlashDrive[] bUsbFlashDriveArray = (BUsbFlashDrive[])this.getChildren(clazz);
        int n = 0;
        while (n < bUsbFlashDriveArray.length) {
            this.umount(bUsbFlashDriveArray[n]);
            ++n;
        }
    }

    public void addListener(UsbMonitorListener usbMonitorListener) {
        this.listeners.addElement(usbMonitorListener);
    }

    public void removeListener(UsbMonitorListener usbMonitorListener) {
        this.listeners.removeElement(usbMonitorListener);
    }

    private final void processMessage(UsbMessage usbMessage) {
        try {
            BUsbDevice bUsbDevice = usbMessage.getDevice();
            String string = "usb" + this.toHexString(bUsbDevice.getPath(), 2) + this.toHexString(bUsbDevice.getDevno(), 2);
            log.trace("processing message " + string + ": " + usbMessage.toString());
            switch (usbMessage.getCommand()) {
                case 0: {
                    if (bUsbDevice instanceof BUsbFlashDrive) {
                        this.mount((BUsbFlashDrive)bUsbDevice);
                    }
                    log.trace("adding device " + string + " to service");
                    this.add(string, (BValue)bUsbDevice, 3);
                    this.notifyGuis(usbMessage);
                    Iterator iterator = this.listeners.iterator();
                    while (iterator.hasNext()) {
                        UsbMonitorListener usbMonitorListener = (UsbMonitorListener)iterator.next();
                        usbMonitorListener.deviceInserted(bUsbDevice);
                    }
                    break;
                }
                case 1: {
                    try {
                        bUsbDevice = (BUsbDevice)this.get(string);
                        this.notifyGuis(usbMessage);
                        Iterator iterator = this.listeners.iterator();
                        while (iterator.hasNext()) {
                            UsbMonitorListener usbMonitorListener = (UsbMonitorListener)iterator.next();
                            usbMonitorListener.deviceRemoved(bUsbDevice);
                        }
                        log.trace("removing device " + string + " to service");
                        this.remove((BComplex)bUsbDevice);
                        if (bUsbDevice instanceof BUsbFlashDrive) {
                            this.umount((BUsbFlashDrive)bUsbDevice);
                        }
                    }
                    catch (NoSuchSlotException noSuchSlotException) {
                        log.error("unable to find matching device", (Throwable)noSuchSlotException);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            log.error("unhandled usbmon exception", (Throwable)exception);
        }
    }

    private final void notifyGuis(UsbMessage usbMessage) {
        BUsbmonNotification bUsbmonNotification = new BUsbmonNotification();
        if (usbMessage.getCommand() == 0) {
            bUsbmonNotification.add("inserted", (BValue)BBoolean.TRUE);
            bUsbmonNotification.add("message", (BValue)BString.make((String)"device inserted"));
        } else {
            bUsbmonNotification.add("inserted", (BValue)BBoolean.FALSE);
            bUsbmonNotification.add("message", (BValue)BString.make((String)"device removed"));
        }
        bUsbmonNotification.add("icon", (BValue)usbMessage.getDevice().getIcon());
        bUsbmonNotification.add("title", (BValue)BString.make((String)TextUtil.toFriendly((String)usbMessage.getDevice().getType().getTypeName())));
        bUsbmonNotification.add("undo", (BValue)BBoolean.FALSE);
        bUsbmonNotification.raise(true);
    }

    private final BUsbDevice createDevice(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        BUsbFlashDrive bUsbFlashDrive = null;
        log.trace("creating device path[" + n + "] devno[" + n2 + "] vid[" + n3 + "] did[" + n4 + "] dclass[" + n5 + "] subclass[" + n6 + "] protocol[" + n7 + ']');
        block0 : switch (n5) {
            case 8: {
                bUsbFlashDrive = new BUsbFlashDrive(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 3: {
                switch (n7) {
                    case 2: {
                        if (n3 == 5345 && (n4 == 20480 || n4 == 24576)) {
                            bUsbFlashDrive = new BUsbTouchscreen(n, n2, n3, n4, n5, n6, n7);
                            break block0;
                        }
                        bUsbFlashDrive = new BUsbMouse(n, n2, n3, n4, n5, n6, n7);
                        break block0;
                    }
                    case 1: {
                        bUsbFlashDrive = new BUsbKeyboard(n, n2, n3, n4, n5, n6, n7);
                        break block0;
                    }
                }
                break;
            }
        }
        return bUsbFlashDrive;
    }

    protected String toHexString(int n, int n2) {
        String string = Integer.toHexString(n);
        if (string.length() == n2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    protected void mount(BUsbFlashDrive bUsbFlashDrive) {
    }

    protected void umount(BUsbFlashDrive bUsbFlashDrive) {
    }

    protected void deviceInserted(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        BUsbDevice bUsbDevice = this.createDevice(n, n2, n3, n4, n5, n6, n7);
        if (bUsbDevice != null) {
            this.queue.enqueue((Object)new UsbMessage(0, bUsbDevice));
        }
    }

    protected void deviceRemoved(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        BUsbDevice bUsbDevice = this.createDevice(n, n2, n3, n4, n5, n6, n7);
        if (bUsbDevice != null) {
            this.queue.enqueue((Object)new UsbMessage(1, bUsbDevice));
        }
    }

    protected abstract boolean loadLibraries();

    public void deviceInserted(BUsbDevice bUsbDevice) {
        if (bUsbDevice instanceof BUsbMouse) {
            if (bUsbDevice instanceof BUsbTouchscreen) {
                ++this.touchscreenCount;
                if (this.touchscreenCount == 1) {
                    log.trace("setting ui hasTouchscreen to true");
                    this.setHasTouchscreen(true);
                }
            } else {
                ++this.mouseCount;
                if (this.mouseCount == 1) {
                    log.trace("setting ui hasMouse to true");
                    this.setHasMouse(true);
                }
            }
        }
        if (bUsbDevice instanceof BUsbKeyboard) {
            ++this.keyboardCount;
            if (this.keyboardCount == 1) {
                log.trace("setting ui hasKeyboard to true");
                this.setHasKeyboard(true);
            }
        }
    }

    public void deviceRemoved(BUsbDevice bUsbDevice) {
        if (bUsbDevice instanceof BUsbMouse) {
            if (bUsbDevice instanceof BUsbTouchscreen) {
                --this.touchscreenCount;
                if (this.touchscreenCount <= 0) {
                    log.trace("setting ui hasTouchscreen to false");
                    this.setHasTouchscreen(false);
                }
            } else {
                --this.mouseCount;
                if (this.mouseCount <= 0) {
                    log.trace("setting ui hasMouse to false");
                    this.setHasMouse(false);
                }
            }
        }
        if (bUsbDevice instanceof BUsbKeyboard) {
            --this.keyboardCount;
            if (this.keyboardCount <= 0) {
                log.trace("setting ui hasKeyboard to false");
                this.setHasKeyboard(false);
            }
        }
    }

    private final void setHasMouse(boolean bl) {
        try {
            Class clazz = Sys.loadClass((String)"bajaui", (String)"com.tridium.ui.UiEnv");
            Method method = clazz.getDeclaredMethod("get", null);
            Object object = method.invoke(null, null);
            Method method2 = clazz.getDeclaredMethod("setHasMouse", Boolean.TYPE);
            method2.invoke(object, new Boolean(bl));
        }
        catch (Exception exception) {
            log.trace("unable to set hasMouse", (Throwable)exception);
        }
    }

    private final void setHasKeyboard(boolean bl) {
        try {
            Class clazz = Sys.loadClass((String)"bajaui", (String)"com.tridium.ui.UiEnv");
            Method method = clazz.getDeclaredMethod("get", null);
            Object object = method.invoke(null, null);
            Method method2 = clazz.getDeclaredMethod("setHasKeyboard", Boolean.TYPE);
            method2.invoke(object, new Boolean(bl));
        }
        catch (Exception exception) {
            log.trace("unable to set hasKeyboard", (Throwable)exception);
        }
    }

    private final void setHasTouchscreen(boolean bl) {
        try {
            Class clazz = Sys.loadClass((String)"bajaui", (String)"com.tridium.ui.UiEnv");
            Method method = clazz.getDeclaredMethod("get", null);
            Object object = method.invoke(null, null);
            Method method2 = clazz.getDeclaredMethod("setHasTouchscreen", Boolean.TYPE);
            method2.invoke(object, new Boolean(bl));
        }
        catch (Exception exception) {
            log.trace("unable to set hasKeyboard", (Throwable)exception);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.queue = new Queue();
        this.listeners = new Vector();
        this.mouseCount = 0;
        this.keyboardCount = 0;
        this.touchscreenCount = 0;
        this.running = false;
    }

    public BUsbMonitorPlatformService() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platUsbmon$BUsbMonitorPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platUsbmon$BUsbMonitorPlatformService = BUsbMonitorPlatformService.class("[Lcom.tridium.platUsbmon.BUsbMonitorPlatformService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"usbPort.png");
        log = Log.getLog((String)"usbmon");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UsbProcessThread
    extends Thread {
        public void run() {
            while (BUsbMonitorPlatformService.this.running) {
                try {
                    UsbMessage usbMessage = (UsbMessage)BUsbMonitorPlatformService.this.queue.dequeue(1000);
                    if (usbMessage == null) continue;
                    BUsbMonitorPlatformService.this.processMessage(usbMessage);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public UsbProcessThread() {
            super("tUsbProcessThread");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UsbMessage {
        public static final int INSERTED_CMD = 0;
        public static final int REMOVED_CMD = 1;
        private BUsbDevice device;
        private int cmd;

        public int getCommand() {
            return this.cmd;
        }

        public BUsbDevice getDevice() {
            return this.device;
        }

        public String toString() {
            if (this.cmd == 0) {
                return "inserted -> " + this.device.summaryString();
            }
            return "removed -> " + this.device.summaryString();
        }

        public UsbMessage(int n, BUsbDevice bUsbDevice) {
            this.cmd = n;
            this.device = bUsbDevice;
        }
    }
}

