/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver.serial;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.BCommPlugIn;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.util.BasicException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.data.BIDataValue;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSerialComm
extends BCommPlugIn
implements BISerialHelperParent {
    public static final Property interMessageDelay = BSerialComm.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property serialPortConfig = BSerialComm.newProperty((int)0, (BValue)new BSerialHelper(), null);
    public static final Type TYPE;
    private static final long MIN_SLEEP_TIME = 10L;
    private BISerialPort serialPort;
    private InputStream in;
    private OutputStream out;
    private Thread rxThread;
    private long lastRecvMessageTicks;
    static /* synthetic */ Class class$com$tridium$basicdriver$serial$BSerialComm;

    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public void setInterMessageDelay(BRelTime bRelTime) {
        this.set(interMessageDelay, (BValue)bRelTime, null);
    }

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper bSerialHelper) {
        this.set(serialPortConfig, (BValue)bSerialHelper, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void reopenPort() {
        try {
            String string = this.getSerialPortConfig().getPortName();
            if (string.equals("none")) {
                this.getNetwork().configFail("No port selected for serial communication.");
                this.getNetwork().stopComm();
                return;
            }
            this.restartSerialNetwork();
        }
        catch (Exception exception) {
            this.getNetwork().getLog().error("BSerialNetwork caught exception in reopenPort(): ", (Throwable)exception);
        }
    }

    private final void restartSerialNetwork() throws Exception {
        BBasicNetwork bBasicNetwork = this.getNetwork();
        if (!(bBasicNetwork.isDisabled() || bBasicNetwork.isDown() || bBasicNetwork.isFatalFault())) {
            if (bBasicNetwork.getLog().isTraceOn()) {
                bBasicNetwork.getLog().trace(this.getName() + " *** Restarting serial comm ***");
            }
            bBasicNetwork.stopComm();
            bBasicNetwork.startComm();
        }
    }

    public boolean commStarted() throws Exception {
        Object object;
        try {
            object = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            this.serialPort = this.getSerialPortConfig().open(this.getNetwork().getName());
            this.serialPort.enableReceiveTimeout(object.getMinTimeout());
            this.in = this.serialPort.getInputStream();
            this.out = this.serialPort.getOutputStream();
        }
        catch (Exception exception) {
            String string = "Error opening and configuring the serial port";
            this.getNetwork().getLog().error(string, (Throwable)exception);
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception exception2) {
                    this.getNetwork().getLog().error("Unable to close serial input stream.", (Throwable)exception2);
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception exception3) {
                    this.getNetwork().getLog().error("Unable to close serial output stream.", (Throwable)exception3);
                }
            }
            if (this.serialPort != null) {
                this.serialPort.close();
            }
            throw exception;
        }
        object = this.getCommReceiver();
        ((CommReceiver)object).setInputStream(this.in);
        this.getCommTransmitter().setOutputStream(this.out);
        this.rxThread = new Thread((Runnable)object, "SerialRcv:" + this.getNetwork().getName());
        ((CommReceiver)object).setAlive(true);
        this.rxThread.start();
        this.rxThread.setPriority(5);
        return true;
    }

    public void commStopped() throws Exception {
        this.getCommReceiver().setAlive(false);
        if (this.getCommReceiver() != null && this.rxThread != null) {
            this.rxThread.interrupt();
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                this.getNetwork().getLog().error("Unable to close serial input stream.", (Throwable)exception);
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                this.getNetwork().getLog().error("Unable to close serial output stream.", (Throwable)exception);
            }
        }
        if (this.serialPort != null) {
            this.serialPort.disableReceiveTimeout();
            this.serialPort.close();
        }
        this.in = null;
        this.out = null;
    }

    public Message transmit(Message message, BRelTime bRelTime, int n) throws BasicException {
        if (message == null) {
            return null;
        }
        if (!message.getResponseExpected()) {
            this.transmitNoResponse(message);
            return null;
        }
        this.performInterMessageDelay();
        return this.getComm().transmit(message, bRelTime, n);
    }

    public void transmitNoResponse(Message message) throws BasicException {
        if (message == null) {
            return;
        }
        if (!this.getComm().isCommStarted()) {
            throw new BasicException("Communication handler service not started.");
        }
        this.performInterMessageDelay();
        this.getComm().transmitNoResponse(message);
    }

    public void receive(ReceivedMessage receivedMessage) {
        if (receivedMessage == null) {
            return;
        }
        this.setReceivedMessageTicks(Clock.ticks());
        this.getComm().receive(receivedMessage);
    }

    protected void performInterMessageDelay() {
        long l = ((BSerialNetwork)this.getNetwork()).getInterMessageDelay().getMillis();
        if (l <= 0L) {
            return;
        }
        long l2 = Clock.ticks() - this.lastRecvMessageTicks;
        if (l2 >= l) {
            return;
        }
        long l3 = Math.max(l - l2, 10L);
        try {
            Thread.sleep(l3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setReceivedMessageTicks(long l) {
        this.lastRecvMessageTicks = l;
    }

    public BISerialPort getSerialPort() {
        return this.serialPort;
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        BSerialHelper bSerialHelper = this.getSerialPortConfig();
        stringBuffer.append(bSerialHelper.getPortName());
        stringBuffer.append(' ');
        stringBuffer.append(bSerialHelper.getBaudRate());
        stringBuffer.append(',');
        stringBuffer.append(bSerialHelper.getDataBits());
        stringBuffer.append(',');
        stringBuffer.append(bSerialHelper.getStopBits());
        stringBuffer.append(',');
        stringBuffer.append(bSerialHelper.getParity());
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastRecvMessageTicks = 0L;
    }

    public BSerialComm() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$basicdriver$serial$BSerialComm;
        if (clazz == null) {
            clazz = class$com$tridium$basicdriver$serial$BSerialComm = BSerialComm.class("[Lcom.tridium.basicdriver.serial.BSerialComm;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

