/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.axisVideo.event.enableEvents;

import com.tridium.axisVideo.BAxisVideoCamera;
import com.tridium.axisVideo.event.BAxisVideoEventPointId;
import com.tridium.axisVideo.event.BAxisVideoEventProxyExt;
import com.tridium.axisVideo.event.enableEvents.AxisParameterUtil;
import com.tridium.axisVideo.event.enableEvents.EventActionUtil;
import com.tridium.axisVideo.event.enableEvents.EventServerUtil;
import com.tridium.axisVideo.event.enableEvents.MotionDetectionUtil;
import com.tridium.axisVideo.event.enableEvents.MotionWindowUtil;
import java.net.UnknownHostException;

public class AxisEnableDetectionRunnable
implements Runnable {
    protected BAxisVideoCamera avCamera;
    protected BAxisVideoEventProxyExt avProxy;
    protected BAxisVideoEventPointId eventPointId;
    protected EventServerUtil eventServerUtil;
    protected MotionWindowUtil motionWindowUtil;
    protected String enableDetection;
    protected String eventServerId;
    protected String motionWindowId;

    public void findOrAddEventServerEntry() throws UnknownHostException, AxisParameterUtil.ReadGroupException, AxisParameterUtil.UnableToAddGroupException, AxisParameterUtil.UnableToUpdateParameterException {
        this.eventServerId = this.eventServerUtil.getIdForTheEventServerWithIpOfThisStationInAxisCam(this.eventPointId.getEventServer());
    }

    public void findOrAddMotionDetectionWindow() throws AxisParameterUtil.ReadGroupException, AxisParameterUtil.UnableToAddGroupException {
        this.motionWindowId = this.motionWindowUtil.getMotionWindowId(this.eventPointId.getMotionWindow());
    }

    public void findOrAddMotionStartedEvent() throws AxisParameterUtil.ReadGroupException, AxisParameterUtil.UnableToUpdateParameterException, AxisParameterUtil.UnableToAddGroupException {
        EventActionUtil eventActionUtil = new EventActionUtil(this.avCamera, this.eventPointId.getActionStart(), this.eventServerId);
        String string = eventActionUtil.getActionId();
        AxisParameterUtil.updateParameter(this.avCamera, string + ".Enabled", this.enableDetection);
        MotionDetectionUtil motionDetectionUtil = new MotionDetectionUtil(this.avCamera, string, this.motionWindowId, this.avProxy.getEventTypeEnum());
        motionDetectionUtil.triggerEventOnMotionStart();
    }

    public void findOrAddMotionStoppedEvent() throws AxisParameterUtil.ReadGroupException, AxisParameterUtil.UnableToUpdateParameterException, AxisParameterUtil.UnableToAddGroupException {
        EventActionUtil eventActionUtil = new EventActionUtil(this.avCamera, this.eventPointId.getActionStop(), this.eventServerId);
        String string = eventActionUtil.getActionId();
        AxisParameterUtil.updateParameter(this.avCamera, string + ".Enabled", this.enableDetection);
        MotionDetectionUtil motionDetectionUtil = new MotionDetectionUtil(this.avCamera, string, this.motionWindowId, this.avProxy.getEventTypeEnum());
        motionDetectionUtil.triggerEventOnMotionStop();
    }

    public void run() {
        try {
            this.findOrAddEventServerEntry();
            this.findOrAddMotionDetectionWindow();
            this.findOrAddMotionStartedEvent();
            this.findOrAddMotionStoppedEvent();
            this.avProxy.writeOk(this.avProxy.getWriteValue());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.avProxy.writeFail(exception.toString());
        }
    }

    public AxisEnableDetectionRunnable(BAxisVideoCamera bAxisVideoCamera, BAxisVideoEventProxyExt bAxisVideoEventProxyExt, boolean bl) {
        this.avCamera = bAxisVideoCamera;
        this.avProxy = bAxisVideoEventProxyExt;
        this.eventServerUtil = new EventServerUtil(bAxisVideoCamera);
        this.motionWindowUtil = new MotionWindowUtil(bAxisVideoCamera);
        this.eventPointId = (BAxisVideoEventPointId)bAxisVideoEventProxyExt.getPointId();
        this.enableDetection = bl ? "yes" : "no";
    }
}

