/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaratenantbilling.util;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.FilePath;
import javax.baja.history.BHistoryId;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BTime;

public final class TenantBillingToolkit {
    public static final Log log = Log.getLog((String)"niagaraTenantBilling");
    public static final BTime END_DAY_TIME = BTime.make((int)23, (int)59, (int)59, (int)999);
    public static final BTime START_DAY_TIME = BTime.make((int)0, (int)0, (int)0, (int)0);
    private static boolean tenantBillingProfileActive = false;
    public static final String INVOICE_GENERATION_AUDIT_OPERATION = "invoiceGenerationOk";
    public static final String INVOICE_GENERATION_FAILURE_AUDIT_OPERATION = "invoiceGenerationFailed";

    public static final void dump(BComplex bComplex) {
        try {
            File file = new File("c:\\compdump\\" + bComplex.getName() + ".html");
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            SpyWriter spyWriter = new SpyWriter((Writer)printWriter, new FilePath("!"));
            bComplex.spy(spyWriter);
            printWriter.close();
        }
        catch (Exception exception) {
            log.error("Error spying on component...", (Throwable)exception);
        }
    }

    public static final BHistoryId getMeterHistoryId(String string, String string2) {
        return BHistoryId.make((String)string, (String)(string2 + "_meter"));
    }

    public static final String filterNameForBql(String string) {
        return SlotPath.escape((String)string);
    }

    public static final void processAgents(BComponent bComponent, AgentList agentList) {
        if (bComponent.isMounted() && bComponent.getComponentSpace().isProxyComponentSpace() && !tenantBillingProfileActive) {
            AgentInfo[] agentInfoArray = agentList.list();
            int n = 0;
            while (n < agentInfoArray.length) {
                if (agentInfoArray[n].getAgentType().toString().equals("niagaraTenantBilling:TenantBillingComponentMenuAgent")) {
                    agentList.remove(agentInfoArray[n]);
                }
                ++n;
            }
        }
    }

    public static final void setTenantBillingWbProfileActive(boolean bl) {
        tenantBillingProfileActive = bl;
    }

    private TenantBillingToolkit() {
    }
}

