/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaratenantbilling.meter;

import com.tridium.history.DeltaCursor;
import com.tridium.niagaratenantbilling.meter.ConsumptionData;
import com.tridium.niagaratenantbilling.util.TenantBillingToolkit;
import javax.baja.collection.BICollection;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BRolloverValue;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class HistoryQueryUtil {
    private Array recordArray;
    private BAbsTime orgStartDateTime;
    private BAbsTime orgEndDateTime;
    private BHistoryId id;
    private BFacets valueFacets;
    private BStatus statusFilter;
    private Lexicon lex;
    private boolean checkData;
    private BRelTime checkDataIntervalDeadband;
    private BRelTime MIN_TIME;
    private boolean ignoreHiddenRecs;
    private boolean allowNegativeUsage;
    static /* synthetic */ Class class$javax$baja$history$BNumericTrendRecord;

    private final void queryHistory() throws Exception {
        FilterCursor filterCursor;
        BNumericTrendRecord bNumericTrendRecord;
        Property property;
        Property property2;
        BRolloverValue bRolloverValue;
        BICollection bICollection;
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BIHistory bIHistory = bHistoryDatabase.getHistory(this.id);
        BAbsTime bAbsTime = this.orgStartDateTime.subtract(BRelTime.DAY);
        if (TenantBillingToolkit.log.isTraceOn()) {
            TenantBillingToolkit.log.trace("History query start: " + bAbsTime + " end: " + this.orgEndDateTime);
        }
        boolean bl = true;
        BValue bValue = bIHistory.getConfig().loadSlots().get("useDelta");
        if (bValue != null && bValue instanceof BBoolean) {
            bl = ((BBoolean)bValue).getBoolean();
        }
        if (bl) {
            bICollection = bIHistory.timeQuery(bAbsTime, this.orgEndDateTime);
            bRolloverValue = null;
            property2 = bIHistory.getConfig().loadSlots().getProperty("minRolloverValue");
            if (property2 != null) {
                bRolloverValue = (BRolloverValue)bIHistory.getConfig().get(property2);
            }
            BRolloverValue bRolloverValue2 = null;
            property = bIHistory.getConfig().loadSlots().getProperty("maxRolloverValue");
            if (property != null) {
                bRolloverValue2 = (BRolloverValue)bIHistory.getConfig().get(property);
            }
            bNumericTrendRecord = this.getReferenceRecord(bIHistory, bAbsTime);
            filterCursor = new DeltaCursor((Cursor)new FilterCursor(bICollection.cursor()), bRolloverValue, bRolloverValue2, bNumericTrendRecord);
        } else {
            bICollection = bIHistory.timeQuery(bAbsTime, this.orgEndDateTime);
            filterCursor = new FilterCursor(bICollection.cursor());
        }
        bICollection = null;
        bRolloverValue = null;
        if (this.checkData && !bIHistory.getConfig().getInterval().isIrregular()) {
            bICollection = BRelTime.make((long)(bIHistory.getConfig().getInterval().getInterval().getMillis() - this.checkDataIntervalDeadband.getMillis() / (long)2));
            bRolloverValue = BRelTime.make((long)(bIHistory.getConfig().getInterval().getInterval().getMillis() + this.checkDataIntervalDeadband.getMillis() / (long)2));
        }
        property2 = null;
        boolean bl2 = false;
        while (filterCursor.next()) {
            property = (BNumericTrendRecord)((BValue)filterCursor.get()).newCopy();
            if (!this.allowNegativeUsage && property.getValue() < 0.0) {
                throw new Exception(this.lex.getText("meter.consumption.error.negativeDelta") + ": " + property.getTimestamp() + " -> " + String.valueOf(property.getValue()));
            }
            if (!bl2 && bICollection != null && bRolloverValue != null && property2 != null) {
                bNumericTrendRecord = property2.getTimestamp().delta(property.getTimestamp());
                if (bNumericTrendRecord.getMillis() < 0L) {
                    throw new Exception(this.lex.getText("meter.consumption.error.meterHistoryOutOfOrder"));
                }
                if (bNumericTrendRecord.compareTo((Object)bICollection) < 0 || bNumericTrendRecord.compareTo((Object)bRolloverValue) > 0) {
                    throw new Exception(this.lex.getText("meter.consumption.error.missingMeterHistory") + ": " + property2.getTimestamp() + " -> " + property.getTimestamp());
                }
            }
            if (this.ignoreHiddenRecs && property.getTrendFlags().getBit("hidden")) {
                if (TenantBillingToolkit.log.isTraceOn()) {
                    TenantBillingToolkit.log.trace("Skipping hidden record at time : " + property.getTimestamp());
                }
                bl2 = true;
                continue;
            }
            this.recordArray.add((Object)property);
            property2 = property;
            bl2 = false;
        }
        if (this.recordArray.size() <= 1) {
            throw new Exception(this.lex.getText("meter.consumption.error.couldNotFindEnoughMeterHistory"));
        }
        try {
            this.valueFacets = (BFacets)bIHistory.getConfig().get("valueFacets");
        }
        catch (Exception exception) {
            TenantBillingToolkit.log.error("Could not access valueFacets from history config to create Meter History", (Throwable)exception);
        }
        if (this.valueFacets == null) {
            this.valueFacets = BFacets.NULL;
        }
        if (TenantBillingToolkit.log.isTraceOn()) {
            TenantBillingToolkit.log.trace("Successfully queried history");
        }
    }

    final ConsumptionData getConsumptionValue(BAbsTime bAbsTime, BAbsTime bAbsTime2, Lexicon lexicon) throws Exception {
        ConsumptionData consumptionData = new ConsumptionData();
        BNumericTrendRecord bNumericTrendRecord = null;
        boolean bl = false;
        double d = 0.0;
        if (BTime.make((BAbsTime)bAbsTime2).equals((Object)BTime.MIDNIGHT)) {
            bAbsTime2 = bAbsTime2.nextDay();
        }
        if (bAbsTime.delta(bAbsTime2).compareTo((Object)this.MIN_TIME) <= 0) {
            if (TenantBillingToolkit.log.isTraceOn()) {
                TenantBillingToolkit.log.trace("Found small time diff -> start: " + bAbsTime.encodeToString() + " end: " + bAbsTime2.encodeToString());
            }
            return consumptionData;
        }
        int n = 0;
        while (n < this.recordArray.size()) {
            bNumericTrendRecord = (BNumericTrendRecord)this.recordArray.get(n);
            if (bNumericTrendRecord.getTimestamp().isAfter(bAbsTime2)) break;
            if (bNumericTrendRecord.getTimestamp().isAfter(bAbsTime) && consumptionData.getFirstDateTime().isNull() && !consumptionData.getLastDateTime().isNull()) {
                consumptionData.setFirstDateTime(consumptionData.getLastDateTime());
                bl = true;
            }
            consumptionData.setLastDateTime(bNumericTrendRecord.getTimestamp());
            if (bl) {
                d += bNumericTrendRecord.getValue();
            }
            ++n;
        }
        if (!bl) {
            consumptionData.setFirstDateTime(BAbsTime.NULL);
            consumptionData.setLastDateTime(BAbsTime.NULL);
        } else {
            consumptionData.setCalcValue(d);
        }
        if (TenantBillingToolkit.log.isTraceOn()) {
            TenantBillingToolkit.log.trace("Consumption input dates: " + bAbsTime + " end: " + bAbsTime2);
            TenantBillingToolkit.log.trace("Consumption: " + consumptionData);
        }
        return consumptionData;
    }

    final BFacets getValueFacets() {
        return this.valueFacets;
    }

    protected final BNumericTrendRecord getReferenceRecord(BIHistory bIHistory, BAbsTime bAbsTime) {
        if (bAbsTime == null) {
            return null;
        }
        BICollection bICollection = bIHistory.timeQuery(null, bAbsTime);
        BNumericTrendRecord bNumericTrendRecord = null;
        if (bICollection != null) {
            FilterCursor filterCursor = new FilterCursor(bICollection.cursor());
            while (filterCursor.next()) {
                BObject bObject = filterCursor.get();
                if (bObject instanceof BNumericTrendRecord) {
                    BNumericTrendRecord bNumericTrendRecord2 = (BNumericTrendRecord)bObject;
                    if (!bNumericTrendRecord2.getTimestamp().isBefore(bAbsTime)) continue;
                    bNumericTrendRecord = (BNumericTrendRecord)bObject;
                    continue;
                }
                return null;
            }
        }
        return bNumericTrendRecord;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$javax$baja$history$BNumericTrendRecord;
        if (clazz == null) {
            clazz = class$javax$baja$history$BNumericTrendRecord = HistoryQueryUtil.class("[Ljavax.baja.history.BNumericTrendRecord;", false);
        }
        this.recordArray = new Array(clazz);
        this.orgStartDateTime = BAbsTime.NULL;
        this.orgEndDateTime = BAbsTime.NULL;
        this.id = BHistoryId.NULL;
        this.valueFacets = BFacets.NULL;
        this.statusFilter = BStatus.nullStatus;
        this.checkData = false;
        this.checkDataIntervalDeadband = BRelTime.DEFAULT;
        this.MIN_TIME = BRelTime.makeMinutes((int)1);
        this.ignoreHiddenRecs = false;
        this.allowNegativeUsage = false;
    }

    HistoryQueryUtil(BAbsTime bAbsTime, BAbsTime bAbsTime2, BHistoryId bHistoryId, boolean bl, BRelTime bRelTime, BStatus bStatus, boolean bl2, boolean bl3, Lexicon lexicon) throws Exception {
        this.this();
        this.orgStartDateTime = bAbsTime;
        this.orgEndDateTime = bAbsTime2;
        this.id = bHistoryId;
        this.checkData = bl;
        this.checkDataIntervalDeadband = bRelTime;
        this.statusFilter = bStatus;
        this.ignoreHiddenRecs = bl2;
        this.allowNegativeUsage = bl3;
        this.lex = lexicon;
        this.queryHistory();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class FilterCursor
    implements Cursor {
        private Cursor c;

        public BObject get() {
            return this.c.get();
        }

        public Context getContext() {
            return this.c.getContext();
        }

        public boolean next() {
            while (this.c.next()) {
                BObject bObject = this.get();
                if (bObject != null && bObject instanceof BNumericTrendRecord) {
                    if (!this.isValid((BNumericTrendRecord)bObject)) continue;
                    return true;
                }
                return true;
            }
            return false;
        }

        private final boolean isValid(BNumericTrendRecord bNumericTrendRecord) {
            boolean bl = true;
            if (Double.isNaN(bNumericTrendRecord.getValue()) || Double.isInfinite(bNumericTrendRecord.getValue())) {
                bl = false;
            } else if (!HistoryQueryUtil.this.statusFilter.isOk() && (bNumericTrendRecord.getStatus().isDisabled() && HistoryQueryUtil.this.statusFilter.isDisabled() || bNumericTrendRecord.getStatus().isFault() && HistoryQueryUtil.this.statusFilter.isFault() || bNumericTrendRecord.getStatus().isDown() && HistoryQueryUtil.this.statusFilter.isDown() || bNumericTrendRecord.getStatus().isAlarm() && HistoryQueryUtil.this.statusFilter.isAlarm() || bNumericTrendRecord.getStatus().isStale() && HistoryQueryUtil.this.statusFilter.isStale() || bNumericTrendRecord.getStatus().isOverridden() && HistoryQueryUtil.this.statusFilter.isOverridden() || bNumericTrendRecord.getStatus().isNull() && HistoryQueryUtil.this.statusFilter.isNull() || bNumericTrendRecord.getStatus().isUnackedAlarm() && HistoryQueryUtil.this.statusFilter.isUnackedAlarm())) {
                bl = false;
            }
            return bl;
        }

        public boolean next(Class clazz) {
            throw new UnsupportedOperationException();
        }

        public boolean nextComponent() {
            throw new UnsupportedOperationException();
        }

        private FilterCursor(Cursor cursor) {
            this.c = cursor;
        }
    }
}

