/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaratenantbilling.meter;

import com.tridium.niagaratenantbilling.BTenantBillingStatusEnabledComponent;
import com.tridium.niagaratenantbilling.enums.BMeterType;
import com.tridium.niagaratenantbilling.invoice.InvoiceHistoryData;
import com.tridium.niagaratenantbilling.meter.BMeterGroup;
import com.tridium.niagaratenantbilling.template.BTemplate;
import com.tridium.niagaratenantbilling.ui.dynamicpx.BDynamicPxHistoryView;
import com.tridium.niagaratenantbilling.util.TenantBillingToolkit;
import com.tridium.niagaratenantbilling.utility.BUtility;
import javax.baja.agent.AgentList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BMeter
extends BTenantBillingStatusEnabledComponent {
    public static final Property description = BMeter.newProperty((int)0, (String)"", null);
    public static final Property reference = BMeter.newProperty((int)0, (BValue)BFormat.make((String)"%meterType.tag%"), null);
    public static final Property meterType = BMeter.newProperty((int)0, (BValue)BMeterType.electric, null);
    public static final Property historyId = BMeter.newProperty((int)0, (BValue)BHistoryId.NULL, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"niagaraTenantBilling:HistorySelectionFE")));
    public static final Property checkData = BMeter.newProperty((int)0, (boolean)true, null);
    public static final Property checkDataIntervalDeadband = BMeter.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    public static final Property allowNegativeUsage = BMeter.newProperty((int)0, (boolean)false, null);
    public static final Property ignoreHiddenRecs = BMeter.newProperty((int)0, (boolean)true, null);
    public static final Property statusFilter = BMeter.newProperty((int)0, (BValue)BStatus.make((int)87), null);
    public static final Property historyChart = BMeter.newProperty((int)5, (BValue)new BDynamicPxHistoryView("HistoryChart", BPermissions.operatorRead), null);
    public static final Property historyTable = BMeter.newProperty((int)5, (BValue)new BDynamicPxHistoryView("HistoryTable", BPermissions.operatorRead), null);
    public static final Property collectionTable = BMeter.newProperty((int)5, (BValue)new BDynamicPxHistoryView("CollectionTable", BPermissions.operatorRead), null);
    public static final Property historySummaryView = BMeter.newProperty((int)5, (BValue)new BDynamicPxHistoryView("HistorySummaryView", BPermissions.operatorRead), null);
    public static final Property historyEditor = BMeter.newProperty((int)5, (BValue)new BDynamicPxHistoryView("HistoryEditor", BPermissions.operatorWrite), null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$meter$BMeter;

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public BFormat getReference() {
        return (BFormat)this.get(reference);
    }

    public void setReference(BFormat bFormat) {
        this.set(reference, (BValue)bFormat, null);
    }

    public BMeterType getMeterType() {
        return (BMeterType)this.get(meterType);
    }

    public void setMeterType(BMeterType bMeterType) {
        this.set(meterType, (BValue)bMeterType, null);
    }

    public BHistoryId getHistoryId() {
        return (BHistoryId)this.get(historyId);
    }

    public void setHistoryId(BHistoryId bHistoryId) {
        this.set(historyId, (BValue)bHistoryId, null);
    }

    public boolean getCheckData() {
        return this.getBoolean(checkData);
    }

    public void setCheckData(boolean bl) {
        this.setBoolean(checkData, bl, null);
    }

    public BRelTime getCheckDataIntervalDeadband() {
        return (BRelTime)this.get(checkDataIntervalDeadband);
    }

    public void setCheckDataIntervalDeadband(BRelTime bRelTime) {
        this.set(checkDataIntervalDeadband, (BValue)bRelTime, null);
    }

    public boolean getAllowNegativeUsage() {
        return this.getBoolean(allowNegativeUsage);
    }

    public void setAllowNegativeUsage(boolean bl) {
        this.setBoolean(allowNegativeUsage, bl, null);
    }

    public boolean getIgnoreHiddenRecs() {
        return this.getBoolean(ignoreHiddenRecs);
    }

    public void setIgnoreHiddenRecs(boolean bl) {
        this.setBoolean(ignoreHiddenRecs, bl, null);
    }

    public BStatus getStatusFilter() {
        return (BStatus)this.get(statusFilter);
    }

    public void setStatusFilter(BStatus bStatus) {
        this.set(statusFilter, (BValue)bStatus, null);
    }

    public BDynamicPxHistoryView getHistoryChart() {
        return (BDynamicPxHistoryView)this.get(historyChart);
    }

    public void setHistoryChart(BDynamicPxHistoryView bDynamicPxHistoryView) {
        this.set(historyChart, (BValue)bDynamicPxHistoryView, null);
    }

    public BDynamicPxHistoryView getHistoryTable() {
        return (BDynamicPxHistoryView)this.get(historyTable);
    }

    public void setHistoryTable(BDynamicPxHistoryView bDynamicPxHistoryView) {
        this.set(historyTable, (BValue)bDynamicPxHistoryView, null);
    }

    public BDynamicPxHistoryView getCollectionTable() {
        return (BDynamicPxHistoryView)this.get(collectionTable);
    }

    public void setCollectionTable(BDynamicPxHistoryView bDynamicPxHistoryView) {
        this.set(collectionTable, (BValue)bDynamicPxHistoryView, null);
    }

    public BDynamicPxHistoryView getHistorySummaryView() {
        return (BDynamicPxHistoryView)this.get(historySummaryView);
    }

    public void setHistorySummaryView(BDynamicPxHistoryView bDynamicPxHistoryView) {
        this.set(historySummaryView, (BValue)bDynamicPxHistoryView, null);
    }

    public BDynamicPxHistoryView getHistoryEditor() {
        return (BDynamicPxHistoryView)this.get(historyEditor);
    }

    public void setHistoryEditor(BDynamicPxHistoryView bDynamicPxHistoryView) {
        this.set(historyEditor, (BValue)bDynamicPxHistoryView, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BUtility || bComponent instanceof BTemplate || bComponent instanceof BMeterGroup) {
            bl = true;
        }
        return bl;
    }

    public BIcon getIcon() {
        return icon;
    }

    protected AgentList doAgents(AgentList agentList, Context context) {
        AgentList agentList2 = super.doAgents(agentList, context);
        agentList2.toTop("workbench:PropertySheet");
        return agentList2;
    }

    public abstract void calcInvoiceData(InvoiceHistoryData var1, BAbsTime var2, BAbsTime var3, double var4, Lexicon var6) throws Exception;

    public double getConsumptionValue(BAbsTime bAbsTime, BAbsTime bAbsTime2, Lexicon lexicon) throws Exception {
        BAbsTime bAbsTime3 = BAbsTime.NULL;
        double d = Double.NEGATIVE_INFINITY;
        BAbsTime bAbsTime4 = BAbsTime.NULL;
        double d2 = Double.NEGATIVE_INFINITY;
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BIHistory bIHistory = bHistoryDatabase.getHistory(this.getHistoryId());
        if (bIHistory == null) {
            throw new Exception(lexicon.getText("meter.consumption.error.unresolvedMeterHistory") + ": " + this.getHistoryId());
        }
        BAbsTime bAbsTime5 = bAbsTime.subtract(BRelTime.DAY);
        if (TenantBillingToolkit.log.isTraceOn()) {
            TenantBillingToolkit.log.trace("History query start: " + bAbsTime5 + " end: " + bAbsTime2);
        }
        BITable bITable = bIHistory.timeQuery(bAbsTime5, bAbsTime2).toTable();
        ColumnList columnList = bITable.getColumns();
        Column column = columnList.get("timestamp");
        Column column2 = columnList.get("value");
        if (column != null && column2 != null) {
            TableCursor tableCursor = (TableCursor)bITable.cursor();
            BAbsTime bAbsTime6 = BAbsTime.NULL;
            while (tableCursor.next()) {
                bAbsTime6 = (BAbsTime)tableCursor.get(column);
                if (bAbsTime6.isAfter(bAbsTime) && bAbsTime3.isNull() && !bAbsTime4.isNull()) {
                    bAbsTime3 = bAbsTime4;
                    d = d2;
                }
                bAbsTime4 = bAbsTime6;
                d2 = tableCursor.getDouble(column2);
            }
            if (TenantBillingToolkit.log.isTraceOn()) {
                TenantBillingToolkit.log.trace("Calculating consumption: Start date: " + bAbsTime3 + " and value: " + d);
                TenantBillingToolkit.log.trace("Calculating consumption: End date: " + bAbsTime4 + " and value: " + d2);
            }
            if (d > d2) {
                throw new Exception(lexicon.getText("meter.consumption.error.incorrecthistory"));
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return 0.0;
            }
            if (d2 == Double.NEGATIVE_INFINITY) {
                return 0.0;
            }
        } else {
            throw new Exception(lexicon.getText("meter.consumption.error.invalidcolumns") + ": " + this.getHistoryId());
        }
        return d2 - d;
    }

    public String getMeterTypeName() {
        return this.getMeterType().getDisplayTag(null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$niagaratenantbilling$meter$BMeter;
        if (clazz == null) {
            clazz = class$com$tridium$niagaratenantbilling$meter$BMeter = BMeter.class("[Lcom.tridium.niagaratenantbilling.meter.BMeter;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://niagaraTenantBilling/res/meter.png");
    }
}

