/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaratenantbilling.meter;

import com.tridium.niagaratenantbilling.BTenantBillingService;
import com.tridium.niagaratenantbilling.history.BMeterHistoryRecord;
import com.tridium.niagaratenantbilling.invoice.BInvoiceGroup;
import com.tridium.niagaratenantbilling.invoice.InvoiceHistoryData;
import com.tridium.niagaratenantbilling.meter.BMeter;
import com.tridium.niagaratenantbilling.meter.ConsumptionData;
import com.tridium.niagaratenantbilling.meter.HistoryQueryUtil;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BFlatRateMeter
extends BMeter {
    public static final Property utilityRate = BFlatRateMeter.newProperty((int)0, (BValue)new BStatusNumeric(1.0), (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)1.0E-4), (String)"precision", (BIDataValue)BInteger.make((int)4), (String)"fieldEditor", (BIDataValue)BString.make((String)"niagaraTenantBilling:StatusNumericFE")));
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$meter$BFlatRateMeter;

    public final BStatusNumeric getUtilityRate() {
        return (BStatusNumeric)this.get(utilityRate);
    }

    public final void setUtilityRate(BStatusNumeric bStatusNumeric) {
        this.set(utilityRate, (BValue)bStatusNumeric, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void calcInvoiceData(InvoiceHistoryData invoiceHistoryData, BAbsTime bAbsTime, BAbsTime bAbsTime2, double d, Lexicon lexicon) throws Exception {
        HistoryQueryUtil historyQueryUtil = new HistoryQueryUtil(bAbsTime, bAbsTime2.nextDay(), this.getHistoryId(), this.getCheckData(), this.getCheckDataIntervalDeadband(), this.getStatusFilter(), this.getIgnoreHiddenRecs(), this.getAllowNegativeUsage(), lexicon);
        ConsumptionData consumptionData = historyQueryUtil.getConsumptionValue(bAbsTime, bAbsTime2, lexicon);
        BMeterHistoryRecord bMeterHistoryRecord = new BMeterHistoryRecord();
        bMeterHistoryRecord.setMeterOrd(this.getHandleOrd());
        bMeterHistoryRecord.setInHoursCost(this.getUtilityRate().getValue());
        bMeterHistoryRecord.setRecordedInHoursUsed(consumptionData.getCalcValue());
        BInvoiceGroup bInvoiceGroup = ((BTenantBillingService)Sys.getService((Type)BTenantBillingService.TYPE)).getInvoices();
        int n = bInvoiceGroup.getMeterUsagePrecision();
        double d2 = Math.pow(10.0, n);
        bMeterHistoryRecord.setRecordedInHoursCharge((double)Math.round(consumptionData.getCalcValue() * this.getUtilityRate().getValue() * d2) / d2);
        bMeterHistoryRecord.setValueFacets(historyQueryUtil.getValueFacets());
        bMeterHistoryRecord.setPercentage(d);
        bMeterHistoryRecord.setFirstDateTime(consumptionData.getFirstDateTime());
        bMeterHistoryRecord.setLastDateTime(consumptionData.getLastDateTime());
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BIHistory bIHistory = bHistoryDatabase.getHistory(this.getHistoryId());
        double d3 = historyQueryUtil.getReferenceRecord(bIHistory, consumptionData.getFirstDateTime()).getValue();
        double d4 = historyQueryUtil.getReferenceRecord(bIHistory, consumptionData.getLastDateTime()).getValue();
        BFacets bFacets = BFacets.make((String)"firstReading", (BIDataValue)BDouble.make((double)d3), (String)"lastReading", (BIDataValue)BDouble.make((double)d4));
        bMeterHistoryRecord.setData(BFacets.make((BFacets)bMeterHistoryRecord.getData(), (BFacets)bFacets));
        invoiceHistoryData.addMeterRecord(bMeterHistoryRecord);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$niagaratenantbilling$meter$BFlatRateMeter;
        if (clazz == null) {
            clazz = class$com$tridium$niagaratenantbilling$meter$BFlatRateMeter = BFlatRateMeter.class("[Lcom.tridium.niagaratenantbilling.meter.BFlatRateMeter;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

