/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaratenantbilling.invoice;

import com.tridium.niagaratenantbilling.BTenantBillingService;
import com.tridium.niagaratenantbilling.contract.BContract;
import com.tridium.niagaratenantbilling.history.BInvoiceHistoryRecord;
import com.tridium.niagaratenantbilling.invoice.BInvoiceGeneratorExtension;
import com.tridium.niagaratenantbilling.invoice.BInvoiceGeneratorJob;
import com.tridium.niagaratenantbilling.invoice.BInvoiceInfo;
import com.tridium.niagaratenantbilling.owner.BOwner;
import com.tridium.niagaratenantbilling.template.BTemplate;
import com.tridium.niagaratenantbilling.tenant.BTenant;
import com.tridium.niagaratenantbilling.util.TenantBillingToolkit;
import com.tridium.pdf.BPxViewToPdf;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.baja.agent.BAbstractPxView;
import javax.baja.data.BIDataValue;
import javax.baja.email.BBlobPart;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.BEmailPartList;
import javax.baja.email.BEmailService;
import javax.baja.file.ExportOp;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BSendEmailExtension
extends BInvoiceGeneratorExtension {
    public static final Property emailAddress = BSendEmailExtension.newProperty((int)0, (String)BSendEmailExtension.getTenantDefaultEmailStr(), null);
    public static final Property ccEmailAddressList = BSendEmailExtension.newProperty((int)0, (String)"", null);
    public static final Property bccEmailAddressList = BSendEmailExtension.newProperty((int)0, (String)"", null);
    public static final Property subject = BSendEmailExtension.newProperty((int)0, (String)"invoice", null);
    public static final Property body = BSendEmailExtension.newProperty((int)0, (BValue)BFormat.make((String)"Please find your Invoice attached."), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Type TYPE;
    private static final BIcon icon;
    private static final String TENANT_EMAIL_ADDRESS = "<TENANT_EMAIL_ADDRESS>";
    private static final String OWNER_EMAIL_ADDRESS = "<OWNER_EMAIL_ADDRESS>";
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$invoice$BSendEmailExtension;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$email$BBlobPart;

    public final String getEmailAddress() {
        return this.getString(emailAddress);
    }

    public final void setEmailAddress(String string) {
        this.setString(emailAddress, string, null);
    }

    public final String getCcEmailAddressList() {
        return this.getString(ccEmailAddressList);
    }

    public final void setCcEmailAddressList(String string) {
        this.setString(ccEmailAddressList, string, null);
    }

    public final String getBccEmailAddressList() {
        return this.getString(bccEmailAddressList);
    }

    public final void setBccEmailAddressList(String string) {
        this.setString(bccEmailAddressList, string, null);
    }

    public final String getSubject() {
        return this.getString(subject);
    }

    public final void setSubject(String string) {
        this.setString(subject, string, null);
    }

    public final BFormat getBody() {
        return (BFormat)this.get(body);
    }

    public final void setBody(BFormat bFormat) {
        this.set(body, (BValue)bFormat, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void processInvoice(BInvoiceHistoryRecord bInvoiceHistoryRecord, BInvoiceGeneratorJob bInvoiceGeneratorJob, Lexicon lexicon) throws Exception {
        Method method;
        ExportOp exportOp;
        BPxViewToPdf bPxViewToPdf;
        BTemplate bTemplate = (BTemplate)((BContract)bInvoiceHistoryRecord.getContractOrd().get((BObject)this)).getTemplate().get((BObject)this);
        bInvoiceGeneratorJob.log().success(lexicon.getText("invoicejob.sendingEmailUsingTemplate") + ": " + bTemplate.getDisplayName(null));
        BTenantBillingService bTenantBillingService = (BTenantBillingService)Sys.getService((Type)BTenantBillingService.TYPE);
        BInvoiceInfo bInvoiceInfo = bTenantBillingService.addInvoiceInfo(bInvoiceHistoryRecord);
        String string = this.getBody().format((Object)bInvoiceInfo);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try {
                bPxViewToPdf = new BPxViewToPdf((BAbstractPxView)bInvoiceInfo.getInvoiceView());
                exportOp = ExportOp.make((OrdTarget)bInvoiceInfo.getNavOrd().resolve((BObject)this), (OutputStream)byteArrayOutputStream);
                bPxViewToPdf.export(exportOp);
                byteArrayOutputStream.flush();
            }
            catch (Exception exception) {
                bInvoiceGeneratorJob.log().failed(lexicon.getText("invoicejob.errorCreatingPdfForEmail"));
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            bInvoiceInfo.removeFromParent();
            throw throwable;
        }
        {
            Object var10_14 = null;
            bInvoiceInfo.removeFromParent();
        }
        bInvoiceGeneratorJob.log().success(lexicon.getText("invoicejob.createdPdf"));
        bPxViewToPdf = BEmailAddress.make((String)this.processEmailAddress(this.getEmailAddress(), bInvoiceHistoryRecord));
        exportOp = BEmailAddressList.make((String)this.processEmailAddress(this.getCcEmailAddressList(), bInvoiceHistoryRecord));
        BEmailAddressList bEmailAddressList = BEmailAddressList.make((String)this.processEmailAddress(this.getBccEmailAddressList(), bInvoiceHistoryRecord));
        BEmail bEmail = new BEmail((BEmailAddress)bPxViewToPdf, this.getSubject(), string);
        bEmail.setCc((BEmailAddressList)exportOp);
        bEmail.setBcc(bEmailAddressList);
        bInvoiceGeneratorJob.log().success(lexicon.getText("invoicejob.sendingToEmail") + ": " + bPxViewToPdf);
        BEmailPartList bEmailPartList = new BEmailPartList();
        BBlobPart bBlobPart = new BBlobPart("invoice.pdf", BBlob.make((byte[])byteArrayOutputStream.toByteArray()));
        try {
            Class clazz = class$javax$baja$email$BBlobPart;
            if (clazz == null) {
                clazz = class$javax$baja$email$BBlobPart = BSendEmailExtension.class("[Ljavax.baja.email.BBlobPart;", false);
            }
            Class[] classArray = new Class[1];
            Class clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = BSendEmailExtension.class("[Ljava.lang.String;", false);
            }
            classArray[0] = clazz2;
            method = clazz.getMethod("setMimeType", classArray);
            method.invoke((Object)bBlobPart, "application/pdf");
        }
        catch (Exception exception) {
            TenantBillingToolkit.log.error("Email sending of Pdf is only available in AX version 3.1 or later!", (Throwable)exception);
        }
        bEmailPartList.add("invoice", (BValue)bBlobPart);
        bEmail.setAttachments(bEmailPartList);
        try {
            method = (BEmailService)Sys.getService((Type)BEmailService.TYPE);
            method.send(bEmail);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            throw new Exception(lexicon.getText("invoicejob.couldNotFindEmailService"));
        }
        bInvoiceGeneratorJob.log().success(lexicon.getText("invoicejob.emailSentWithPdf"));
    }

    private final String processEmailAddress(String string, BInvoiceHistoryRecord bInvoiceHistoryRecord) {
        if (string.indexOf(TENANT_EMAIL_ADDRESS) > -1) {
            BContract bContract = (BContract)bInvoiceHistoryRecord.getContractOrd().resolve((BObject)this).get();
            BTenant bTenant = (BTenant)bContract.getParent();
            string = TextUtil.replace((String)string, (String)TENANT_EMAIL_ADDRESS, (String)bTenant.getContactEmail().getAddress());
        } else if (string.indexOf(OWNER_EMAIL_ADDRESS) > -1) {
            BContract bContract = (BContract)bInvoiceHistoryRecord.getContractOrd().resolve((BObject)this).get();
            BOwner bOwner = (BOwner)bContract.getParent().getParent();
            string = TextUtil.replace((String)string, (String)OWNER_EMAIL_ADDRESS, (String)bOwner.getContactEmail().getAddress());
        }
        return string;
    }

    private static final String getTenantDefaultEmailStr() {
        return TENANT_EMAIL_ADDRESS;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$niagaratenantbilling$invoice$BSendEmailExtension;
        if (clazz == null) {
            clazz = class$com$tridium$niagaratenantbilling$invoice$BSendEmailExtension = BSendEmailExtension.class("[Lcom.tridium.niagaratenantbilling.invoice.BSendEmailExtension;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"email.png");
    }
}

