/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaratenantbilling.invoice;

import com.tridium.niagaratenantbilling.BTenantBillingService;
import com.tridium.niagaratenantbilling.contract.BContract;
import com.tridium.niagaratenantbilling.enums.BMeterType;
import com.tridium.niagaratenantbilling.history.BInvoiceHistoryRecord;
import com.tridium.niagaratenantbilling.history.BMeterHistoryRecord;
import com.tridium.niagaratenantbilling.history.BTenantBillingHistoryRecord;
import com.tridium.niagaratenantbilling.invoice.BInvoiceGroup;
import com.tridium.niagaratenantbilling.meter.BMeter;
import com.tridium.niagaratenantbilling.meter.BMeterGroup;
import com.tridium.niagaratenantbilling.owner.BOwner;
import com.tridium.niagaratenantbilling.template.BTemplate;
import com.tridium.niagaratenantbilling.tenant.BTenant;
import com.tridium.niagaratenantbilling.util.TenantBillingToolkit;
import com.tridium.niagaratenantbilling.utility.BUtility;
import java.util.HashMap;
import javax.baja.agent.BPxView;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrdList;
import javax.baja.naming.BatchResolve;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BInvoiceInfo
extends BComponent {
    public static final Property invoiceView = BInvoiceInfo.newProperty((int)262, (BValue)new BPxView(), null);
    public static final Property record = BInvoiceInfo.newProperty((int)262, (BValue)new BInvoiceHistoryRecord(), null);
    public static final Property contract = BInvoiceInfo.newProperty((int)262, (BValue)new BContract(), null);
    public static final Property tenant = BInvoiceInfo.newProperty((int)262, (BValue)new BTenant(), null);
    public static final Property owner = BInvoiceInfo.newProperty((int)262, (BValue)new BOwner(), null);
    public static final Property meters = BInvoiceInfo.newProperty((int)262, (BValue)new BMeterGroup(), null);
    public static final Property showUsageSeparator = BInvoiceInfo.newProperty((int)262, (boolean)true, null);
    public static final Property showChargeSeparator = BInvoiceInfo.newProperty((int)262, (boolean)true, null);
    public static final Property total = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalElectricInHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalElectricOutHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalElectricHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalElectricInHoursCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalElectricOutHoursCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalElectricCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalGasInHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalGasOutHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalGasHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalGasInHoursCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalGasOutHoursCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalGasCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalOutsideAirTempInHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalOutsideAirTempOutHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalOutsideAirTempHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalOutsideAirTempInHoursCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalOutsideAirTempOutHoursCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalOutsideAirTempCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalSewerInHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalSewerOutHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalSewerHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalSewerInHoursCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalSewerOutHoursCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalSewerCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalWaterInHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalWaterOutHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalWaterHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalWaterInHoursCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalWaterOutHoursCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalWaterCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalOtherInHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalOtherOutHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalOtherHoursUsed = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalOtherInHoursCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalOtherOutHoursCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property totalOtherCharge = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property tax = BInvoiceInfo.newProperty((int)262, (double)0.0, null);
    public static final Property electricFacets = BInvoiceInfo.newProperty((int)262, (BValue)BFacets.NULL, null);
    public static final Property gasFacets = BInvoiceInfo.newProperty((int)262, (BValue)BFacets.NULL, null);
    public static final Property outdoorairFacets = BInvoiceInfo.newProperty((int)262, (BValue)BFacets.NULL, null);
    public static final Property sewerFacets = BInvoiceInfo.newProperty((int)262, (BValue)BFacets.NULL, null);
    public static final Property waterFacets = BInvoiceInfo.newProperty((int)262, (BValue)BFacets.NULL, null);
    public static final Property otherFacets = BInvoiceInfo.newProperty((int)262, (BValue)BFacets.NULL, null);
    public static final Action removeFromParent = BInvoiceInfo.newAction((int)260, null);
    public static final Type TYPE;
    public static final BIcon icon;
    private static final BRelTime LINGER_TIMEOUT;
    private static BFacets SHOW_SEP;
    private Clock.Ticket lingerTicket;
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$invoice$BInvoiceInfo;
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$history$BMeterHistoryRecord;

    public final BPxView getInvoiceView() {
        return (BPxView)this.get(invoiceView);
    }

    public final void setInvoiceView(BPxView bPxView) {
        this.set(invoiceView, (BValue)bPxView, null);
    }

    public final BInvoiceHistoryRecord getRecord() {
        return (BInvoiceHistoryRecord)this.get(record);
    }

    public final void setRecord(BInvoiceHistoryRecord bInvoiceHistoryRecord) {
        this.set(record, (BValue)bInvoiceHistoryRecord, null);
    }

    public final BContract getContract() {
        return (BContract)this.get(contract);
    }

    public final void setContract(BContract bContract) {
        this.set(contract, (BValue)bContract, null);
    }

    public final BTenant getTenant() {
        return (BTenant)this.get(tenant);
    }

    public final void setTenant(BTenant bTenant) {
        this.set(tenant, (BValue)bTenant, null);
    }

    public final BOwner getOwner() {
        return (BOwner)this.get(owner);
    }

    public final void setOwner(BOwner bOwner) {
        this.set(owner, (BValue)bOwner, null);
    }

    public final BMeterGroup getMeters() {
        return (BMeterGroup)this.get(meters);
    }

    public final void setMeters(BMeterGroup bMeterGroup) {
        this.set(meters, (BValue)bMeterGroup, null);
    }

    public final boolean getShowUsageSeparator() {
        return this.getBoolean(showUsageSeparator);
    }

    public final void setShowUsageSeparator(boolean bl) {
        this.setBoolean(showUsageSeparator, bl, null);
    }

    public final boolean getShowChargeSeparator() {
        return this.getBoolean(showChargeSeparator);
    }

    public final void setShowChargeSeparator(boolean bl) {
        this.setBoolean(showChargeSeparator, bl, null);
    }

    public final double getTotal() {
        return this.getDouble(total);
    }

    public final void setTotal(double d) {
        this.setDouble(total, d, null);
    }

    public final double getTotalElectricInHoursUsed() {
        return this.getDouble(totalElectricInHoursUsed);
    }

    public final void setTotalElectricInHoursUsed(double d) {
        this.setDouble(totalElectricInHoursUsed, d, null);
    }

    public final double getTotalElectricOutHoursUsed() {
        return this.getDouble(totalElectricOutHoursUsed);
    }

    public final void setTotalElectricOutHoursUsed(double d) {
        this.setDouble(totalElectricOutHoursUsed, d, null);
    }

    public final double getTotalElectricHoursUsed() {
        return this.getDouble(totalElectricHoursUsed);
    }

    public final void setTotalElectricHoursUsed(double d) {
        this.setDouble(totalElectricHoursUsed, d, null);
    }

    public final double getTotalElectricInHoursCharge() {
        return this.getDouble(totalElectricInHoursCharge);
    }

    public final void setTotalElectricInHoursCharge(double d) {
        this.setDouble(totalElectricInHoursCharge, d, null);
    }

    public final double getTotalElectricOutHoursCharge() {
        return this.getDouble(totalElectricOutHoursCharge);
    }

    public final void setTotalElectricOutHoursCharge(double d) {
        this.setDouble(totalElectricOutHoursCharge, d, null);
    }

    public final double getTotalElectricCharge() {
        return this.getDouble(totalElectricCharge);
    }

    public final void setTotalElectricCharge(double d) {
        this.setDouble(totalElectricCharge, d, null);
    }

    public final double getTotalGasInHoursUsed() {
        return this.getDouble(totalGasInHoursUsed);
    }

    public final void setTotalGasInHoursUsed(double d) {
        this.setDouble(totalGasInHoursUsed, d, null);
    }

    public final double getTotalGasOutHoursUsed() {
        return this.getDouble(totalGasOutHoursUsed);
    }

    public final void setTotalGasOutHoursUsed(double d) {
        this.setDouble(totalGasOutHoursUsed, d, null);
    }

    public final double getTotalGasHoursUsed() {
        return this.getDouble(totalGasHoursUsed);
    }

    public final void setTotalGasHoursUsed(double d) {
        this.setDouble(totalGasHoursUsed, d, null);
    }

    public final double getTotalGasInHoursCharge() {
        return this.getDouble(totalGasInHoursCharge);
    }

    public final void setTotalGasInHoursCharge(double d) {
        this.setDouble(totalGasInHoursCharge, d, null);
    }

    public final double getTotalGasOutHoursCharge() {
        return this.getDouble(totalGasOutHoursCharge);
    }

    public final void setTotalGasOutHoursCharge(double d) {
        this.setDouble(totalGasOutHoursCharge, d, null);
    }

    public final double getTotalGasCharge() {
        return this.getDouble(totalGasCharge);
    }

    public final void setTotalGasCharge(double d) {
        this.setDouble(totalGasCharge, d, null);
    }

    public final double getTotalOutsideAirTempInHoursUsed() {
        return this.getDouble(totalOutsideAirTempInHoursUsed);
    }

    public final void setTotalOutsideAirTempInHoursUsed(double d) {
        this.setDouble(totalOutsideAirTempInHoursUsed, d, null);
    }

    public final double getTotalOutsideAirTempOutHoursUsed() {
        return this.getDouble(totalOutsideAirTempOutHoursUsed);
    }

    public final void setTotalOutsideAirTempOutHoursUsed(double d) {
        this.setDouble(totalOutsideAirTempOutHoursUsed, d, null);
    }

    public final double getTotalOutsideAirTempHoursUsed() {
        return this.getDouble(totalOutsideAirTempHoursUsed);
    }

    public final void setTotalOutsideAirTempHoursUsed(double d) {
        this.setDouble(totalOutsideAirTempHoursUsed, d, null);
    }

    public final double getTotalOutsideAirTempInHoursCharge() {
        return this.getDouble(totalOutsideAirTempInHoursCharge);
    }

    public final void setTotalOutsideAirTempInHoursCharge(double d) {
        this.setDouble(totalOutsideAirTempInHoursCharge, d, null);
    }

    public final double getTotalOutsideAirTempOutHoursCharge() {
        return this.getDouble(totalOutsideAirTempOutHoursCharge);
    }

    public final void setTotalOutsideAirTempOutHoursCharge(double d) {
        this.setDouble(totalOutsideAirTempOutHoursCharge, d, null);
    }

    public final double getTotalOutsideAirTempCharge() {
        return this.getDouble(totalOutsideAirTempCharge);
    }

    public final void setTotalOutsideAirTempCharge(double d) {
        this.setDouble(totalOutsideAirTempCharge, d, null);
    }

    public final double getTotalSewerInHoursUsed() {
        return this.getDouble(totalSewerInHoursUsed);
    }

    public final void setTotalSewerInHoursUsed(double d) {
        this.setDouble(totalSewerInHoursUsed, d, null);
    }

    public final double getTotalSewerOutHoursUsed() {
        return this.getDouble(totalSewerOutHoursUsed);
    }

    public final void setTotalSewerOutHoursUsed(double d) {
        this.setDouble(totalSewerOutHoursUsed, d, null);
    }

    public final double getTotalSewerHoursUsed() {
        return this.getDouble(totalSewerHoursUsed);
    }

    public final void setTotalSewerHoursUsed(double d) {
        this.setDouble(totalSewerHoursUsed, d, null);
    }

    public final double getTotalSewerInHoursCharge() {
        return this.getDouble(totalSewerInHoursCharge);
    }

    public final void setTotalSewerInHoursCharge(double d) {
        this.setDouble(totalSewerInHoursCharge, d, null);
    }

    public final double getTotalSewerOutHoursCharge() {
        return this.getDouble(totalSewerOutHoursCharge);
    }

    public final void setTotalSewerOutHoursCharge(double d) {
        this.setDouble(totalSewerOutHoursCharge, d, null);
    }

    public final double getTotalSewerCharge() {
        return this.getDouble(totalSewerCharge);
    }

    public final void setTotalSewerCharge(double d) {
        this.setDouble(totalSewerCharge, d, null);
    }

    public final double getTotalWaterInHoursUsed() {
        return this.getDouble(totalWaterInHoursUsed);
    }

    public final void setTotalWaterInHoursUsed(double d) {
        this.setDouble(totalWaterInHoursUsed, d, null);
    }

    public final double getTotalWaterOutHoursUsed() {
        return this.getDouble(totalWaterOutHoursUsed);
    }

    public final void setTotalWaterOutHoursUsed(double d) {
        this.setDouble(totalWaterOutHoursUsed, d, null);
    }

    public final double getTotalWaterHoursUsed() {
        return this.getDouble(totalWaterHoursUsed);
    }

    public final void setTotalWaterHoursUsed(double d) {
        this.setDouble(totalWaterHoursUsed, d, null);
    }

    public final double getTotalWaterInHoursCharge() {
        return this.getDouble(totalWaterInHoursCharge);
    }

    public final void setTotalWaterInHoursCharge(double d) {
        this.setDouble(totalWaterInHoursCharge, d, null);
    }

    public final double getTotalWaterOutHoursCharge() {
        return this.getDouble(totalWaterOutHoursCharge);
    }

    public final void setTotalWaterOutHoursCharge(double d) {
        this.setDouble(totalWaterOutHoursCharge, d, null);
    }

    public final double getTotalWaterCharge() {
        return this.getDouble(totalWaterCharge);
    }

    public final void setTotalWaterCharge(double d) {
        this.setDouble(totalWaterCharge, d, null);
    }

    public final double getTotalOtherInHoursUsed() {
        return this.getDouble(totalOtherInHoursUsed);
    }

    public final void setTotalOtherInHoursUsed(double d) {
        this.setDouble(totalOtherInHoursUsed, d, null);
    }

    public final double getTotalOtherOutHoursUsed() {
        return this.getDouble(totalOtherOutHoursUsed);
    }

    public final void setTotalOtherOutHoursUsed(double d) {
        this.setDouble(totalOtherOutHoursUsed, d, null);
    }

    public final double getTotalOtherHoursUsed() {
        return this.getDouble(totalOtherHoursUsed);
    }

    public final void setTotalOtherHoursUsed(double d) {
        this.setDouble(totalOtherHoursUsed, d, null);
    }

    public final double getTotalOtherInHoursCharge() {
        return this.getDouble(totalOtherInHoursCharge);
    }

    public final void setTotalOtherInHoursCharge(double d) {
        this.setDouble(totalOtherInHoursCharge, d, null);
    }

    public final double getTotalOtherOutHoursCharge() {
        return this.getDouble(totalOtherOutHoursCharge);
    }

    public final void setTotalOtherOutHoursCharge(double d) {
        this.setDouble(totalOtherOutHoursCharge, d, null);
    }

    public final double getTotalOtherCharge() {
        return this.getDouble(totalOtherCharge);
    }

    public final void setTotalOtherCharge(double d) {
        this.setDouble(totalOtherCharge, d, null);
    }

    public final double getTax() {
        return this.getDouble(tax);
    }

    public final void setTax(double d) {
        this.setDouble(tax, d, null);
    }

    public final BFacets getElectricFacets() {
        return (BFacets)this.get(electricFacets);
    }

    public final void setElectricFacets(BFacets bFacets) {
        this.set(electricFacets, (BValue)bFacets, null);
    }

    public final BFacets getGasFacets() {
        return (BFacets)this.get(gasFacets);
    }

    public final void setGasFacets(BFacets bFacets) {
        this.set(gasFacets, (BValue)bFacets, null);
    }

    public final BFacets getOutdoorairFacets() {
        return (BFacets)this.get(outdoorairFacets);
    }

    public final void setOutdoorairFacets(BFacets bFacets) {
        this.set(outdoorairFacets, (BValue)bFacets, null);
    }

    public final BFacets getSewerFacets() {
        return (BFacets)this.get(sewerFacets);
    }

    public final void setSewerFacets(BFacets bFacets) {
        this.set(sewerFacets, (BValue)bFacets, null);
    }

    public final BFacets getWaterFacets() {
        return (BFacets)this.get(waterFacets);
    }

    public final void setWaterFacets(BFacets bFacets) {
        this.set(waterFacets, (BValue)bFacets, null);
    }

    public final BFacets getOtherFacets() {
        return (BFacets)this.get(otherFacets);
    }

    public final void setOtherFacets(BFacets bFacets) {
        this.set(otherFacets, (BValue)bFacets, null);
    }

    public final void removeFromParent() {
        this.invoke(removeFromParent, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public static final BInvoiceInfo make(BInvoiceHistoryRecord bInvoiceHistoryRecord) {
        BInvoiceInfo bInvoiceInfo = new BInvoiceInfo();
        bInvoiceInfo.setRecord((BInvoiceHistoryRecord)bInvoiceHistoryRecord.newCopy());
        return bInvoiceInfo;
    }

    public final void started() throws Exception {
        Object object;
        Object object2;
        BInvoiceGroup bInvoiceGroup = ((BTenantBillingService)Sys.getService((Type)BTenantBillingService.TYPE)).getInvoices();
        this.setShowUsageSeparator(bInvoiceGroup.getShowUsageSeparators());
        this.setShowChargeSeparator(bInvoiceGroup.getShowChargeSeparators());
        BInvoiceHistoryRecord bInvoiceHistoryRecord = this.getRecord();
        bInvoiceHistoryRecord.setChargePrecision(bInvoiceGroup.getChargePrecision());
        bInvoiceHistoryRecord.setMeterRatePrecision(bInvoiceGroup.getMeterRatePrecision());
        bInvoiceHistoryRecord.setMeterUsagePrecision(bInvoiceGroup.getMeterUsagePrecision());
        bInvoiceHistoryRecord.setPercentagePrecision(bInvoiceGroup.getPercentagePrecision());
        HashMap<String, BFormat> hashMap = new HashMap<String, BFormat>();
        BContract bContract = (BContract)this.getRecord().getContractOrd().resolve((BObject)this).get();
        this.setContract((BContract)bContract.newCopy());
        hashMap.put(contract.getName(), BFormat.make((String)bContract.getDisplayName(null)));
        BTemplate bTemplate = (BTemplate)bContract.getTemplate().get((BObject)this);
        BPxView bPxView = new BPxView();
        bPxView.setPxFile(bTemplate.getView().getPxFile());
        this.setInvoiceView(bPxView);
        BTenant bTenant = (BTenant)bContract.getParent();
        BTenant bTenant2 = (BTenant)bTenant.newCopy();
        bTenant2.removeAll();
        this.setTenant(bTenant2);
        hashMap.put(tenant.getName(), BFormat.make((String)bTenant.getDisplayName(null)));
        BOwner bOwner = (BOwner)bTenant.getParent();
        BOwner bOwner2 = (BOwner)bOwner.newCopy();
        bOwner2.removeAll();
        this.setOwner(bOwner2);
        hashMap.put(owner.getName(), BFormat.make((String)bOwner.getDisplayName(null)));
        this.add("displayNames", (BValue)BNameMap.make(hashMap));
        BOrdList bOrdList = bContract.getMeters().getOrdList();
        BatchResolve batchResolve = new BatchResolve(bOrdList.toArray());
        batchResolve.resolve((BObject)this);
        BHistoryId bHistoryId = TenantBillingToolkit.getMeterHistoryId(bTenant.getId(), bContract.getName());
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
        Class clazz = class$com$tridium$niagaratenantbilling$history$BMeterHistoryRecord;
        if (clazz == null) {
            clazz = class$com$tridium$niagaratenantbilling$history$BMeterHistoryRecord = BInvoiceInfo.class("[Lcom.tridium.niagaratenantbilling.history.BMeterHistoryRecord;", false);
        }
        Array array = new Array(clazz);
        Cursor cursor = bIHistory.scan();
        String string = bInvoiceHistoryRecord.getInvoiceReference();
        String string2 = bInvoiceHistoryRecord.getCurrency();
        while (cursor.next()) {
            object2 = (BMeterHistoryRecord)cursor.get();
            if (!object2.getInvoiceReference().equals(string)) continue;
            object = (BMeterHistoryRecord)object2.newCopy();
            ((BTenantBillingHistoryRecord)((Object)object)).setCurrency(string2);
            if (this.getShowUsageSeparator()) {
                ((BTenantBillingHistoryRecord)((Object)object)).setMeterUsageFacets(SHOW_SEP);
            }
            if (this.getShowChargeSeparator()) {
                ((BTenantBillingHistoryRecord)((Object)object)).setChargeFacets(SHOW_SEP);
            }
            ((BTenantBillingHistoryRecord)((Object)object)).setChargePrecision(bInvoiceGroup.getChargePrecision());
            ((BTenantBillingHistoryRecord)((Object)object)).setMeterRatePrecision(bInvoiceGroup.getMeterRatePrecision());
            ((BTenantBillingHistoryRecord)((Object)object)).setMeterUsagePrecision(bInvoiceGroup.getMeterUsagePrecision());
            ((BTenantBillingHistoryRecord)((Object)object)).setPercentagePrecision(bInvoiceGroup.getPercentagePrecision());
            array.add(object);
        }
        object2 = (BMeterHistoryRecord[])array.trim();
        object = new HashMap();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        double d22 = 0.0;
        double d23 = 0.0;
        double d24 = 0.0;
        BMeterGroup bMeterGroup = new BMeterGroup();
        int n = 0;
        while (n < batchResolve.size()) {
            if (batchResolve.isResolved(n)) {
                BMeter bMeter = (BMeter)batchResolve.getTarget(n).getComponent();
                BUtility bUtility = (BUtility)bMeter.getParent();
                BMeter bMeter2 = (BMeter)bMeter.newCopy();
                BUtility bUtility2 = (BUtility)bUtility.newCopy();
                bUtility2.removeAll();
                bMeter2.add("utility", (BValue)bUtility2, 262);
                HashMap<String, BFormat> hashMap2 = new HashMap<String, BFormat>();
                hashMap2.put("utility", BFormat.make((String)bUtility.getDisplayName(null)));
                bMeter2.add("displayNames", (BValue)BNameMap.make(hashMap2));
                int n2 = 0;
                while (n2 < ((Object)object2).length) {
                    if (((BMeterHistoryRecord)((Object)object2[n2])).getMeterOrd().equals((Object)bMeter.getHandleOrd())) {
                        bMeter2.add("record", object2[n2].newCopy(), 262);
                        if (bMeter.getMeterType() == BMeterType.electric) {
                            if (this.getElectricFacets() == BFacets.NULL) {
                                this.setElectricFacets(((BMeterHistoryRecord)((Object)object2[n2])).getValueFacets());
                            }
                            d += ((BMeterHistoryRecord)((Object)object2[n2])).getInHoursUsed();
                            d2 += ((BMeterHistoryRecord)((Object)object2[n2])).getOutHoursUsed();
                            d3 += (double)Math.round(((BMeterHistoryRecord)((Object)object2[n2])).getInHoursCharge() * 100.0) / 100.0;
                            d4 += (double)Math.round(((BMeterHistoryRecord)((Object)object2[n2])).getOutHoursCharge() * 100.0) / 100.0;
                            break;
                        }
                        if (bMeter.getMeterType() == BMeterType.gas) {
                            if (this.getGasFacets() == BFacets.NULL) {
                                this.setGasFacets(((BMeterHistoryRecord)((Object)object2[n2])).getValueFacets());
                            }
                            d5 += ((BMeterHistoryRecord)((Object)object2[n2])).getInHoursUsed();
                            d6 += ((BMeterHistoryRecord)((Object)object2[n2])).getOutHoursUsed();
                            d7 += (double)Math.round(((BMeterHistoryRecord)((Object)object2[n2])).getInHoursCharge() * 100.0) / 100.0;
                            d8 += (double)Math.round(((BMeterHistoryRecord)((Object)object2[n2])).getOutHoursCharge() * 100.0) / 100.0;
                            break;
                        }
                        if (bMeter.getMeterType() == BMeterType.outsideAirTemp) {
                            if (this.getOutdoorairFacets() == BFacets.NULL) {
                                this.setOutdoorairFacets(((BMeterHistoryRecord)((Object)object2[n2])).getValueFacets());
                            }
                            d9 += ((BMeterHistoryRecord)((Object)object2[n2])).getInHoursUsed();
                            d10 += ((BMeterHistoryRecord)((Object)object2[n2])).getOutHoursUsed();
                            d11 += (double)Math.round(((BMeterHistoryRecord)((Object)object2[n2])).getInHoursCharge() * 100.0) / 100.0;
                            d12 += (double)Math.round(((BMeterHistoryRecord)((Object)object2[n2])).getOutHoursCharge() * 100.0) / 100.0;
                            break;
                        }
                        if (bMeter.getMeterType() == BMeterType.sewer) {
                            if (this.getSewerFacets() == BFacets.NULL) {
                                this.setSewerFacets(((BMeterHistoryRecord)((Object)object2[n2])).getValueFacets());
                            }
                            d13 += ((BMeterHistoryRecord)((Object)object2[n2])).getInHoursUsed();
                            d14 += ((BMeterHistoryRecord)((Object)object2[n2])).getOutHoursUsed();
                            d15 += (double)Math.round(((BMeterHistoryRecord)((Object)object2[n2])).getInHoursCharge() * 100.0) / 100.0;
                            d16 += (double)Math.round(((BMeterHistoryRecord)((Object)object2[n2])).getOutHoursCharge() * 100.0) / 100.0;
                            break;
                        }
                        if (bMeter.getMeterType() == BMeterType.water) {
                            if (this.getWaterFacets() == BFacets.NULL) {
                                this.setWaterFacets(((BMeterHistoryRecord)((Object)object2[n2])).getValueFacets());
                            }
                            d17 += ((BMeterHistoryRecord)((Object)object2[n2])).getInHoursUsed();
                            d18 += ((BMeterHistoryRecord)((Object)object2[n2])).getOutHoursUsed();
                            d19 += (double)Math.round(((BMeterHistoryRecord)((Object)object2[n2])).getInHoursCharge() * 100.0) / 100.0;
                            d20 += (double)Math.round(((BMeterHistoryRecord)((Object)object2[n2])).getOutHoursCharge() * 100.0) / 100.0;
                            break;
                        }
                        if (bMeter.getMeterType() != BMeterType.other) break;
                        if (this.getOtherFacets() == BFacets.NULL) {
                            this.setOtherFacets(((BMeterHistoryRecord)((Object)object2[n2])).getValueFacets());
                        }
                        d21 += ((BMeterHistoryRecord)((Object)object2[n2])).getInHoursUsed();
                        d22 += ((BMeterHistoryRecord)((Object)object2[n2])).getOutHoursUsed();
                        d23 += (double)Math.round(((BMeterHistoryRecord)((Object)object2[n2])).getInHoursCharge() * 100.0) / 100.0;
                        d24 += (double)Math.round(((BMeterHistoryRecord)((Object)object2[n2])).getOutHoursCharge() * 100.0) / 100.0;
                        break;
                    }
                    ++n2;
                }
                String string3 = SlotPath.escape((String)bMeter.getReference().format((Object)bMeter));
                Property property = bMeterGroup.add(string3 + '?', (BValue)bMeter2);
                if (TenantBillingToolkit.log.isTraceOn()) {
                    TenantBillingToolkit.log.trace("Added meter for InvoiceInfo: " + property.getName());
                }
                ((HashMap)object).put(property.getName(), BFormat.make((String)bMeter.getDisplayName(null)));
            }
            ++n;
        }
        this.setTotalElectricInHoursUsed(d);
        this.setTotalElectricOutHoursUsed(d2);
        this.setTotalElectricHoursUsed(d + d2);
        this.setTotalElectricInHoursCharge(d3);
        this.setTotalElectricOutHoursCharge(d4);
        this.setTotalElectricCharge(d3 + d4);
        this.setTotalGasInHoursUsed(d5);
        this.setTotalGasOutHoursUsed(d6);
        this.setTotalGasHoursUsed(d5 + d6);
        this.setTotalGasInHoursCharge(d7);
        this.setTotalGasOutHoursCharge(d8);
        this.setTotalGasCharge(d7 + d8);
        this.setTotalOutsideAirTempInHoursUsed(d9);
        this.setTotalOutsideAirTempOutHoursUsed(d10);
        this.setTotalOutsideAirTempHoursUsed(d9 + d10);
        this.setTotalOutsideAirTempInHoursCharge(d11);
        this.setTotalOutsideAirTempOutHoursCharge(d12);
        this.setTotalOutsideAirTempCharge(d11 + d12);
        this.setTotalSewerInHoursUsed(d13);
        this.setTotalSewerOutHoursUsed(d14);
        this.setTotalSewerHoursUsed(d13 + d14);
        this.setTotalSewerInHoursCharge(d15);
        this.setTotalSewerOutHoursCharge(d16);
        this.setTotalSewerCharge(d15 + d16);
        this.setTotalWaterInHoursUsed(d17);
        this.setTotalWaterOutHoursUsed(d18);
        this.setTotalWaterHoursUsed(d17 + d18);
        this.setTotalWaterInHoursCharge(d19);
        this.setTotalWaterOutHoursCharge(d20);
        this.setTotalWaterCharge(d19 + d20);
        this.setTotalOtherInHoursUsed(d21);
        this.setTotalOtherOutHoursUsed(d22);
        this.setTotalOtherHoursUsed(d21 + d22);
        this.setTotalOtherInHoursCharge(d23);
        this.setTotalOtherOutHoursCharge(d24);
        this.setTotalOtherCharge(d23 + d24);
        bMeterGroup.add("displayNames", (BValue)BNameMap.make((HashMap)object));
        this.setMeters(bMeterGroup);
        this.setTotal(this.getTotal(bInvoiceHistoryRecord, (BMeterHistoryRecord[])object2));
        this.setTax(this.calcTax(bInvoiceHistoryRecord, (BMeterHistoryRecord[])object2));
        this.startLingerTimer();
    }

    private final double getTotal(BInvoiceHistoryRecord bInvoiceHistoryRecord, BMeterHistoryRecord[] bMeterHistoryRecordArray) {
        double d = 0.0;
        int n = 0;
        while (n < bMeterHistoryRecordArray.length) {
            double d2 = (double)Math.round(bMeterHistoryRecordArray[n].getInHoursCharge() * 100.0) / 100.0;
            double d3 = (double)Math.round(bMeterHistoryRecordArray[n].getOutHoursCharge() * 100.0) / 100.0;
            d += (double)Math.round((d2 + d3) * 100.0) / 100.0;
            ++n;
        }
        double d4 = d + bInvoiceHistoryRecord.getManagementFee() + bInvoiceHistoryRecord.getFacilitiesImprovementFee() + bInvoiceHistoryRecord.getSurcharge() + bInvoiceHistoryRecord.getAdjustment();
        d4 = (double)Math.round(d4 * 100.0) / 100.0;
        if (bInvoiceHistoryRecord.getIncludeTax()) {
            d4 += (double)Math.round(d4 * (bInvoiceHistoryRecord.getTaxRatePercentage() / 100.0) * 100.0) / 100.0;
        }
        return d4;
    }

    private final double calcTax(BInvoiceHistoryRecord bInvoiceHistoryRecord, BMeterHistoryRecord[] bMeterHistoryRecordArray) {
        double d = 0.0;
        if (bInvoiceHistoryRecord.getIncludeTax()) {
            double d2 = 0.0;
            int n = 0;
            while (n < bMeterHistoryRecordArray.length) {
                double d3 = (double)Math.round(bMeterHistoryRecordArray[n].getInHoursCharge() * 100.0) / 100.0;
                double d4 = (double)Math.round(bMeterHistoryRecordArray[n].getOutHoursCharge() * 100.0) / 100.0;
                d2 += d3 + d4;
                ++n;
            }
            double d5 = d2 + bInvoiceHistoryRecord.getManagementFee() + bInvoiceHistoryRecord.getFacilitiesImprovementFee() + bInvoiceHistoryRecord.getSurcharge() + bInvoiceHistoryRecord.getAdjustment();
            d = d5 * (bInvoiceHistoryRecord.getTaxRatePercentage() / 100.0);
        }
        return d;
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final void subscribed() {
        this.stopLingerTimer();
    }

    public final void unsubscribed() {
        if (this.isRunning()) {
            this.startLingerTimer();
        }
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BTenantBillingService;
    }

    public final BFacets getSlotFacets(Slot slot) {
        BFacets bFacets = super.getSlotFacets(slot);
        if (slot == total || slot == totalElectricInHoursCharge || slot == totalElectricOutHoursCharge || slot == totalElectricCharge || slot == totalGasInHoursCharge || slot == totalGasOutHoursCharge || slot == totalGasCharge || slot == totalOutsideAirTempInHoursCharge || slot == totalOutsideAirTempOutHoursCharge || slot == totalOutsideAirTempCharge || slot == totalSewerInHoursCharge || slot == totalSewerOutHoursCharge || slot == totalSewerCharge || slot == totalWaterInHoursCharge || slot == totalWaterOutHoursCharge || slot == totalWaterCharge || slot == totalOtherInHoursCharge || slot == totalOtherOutHoursCharge || slot == totalOtherCharge || slot == tax) {
            BFacets bFacets2 = null;
            bFacets2 = this.getShowChargeSeparator() ? BFacets.make((BFacets)SHOW_SEP, (BFacets)this.getRecord().getChargeFacets()) : this.getRecord().getChargeFacets();
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)bFacets2);
        } else if (slot == totalElectricInHoursUsed || slot == totalElectricOutHoursUsed || slot == totalElectricHoursUsed) {
            BFacets bFacets3 = this.getElectricFacets();
            if (this.getShowUsageSeparator()) {
                bFacets3 = BFacets.make((BFacets)bFacets3, (BFacets)SHOW_SEP);
            }
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)bFacets3);
        } else if (slot == totalGasInHoursUsed || slot == totalGasOutHoursUsed || slot == totalGasHoursUsed) {
            BFacets bFacets4 = this.getGasFacets();
            if (this.getShowUsageSeparator()) {
                bFacets4 = BFacets.make((BFacets)bFacets4, (BFacets)SHOW_SEP);
            }
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)bFacets4);
        } else if (slot == totalOutsideAirTempInHoursUsed || slot == totalOutsideAirTempOutHoursUsed || slot == totalOutsideAirTempHoursUsed) {
            BFacets bFacets5 = this.getOutdoorairFacets();
            if (this.getShowUsageSeparator()) {
                bFacets5 = BFacets.make((BFacets)bFacets5, (BFacets)SHOW_SEP);
            }
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)bFacets5);
        } else if (slot == totalSewerInHoursUsed || slot == totalSewerOutHoursUsed || slot == totalSewerHoursUsed) {
            BFacets bFacets6 = this.getSewerFacets();
            if (this.getShowUsageSeparator()) {
                bFacets6 = BFacets.make((BFacets)bFacets6, (BFacets)SHOW_SEP);
            }
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)bFacets6);
        } else if (slot == totalWaterInHoursUsed || slot == totalWaterOutHoursUsed || slot == totalWaterHoursUsed) {
            BFacets bFacets7 = this.getWaterFacets();
            if (this.getShowUsageSeparator()) {
                bFacets7 = BFacets.make((BFacets)bFacets7, (BFacets)SHOW_SEP);
            }
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)bFacets7);
        } else if (slot == totalOtherInHoursUsed || slot == totalOtherOutHoursUsed || slot == totalOtherHoursUsed) {
            BFacets bFacets8 = this.getOtherFacets();
            if (this.getShowUsageSeparator()) {
                bFacets8 = BFacets.make((BFacets)bFacets8, (BFacets)SHOW_SEP);
            }
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)bFacets8);
        }
        return bFacets;
    }

    public final void doRemoveFromParent() {
        if (this.isRunning()) {
            this.getParent().asComponent().remove((BComplex)this);
        }
    }

    private final void startLingerTimer() {
        this.stopLingerTimer();
        this.lingerTicket = Clock.schedule((BComponent)this, (BRelTime)LINGER_TIMEOUT, (Action)removeFromParent, null);
    }

    private final void stopLingerTimer() {
        if (this.lingerTicket != null) {
            this.lingerTicket.cancel();
            this.lingerTicket = null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lingerTicket = null;
    }

    public BInvoiceInfo() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$niagaratenantbilling$invoice$BInvoiceInfo;
        if (clazz == null) {
            clazz = class$com$tridium$niagaratenantbilling$invoice$BInvoiceInfo = BInvoiceInfo.class("[Lcom.tridium.niagaratenantbilling.invoice.BInvoiceInfo;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"detailsView.png");
        LINGER_TIMEOUT = BRelTime.makeSeconds((int)25);
        SHOW_SEP = BFacets.make((String)"showSeparators", (BIDataValue)BBoolean.make((boolean)true));
    }
}

