/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaratenantbilling.invoice;

import com.tridium.niagaratenantbilling.BTenantBillingService;
import com.tridium.niagaratenantbilling.contract.BContract;
import com.tridium.niagaratenantbilling.history.BInvoiceHistoryRecord;
import com.tridium.niagaratenantbilling.history.BMeterHistoryRecord;
import com.tridium.niagaratenantbilling.invoice.BInvoiceGeneratorExtension;
import com.tridium.niagaratenantbilling.invoice.BInvoiceGeneratorJob;
import com.tridium.niagaratenantbilling.invoice.InvoiceHistoryData;
import com.tridium.niagaratenantbilling.tenant.BTenant;
import com.tridium.niagaratenantbilling.util.TenantBillingToolkit;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.AuditEvent;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BInvoiceGeneratorJobStep
extends BComponent {
    public static final Property contract = BInvoiceGeneratorJobStep.newProperty((int)4, (BValue)BOrd.NULL, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$invoice$BInvoiceGeneratorJobStep;
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$invoice$BInvoiceGeneratorExtension;

    public final BOrd getContract() {
        return (BOrd)this.get(contract);
    }

    public final void setContract(BOrd bOrd) {
        this.set(contract, (BValue)bOrd, null);
    }

    public final Type getType() {
        return TYPE;
    }

    final boolean run(BInvoiceGeneratorJob bInvoiceGeneratorJob, Lexicon lexicon, Context context) {
        BInvoiceHistoryRecord bInvoiceHistoryRecord = null;
        if (this.isRunning()) {
            BContract bContract = null;
            try {
                try {
                    bContract = (BContract)this.getContract().resolve((BObject)this).get();
                }
                catch (UnresolvedException unresolvedException) {
                    throw new Exception(lexicon.getText("invoicejob.unresolvedContract") + ": " + this.getContract());
                }
                if (bContract.getStatus().isDisabled()) {
                    throw new Exception(lexicon.getText("invoicejob.contractDisabled") + ": " + SlotPath.unescape((String)bContract.toPathString()));
                }
                bInvoiceGeneratorJob.log().success(lexicon.getText("invoicejob.startingInvoiceGeneration") + ": " + SlotPath.unescape((String)bContract.toPathString()));
                bInvoiceHistoryRecord = new BInvoiceHistoryRecord();
                bInvoiceHistoryRecord.setTimestamp(BAbsTime.now());
                BTenantBillingService bTenantBillingService = (BTenantBillingService)Sys.getService((Type)BTenantBillingService.TYPE);
                bInvoiceHistoryRecord.setInvoiceReference(bTenantBillingService.getInvoices().getFreshInvoiceReference(((BTenant)bContract.getParent()).getName()));
                bInvoiceGeneratorJob.log().success(lexicon.getText("invoicejob.invoiceReference") + ": " + bInvoiceHistoryRecord.getInvoiceReference());
                bInvoiceHistoryRecord.setStartDate(BAbsTime.make((BAbsTime)bInvoiceGeneratorJob.getStartDate(), (BTime)TenantBillingToolkit.START_DAY_TIME));
                bInvoiceHistoryRecord.setEndDate(BAbsTime.make((BAbsTime)bInvoiceGeneratorJob.getEndDate(), (BTime)TenantBillingToolkit.START_DAY_TIME));
                bInvoiceHistoryRecord.setAdjustment(bInvoiceGeneratorJob.getAdjustment());
                bInvoiceHistoryRecord.setAdjustmentDescription(bInvoiceGeneratorJob.getAdjustmentDescription());
                bInvoiceGeneratorJob.log().success(lexicon.getText("invoicejob.addingInvoice"));
                InvoiceHistoryData invoiceHistoryData = new InvoiceHistoryData();
                invoiceHistoryData.setInvoiceRecord(bInvoiceHistoryRecord);
                bContract.addInvoiceData(invoiceHistoryData, lexicon);
                BTenant bTenant = (BTenant)bContract.getParent();
                BHistoryId bHistoryId = BHistoryId.make((String)bTenant.getId(), (String)bContract.getName());
                BHistoryId bHistoryId2 = TenantBillingToolkit.getMeterHistoryId(bTenant.getId(), bContract.getName());
                BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
                BHistoryConfig bHistoryConfig = new BHistoryConfig(bHistoryId, BTypeSpec.make((Type)BInvoiceHistoryRecord.TYPE));
                bHistoryConfig.setTimeZone(BTimeZone.getLocal());
                bHistoryConfig.setCapacity(bTenantBillingService.getInvoices().getInvoiceHistoryCapacity());
                bHistoryConfig.setFullPolicy(bTenantBillingService.getInvoices().getInvoiceHistoryFullPolicy());
                BHistoryConfig bHistoryConfig2 = new BHistoryConfig(bHistoryId2, BTypeSpec.make((Type)BMeterHistoryRecord.TYPE));
                bHistoryConfig2.setTimeZone(BTimeZone.getLocal());
                bHistoryConfig2.setCapacity(bTenantBillingService.getInvoices().getInvoiceHistoryCapacity());
                bHistoryConfig2.setFullPolicy(bTenantBillingService.getInvoices().getInvoiceHistoryFullPolicy());
                bInvoiceGeneratorJob.log().success(lexicon.getText("invoicejob.addingInvoiceHistory") + ": " + bHistoryId);
                if (!bHistoryDatabase.exists(bHistoryId)) {
                    bHistoryDatabase.createHistory(bHistoryConfig);
                } else {
                    bHistoryDatabase.reconfigureHistory(bHistoryConfig);
                }
                if (!bHistoryDatabase.exists(bHistoryId2)) {
                    bHistoryDatabase.createHistory(bHistoryConfig2);
                } else {
                    bHistoryDatabase.reconfigureHistory(bHistoryConfig2);
                }
                BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
                bIHistory.append((BIHistoryRecordSet)bInvoiceHistoryRecord);
                BIHistory bIHistory2 = bHistoryDatabase.getHistory(bHistoryId2);
                bInvoiceGeneratorJob.log().success(lexicon.getText("invoicejob.addingMeterHistory") + ": " + bHistoryId2);
                BMeterHistoryRecord[] bMeterHistoryRecordArray = invoiceHistoryData.getMeterRecords();
                int n = 0;
                while (n < bMeterHistoryRecordArray.length) {
                    bMeterHistoryRecordArray[n].setTimestamp(bInvoiceHistoryRecord.getTimestamp());
                    bMeterHistoryRecordArray[n].setInvoiceReference(bInvoiceHistoryRecord.getInvoiceReference());
                    bIHistory2.append((BIHistoryRecordSet)bMeterHistoryRecordArray[n]);
                    ++n;
                }
                this.processExtensions(bInvoiceHistoryRecord, bInvoiceGeneratorJob, lexicon);
                bContract.setStatus(BStatus.makeFault((BStatus)bContract.getStatus(), (boolean)false));
                bContract.setLastOkTime(BAbsTime.now());
                bContract.fireInvoiceGenerated(BString.make((String)bInvoiceHistoryRecord.getInvoiceReference()));
                this.audit(bContract, bInvoiceHistoryRecord.getInvoiceReference(), true, context);
                return true;
            }
            catch (Exception exception) {
                Object object;
                BFacets bFacets = BFacets.NULL;
                if (bContract != null) {
                    bContract.setStatus(BStatus.makeFault((BStatus)bContract.getStatus(), (boolean)true));
                    bContract.setLastFailureTime(BAbsTime.now());
                    bContract.setLastFailureCause(exception.getMessage());
                    bFacets = BFacets.make((String)"invoiceGenertaionContract", (String)bContract.toPathString());
                    object = "";
                    if (bInvoiceHistoryRecord != null) {
                        object = bInvoiceHistoryRecord.getInvoiceReference();
                    }
                    this.audit(bContract, (String)object, false, context);
                }
                try {
                    bFacets = BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)"invoiceGenerationFailureCause", (BIDataValue)BString.make((String)exception.getMessage())));
                    object = (BTenantBillingService)Sys.getService((Type)BTenantBillingService.TYPE);
                    object.getInvoices().raiseAlarm(bFacets);
                }
                catch (Exception exception2) {
                    TenantBillingToolkit.log.error("Fatal error attempting to raise alarm from Invoice Generation", (Throwable)exception2);
                }
                TenantBillingToolkit.log.error("Error creating the invoice history data", (Throwable)exception);
                bInvoiceGeneratorJob.failed(exception);
            }
        }
        return false;
    }

    private final void audit(BContract bContract, String string, boolean bl, Context context) {
        String string2 = "";
        if (context != null && context.getUser() != null) {
            string2 = context.getUser().getName();
        }
        Sys.getAuditor().audit(new AuditEvent(bl ? "invoiceGenerationOk" : "invoiceGenerationFailed", bContract.toPathString(), bContract.getName(), "", string, string2));
    }

    final void processExtensions(BInvoiceHistoryRecord bInvoiceHistoryRecord, BInvoiceGeneratorJob bInvoiceGeneratorJob, Lexicon lexicon) throws Exception {
        Class clazz = class$com$tridium$niagaratenantbilling$invoice$BInvoiceGeneratorExtension;
        if (clazz == null) {
            clazz = class$com$tridium$niagaratenantbilling$invoice$BInvoiceGeneratorExtension = BInvoiceGeneratorJobStep.class("[Lcom.tridium.niagaratenantbilling.invoice.BInvoiceGeneratorExtension;", false);
        }
        BInvoiceGeneratorExtension[] bInvoiceGeneratorExtensionArray = (BInvoiceGeneratorExtension[])bInvoiceGeneratorJob.getChildren(clazz);
        int n = 0;
        while (n < bInvoiceGeneratorExtensionArray.length) {
            bInvoiceGeneratorExtensionArray[n].processInvoice(bInvoiceHistoryRecord, bInvoiceGeneratorJob, lexicon);
            ++n;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BInvoiceGeneratorJobStep() {
    }

    public BInvoiceGeneratorJobStep(BOrd bOrd) {
        this.setContract(bOrd);
    }

    static {
        Class clazz = class$com$tridium$niagaratenantbilling$invoice$BInvoiceGeneratorJobStep;
        if (clazz == null) {
            clazz = class$com$tridium$niagaratenantbilling$invoice$BInvoiceGeneratorJobStep = BInvoiceGeneratorJobStep.class("[Lcom.tridium.niagaratenantbilling.invoice.BInvoiceGeneratorJobStep;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

