/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaratenantbilling.invoice;

import com.tridium.niagaratenantbilling.BTenantBillingService;
import com.tridium.niagaratenantbilling.invoice.BInvoiceGeneratorJobStep;
import com.tridium.niagaratenantbilling.util.TenantBillingToolkit;
import javax.baja.data.BIDataValue;
import javax.baja.job.BJob;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BInvoiceGeneratorJob
extends BJob
implements Runnable {
    public static final Property startDate = BInvoiceGeneratorJob.newProperty((int)0, (BValue)BAbsTime.now().prevDay().prevMonth(), (BFacets)BInvoiceGeneratorJob.makeDateFacets());
    public static final Property endDate = BInvoiceGeneratorJob.newProperty((int)0, (BValue)BAbsTime.now().prevDay(), (BFacets)BInvoiceGeneratorJob.makeDateFacets());
    public static final Property adjustment = BInvoiceGeneratorJob.newProperty((int)0, (double)0.0, null);
    public static final Property adjustmentDescription = BInvoiceGeneratorJob.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Type TYPE;
    private Context lastContext;
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$invoice$BInvoiceGeneratorJob;
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$invoice$BInvoiceGeneratorJobStep;

    public final BAbsTime getStartDate() {
        return (BAbsTime)this.get(startDate);
    }

    public final void setStartDate(BAbsTime bAbsTime) {
        this.set(startDate, (BValue)bAbsTime, null);
    }

    public final BAbsTime getEndDate() {
        return (BAbsTime)this.get(endDate);
    }

    public final void setEndDate(BAbsTime bAbsTime) {
        this.set(endDate, (BValue)bAbsTime, null);
    }

    public final double getAdjustment() {
        return this.getDouble(adjustment);
    }

    public final void setAdjustment(double d) {
        this.setDouble(adjustment, d, null);
    }

    public final String getAdjustmentDescription() {
        return this.getString(adjustmentDescription);
    }

    public final void setAdjustmentDescription(String string) {
        this.setString(adjustmentDescription, string, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public static final BFacets makeDateFacets() {
        String[] stringArray = new String[]{"showDate", "showTime", "showSeconds", "showTimeZone"};
        BIDataValue[] bIDataValueArray = new BIDataValue[]{BBoolean.TRUE, BBoolean.FALSE, BBoolean.FALSE, BBoolean.FALSE};
        return BFacets.make((String[])stringArray, (BIDataValue[])bIDataValueArray);
    }

    public final void doRun(Context context) {
        this.lastContext = context;
        BTenantBillingService bTenantBillingService = (BTenantBillingService)Sys.getService((Type)BTenantBillingService.TYPE);
        bTenantBillingService.getWorker().post(this);
    }

    public final void doCancel(Context context) {
    }

    public final void run() {
        try {
            BTenantBillingService bTenantBillingService = (BTenantBillingService)Sys.getService((Type)BTenantBillingService.TYPE);
            if (bTenantBillingService.isLicensed()) {
                Class clazz = class$com$tridium$niagaratenantbilling$invoice$BInvoiceGeneratorJobStep;
                if (clazz == null) {
                    clazz = class$com$tridium$niagaratenantbilling$invoice$BInvoiceGeneratorJobStep = BInvoiceGeneratorJob.class("[Lcom.tridium.niagaratenantbilling.invoice.BInvoiceGeneratorJobStep;", false);
                }
                BInvoiceGeneratorJobStep[] bInvoiceGeneratorJobStepArray = (BInvoiceGeneratorJobStep[])this.getChildren(clazz);
                boolean bl = true;
                Lexicon lexicon = Lexicon.make((BModule)this.getType().getModule(), (Context)this.lastContext);
                if (bInvoiceGeneratorJobStepArray.length == 0) {
                    throw new Exception(lexicon.getText("invoicejob.noContracts"));
                }
                this.log().success(lexicon.getText("invoicejob.startDate") + ": " + this.getStartDate().toDateString(this.lastContext));
                this.log().success(lexicon.getText("invoicejob.endDate") + ":   " + this.getEndDate().toDateString(this.lastContext));
                int n = 0;
                while (n < bInvoiceGeneratorJobStepArray.length) {
                    if (!bInvoiceGeneratorJobStepArray[n].run(this, lexicon, this.lastContext)) {
                        bl = false;
                    }
                    ++n;
                }
                if (bl) {
                    this.success();
                } else {
                    this.failed(null);
                }
            } else {
                Lexicon lexicon = Lexicon.make((BModule)this.getType().getModule(), (Context)this.lastContext);
                this.log().failed(lexicon.getText("invoicejob.notLicensed"));
                if (BTenantBillingService.getTenantLimit() > 0) {
                    this.log().failed(lexicon.getText("invoicejob.licenseTenantCount") + ": " + String.valueOf(bTenantBillingService.getCurrentTenantCount()) + '/' + String.valueOf(BTenantBillingService.getTenantLimit()));
                }
                if (BTenantBillingService.getUtilityLimit() > 0) {
                    this.log().failed(lexicon.getText("invoicejob.licenseUtilityCount") + ": " + String.valueOf(bTenantBillingService.getCurrentUtilityCount()) + '/' + String.valueOf(BTenantBillingService.getUtilityLimit()));
                }
                this.failed(null);
            }
        }
        catch (Exception exception) {
            TenantBillingToolkit.log.error("Error creating the invoice");
            this.failed(exception);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$niagaratenantbilling$invoice$BInvoiceGeneratorJob;
        if (clazz == null) {
            clazz = class$com$tridium$niagaratenantbilling$invoice$BInvoiceGeneratorJob = BInvoiceGeneratorJob.class("[Lcom.tridium.niagaratenantbilling.invoice.BInvoiceGeneratorJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

