/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaratenantbilling.importcsv;

import com.tridium.niagaratenantbilling.util.TenantBillingToolkit;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.io.BIEncodable;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BImportCSVJob
extends BSimpleJob {
    public static final Property parentCompOrd = BImportCSVJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property fileText = BImportCSVJob.newProperty((int)0, (String)"", null);
    public static final Property newType = BImportCSVJob.newProperty((int)0, (BValue)BTypeSpec.NULL, null);
    public static final Type TYPE;
    private static final String NAME = "name";
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$importcsv$BImportCSVJob;

    public final BOrd getParentCompOrd() {
        return (BOrd)this.get(parentCompOrd);
    }

    public final void setParentCompOrd(BOrd bOrd) {
        this.set(parentCompOrd, (BValue)bOrd, null);
    }

    public final String getFileText() {
        return this.getString(fileText);
    }

    public final void setFileText(String string) {
        this.setString(fileText, string, null);
    }

    public final BTypeSpec getNewType() {
        return (BTypeSpec)this.get(newType);
    }

    public final void setNewType(BTypeSpec bTypeSpec) {
        this.set(newType, (BValue)bTypeSpec, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void run(Context context) throws Exception {
        BComponent bComponent = (BComponent)this.getParentCompOrd().resolve((BObject)this).get();
        String[] stringArray = TextUtil.split((String)this.getFileText(), (char)'\n');
        Lexicon lexicon = Lexicon.make((BModule)this.getType().getModule(), (Context)context);
        if (stringArray.length > 1) {
            Property property;
            this.log().success(lexicon.getText("importCSVJob.foundRows"));
            HashMap<String, Property> hashMap = new HashMap<String, Property>();
            BComponent bComponent2 = (BComponent)this.getNewType().getInstance();
            Property[] propertyArray = bComponent2.getPropertiesArray();
            int n = 0;
            while (n < propertyArray.length) {
                if (TenantBillingToolkit.log.isTraceOn()) {
                    TenantBillingToolkit.log.trace("Adding property: " + this.processStr(propertyArray[n].getName()));
                }
                hashMap.put(this.processStr(propertyArray[n].getName()), propertyArray[n]);
                ++n;
            }
            this.log().success(lexicon.getText("importCSVJob.targetType") + ": " + bComponent2.getType().getTypeName());
            String[] stringArray2 = TextUtil.split((String)stringArray[0], (char)',');
            HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
            String string = "";
            int n2 = 0;
            while (n2 < stringArray2.length) {
                string = this.processStr(stringArray2[n2]);
                property = (Property)hashMap.get(string);
                if (TextUtil.fromFriendly((String)stringArray2[n2]).equals(NAME)) {
                    this.log().success(lexicon.getText("importCSVJob.foundName") + ": " + stringArray2[n2]);
                    hashMap2.put(new Integer(n2), string);
                } else if (property != null) {
                    if (property.getDefaultValue() instanceof BIEncodable) {
                        this.log().success(lexicon.getText("importCSVJob.foundProperty") + ": " + stringArray2[n2]);
                        hashMap2.put(new Integer(n2), string);
                    } else {
                        this.log().failed(lexicon.getText("importCSVJob.foundPropertyNoType"));
                    }
                } else {
                    this.log().message(lexicon.getText("importCSVJob.couldNotFindProperty") + ": " + stringArray2[n2]);
                }
                ++n2;
            }
            String string2 = "";
            String string3 = null;
            if (hashMap2.isEmpty()) {
                this.log().failed(lexicon.getText("importCSVJob.couldNotFindPropertyMapToo"));
            } else {
                int n3 = 1;
                while (n3 < stringArray.length) {
                    String[] stringArray3 = TextUtil.split((String)stringArray[n3], (char)',');
                    if (stringArray3.length > 0) {
                        this.log().message(lexicon.getText("importCSVJob.processingRow") + ": " + String.valueOf(n3));
                        BComponent bComponent3 = (BComponent)bComponent2.getType().getInstance();
                        int n4 = 0;
                        while (n4 < stringArray3.length) {
                            string2 = (String)hashMap2.get(new Integer(n4));
                            if (string2 != null) {
                                if (string2.equals(NAME)) {
                                    string3 = TextUtil.replace((String)stringArray3[n4], (String)"\"", (String)"");
                                } else {
                                    property = (Property)hashMap.get(string2);
                                    if (property != null && !property.getType().is(BStatus.TYPE)) {
                                        if (TenantBillingToolkit.log.isTraceOn()) {
                                            TenantBillingToolkit.log.trace("Importing property: " + string2 + " at index: " + n4);
                                        }
                                        BIEncodable bIEncodable = (BIEncodable)property.getType().getInstance();
                                        try {
                                            bComponent3.set(property, (BValue)bIEncodable.decodeFromString(TextUtil.replace((String)stringArray3[n4], (String)"\"", (String)"")));
                                        }
                                        catch (IOException iOException) {
                                            if (TenantBillingToolkit.log.isTraceOn()) {
                                                TenantBillingToolkit.log.trace("Error decoding string on import csv", (Throwable)iOException);
                                            }
                                            this.log().failed(lexicon.getText("importCSVJob.errorMappingType") + ": " + bIEncodable.getType() + ' ' + lexicon.getText("importCSVJob.withData") + ": " + stringArray3[n4]);
                                        }
                                    }
                                }
                            }
                            ++n4;
                        }
                        if (string3 != null) {
                            string3 = SlotPath.escape(string3);
                            string3 = string3 + '?';
                        }
                        bComponent.add(string3, (BValue)bComponent3, 256);
                        this.log().success(lexicon.getText("importCSVJob.addingNewComponent") + ": " + bComponent3.getName());
                    }
                    ++n3;
                }
            }
        } else {
            this.log().failed(lexicon.getText("importCSVJob.couldNotFindData"));
        }
    }

    private final String processStr(String string) {
        return TextUtil.replace((String)string.toLowerCase(), (String)" ", (String)"");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BImportCSVJob() {
    }

    public BImportCSVJob(BOrd bOrd, String string, BTypeSpec bTypeSpec) {
        this.setParentCompOrd(bOrd);
        this.setFileText(string);
        this.setNewType(bTypeSpec);
    }

    static {
        Class clazz = class$com$tridium$niagaratenantbilling$importcsv$BImportCSVJob;
        if (clazz == null) {
            clazz = class$com$tridium$niagaratenantbilling$importcsv$BImportCSVJob = BImportCSVJob.class("[Lcom.tridium.niagaratenantbilling.importcsv.BImportCSVJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

