/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaratenantbilling.history;

import com.tridium.niagaratenantbilling.history.BTenantBillingHistoryRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BInvoiceHistoryRecord
extends BTenantBillingHistoryRecord {
    public static final Property invoiceReference = BInvoiceHistoryRecord.newProperty((int)1, (String)"", null);
    public static final Property startDate = BInvoiceHistoryRecord.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE));
    public static final Property endDate = BInvoiceHistoryRecord.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE));
    public static final Property contractOrd = BInvoiceHistoryRecord.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Property includeTax = BInvoiceHistoryRecord.newProperty((int)1, (boolean)true, null);
    public static final Property taxRatePercentage = BInvoiceHistoryRecord.newProperty((int)1, (double)0.0, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"percent"), (BNumber)BDouble.make((double)0.0), (BNumber)BDouble.POSITIVE_INFINITY));
    public static final Property managementFee = BInvoiceHistoryRecord.newProperty((int)1, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)));
    public static final Property facilitiesImprovementFee = BInvoiceHistoryRecord.newProperty((int)1, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)));
    public static final Property surcharge = BInvoiceHistoryRecord.newProperty((int)1, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)));
    public static final Property adjustment = BInvoiceHistoryRecord.newProperty((int)1, (double)0.0, null);
    public static final Property adjustmentDescription = BInvoiceHistoryRecord.newProperty((int)1, (String)"", null);
    public static final Property data = BInvoiceHistoryRecord.newProperty((int)1, (BValue)BFacets.NULL, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$history$BInvoiceHistoryRecord;

    public final String getInvoiceReference() {
        return this.getString(invoiceReference);
    }

    public final void setInvoiceReference(String string) {
        this.setString(invoiceReference, string, null);
    }

    public final BAbsTime getStartDate() {
        return (BAbsTime)this.get(startDate);
    }

    public final void setStartDate(BAbsTime bAbsTime) {
        this.set(startDate, (BValue)bAbsTime, null);
    }

    public final BAbsTime getEndDate() {
        return (BAbsTime)this.get(endDate);
    }

    public final void setEndDate(BAbsTime bAbsTime) {
        this.set(endDate, (BValue)bAbsTime, null);
    }

    public final BOrd getContractOrd() {
        return (BOrd)this.get(contractOrd);
    }

    public final void setContractOrd(BOrd bOrd) {
        this.set(contractOrd, (BValue)bOrd, null);
    }

    public final boolean getIncludeTax() {
        return this.getBoolean(includeTax);
    }

    public final void setIncludeTax(boolean bl) {
        this.setBoolean(includeTax, bl, null);
    }

    public final double getTaxRatePercentage() {
        return this.getDouble(taxRatePercentage);
    }

    public final void setTaxRatePercentage(double d) {
        this.setDouble(taxRatePercentage, d, null);
    }

    public final double getManagementFee() {
        return this.getDouble(managementFee);
    }

    public final void setManagementFee(double d) {
        this.setDouble(managementFee, d, null);
    }

    public final double getFacilitiesImprovementFee() {
        return this.getDouble(facilitiesImprovementFee);
    }

    public final void setFacilitiesImprovementFee(double d) {
        this.setDouble(facilitiesImprovementFee, d, null);
    }

    public final double getSurcharge() {
        return this.getDouble(surcharge);
    }

    public final void setSurcharge(double d) {
        this.setDouble(surcharge, d, null);
    }

    public final double getAdjustment() {
        return this.getDouble(adjustment);
    }

    public final void setAdjustment(double d) {
        this.setDouble(adjustment, d, null);
    }

    public final String getAdjustmentDescription() {
        return this.getString(adjustmentDescription);
    }

    public final void setAdjustmentDescription(String string) {
        this.setString(adjustmentDescription, string, null);
    }

    public final BFacets getData() {
        return (BFacets)this.get(data);
    }

    public final void setData(BFacets bFacets) {
        this.set(data, (BValue)bFacets, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final boolean isFixedSize() {
        return false;
    }

    protected final void doRead(DataInput dataInput) throws IOException {
        super.doRead(dataInput);
        this.setInvoiceReference(dataInput.readUTF());
        this.setStartDate((BAbsTime)BAbsTime.DEFAULT.decode(dataInput));
        this.setEndDate((BAbsTime)BAbsTime.DEFAULT.decode(dataInput));
        this.setContractOrd(BOrd.make((String)dataInput.readUTF()));
        this.setIncludeTax(dataInput.readBoolean());
        this.setTaxRatePercentage(dataInput.readDouble());
        this.setManagementFee(dataInput.readDouble());
        this.setFacilitiesImprovementFee(dataInput.readDouble());
        this.setSurcharge(dataInput.readDouble());
        this.setAdjustment(dataInput.readDouble());
        this.setAdjustmentDescription(dataInput.readUTF());
        this.setData(BFacets.make((String)dataInput.readUTF()));
    }

    protected final void doWrite(DataOutput dataOutput) throws IOException {
        super.doWrite(dataOutput);
        dataOutput.writeUTF(this.getInvoiceReference());
        this.getStartDate().encode(dataOutput);
        this.getEndDate().encode(dataOutput);
        dataOutput.writeUTF(this.getContractOrd().toString());
        dataOutput.writeBoolean(this.getIncludeTax());
        dataOutput.writeDouble(this.getTaxRatePercentage());
        dataOutput.writeDouble(this.getManagementFee());
        dataOutput.writeDouble(this.getFacilitiesImprovementFee());
        dataOutput.writeDouble(this.getSurcharge());
        dataOutput.writeDouble(this.getAdjustment());
        dataOutput.writeUTF(this.getAdjustmentDescription());
        dataOutput.writeUTF(this.getData().encodeToString());
    }

    public final int getNumberOfDays() {
        return this.getStartDate().delta(this.getEndDate()).getDays() + 1;
    }

    public final String calTaxRatePercentage() {
        String string = this.getIncludeTax() ? BDouble.toString((double)this.getTaxRatePercentage(), (Context)this.getPercentageFacets()) : BDouble.toString((double)0.0, (Context)this.getPercentageFacets());
        return string;
    }

    public final BFacets getSlotFacets(Slot slot) {
        BFacets bFacets = super.getSlotFacets(slot);
        if (slot == taxRatePercentage) {
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)this.getPercentageFacets());
        } else if (slot == managementFee || slot == facilitiesImprovementFee || slot == surcharge || slot == adjustment) {
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)this.getChargeFacets());
        }
        return bFacets;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$niagaratenantbilling$history$BInvoiceHistoryRecord;
        if (clazz == null) {
            clazz = class$com$tridium$niagaratenantbilling$history$BInvoiceHistoryRecord = BInvoiceHistoryRecord.class("[Lcom.tridium.niagaratenantbilling.history.BInvoiceHistoryRecord;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

