/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaratenantbilling.contract;

import com.tridium.niagaratenantbilling.BTenantBillingStatusEnabledComponent;
import com.tridium.niagaratenantbilling.history.BInvoiceHistoryRecord;
import com.tridium.niagaratenantbilling.invoice.BIInvoiceFilter;
import com.tridium.niagaratenantbilling.invoice.BInvoiceInfo;
import com.tridium.niagaratenantbilling.invoice.InvoiceHistoryData;
import com.tridium.niagaratenantbilling.meter.BMeter;
import com.tridium.niagaratenantbilling.meter.BMeterList;
import com.tridium.niagaratenantbilling.tenant.BTenant;
import com.tridium.niagaratenantbilling.util.TenantBillingToolkit;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BContract
extends BTenantBillingStatusEnabledComponent
implements BIInvoiceFilter {
    private static final BFacets DEFAULT_FACETS = BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0), (String)"precision", (BIDataValue)BInteger.make((int)4), (String)"fieldEditor", (BIDataValue)BString.make((String)"niagaraTenantBilling:StatusNumericFE"));
    private static final BFacets TAX_RATE_FACETS = BFacets.make((BFacets)DEFAULT_FACETS, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"percent"), (BNumber)BDouble.make((double)0.0), (BNumber)BDouble.POSITIVE_INFINITY));
    public static final Property lastOkTime = BContract.newProperty((int)2051, (BValue)BAbsTime.NULL, null);
    public static final Property lastFailureTime = BContract.newProperty((int)2051, (BValue)BAbsTime.NULL, null);
    public static final Property lastFailureCause = BContract.newProperty((int)2051, (String)"", null);
    public static final Property description = BContract.newProperty((int)0, (String)"", null);
    public static final Property currency = BContract.newProperty((int)0, (String)"$", null);
    public static final Property includeTax = BContract.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"yes", (String)"no"));
    public static final Property taxRatePercentage = BContract.newProperty((int)0, (BValue)new BStatusNumeric(), (BFacets)TAX_RATE_FACETS);
    public static final Property managementFee = BContract.newProperty((int)0, (BValue)new BStatusNumeric(), (BFacets)DEFAULT_FACETS);
    public static final Property facilitiesImprovementFee = BContract.newProperty((int)0, (BValue)new BStatusNumeric(), (BFacets)DEFAULT_FACETS);
    public static final Property surcharge = BContract.newProperty((int)0, (BValue)new BStatusNumeric(), (BFacets)DEFAULT_FACETS);
    public static final Property template = BContract.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"niagaraTenantBilling:DualComponentOrdFE"), (String)"parentType", (BIDataValue)BString.make((String)"niagaraTenantBilling:TemplateGroup"), (String)"childType", (BIDataValue)BString.make((String)"niagaraTenantBilling:Template")));
    public static final Property meters = BContract.newProperty((int)0, (BValue)BMeterList.DEFAULT, null);
    public static final Topic invoiceGenerated = BContract.newTopic((int)0, null);
    public static final Type TYPE;
    public static final BIcon icon;
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$contract$BContract;

    public final BAbsTime getLastOkTime() {
        return (BAbsTime)this.get(lastOkTime);
    }

    public final void setLastOkTime(BAbsTime bAbsTime) {
        this.set(lastOkTime, (BValue)bAbsTime, null);
    }

    public final BAbsTime getLastFailureTime() {
        return (BAbsTime)this.get(lastFailureTime);
    }

    public final void setLastFailureTime(BAbsTime bAbsTime) {
        this.set(lastFailureTime, (BValue)bAbsTime, null);
    }

    public final String getLastFailureCause() {
        return this.getString(lastFailureCause);
    }

    public final void setLastFailureCause(String string) {
        this.setString(lastFailureCause, string, null);
    }

    public final String getDescription() {
        return this.getString(description);
    }

    public final void setDescription(String string) {
        this.setString(description, string, null);
    }

    public final String getCurrency() {
        return this.getString(currency);
    }

    public final void setCurrency(String string) {
        this.setString(currency, string, null);
    }

    public final boolean getIncludeTax() {
        return this.getBoolean(includeTax);
    }

    public final void setIncludeTax(boolean bl) {
        this.setBoolean(includeTax, bl, null);
    }

    public final BStatusNumeric getTaxRatePercentage() {
        return (BStatusNumeric)this.get(taxRatePercentage);
    }

    public final void setTaxRatePercentage(BStatusNumeric bStatusNumeric) {
        this.set(taxRatePercentage, (BValue)bStatusNumeric, null);
    }

    public final BStatusNumeric getManagementFee() {
        return (BStatusNumeric)this.get(managementFee);
    }

    public final void setManagementFee(BStatusNumeric bStatusNumeric) {
        this.set(managementFee, (BValue)bStatusNumeric, null);
    }

    public final BStatusNumeric getFacilitiesImprovementFee() {
        return (BStatusNumeric)this.get(facilitiesImprovementFee);
    }

    public final void setFacilitiesImprovementFee(BStatusNumeric bStatusNumeric) {
        this.set(facilitiesImprovementFee, (BValue)bStatusNumeric, null);
    }

    public final BStatusNumeric getSurcharge() {
        return (BStatusNumeric)this.get(surcharge);
    }

    public final void setSurcharge(BStatusNumeric bStatusNumeric) {
        this.set(surcharge, (BValue)bStatusNumeric, null);
    }

    public final BOrd getTemplate() {
        return (BOrd)this.get(template);
    }

    public final void setTemplate(BOrd bOrd) {
        this.set(template, (BValue)bOrd, null);
    }

    public final BMeterList getMeters() {
        return (BMeterList)this.get(meters);
    }

    public final void setMeters(BMeterList bMeterList) {
        this.set(meters, (BValue)bMeterList, null);
    }

    public final void fireInvoiceGenerated(BString bString) {
        this.fire(invoiceGenerated, (BValue)bString, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BTenant || bComponent instanceof BInvoiceInfo) {
            bl = true;
        }
        return bl;
    }

    public final BIcon getIcon() {
        return icon;
    }

    protected final AgentList doAgents(AgentList agentList, Context context) {
        agentList.toTop("niagaraTenantBilling:InvoiceHistoryManager");
        agentList.toTop("workbench:PropertySheet");
        return agentList;
    }

    public final void addInvoiceData(InvoiceHistoryData invoiceHistoryData, Lexicon lexicon) throws Exception {
        BInvoiceHistoryRecord bInvoiceHistoryRecord = invoiceHistoryData.getInvoiceRecord();
        bInvoiceHistoryRecord.setContractOrd(this.getHandleOrd());
        bInvoiceHistoryRecord.setCurrency(this.getCurrency());
        bInvoiceHistoryRecord.setIncludeTax(this.getIncludeTax());
        bInvoiceHistoryRecord.setTaxRatePercentage(this.getTaxRatePercentage().getValue());
        bInvoiceHistoryRecord.setManagementFee(this.getManagementFee().getValue());
        bInvoiceHistoryRecord.setFacilitiesImprovementFee(this.getFacilitiesImprovementFee().getValue());
        bInvoiceHistoryRecord.setSurcharge(this.getSurcharge().getValue());
        BAbsTime bAbsTime = bInvoiceHistoryRecord.getStartDate();
        BAbsTime bAbsTime2 = bInvoiceHistoryRecord.getEndDate();
        BOrd[] bOrdArray = this.getMeters().getOrdList().toArray();
        BDouble[] bDoubleArray = this.getMeters().getDoubles();
        if (bOrdArray.length == 0) {
            throw new Exception(lexicon.getText("invoicejob.noMetersFound") + ": " + this.toPathString());
        }
        int n = 0;
        while (n < bOrdArray.length) {
            if (!bOrdArray[n].isNull()) {
                BMeter bMeter = null;
                try {
                    bMeter = (BMeter)bOrdArray[n].resolve((BObject)this).get();
                }
                catch (UnresolvedException unresolvedException) {
                    throw new Exception(lexicon.getText("invoicejob.unresolvedMeter") + ": " + bOrdArray[n]);
                }
                if (bMeter.getStatus().isDisabled()) {
                    throw new Exception(lexicon.getText("invoicejob.meterDisabled") + ": " + bMeter.toPathString());
                }
                bMeter.calcInvoiceData(invoiceHistoryData, bAbsTime, bAbsTime2, bDoubleArray[n].getDouble(), lexicon);
            }
            ++n;
        }
    }

    public final String getInvoiceFilter() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(name = '");
        stringBuffer.append(TenantBillingToolkit.filterNameForBql(this.getName()));
        stringBuffer.append("' and parent.name = '");
        stringBuffer.append(TenantBillingToolkit.filterNameForBql(((BTenant)this.getParent()).getName()));
        stringBuffer.append("')");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$niagaratenantbilling$contract$BContract;
        if (clazz == null) {
            clazz = class$com$tridium$niagaratenantbilling$contract$BContract = BContract.class("[Lcom.tridium.niagaratenantbilling.contract.BContract;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://niagaraTenantBilling/res/contract.png");
    }
}

