/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaratenantbilling;

import com.tridium.niagaratenantbilling.BTenantBillingComponent;
import com.tridium.niagaratenantbilling.autobilling.BAutoBillingGroup;
import com.tridium.niagaratenantbilling.history.BInvoiceHistoryRecord;
import com.tridium.niagaratenantbilling.importcsv.BImportCSVJob;
import com.tridium.niagaratenantbilling.invoice.BInvoiceGeneratorJob;
import com.tridium.niagaratenantbilling.invoice.BInvoiceGroup;
import com.tridium.niagaratenantbilling.invoice.BInvoiceInfo;
import com.tridium.niagaratenantbilling.owner.BOwnerGroup;
import com.tridium.niagaratenantbilling.template.BTemplateGroup;
import com.tridium.niagaratenantbilling.test.BGenerateCSVData;
import com.tridium.niagaratenantbilling.test.BImportHistoryData;
import com.tridium.niagaratenantbilling.util.BTenantBillingWorker;
import com.tridium.niagaratenantbilling.util.TenantBillingToolkit;
import com.tridium.niagaratenantbilling.utility.BUtilityGroup;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import javax.baja.agent.AgentList;
import javax.baja.collection.BITable;
import javax.baja.email.BEmailService;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BTenantBillingService
extends BAbstractService {
    public static final Property worker = BTenantBillingService.newProperty((int)4, (BValue)new BTenantBillingWorker(), null);
    public static final Property owners = BTenantBillingService.newProperty((int)0, (BValue)new BOwnerGroup(), null);
    public static final Property utilities = BTenantBillingService.newProperty((int)0, (BValue)new BUtilityGroup(), null);
    public static final Property invoices = BTenantBillingService.newProperty((int)0, (BValue)new BInvoiceGroup(), null);
    public static final Property autoBilling = BTenantBillingService.newProperty((int)0, (BValue)new BAutoBillingGroup(), null);
    public static final Property templates = BTenantBillingService.newProperty((int)0, (BValue)new BTemplateGroup(), null);
    public static final Property tenantId = BTenantBillingService.newProperty((int)69, (int)0, null);
    public static final Action importHistoryFromCSV = BTenantBillingService.newAction((int)4, (BValue)new BImportHistoryData(), null);
    public static final Action generateCSVData = BTenantBillingService.newAction((int)4, (BValue)new BGenerateCSVData(), null);
    public static final Action submitImportJob = BTenantBillingService.newAction((int)4, (BValue)new BImportCSVJob(), null);
    public static final Action addInvoiceInfoToStation = BTenantBillingService.newAction((int)260, (BValue)new BInvoiceInfo(), null);
    public static final Action submitInvoiceGeneration = BTenantBillingService.newAction((int)4, (BValue)new BInvoiceGeneratorJob(), null);
    public static final Action getBrandLogo = BTenantBillingService.newAction((int)4, null);
    public static final Action getBrandBkColor = BTenantBillingService.newAction((int)4, null);
    public static final Type TYPE;
    public static final BIcon icon;
    private static boolean licensed;
    private static int tenantLimit;
    private static int utilityLimit;
    public static final String TENANT_FEATURE = "tenantBilling";
    public static final String TENANT_LIMIT_FEATURE = "tenant.limit";
    public static final String UTILITY_LIMIT_FEATURE = "utility.limit";
    public static final String LIMIT_NONE = "none";
    private static final String DEFAULT_LOGO = "module://niagaraTenantBilling/res/tbs.png";
    private static final String DEFAULT_BK_COLOR = "#ffffff";
    private Object tenantIdMonitor;
    static /* synthetic */ Class class$com$tridium$niagaratenantbilling$BTenantBillingService;

    public final BTenantBillingWorker getWorker() {
        return (BTenantBillingWorker)this.get(worker);
    }

    public final void setWorker(BTenantBillingWorker bTenantBillingWorker) {
        this.set(worker, (BValue)bTenantBillingWorker, null);
    }

    public final BOwnerGroup getOwners() {
        return (BOwnerGroup)this.get(owners);
    }

    public final void setOwners(BOwnerGroup bOwnerGroup) {
        this.set(owners, (BValue)bOwnerGroup, null);
    }

    public final BUtilityGroup getUtilities() {
        return (BUtilityGroup)this.get(utilities);
    }

    public final void setUtilities(BUtilityGroup bUtilityGroup) {
        this.set(utilities, (BValue)bUtilityGroup, null);
    }

    public final BInvoiceGroup getInvoices() {
        return (BInvoiceGroup)this.get(invoices);
    }

    public final void setInvoices(BInvoiceGroup bInvoiceGroup) {
        this.set(invoices, (BValue)bInvoiceGroup, null);
    }

    public final BAutoBillingGroup getAutoBilling() {
        return (BAutoBillingGroup)this.get(autoBilling);
    }

    public final void setAutoBilling(BAutoBillingGroup bAutoBillingGroup) {
        this.set(autoBilling, (BValue)bAutoBillingGroup, null);
    }

    public final BTemplateGroup getTemplates() {
        return (BTemplateGroup)this.get(templates);
    }

    public final void setTemplates(BTemplateGroup bTemplateGroup) {
        this.set(templates, (BValue)bTemplateGroup, null);
    }

    public final long getTenantId() {
        return this.getLong(tenantId);
    }

    public final void setTenantId(long l) {
        this.setLong(tenantId, l, null);
    }

    public final void importHistoryFromCSV(BImportHistoryData bImportHistoryData) {
        this.invoke(importHistoryFromCSV, (BValue)bImportHistoryData, null);
    }

    public final void generateCSVData(BGenerateCSVData bGenerateCSVData) {
        this.invoke(generateCSVData, (BValue)bGenerateCSVData, null);
    }

    public final BOrd submitImportJob(BImportCSVJob bImportCSVJob) {
        return (BOrd)this.invoke(submitImportJob, (BValue)bImportCSVJob, null);
    }

    public final BOrd addInvoiceInfoToStation(BInvoiceInfo bInvoiceInfo) {
        return (BOrd)this.invoke(addInvoiceInfoToStation, (BValue)bInvoiceInfo, null);
    }

    public final BOrd submitInvoiceGeneration(BInvoiceGeneratorJob bInvoiceGeneratorJob) {
        return (BOrd)this.invoke(submitInvoiceGeneration, (BValue)bInvoiceGeneratorJob, null);
    }

    public final BOrd getBrandLogo() {
        return (BOrd)this.invoke(getBrandLogo, null, null);
    }

    public final BString getBrandBkColor() {
        return (BString)this.invoke(getBrandBkColor, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public final void serviceStarted() {
    }

    public final void serviceStopped() {
    }

    public final void started() {
        if (this.isRunning() && !this.getComponentSpace().isProxyComponentSpace()) {
            try {
                Sys.getService((Type)BEmailService.TYPE);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                TenantBillingToolkit.log.warning("EmailService not found on station");
            }
        }
        if (TenantBillingToolkit.log.isTraceOn()) {
            TenantBillingToolkit.log.trace("*** Started Tridium Tenant Billing Service ***");
        }
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        TenantBillingToolkit.processAgents((BComponent)this, agentList);
        return BTenantBillingComponent.rearrangeAgentList(agentList);
    }

    public final void doImportHistoryFromCSV(BImportHistoryData bImportHistoryData) {
        try {
            BHistoryId bHistoryId = bImportHistoryData.getHistoryId();
            BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
            BHistoryConfig bHistoryConfig = new BHistoryConfig(bHistoryId, BTypeSpec.make((Type)BNumericTrendRecord.TYPE));
            bHistoryConfig.setCapacity(BCapacity.makeUnlimited());
            bHistoryConfig.setTimeZone(BTimeZone.getLocal());
            bHistoryConfig.add("valueFacets", (BValue)bImportHistoryData.getValueFacets());
            bHistoryConfig.add("minRolloverValue", bImportHistoryData.getMinRolloverValue().newCopy());
            bHistoryConfig.add("maxRolloverValue", bImportHistoryData.getMaxRolloverValue().newCopy());
            bHistoryConfig.add("useDelta", (BValue)BBoolean.make((boolean)bImportHistoryData.getUseDelta()));
            bHistoryConfig.setInterval(bImportHistoryData.getInterval());
            if (!bHistoryDatabase.exists(bHistoryId)) {
                bHistoryDatabase.createHistory(bHistoryConfig);
            } else {
                bHistoryDatabase.reconfigureHistory(bHistoryConfig);
            }
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            String[] stringArray = TextUtil.splitAndTrim((String)FileUtil.readString((BIFile)((BIFile)bImportHistoryData.getFileOrd().resolve((BObject)this).get())), (char)',');
            BNumericTrendRecord bNumericTrendRecord = null;
            BAbsTime bAbsTime = BAbsTime.NULL;
            double d = 0.0;
            if (TenantBillingToolkit.log.isTraceOn()) {
                TenantBillingToolkit.log.trace("*** Processing time value data ***");
            }
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].length() > 0) {
                    bAbsTime = BAbsTime.make((String)stringArray[n]);
                    d = Double.parseDouble(stringArray[++n]);
                    System.out.println("time: " + bAbsTime);
                    System.out.println("value: " + d);
                    bNumericTrendRecord = new BNumericTrendRecord();
                    bNumericTrendRecord.setTimestamp(bAbsTime);
                    bNumericTrendRecord.setValue(d);
                    bIHistory.append((BIHistoryRecordSet)bNumericTrendRecord);
                }
                ++n;
            }
            if (TenantBillingToolkit.log.isTraceOn()) {
                TenantBillingToolkit.log.trace("*** Finished processing time value data ***");
            }
        }
        catch (Exception exception) {
            TenantBillingToolkit.log.error("Error adding history data to station database", (Throwable)exception);
        }
    }

    public final void doGenerateCSVData(BGenerateCSVData bGenerateCSVData) {
        try {
            BAbsTime bAbsTime;
            File file = new File(Sys.getStationHome(), "testData");
            file.mkdirs();
            File file2 = new File(file, bGenerateCSVData.getFileName() + ".csv");
            if (file2.exists()) {
                file2.delete();
            }
            file2.createNewFile();
            FileWriter fileWriter = new FileWriter(file2);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            BAbsTime bAbsTime2 = BAbsTime.make((BAbsTime)bGenerateCSVData.getEndDate(), (BTime)TenantBillingToolkit.END_DAY_TIME);
            BRelTime bRelTime = BRelTime.make((long)(BRelTime.DAY.getMillis() * (long)bGenerateCSVData.getNumOfDays()));
            BAbsTime bAbsTime3 = bAbsTime = BAbsTime.make((BAbsTime)bAbsTime2.subtract(bRelTime), (BTime)TenantBillingToolkit.START_DAY_TIME);
            double d = 1.0;
            if (bGenerateCSVData.getUseDelta() && !bGenerateCSVData.getMinRolloverValue().getUnspecified()) {
                d = bGenerateCSVData.getMinRolloverValue().getValue();
            }
            if (TenantBillingToolkit.log.isTraceOn()) {
                TenantBillingToolkit.log.trace("Generating CSV data. Start: " + bAbsTime + " end: " + bAbsTime2);
            }
            while (bAbsTime3.isBefore(bAbsTime2)) {
                printWriter.print(bAbsTime3.encodeToString());
                printWriter.print(",");
                printWriter.print(String.valueOf(d));
                printWriter.print(",");
                bAbsTime3 = bAbsTime3.add(BRelTime.make((long)((int)((double)BRelTime.HOUR.getMillis() * bGenerateCSVData.getNumOfHoursBetween()))));
                if (!bGenerateCSVData.getUseDelta()) continue;
                d += 1.0;
                if (bGenerateCSVData.getMaxRolloverValue().getUnspecified() || !(d >= bGenerateCSVData.getMaxRolloverValue().getValue())) continue;
                d = !bGenerateCSVData.getMinRolloverValue().getUnspecified() ? bGenerateCSVData.getMinRolloverValue().getValue() : 1.0;
            }
            printWriter.close();
            if (TenantBillingToolkit.log.isTraceOn()) {
                TenantBillingToolkit.log.trace("Finished generating CSV data");
            }
        }
        catch (Exception exception) {
            TenantBillingToolkit.log.error("Error generating CSV file", (Throwable)exception);
        }
    }

    public final BOrd doSubmitImportJob(BImportCSVJob bImportCSVJob, Context context) {
        return bImportCSVJob.submit(context);
    }

    public final BOrd doAddInvoiceInfoToStation(BInvoiceInfo bInvoiceInfo) {
        BInvoiceInfo bInvoiceInfo2 = (BInvoiceInfo)bInvoiceInfo.newCopy();
        this.add("ViewInvoice?", (BValue)bInvoiceInfo2, 2310);
        return bInvoiceInfo2.getHandleOrd();
    }

    public final BOrd doSubmitInvoiceGeneration(BInvoiceGeneratorJob bInvoiceGeneratorJob, Context context) {
        BInvoiceGeneratorJob bInvoiceGeneratorJob2 = (BInvoiceGeneratorJob)bInvoiceGeneratorJob.newCopy();
        return bInvoiceGeneratorJob2.submit(context);
    }

    public final BOrd doGetBrandLogo() {
        return BOrd.make((String)this.loadFromBrandProperties("tbs.logo", DEFAULT_LOGO));
    }

    public final BString doGetBrandBkColor() {
        return BString.make((String)this.loadFromBrandProperties("tbs.bkcolor", DEFAULT_BK_COLOR));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String loadFromBrandProperties(String string, String string2) {
        InputStream inputStream = null;
        try {
            String string3;
            try {
                inputStream = ((BIFile)BOrd.make((String)"file:!lib/brand.properties").get((BObject)this)).getInputStream();
                Properties properties = new Properties();
                properties.load(inputStream);
                string3 = properties.getProperty(string, string2);
                Object var5_6 = null;
            }
            catch (Exception exception) {}
            try {
                if (inputStream == null) return string3;
                inputStream.close();
                return string3;
            }
            catch (Exception exception) {}
            return string3;
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {}
            catch (Exception exception) {}
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            return string2;
        }
        if (inputStream == null) return string2;
        inputStream.close();
        return string2;
    }

    public final BInvoiceInfo addInvoiceInfo(BInvoiceHistoryRecord bInvoiceHistoryRecord) {
        if (!this.isMounted()) {
            return null;
        }
        BInvoiceInfo bInvoiceInfo = BInvoiceInfo.make(bInvoiceHistoryRecord);
        BOrd bOrd = this.addInvoiceInfoToStation(bInvoiceInfo);
        try {
            if (this.getComponentSpace().isProxyComponentSpace()) {
                this.getComponentSpace().sync();
            }
        }
        catch (Exception exception) {
            TenantBillingToolkit.log.error("Error syncing component space on adding Invoice Info");
        }
        bInvoiceInfo = (BInvoiceInfo)bOrd.get((BObject)this);
        bInvoiceInfo.loadSlots();
        return bInvoiceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getNewTenantId() {
        long l = 0L;
        Object object = this.tenantIdMonitor;
        synchronized (object) {
            l = this.getTenantId();
            this.setTenantId(++l);
            return String.valueOf(l);
        }
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("Licensing");
        spyWriter.prop((Object)"License State", (Object)(this.isLicensed() ? "ok" : "not licensed"));
        spyWriter.prop((Object)"Tenant Limit", (Object)(tenantLimit == 0 ? LIMIT_NONE : String.valueOf(tenantLimit)));
        spyWriter.prop((Object)"Current Tenant Count", this.getCurrentTenantCount());
        spyWriter.prop((Object)"Utility Limit", (Object)(utilityLimit == 0 ? LIMIT_NONE : String.valueOf(utilityLimit)));
        spyWriter.prop((Object)"Current Tenant Count", this.getCurrentUtilityCount());
        spyWriter.endProps();
        super.spy(spyWriter);
    }

    public final Feature getLicenseFeature() {
        Feature[] featureArray = Sys.getLicenseManager().getFeatures();
        Feature feature = null;
        int n = 0;
        while (n < featureArray.length) {
            if (featureArray[n].getFeatureName().equals(TENANT_FEATURE)) {
                feature = featureArray[n];
            }
            ++n;
        }
        if (feature == null) {
            throw new FeatureNotLicensedException("tenantBilling is not licensed for this host.");
        }
        feature.check();
        String string = feature.get(TENANT_LIMIT_FEATURE, LIMIT_NONE);
        int n2 = Integer.parseInt(string.equals(LIMIT_NONE) ? "0" : string);
        String string2 = feature.get(UTILITY_LIMIT_FEATURE, LIMIT_NONE);
        int n3 = Integer.parseInt(string.equals(LIMIT_NONE) ? "0" : string);
        if (TenantBillingToolkit.log.isTraceOn()) {
            TenantBillingToolkit.log.trace("Tenant Billing System Licensed OK. Tenant limit: " + string + " -> Utility limit: " + string2);
        }
        tenantLimit = n2;
        utilityLimit = n3;
        licensed = true;
        return feature;
    }

    public final boolean isLicensed() {
        if (licensed && (tenantLimit > 0 || utilityLimit > 0)) {
            boolean bl = true;
            if (this.getCurrentTenantCount() > tenantLimit) {
                TenantBillingToolkit.log.error("Licensed Tenant Billing System tenant limit of " + tenantLimit + " has been exceeded");
                bl = false;
            }
            if (this.getCurrentUtilityCount() > utilityLimit) {
                TenantBillingToolkit.log.error("Licensed Tenant Billing System utility limit of " + utilityLimit + " has been exceeded");
                bl = false;
            }
            return bl;
        }
        return licensed;
    }

    public final int getCurrentTenantCount() {
        BITable bITable = (BITable)BOrd.make((BOrd)this.getOwners().getHandleOrd(), (String)"bql:select slotPath from niagaraTenantBilling:Tenant").get((BObject)this);
        return bITable.toList().list().length;
    }

    public final int getCurrentUtilityCount() {
        BITable bITable = (BITable)BOrd.make((BOrd)this.getUtilities().getHandleOrd(), (String)"bql:select slotPath from niagaraTenantBilling:Utility").get((BObject)this);
        return bITable.toList().list().length;
    }

    public static final int getTenantLimit() {
        return tenantLimit;
    }

    public static final int getUtilityLimit() {
        return utilityLimit;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.tenantIdMonitor = new Object();
    }

    public BTenantBillingService() {
        this.this();
        this.setFlags((Slot)enabled, 5);
    }

    static {
        Class clazz = class$com$tridium$niagaratenantbilling$BTenantBillingService;
        if (clazz == null) {
            clazz = class$com$tridium$niagaratenantbilling$BTenantBillingService = BTenantBillingService.class("[Lcom.tridium.niagaratenantbilling.BTenantBillingService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://icons/x16/dollarBill.png");
        licensed = false;
        tenantLimit = 0;
        utilityLimit = 0;
    }
}

