/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk.impl;

import com.tridium.silk.SoapEnvelope;
import com.tridium.silk.SoapFault;
import com.tridium.silk.impl.Soap11Envelope;
import com.tridium.silk.impl.Soap12Fault;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class Soap12Envelope
extends SoapEnvelope {
    public SoapFault asFault() {
        if (!this.isFault()) {
            throw new IllegalStateException("Not a fault envelope");
        }
        return new Soap12Fault(this.envelope);
    }

    public String getContentType() {
        return "application/soap+xml";
    }

    public SoapEnvelope newEnvelope() {
        XElem xElem = new XElem(this.envelope.ns(), this.getEnvelopeTag());
        xElem.defineNs(this.envelope.ns());
        return new Soap11Envelope(xElem);
    }

    public SoapFault newFault(String string, String string2, String string3, XContent xContent) {
        return new Soap12Fault(string, string2, string3, xContent);
    }

    public SoapFault newReceiverFault(String string, String string2, Throwable throwable) {
        return new Soap12Fault(Soap12Fault.CODE_RECEIVER, string, string2, (XContent)Soap12Envelope.toXml(throwable));
    }

    public SoapFault newSenderFault(String string, String string2, Throwable throwable) {
        return new Soap12Fault(Soap12Fault.CODE_SENDER, string, string2, (XContent)Soap12Envelope.toXml(throwable));
    }

    public Soap12Envelope() {
        this.setRoot(new XElem("env", SOAP_12.toString(), this.getEnvelopeTag()));
    }

    public Soap12Envelope(XElem xElem) {
        this.setRoot(xElem);
    }
}

