/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk.impl;

import com.tridium.silk.SoapEnvelope;
import com.tridium.silk.SoapFault;
import com.tridium.silk.impl.Soap11Envelope;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XNs;

public class Soap11Fault
extends Soap11Envelope
implements SoapFault {
    public static String CODE_VERSIONMISMATCH = "VersionMismatch";
    public static String CODE_MUSTUNDERSTAND = "MustUnderstand";
    public static String CODE_CLIENT = "Client";
    public static String CODE_SERVER = "Server";

    public SoapFault asFault() {
        return this;
    }

    public XElem getCode() {
        return this.elemCode(false);
    }

    public XElem getDetail(boolean bl) {
        return this.elemDetail(bl);
    }

    public SoapEnvelope getEnvelope() {
        return this;
    }

    public XElem getFault() {
        return this.elemFault(false);
    }

    public XElem getReason() {
        return this.elemReason(false);
    }

    public XElem getRole(boolean bl) {
        return this.elemRole(bl);
    }

    public boolean isMustUnderstand() {
        XElem xElem = this.elemCode(false);
        if (xElem == null) {
            return false;
        }
        String string = xElem.string();
        if (string == null) {
            return false;
        }
        return string.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_VERSIONMISMATCH);
    }

    public boolean isReceiver() {
        XElem xElem = this.elemCode(false);
        if (xElem == null) {
            return false;
        }
        String string = xElem.string();
        if (string == null) {
            return false;
        }
        return string.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_SERVER);
    }

    public boolean isSender() {
        XElem xElem = this.elemCode(false);
        if (xElem == null) {
            return false;
        }
        String string = xElem.string();
        if (string == null) {
            return false;
        }
        return string.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_CLIENT);
    }

    public boolean isVersionMismatch() {
        XElem xElem = this.elemCode(false);
        if (xElem == null) {
            return false;
        }
        String string = xElem.string();
        if (string == null) {
            return false;
        }
        return string.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_VERSIONMISMATCH);
    }

    protected XElem elemCode(boolean bl) {
        XElem xElem = this.elemFault(bl);
        if (xElem == null) {
            return null;
        }
        XElem xElem2 = xElem.elem(this.getCodeTag());
        if (xElem2 == null && bl) {
            xElem2 = new XElem(this.getCodeTag());
            xElem.addContent((XContent)xElem2);
        }
        return xElem2;
    }

    protected XElem elemDetail(boolean bl) {
        XElem xElem = this.elemFault(bl);
        if (xElem == null) {
            return null;
        }
        XElem xElem2 = xElem.elem(this.getDetailTag());
        if (xElem2 == null && bl) {
            xElem2 = new XElem(this.getDetailTag());
            xElem.addContent((XContent)xElem2);
        }
        return xElem2;
    }

    protected XElem elemReason(boolean bl) {
        XElem xElem = this.elemFault(bl);
        if (xElem == null) {
            return null;
        }
        XElem xElem2 = xElem.elem(this.getReasonTag());
        if (xElem2 == null && bl) {
            xElem2 = new XElem(this.getReasonTag());
            xElem.addContent((XContent)xElem2);
        }
        return xElem2;
    }

    protected XElem elemRole(boolean bl) {
        XElem xElem = this.elemFault(bl);
        if (xElem == null) {
            return null;
        }
        XElem xElem2 = xElem.elem(this.getRoleTag());
        if (xElem2 == null && bl) {
            xElem2 = new XElem(this.getRoleTag());
            xElem.addContent((XContent)xElem2);
        }
        return xElem2;
    }

    public String getCodeTag() {
        return "faultcode";
    }

    public String getDetailTag() {
        return "detail";
    }

    public String getReasonTag() {
        return "faultstring";
    }

    public String getRoleTag() {
        return "faultactor";
    }

    public Soap11Fault() {
        this.elemFault(true);
        this.elemCode(true);
        this.elemReason(true);
    }

    public Soap11Fault(String string, String string2, String string3, XContent xContent) {
        if (string == null) {
            throw new NullPointerException("Fault code can not be null.");
        }
        if (string3 == null) {
            throw new NullPointerException("Fault reason can not be null.");
        }
        XNs xNs = this.getEnvelopeNs();
        this.elemFault(true);
        String string4 = string;
        if (string2 != null) {
            string4 = string4 + '.' + string2;
        }
        string4 = xNs.prefix() + ':' + string4;
        this.elemCode(true).addText(string4);
        this.elemReason(true).addText(string3);
        if (xContent != null) {
            this.elemDetail(true).addContent(xContent);
        }
    }

    public Soap11Fault(XElem xElem) {
        super(xElem);
    }
}

