/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk;

import com.tridium.silk.SoapEnvelope;
import com.tridium.silk.impl.Soap11Envelope;
import com.tridium.silk.impl.Soap11Fault;
import com.tridium.silk.impl.Soap12Envelope;
import com.tridium.silk.impl.Soap12Fault;
import java.io.InputStream;
import javax.baja.naming.OrdTarget;
import javax.baja.web.WebOp;
import javax.baja.xml.XElem;
import javax.baja.xml.XNs;
import javax.baja.xml.XParser;

public class SoapContext
extends OrdTarget {
    WebOp cx;
    String lang;
    SoapEnvelope response;
    SoapEnvelope request;

    public String getLanguage() {
        if (this.lang == null) {
            return super.getLanguage();
        }
        return this.lang;
    }

    public SoapEnvelope getRequest() {
        return this.request;
    }

    public SoapEnvelope getResponse() {
        if (this.response == null) {
            this.response = this.request.newEnvelope();
        }
        return this.response;
    }

    public WebOp getWebOp() {
        return this.cx;
    }

    public void setLanguage(String string) {
        this.lang = string;
    }

    public void setResponse(SoapEnvelope soapEnvelope) {
        this.response = soapEnvelope;
    }

    protected static boolean isSoap11(XNs xNs) {
        return xNs.uri().equalsIgnoreCase(SoapEnvelope.SOAP_11.toString());
    }

    protected static boolean isSoap12(XNs xNs) {
        return xNs.uri().equalsIgnoreCase(SoapEnvelope.SOAP_12.toString());
    }

    static SoapEnvelope parse(InputStream inputStream) throws Exception {
        SoapEnvelope soapEnvelope = null;
        XElem xElem = XParser.make((InputStream)inputStream).parse(false);
        XNs xNs = xElem.ns();
        if (SoapContext.isSoap11(xNs)) {
            soapEnvelope = new Soap11Envelope(xElem);
        } else if (SoapContext.isSoap12(xNs)) {
            soapEnvelope = new Soap12Envelope(xElem);
        }
        if (soapEnvelope == null) {
            throw new IllegalArgumentException("Unrecognized namespace:" + xNs);
        }
        if (soapEnvelope.isFault()) {
            if (SoapContext.isSoap11(xNs)) {
                soapEnvelope = new Soap11Fault(soapEnvelope.getRoot());
            } else if (SoapContext.isSoap12(xNs)) {
                soapEnvelope = new Soap12Fault(soapEnvelope.getRoot());
            }
        }
        return soapEnvelope;
    }

    public SoapContext(WebOp webOp) throws Exception {
        super((OrdTarget)webOp);
        this.cx = webOp;
        this.request = SoapContext.parse((InputStream)webOp.getRequest().getInputStream());
    }
}

