/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.ui;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveDeviceFolder;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.BZWaveThermostat;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.cmdclass.BNodeInformation;
import com.tridium.zwave.cmdclass.BZWaveNames;
import com.tridium.zwave.enums.BGenericDeviceEnum;
import com.tridium.zwave.learn.BZWaveDeviceEntry;
import com.tridium.zwave.learn.BZWaveLearnDevicesJob;
import com.tridium.zwave.learn.BZWaveReplicateReceiveJob;
import com.tridium.zwave.learn.BZWaveTransferPrimaryJob;
import java.util.Vector;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveDeviceManager
extends BDeviceManager {
    public static final Type TYPE;
    static BImage stationIcon;
    static Lexicon lex;
    MgrColumn colName;
    MgrColumn colType;
    MgrColumn colDeviceExts;
    MgrColumn colStatus;
    MgrColumn colEnabled;
    MgrColumn colHealth;
    MgrColumn colNodeId;
    MgrColumn colDeviceType;
    MgrColumn colNodeName;
    MgrColumn colNodeLocation;
    MgrColumn colProfile;
    MgrColumn[] cols;
    static /* synthetic */ Class class$com$tridium$zwave$ui$BZWaveDeviceManager;
    static /* synthetic */ Class class$com$tridium$zwave$BZWaveDevice;
    static /* synthetic */ Class class$com$tridium$zwave$learn$BZWaveDeviceEntry;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn();
    }

    public void doLoadValue(BObject bObject, Context context) {
        super.doLoadValue(bObject, context);
        if (bObject instanceof BZWaveNetwork) {
            BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)bObject;
            Class clazz = class$com$tridium$zwave$BZWaveDevice;
            if (clazz == null) {
                clazz = class$com$tridium$zwave$BZWaveDevice = BZWaveDeviceManager.class("[Lcom.tridium.zwave.BZWaveDevice;", false);
            }
            BZWaveDevice[] bZWaveDeviceArray = (BZWaveDevice[])bZWaveNetwork.getChildren(clazz);
            Vector<BCmdClassObject> vector = new Vector<BCmdClassObject>();
            int n = 0;
            while (n < bZWaveDeviceArray.length) {
                vector.addElement(bZWaveDeviceArray[n].getVersion());
                vector.addElement(bZWaveDeviceArray[n].getNodeInfo());
                vector.addElement(bZWaveDeviceArray[n].getNaming());
                ++n;
            }
            BComponent[] bComponentArray = new BComponent[vector.size()];
            vector.toArray(bComponentArray);
            this.registerForComponentEvents(bComponentArray, 1);
        }
    }

    public BZWaveNetwork getNetwork() {
        BObject bObject = this.getCurrentValue();
        if (bObject instanceof BZWaveDeviceFolder) {
            return (BZWaveNetwork)((BZWaveDeviceFolder)bObject).getNetwork();
        }
        if (bObject instanceof BZWaveNetwork) {
            return (BZWaveNetwork)bObject;
        }
        return null;
    }

    void updateLearnData() {
        try {
            BZWaveLearnDevicesJob bZWaveLearnDevicesJob = (BZWaveLearnDevicesJob)this.getLearn().getJob();
            if (bZWaveLearnDevicesJob != null) {
                MgrLearn mgrLearn = this.getLearn();
                BFolder bFolder = bZWaveLearnDevicesJob.getLearnedDevices();
                Class clazz = class$com$tridium$zwave$learn$BZWaveDeviceEntry;
                if (clazz == null) {
                    clazz = class$com$tridium$zwave$learn$BZWaveDeviceEntry = BZWaveDeviceManager.class("[Lcom.tridium.zwave.learn.BZWaveDeviceEntry;", false);
                }
                mgrLearn.updateRoots(bFolder.getChildren(clazz));
            }
        }
        catch (Exception exception) {}
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.colName = new MgrColumn.Name();
        this.colType = new MgrColumn.Type();
        this.colDeviceExts = new DeviceExtsColumn((BDevice)new BZWaveDevice());
        this.colStatus = new MgrColumn.Prop(BDevice.status, 2);
        this.colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
        this.colHealth = new MgrColumn.Prop(BDevice.health, 0);
        this.colNodeId = new MgrColumn.Prop(BZWaveDevice.nodeId, 5);
        this.colDeviceType = new MgrColumn.PropPath(new Property[]{BZWaveDevice.nodeInfo, BNodeInformation.specificDeviceClass});
        this.colNodeName = new MgrColumn.PropPath(new Property[]{BZWaveDevice.naming, BZWaveNames.nodeName});
        this.colNodeLocation = new MgrColumn.PropPath(new Property[]{BZWaveDevice.naming, BZWaveNames.nodeLocation});
        this.colProfile = new MgrColumn.Prop(BZWaveDevice.deviceProfile);
        this.cols = new MgrColumn[]{this.colName, this.colType, this.colDeviceExts, this.colNodeId, this.colDeviceType, this.colStatus, this.colProfile, this.colNodeName, this.colNodeLocation, this.colEnabled, this.colHealth};
    }

    public BZWaveDeviceManager() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$zwave$ui$BZWaveDeviceManager;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$ui$BZWaveDeviceManager = BZWaveDeviceManager.class("[Lcom.tridium.zwave.ui.BZWaveDeviceManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        stationIcon = BImage.make((String)"module://icons/x16/device.png");
        Class clazz2 = class$com$tridium$zwave$ui$BZWaveDeviceManager;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$zwave$ui$BZWaveDeviceManager = BZWaveDeviceManager.class("[Lcom.tridium.zwave.ui.BZWaveDeviceManager;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends DeviceModel {
        protected MgrColumn[] makeColumns() {
            return BZWaveDeviceManager.this.cols;
        }

        public int getSubscribeDepth() {
            return 1;
        }

        Model(BDeviceManager bDeviceManager) {
            super(bDeviceManager);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Controller
    extends DeviceController {
        public final MgrController.MgrCommand replicateReceive;
        public final MgrController.MgrCommand scanForDevices;
        public final MgrController.MgrCommand transferPrimary;
        public final MgrController.MgrCommand optimizeNetwork;

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.edit, this.learnMode, this.discover, this.scanForDevices, this.replicateReceive, this.transferPrimary, this.optimizeNetwork};
        }

        public void updateCommands() {
            super.updateCommands();
            try {
                BZWaveNetwork bZWaveNetwork = ((BZWaveDeviceManager)this.getManager()).getNetwork();
                if (bZWaveNetwork.isDisabled() || bZWaveNetwork.isFault()) {
                    this.edit.setEnabled(false);
                    this.discover.setEnabled(false);
                    this.scanForDevices.setEnabled(false);
                    this.replicateReceive.setEnabled(false);
                    this.transferPrimary.setEnabled(false);
                    this.optimizeNetwork.setEnabled(false);
                    return;
                }
                Object[] objectArray = this.getLearnTable().getSelectedObjects();
                boolean bl = false;
                if (objectArray.length > 0) {
                    bl = true;
                }
                boolean bl2 = bl;
                int n = 0;
                while (n < objectArray.length) {
                    if (BZWaveDeviceManager.this.getLearn().getExisting(objectArray[n]) != null) {
                        bl2 = false;
                        break;
                    }
                    ++n;
                }
                BJob bJob = BZWaveDeviceManager.this.getLearn().getJob();
                boolean bl3 = false;
                if (bJob != null && bJob.isAlive()) {
                    bl3 = true;
                }
                boolean bl4 = bl3;
                this.replicateReceive.setEnabled(bl4 ^ true);
                this.scanForDevices.setEnabled(bl4 ^ true);
                boolean bl5 = false;
                if (bZWaveNetwork.getIsPrimaryController() && !bl4) {
                    bl5 = true;
                }
                this.transferPrimary.setEnabled(bl5);
                boolean bl6 = false;
                if (!bZWaveNetwork.getStatus().isDisabled() && !bl4) {
                    bl6 = true;
                }
                this.optimizeNetwork.setEnabled(bl6);
            }
            catch (Exception exception) {}
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            BZWaveNetwork bZWaveNetwork = ((BZWaveDeviceManager)this.getManager()).getNetwork();
            if (bZWaveNetwork.isDisabled() || bZWaveNetwork.isFault()) {
                throw new RuntimeException("Network is disabled or configured incorrectly");
            }
            super.doDiscover(context);
            BOrd bOrd = bZWaveNetwork.submitDeviceDiscoveryJob();
            BZWaveDeviceManager.this.getLearn().setJob(bOrd);
            return null;
        }

        public CommandArtifact doReplicateReceive() throws Exception {
            BZWaveNetwork bZWaveNetwork = ((BZWaveDeviceManager)this.getManager()).getNetwork();
            if (bZWaveNetwork.isDisabled() || bZWaveNetwork.isFault()) {
                throw new RuntimeException("Network is disabled or configured incorrectly");
            }
            this.learnMode.setSelected(true);
            BOrd bOrd = bZWaveNetwork.replicateReceive();
            BZWaveDeviceManager.this.getLearn().setJob(bOrd);
            return null;
        }

        public CommandArtifact doScanForDevices() throws Exception {
            BZWaveNetwork bZWaveNetwork = ((BZWaveDeviceManager)this.getManager()).getNetwork();
            if (bZWaveNetwork.isDisabled() || bZWaveNetwork.isFault()) {
                throw new RuntimeException("Network is disabled or configured incorrectly");
            }
            this.learnMode.setSelected(true);
            BOrd bOrd = bZWaveNetwork.scanForDevices();
            BZWaveDeviceManager.this.getLearn().setJob(bOrd);
            return null;
        }

        public CommandArtifact doTransferPrimary() throws Exception {
            BZWaveNetwork bZWaveNetwork = ((BZWaveDeviceManager)this.getManager()).getNetwork();
            if (bZWaveNetwork.isDisabled() || bZWaveNetwork.isFault() || !bZWaveNetwork.getIsPrimaryController()) {
                throw new RuntimeException("Network is disabled, configured incorrectly, or not the primaryController");
            }
            this.learnMode.setSelected(true);
            BOrd bOrd = bZWaveNetwork.transferPrimary();
            BZWaveDeviceManager.this.getLearn().setJob(bOrd);
            return null;
        }

        public CommandArtifact doOptimizeNetwork() throws Exception {
            BZWaveNetwork bZWaveNetwork = ((BZWaveDeviceManager)this.getManager()).getNetwork();
            if (bZWaveNetwork.isDisabled() || bZWaveNetwork.isFault()) {
                throw new RuntimeException("Cannot Optimize, Network is disabled, configured incorrectly");
            }
            this.learnMode.setSelected(true);
            BOrd bOrd = bZWaveNetwork.optimizeNetwork();
            BZWaveDeviceManager.this.getLearn().setJob(bOrd);
            return null;
        }

        Controller(BDeviceManager bDeviceManager) {
            super(bDeviceManager);
            this.replicateReceive = new ReplicateReceive((BWidget)bDeviceManager);
            this.scanForDevices = new ScanForDevices((BWidget)bDeviceManager);
            this.transferPrimary = new TransferPrimary((BWidget)bDeviceManager);
            this.optimizeNetwork = new OptimizeNetwork((BWidget)bDeviceManager);
            this.replicateReceive.setFlags(15);
            this.replicateReceive.setEnabled(false);
            this.scanForDevices.setFlags(15);
            this.scanForDevices.setEnabled(false);
            this.transferPrimary.setFlags(15);
            this.transferPrimary.setEnabled(false);
            this.optimizeNetwork.setFlags(15);
            this.optimizeNetwork.setEnabled(false);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class ReplicateReceive
        extends MgrController.MgrCommand {
            public CommandArtifact doInvoke() throws Exception {
                return Controller.this.doReplicateReceive();
            }

            public Command doMerge(Command command) {
                return this;
            }

            ReplicateReceive(BWidget bWidget) {
                super(bWidget, lex, "replicateReceive");
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class ScanForDevices
        extends MgrController.MgrCommand {
            public CommandArtifact doInvoke() throws Exception {
                return Controller.this.doScanForDevices();
            }

            public Command doMerge(Command command) {
                return this;
            }

            ScanForDevices(BWidget bWidget) {
                super(bWidget, lex, "scanForDevices");
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class TransferPrimary
        extends MgrController.MgrCommand {
            public CommandArtifact doInvoke() throws Exception {
                return Controller.this.doTransferPrimary();
            }

            public Command doMerge(Command command) {
                return this;
            }

            TransferPrimary(BWidget bWidget) {
                super(bWidget, lex, "transferPrimary");
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class OptimizeNetwork
        extends MgrController.MgrCommand {
            public CommandArtifact doInvoke() throws Exception {
                return Controller.this.doOptimizeNetwork();
            }

            public Command doMerge(Command command) {
                return this;
            }

            OptimizeNetwork(BWidget bWidget) {
                super(bWidget, lex, "optimizeNetwork");
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Learn
    extends MgrLearn {
        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BZWaveDeviceEntry.nodeId), new MgrColumn.Prop(BZWaveDeviceEntry.basicDeviceClass), new MgrColumn.Prop(BZWaveDeviceEntry.genericDeviceClass), new MgrColumn.Prop(BZWaveDeviceEntry.specificDeviceClass)};
        }

        public BImage getIcon(Object object) {
            return stationIcon;
        }

        public MgrTypeInfo[] toTypes(Object object) {
            BZWaveDeviceEntry bZWaveDeviceEntry = (BZWaveDeviceEntry)((Object)object);
            if (bZWaveDeviceEntry.getGenericDeviceClass().equals((Object)BGenericDeviceEnum.genericThermostat)) {
                return MgrTypeInfo.makeArray((Type)BZWaveThermostat.TYPE);
            }
            return MgrTypeInfo.makeArray((Type)BZWaveDevice.TYPE);
        }

        public void toRow(Object object, MgrEditRow mgrEditRow) {
            BZWaveDeviceEntry bZWaveDeviceEntry = (BZWaveDeviceEntry)((Object)object);
            mgrEditRow.setDefaultName("node_" + bZWaveDeviceEntry.getNodeId());
            mgrEditRow.setCell(BZWaveDeviceManager.this.colNodeId, (BValue)BInteger.make((int)bZWaveDeviceEntry.getNodeId()));
        }

        public boolean isExisting(Object object, BComponent bComponent) {
            try {
                BZWaveDeviceEntry bZWaveDeviceEntry = (BZWaveDeviceEntry)((Object)object);
                BZWaveDevice bZWaveDevice = (BZWaveDevice)bComponent;
                boolean bl = false;
                if (bZWaveDevice.getNodeId() == bZWaveDeviceEntry.getNodeId()) {
                    bl = true;
                }
                return bl;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean isMatchable(Object object, BComponent bComponent) {
            try {
                BZWaveNetwork bZWaveNetwork = ((BZWaveDeviceManager)this.getManager()).getNetwork();
                BZWaveDeviceEntry bZWaveDeviceEntry = (BZWaveDeviceEntry)((Object)object);
                BZWaveDevice bZWaveDevice = bZWaveNetwork.getDevice(bZWaveDeviceEntry.getNodeId());
                if (bZWaveDevice != null) {
                    return false;
                }
                return bZWaveDeviceEntry.is(bComponent);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return false;
            }
        }

        public void jobComplete(BJob bJob) {
            super.jobComplete(bJob);
            if (bJob instanceof BZWaveLearnDevicesJob) {
                BZWaveDeviceManager.this.updateLearnData();
            } else if (bJob instanceof BZWaveReplicateReceiveJob || bJob instanceof BZWaveTransferPrimaryJob) {
                try {
                    if (bJob.getJobState().equals((Object)BJobState.success)) {
                        this.getManager().getController().doDiscover(null);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        Learn() {
            super((BAbstractManager)BZWaveDeviceManager.this);
        }
    }
}

