/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.scene;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.learn.BZWaveLearnNetworkScenesJob;
import com.tridium.zwave.messages.SerialSendData;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.scene.BNetworkSceneAddNode;
import com.tridium.zwave.scene.BNetworkSceneRemoveNode;
import com.tridium.zwave.scene.BZWaveNetworkSceneConfig;
import com.tridium.zwave.scene.BZWaveSceneDeviceExt;
import com.tridium.zwave.scene.BZWaveSceneNetworkExt;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveNetworkScene
extends BComponent
implements ZWaveMessageConst {
    public static final Property sceneId = BZWaveNetworkScene.newProperty((int)65, (int)-1, null);
    public static final Action activate = BZWaveNetworkScene.newAction((int)16, null);
    public static final Action addNode = BZWaveNetworkScene.newAction((int)16, (BValue)new BNetworkSceneAddNode(), null);
    public static final Action removeNode = BZWaveNetworkScene.newAction((int)16, (BValue)new BNetworkSceneRemoveNode(), null);
    public static final Action updateDevices = BZWaveNetworkScene.newAction((int)16, null);
    public static final Action quickDiscover = BZWaveNetworkScene.newAction((int)0, null);
    public static final Action discover = BZWaveNetworkScene.newAction((int)0, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$zwave$scene$BZWaveNetworkScene;
    static /* synthetic */ Class class$com$tridium$zwave$scene$BZWaveNetworkSceneConfig;

    public int getSceneId() {
        return this.getInt(sceneId);
    }

    public void setSceneId(int n) {
        this.setInt(sceneId, n, null);
    }

    public void activate() {
        this.invoke(activate, null, null);
    }

    public void addNode(BNetworkSceneAddNode bNetworkSceneAddNode) {
        this.invoke(addNode, (BValue)bNetworkSceneAddNode, null);
    }

    public void removeNode(BNetworkSceneRemoveNode bNetworkSceneRemoveNode) {
        this.invoke(removeNode, (BValue)bNetworkSceneRemoveNode, null);
    }

    public void updateDevices() {
        this.invoke(updateDevices, null, null);
    }

    public BOrd quickDiscover() {
        return (BOrd)this.invoke(quickDiscover, null, null);
    }

    public BOrd discover() {
        return (BOrd)this.invoke(discover, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        Type type = bComponent.getType();
        return type.is(BZWaveSceneNetworkExt.TYPE);
    }

    public void started() throws Exception {
        BZWaveSceneNetworkExt bZWaveSceneNetworkExt = (BZWaveSceneNetworkExt)this.getParent();
        if (this.getSceneId() <= 0) {
            this.setSceneId(bZWaveSceneNetworkExt.getNextSceneId());
        }
    }

    public final BZWaveNetwork getNetwork() {
        return ((BZWaveSceneNetworkExt)this.getParent()).getZWaveNetwork();
    }

    public void checkRename(Property property, String string, Context context) {
        if (property.getType().is(BZWaveNetworkSceneConfig.TYPE)) {
            throw new IllegalNameException("baja", "IllegalNameException.name", new Object[]{"\"" + string + "\" - cannot rename this component."});
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        if (bValue instanceof BZWaveNetworkSceneConfig) {
            BZWaveNetworkSceneConfig bZWaveNetworkSceneConfig = (BZWaveNetworkSceneConfig)bValue;
            int n = bZWaveNetworkSceneConfig.getNodeId();
            BZWaveDevice bZWaveDevice = this.getNetwork().getDevice(n);
            if (bZWaveDevice == null) {
                return;
            }
            BZWaveSceneDeviceExt.removeScene(bZWaveDevice, bZWaveNetworkSceneConfig.getSceneId());
        }
        super.removed(property, bValue, context);
    }

    public String getDisplayName(Slot slot, Context context) {
        if (slot.isProperty() && slot.asProperty().getType().is(BZWaveNetworkSceneConfig.TYPE)) {
            BZWaveNetworkSceneConfig bZWaveNetworkSceneConfig = (BZWaveNetworkSceneConfig)this.get(slot.asProperty());
            BZWaveDevice bZWaveDevice = this.getNetwork().getDevice(bZWaveNetworkSceneConfig.getNodeId());
            if (bZWaveDevice != null) {
                return bZWaveDevice.getDisplayName(context);
            }
        }
        return super.getDisplayName(slot, context);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BZWaveNetwork bZWaveNetwork;
        if ((action.equals((Object)activate) || action.equals((Object)addNode) || action.equals((Object)removeNode) || action.equals((Object)updateDevices)) && (bZWaveNetwork = this.getNetwork()) != null) {
            return bZWaveNetwork.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals((Object)addNode)) {
            return new BNetworkSceneAddNode(this);
        }
        if (action.equals((Object)removeNode)) {
            return new BNetworkSceneRemoveNode(this);
        }
        return super.getActionParameterDefault(action);
    }

    public void doRemoveNode(BNetworkSceneRemoveNode bNetworkSceneRemoveNode) {
        String string = bNetworkSceneRemoveNode.getZwaveNode().getZwaveNode();
        BDevice[] bDeviceArray = this.getNetwork().getDevices();
        int n = 0;
        String string2 = "";
        BZWaveDevice bZWaveDevice = null;
        int n2 = 0;
        while (n2 < bDeviceArray.length) {
            if (bDeviceArray[n2].getName().equals(string)) {
                bZWaveDevice = (BZWaveDevice)bDeviceArray[n2];
                n = bZWaveDevice.getNodeId();
                string2 = ((BZWaveDevice)bDeviceArray[n2]).getDisplayName(null);
                break;
            }
            ++n2;
        }
        if (bZWaveDevice == null) {
            return;
        }
        Class clazz = class$com$tridium$zwave$scene$BZWaveNetworkSceneConfig;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$scene$BZWaveNetworkSceneConfig = BZWaveNetworkScene.class("[Lcom.tridium.zwave.scene.BZWaveNetworkSceneConfig;", false);
        }
        BZWaveNetworkSceneConfig[] bZWaveNetworkSceneConfigArray = (BZWaveNetworkSceneConfig[])this.getChildren(clazz);
        int n3 = 0;
        while (n3 < bZWaveNetworkSceneConfigArray.length) {
            if (bZWaveNetworkSceneConfigArray[n3].getNodeId() == n) {
                this.remove((BComplex)bZWaveNetworkSceneConfigArray[n3]);
                break;
            }
            ++n3;
        }
    }

    public void doAddNode(BNetworkSceneAddNode bNetworkSceneAddNode) {
        String string = bNetworkSceneAddNode.getZwaveNode().getZwaveNode();
        BDevice[] bDeviceArray = this.getNetwork().getDevices();
        int n = 0;
        String string2 = "";
        BZWaveDevice bZWaveDevice = null;
        int n2 = 0;
        while (n2 < bDeviceArray.length) {
            if (bDeviceArray[n2].getName().equals(string)) {
                bZWaveDevice = (BZWaveDevice)bDeviceArray[n2];
                n = bZWaveDevice.getNodeId();
                string2 = ((BZWaveDevice)bDeviceArray[n2]).getDisplayName(null);
                break;
            }
            ++n2;
        }
        if (bZWaveDevice == null) {
            return;
        }
        BZWaveNetworkSceneConfig bZWaveNetworkSceneConfig = new BZWaveNetworkSceneConfig();
        bZWaveNetworkSceneConfig.setNodeId(n);
        bZWaveNetworkSceneConfig.setSceneId(this.getSceneId());
        bZWaveNetworkSceneConfig.setDimmingDuration(bNetworkSceneAddNode.getDimmingDuration());
        bZWaveNetworkSceneConfig.setLevel(bNetworkSceneAddNode.getLevel());
        this.add(bZWaveDevice.getName(), (BValue)bZWaveNetworkSceneConfig);
        BZWaveSceneDeviceExt.addScene(bZWaveDevice, bZWaveNetworkSceneConfig);
    }

    public void added(Property property, Context context) {
        if (this.isRunning()) {
            this.updateDevices();
        }
    }

    public void doUpdateDevices() {
        Class clazz = class$com$tridium$zwave$scene$BZWaveNetworkSceneConfig;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$scene$BZWaveNetworkSceneConfig = BZWaveNetworkScene.class("[Lcom.tridium.zwave.scene.BZWaveNetworkSceneConfig;", false);
        }
        BZWaveNetworkSceneConfig[] bZWaveNetworkSceneConfigArray = (BZWaveNetworkSceneConfig[])this.getChildren(clazz);
        int n = 0;
        while (n < bZWaveNetworkSceneConfigArray.length) {
            BZWaveDevice bZWaveDevice = this.getNetwork().getDevice(bZWaveNetworkSceneConfigArray[n].getNodeId());
            if (bZWaveDevice != null) {
                BZWaveSceneDeviceExt.addScene(bZWaveDevice, bZWaveNetworkSceneConfigArray[n]);
            }
            ++n;
        }
    }

    public void doActivate() {
        SerialSendData serialSendData = null;
        byte[] byArray = null;
        byArray = new byte[]{43, 1, (byte)this.getSceneId(), -1};
        try {
            int[] nArray = this.getNodeIds();
            serialSendData = new SerialSendData(nArray, byArray, 5);
            this.getNetwork().sendDataReq(serialSendData);
        }
        catch (Exception exception) {}
    }

    private final int[] getNodeIds() {
        Class clazz = class$com$tridium$zwave$scene$BZWaveNetworkSceneConfig;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$scene$BZWaveNetworkSceneConfig = BZWaveNetworkScene.class("[Lcom.tridium.zwave.scene.BZWaveNetworkSceneConfig;", false);
        }
        BZWaveNetworkSceneConfig[] bZWaveNetworkSceneConfigArray = (BZWaveNetworkSceneConfig[])this.getChildren(clazz);
        int[] nArray = new int[bZWaveNetworkSceneConfigArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = bZWaveNetworkSceneConfigArray[n].getNodeId();
            ++n;
        }
        return nArray;
    }

    public BOrd doQuickDiscover() {
        if (this.getNetwork().getStatus().isDisabled()) {
            return null;
        }
        BZWaveLearnNetworkScenesJob bZWaveLearnNetworkScenesJob = new BZWaveLearnNetworkScenesJob(this);
        return bZWaveLearnNetworkScenesJob.submit(null);
    }

    public BOrd doDiscover() {
        if (this.getNetwork().getStatus().isDisabled()) {
            return null;
        }
        BZWaveLearnNetworkScenesJob bZWaveLearnNetworkScenesJob = new BZWaveLearnNetworkScenesJob(this, true);
        return bZWaveLearnNetworkScenesJob.submit(null);
    }

    public String toString(Context context) {
        return "";
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BZWaveNetworkScene() {
    }

    public BZWaveNetworkScene(int n) {
        this.setSceneId(n);
    }

    static {
        Class clazz = class$com$tridium$zwave$scene$BZWaveNetworkScene;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$scene$BZWaveNetworkScene = BZWaveNetworkScene.class("[Lcom.tridium.zwave.scene.BZWaveNetworkScene;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

