/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.BZWaveTuningPolicy;
import com.tridium.zwave.cmdclass.BCcWakeUp;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.messages.SerialSendData;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.Tuning;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveProxyExt
extends BBasicProxyExt
implements BIBasicPollable,
ZWaveMessageConst {
    public static final Property pollFrequency = BZWaveProxyExt.newProperty((int)0, (BValue)BPollFrequency.fast, null);
    public static final Property commandClass = BZWaveProxyExt.newProperty((int)5, (int)-1, null);
    public static final Property readCommand = BZWaveProxyExt.newProperty((int)5, (int)0, null);
    public static final Property writeCommand = BZWaveProxyExt.newProperty((int)5, (int)0, null);
    public static final Property reportCommand = BZWaveProxyExt.newProperty((int)5, (int)0, null);
    public static final Property auxSelector = BZWaveProxyExt.newProperty((int)5, (int)-1, null);
    public static final Property precisionScaleSize = BZWaveProxyExt.newProperty((int)5, (int)0, null);
    public static final Property instance = BZWaveProxyExt.newProperty((int)0, (int)0, null);
    public static final Property rewriteEmergencyCmds = BZWaveProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property age = BZWaveProxyExt.newProperty((int)7, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false));
    public static final Property nextWakeUpIn = BZWaveProxyExt.newProperty((int)7, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false));
    public static final Action readBackTimeout = BZWaveProxyExt.newAction((int)20, null);
    public static final Action setOn = BZWaveProxyExt.newAction((int)16, null);
    public static final Action setOff = BZWaveProxyExt.newAction((int)16, null);
    public static final Type TYPE;
    static final BStatusNumeric ON;
    static final BStatusNumeric OFF;
    public static Log wrLog;
    private Clock.Ticket readBackTimer;
    static /* synthetic */ Class class$com$tridium$zwave$point$BZWaveProxyExt;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public int getCommandClass() {
        return this.getInt(commandClass);
    }

    public void setCommandClass(int n) {
        this.setInt(commandClass, n, null);
    }

    public int getReadCommand() {
        return this.getInt(readCommand);
    }

    public void setReadCommand(int n) {
        this.setInt(readCommand, n, null);
    }

    public int getWriteCommand() {
        return this.getInt(writeCommand);
    }

    public void setWriteCommand(int n) {
        this.setInt(writeCommand, n, null);
    }

    public int getReportCommand() {
        return this.getInt(reportCommand);
    }

    public void setReportCommand(int n) {
        this.setInt(reportCommand, n, null);
    }

    public int getAuxSelector() {
        return this.getInt(auxSelector);
    }

    public void setAuxSelector(int n) {
        this.setInt(auxSelector, n, null);
    }

    public int getPrecisionScaleSize() {
        return this.getInt(precisionScaleSize);
    }

    public void setPrecisionScaleSize(int n) {
        this.setInt(precisionScaleSize, n, null);
    }

    public int getInstance() {
        return this.getInt(instance);
    }

    public void setInstance(int n) {
        this.setInt(instance, n, null);
    }

    public boolean getRewriteEmergencyCmds() {
        return this.getBoolean(rewriteEmergencyCmds);
    }

    public void setRewriteEmergencyCmds(boolean bl) {
        this.setBoolean(rewriteEmergencyCmds, bl, null);
    }

    public BRelTime getAge() {
        return (BRelTime)this.get(age);
    }

    public void setAge(BRelTime bRelTime) {
        this.set(age, (BValue)bRelTime, null);
    }

    public BRelTime getNextWakeUpIn() {
        return (BRelTime)this.get(nextWakeUpIn);
    }

    public void setNextWakeUpIn(BRelTime bRelTime) {
        this.set(nextWakeUpIn, (BValue)bRelTime, null);
    }

    public void readBackTimeout() {
        this.invoke(readBackTimeout, null, null);
    }

    public void setOn() {
        this.invoke(setOn, null, null);
    }

    public void setOff() {
        this.invoke(setOff, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BZWaveNetwork getZWaveNetwork() {
        return (BZWaveNetwork)this.getNetwork();
    }

    public final BZWaveDevice getZWaveDevice() {
        return (BZWaveDevice)this.getDevice();
    }

    public final BZWavePointDeviceExt getZWavePointDeviceExt() {
        return (BZWavePointDeviceExt)this.getDeviceExt();
    }

    public Type getDeviceExtType() {
        return BZWavePointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readWrite;
    }

    public boolean requiresPointSubscription() {
        BStatus bStatus;
        int n;
        if (this.getRewriteEmergencyCmds() && (n = (bStatus = this.getWriteValue().getStatus()).geti("activeLevel", 17)) <= 2) {
            return true;
        }
        return super.requiresPointSubscription();
    }

    public void readSubscribed(Context context) throws Exception {
        if (((BZWaveDevice)this.getDevice()).get("wakeUp") != null) {
            this.setFlags((Slot)age, this.getFlags((Slot)age) & 0xFFFFFFFB);
            this.setFlags((Slot)nextWakeUpIn, this.getFlags((Slot)nextWakeUpIn) & 0xFFFFFFFB);
        } else {
            this.setFlags((Slot)age, this.getFlags((Slot)age) | 4);
            this.setFlags((Slot)nextWakeUpIn, this.getFlags((Slot)nextWakeUpIn) | 4);
        }
        super.readSubscribed(context);
    }

    public void readOk(BStatusValue bStatusValue) {
        super.readOk(bStatusValue);
        BPointCmdClassObject.ptLog.trace(((BZWaveDevice)this.getDevice()).getNodeId() + ": " + this.getParentPoint().getDisplayName(null) + " update = " + bStatusValue);
        if (!this.getParentPoint().isWritablePoint()) {
            return;
        }
        if (bStatusValue.getValueValue().equivalent((Object)this.getWriteValue().getValueValue())) {
            BStatus bStatus = this.getWriteValue().getStatus();
            this.getWriteValue().setStatus(BStatus.make((int)bStatus.getBits(), (BFacets)BFacets.makeRemove((BFacets)bStatus.getFacets(), (String)"sync")));
        } else {
            this.getWriteValue().setStatus("sync", (BIDataValue)BBoolean.make((boolean)true));
            if (this.getRewriteEmergencyCmds()) {
                int n;
                int n2;
                int n3;
                if (bStatusValue instanceof BStatusNumeric && (n3 = (n2 = (int)((BStatusNumeric)bStatusValue).getValue()) - (n = (int)((BStatusNumeric)this.getWriteValue()).getValue())) <= 1 && n3 >= -1) {
                    return;
                }
                BStatus bStatus = this.getWriteValue().getStatus();
                n = bStatus.geti("activeLevel", 17);
                if (n <= 2) {
                    wrLog.trace(((BZWaveDevice)this.getDevice()).getNodeId() + ": rewrite emergency level command: " + this.getWriteValue());
                    try {
                        this.write(null);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void poll() {
        Tuning tuning = this.getTuning();
        long l = tuning.getLastReadTicks();
        if (l != 0L) {
            this.setAge(BRelTime.make((long)(Clock.ticks() - l)));
        }
        if (this.isUnoperational()) {
            return;
        }
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDevice();
        BCcWakeUp bCcWakeUp = bZWaveDevice.getWakeUpClass();
        if (!bZWaveDevice.isNodeListening()) {
            if (bCcWakeUp != null) {
                BAbsTime bAbsTime = BAbsTime.now();
                if (bAbsTime.isBefore(bCcWakeUp.getNextWakeUp())) {
                    this.setNextWakeUpIn(bCcWakeUp.getNextWakeUp().delta(BAbsTime.now()));
                } else {
                    this.setNextWakeUpIn(BRelTime.make((long)0L));
                }
            } else {
                this.setNextWakeUpIn(BRelTime.make((long)0L));
            }
            return;
        }
        BTuningPolicy bTuningPolicy = tuning.getPolicy();
        if (bTuningPolicy.getType().is(BZWaveTuningPolicy.TYPE)) {
            BZWaveTuningPolicy bZWaveTuningPolicy = (BZWaveTuningPolicy)bTuningPolicy;
            long l2 = bZWaveTuningPolicy.getMinReadTime().getMillis();
            long l3 = Clock.ticks();
            if (l2 == 0L || l3 - l > l2) {
                this.pollForData();
            }
        } else {
            this.pollForData();
        }
    }

    public void pollForData() {
        block11: {
            this.cancelReadBackTimer();
            BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)this.getNetwork();
            if (bZWaveNetwork.isReplicationInProcess()) {
                return;
            }
            BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDevice();
            SerialSendData serialSendData = null;
            BCmdClassObject bCmdClassObject = bZWaveNetwork.getCommandClassInstance(this.getCommandClass());
            if (bCmdClassObject != null && bCmdClassObject instanceof BPointCmdClassObject) {
                byte[] byArray = ((BPointCmdClassObject)bCmdClassObject).getReadFrame(this);
                if (byArray == null) {
                    this.readFail("null command frame");
                    return;
                }
                try {
                    BPointCmdClassObject.ptLog.trace(bZWaveDevice.getNodeId() + ": polling - " + this.getParentPoint().getDisplayName(null));
                    serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), byArray, 5);
                    int n = bZWaveNetwork.sendDataReq(serialSendData);
                    if (n != 128) {
                        int n2 = 20;
                        while (n2 > 0 && n == 128) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception exception) {}
                            BPointCmdClassObject.ptLog.trace(bZWaveDevice.getNodeId() + ": retrying poll - " + this.getParentPoint().getDisplayName(null));
                            n = bZWaveNetwork.sendDataReq(serialSendData);
                        }
                    }
                    if (n != 0) {
                        BPointCmdClassObject.ptLog.trace(bZWaveDevice.getNodeId() + ": transmit error: " + BZWaveNetwork.getTxResultString(n));
                        break block11;
                    }
                    BPointCmdClassObject.ptLog.trace(bZWaveDevice.getNodeId() + ": poll transmit OK");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.readFail("could not get instance of command class: 0x" + Integer.toHexString(this.getCommandClass()));
            }
        }
    }

    public void doWrite(BStatusValue bStatusValue) {
        BControlPoint bControlPoint = this.getParentPoint();
        if (bControlPoint == null || !bControlPoint.isWritablePoint()) {
            return;
        }
        BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)this.getNetwork();
        if (bZWaveNetwork.isReplicationInProcess()) {
            return;
        }
        try {
            this.getParentPoint().checkExtensionsRequireSubscription();
        }
        catch (Exception exception) {}
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDevice();
        SerialSendData serialSendData = null;
        BCmdClassObject bCmdClassObject = bZWaveNetwork.getCommandClassInstance(this.getCommandClass());
        if (bCmdClassObject != null && bCmdClassObject instanceof BPointCmdClassObject) {
            byte[] byArray = ((BPointCmdClassObject)bCmdClassObject).getWriteFrame(bStatusValue, this);
            if (byArray == null) {
                Thread.dumpStack();
                this.writeFail("null command frame");
                return;
            }
            try {
                wrLog.trace(this.getDevice().getName() + '.' + this.getParentPoint().getName() + " write value: " + bStatusValue);
                wrLog.trace(ByteArrayUtil.toHexString((byte[])byArray));
                serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), byArray, 5, false);
                bZWaveNetwork.sendDataReq(serialSendData);
                this.writeOk(bStatusValue);
                this.initReadBackTimer();
            }
            catch (Exception exception) {}
        }
    }

    public boolean isReadBackTimerActive() {
        boolean bl = false;
        if (this.readBackTimer != null) {
            bl = true;
        }
        return bl;
    }

    public void initReadBackTimer() {
        BZWaveNetwork bZWaveNetwork;
        int n;
        if (this.readBackTimer != null) {
            this.readBackTimer.cancel();
        }
        if ((n = (bZWaveNetwork = (BZWaveNetwork)this.getNetwork()).getReadBackTime()) > 0) {
            this.readBackTimer = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)n), (Action)readBackTimeout, null);
        }
    }

    private final void cancelReadBackTimer() {
        if (this.readBackTimer != null) {
            this.readBackTimer.cancel();
            this.readBackTimer = null;
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BZWaveNetwork bZWaveNetwork;
        if (action.equals((Object)readBackTimeout) && (bZWaveNetwork = this.getZWaveNetwork()) != null) {
            return bZWaveNetwork.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doReadBackTimeout() {
        this.poll();
    }

    public void doSetOn() {
        this.doWrite((BStatusValue)ON);
    }

    public void doSetOff() {
        this.doWrite((BStatusValue)OFF);
    }

    public boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    public boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    public boolean isString() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusString;
    }

    public boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$point$BZWaveProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$point$BZWaveProxyExt = BZWaveProxyExt.class("[Lcom.tridium.zwave.point.BZWaveProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ON = new BStatusNumeric(255.0);
        OFF = new BStatusNumeric(0.0);
        wrLog = Log.getLog((String)"zwave.wr");
    }
}

