/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.learn;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.messages.ZWaveSerialApiRequest;
import com.tridium.zwave.messages.ZWaveSerialFrame;
import com.tridium.zwave.util.BZWaveApiParam;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.log.Log;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveReplicateReceiveJob
extends BSimpleJob
implements ZWaveMessageConst {
    public static final Property learnedDevices = BZWaveReplicateReceiveJob.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Type TYPE;
    private static Log ldLog;
    BZWaveNetwork network;
    static /* synthetic */ Class class$com$tridium$zwave$learn$BZWaveReplicateReceiveJob;
    static /* synthetic */ Class class$com$tridium$zwave$BZWaveDevice;

    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    public void setLearnedDevices(BFolder bFolder) {
        this.set(learnedDevices, (BValue)bFolder, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doCancel(Context context) {
        super.doCancel(context);
        throw new JobCancelException();
    }

    public void run(Context context) throws Exception {
        try {
            this.getLearnedDevices().removeAll();
            this.log().message("Set Interface Learn Mode");
            this.network.doSetInterfaceLearnMode(true);
            this.progress(66);
            long l = Clock.millis();
            while (!this.network.isAddNodeDone() && Clock.millis() - l < 30000L) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            if (!this.network.isAddNodeDone()) {
                this.network.doSetInterfaceLearnMode(false);
                this.log().message("Replication failed");
                RuntimeException runtimeException = new RuntimeException("Replication Receive timed out");
                throw runtimeException;
            }
            this.progress(90);
            this.log().message("Replication complete");
            this.network.doSetInterfaceLearnMode(false);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            this.network.doSendSerialApiRequest(new BZWaveApiParam(5));
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
            ZWaveSerialApiRequest zWaveSerialApiRequest = new ZWaveSerialApiRequest(0, 32, null);
            this.network.sendZWaveSync(new ZWaveSerialFrame(zWaveSerialApiRequest, false));
            this.progress(90);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            this.network.doEnableSuc();
            this.network.doSetSucNodeId();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            if (this.network.getRemoveExcludedDevices()) {
                Object[] objectArray;
                Class clazz;
                this.log().message("Removing excluded devices");
                byte[] byArray = this.network.getKnownNodes();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                if ((clazz = class$com$tridium$zwave$BZWaveDevice) == null) {
                    clazz = class$com$tridium$zwave$BZWaveDevice = BZWaveReplicateReceiveJob.class("[Lcom.tridium.zwave.BZWaveDevice;", false);
                }
                if ((objectArray = this.network.getChildren(clazz)).length == 0) {
                    this.log().message("No devices located");
                }
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] instanceof BZWaveDevice) {
                        int n2;
                        BZWaveDevice bZWaveDevice = (BZWaveDevice)objectArray[n];
                        int n3 = bZWaveDevice.getNodeId();
                        int n4 = n3 - 1;
                        int n5 = n4 / 8;
                        if ((byArray[n5] & (n2 = 1 << n4 % 8)) != 0) {
                            this.log().message("Device \"" + bZWaveDevice.getDisplayName(null) + "\" known about at node id " + n3);
                        } else {
                            this.log().message("Removing device \"" + bZWaveDevice.getDisplayName(null) + "\" - node id " + n3);
                            String string = bZWaveDevice.getName();
                            if (string == null) {
                                this.log().message("Could not delete failed to get device location");
                            } else {
                                this.network.remove(string);
                            }
                        }
                    }
                    ++n;
                }
            }
            this.progress(100);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.network.doSendSerialApiRequest(new BZWaveApiParam(5));
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception2) {}
            throw exception;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BZWaveReplicateReceiveJob() {
        this.network = null;
    }

    public BZWaveReplicateReceiveJob(BZWaveNetwork bZWaveNetwork) {
        this.network = bZWaveNetwork;
    }

    static {
        Class clazz = class$com$tridium$zwave$learn$BZWaveReplicateReceiveJob;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$learn$BZWaveReplicateReceiveJob = BZWaveReplicateReceiveJob.class("[Lcom.tridium.zwave.learn.BZWaveReplicateReceiveJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ldLog = Log.getLog((String)"zwave.learnDevices");
    }
}

